/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import visad.DateTime;
import visad.VisADException;

public class DatePattern {
    static final char DAY = 'd';
    static final char HOUR = 'h';
    static final char MINUTE = 'n';
    static final char MONTH = 'm';
    static final char SECOND = 's';
    static final char YEAR = 'y';
    static final String valid_chars = "ymdhns";
    private List<DmyPattern> matchList = null;
    private Pattern pat = null;
    private List<DmyPattern> dmts = new ArrayList<DmyPattern>();
    private String regPattern;

    public DatePattern(String dmtpat) {
        this.compileDatetimePattern(dmtpat);
        this.pat = Pattern.compile(this.getRegex());
    }

    public List<Character> getValidFields() {
        ArrayList<Character> ac = new ArrayList<Character>();
        for (int i = 0; i < this.matchList.size(); ++i) {
            ac.add(Character.valueOf(this.matchList.get(i).dt_type));
        }
        return ac;
    }

    public int get(char field) {
        if (this.pat == null) {
            return -1;
        }
        if (this.matchList == null) {
            return -1;
        }
        for (int i = 0; i < this.matchList.size(); ++i) {
            if (this.matchList.get(i).dt_type != field) continue;
            return Integer.parseInt(this.matchList.get(i).reg);
        }
        return -1;
    }

    public boolean match(String search) {
        Matcher match = this.pat.matcher(search);
        if (this.matchList != null) {
            this.matchList = null;
        }
        this.matchList = new ArrayList<DmyPattern>();
        if (match.matches() && match.groupCount() == this.dmts.size()) {
            for (int g = 1; g <= match.groupCount(); ++g) {
                this.matchList.add(new DmyPattern(this.dmts.get(g - 1).getDt_type(), match.group(g)));
            }
        }
        return match.matches();
    }

    public String getRegex() {
        return this.regPattern;
    }

    private void compileDatetimePattern(String pattern) {
        this.regPattern = "\\D*";
        int cc = 0;
        char old_c = 'x';
        char[] patloc = pattern.toCharArray();
        String patpart = "";
        for (char c : patloc) {
            char k = Character.toLowerCase(c);
            if (old_c == k) {
                ++cc;
                continue;
            }
            if (cc > 0) {
                patpart = "(\\d{" + Integer.toString(cc) + "})";
                this.dmts.add(new DmyPattern(old_c, patpart));
                this.regPattern = this.regPattern + patpart;
            }
            if (valid_chars.indexOf(k) == -1) {
                this.regPattern = this.regPattern + c;
                cc = 0;
            } else {
                cc = 1;
            }
            old_c = k;
        }
        if (cc > 0) {
            patpart = "(\\d{" + Integer.toString(cc) + "})";
            this.dmts.add(new DmyPattern(old_c, patpart));
            this.regPattern = this.regPattern + patpart;
        }
        this.regPattern = this.regPattern + ".*";
    }

    public DateTime getDateTime() {
        int year = 0;
        int month = 1;
        int day = 1;
        int hour = 0;
        int minute = 0;
        int seconds = 0;
        List<Character> dpc = this.getValidFields();
        for (Character c : dpc) {
            switch (c.charValue()) {
                case 'y': {
                    year = this.get(c.charValue());
                    break;
                }
                case 'm': {
                    month = this.get(c.charValue());
                    break;
                }
                case 'd': {
                    day = this.get(c.charValue());
                    break;
                }
                case 'h': {
                    hour = this.get(c.charValue());
                    break;
                }
                case 'n': {
                    minute = this.get(c.charValue());
                    break;
                }
                case 's': {
                    seconds = this.get(c.charValue());
                }
            }
        }
        DateTime dt = null;
        try {
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            cal.set(year, month - 1, day, hour, minute, seconds);
            int doy = cal.get(6);
            dt = new DateTime(year, doy, seconds += hour * 3600 + minute * 60);
        }
        catch (VisADException visADException) {
            // empty catch block
        }
        return dt;
    }

    public static void main(String[] args) {
        String fname = "GLR2008081820090919.txt";
        String fname2 = "GLR20070315.txt";
        String fname3 = "20060214";
        String mypat = "yyyymmdd";
        String fname4 = "200704";
        String mypat2 = "yyyymm";
        String fname11 = "GLR2007-04-14.txt";
        String mypat11 = "yyyy-mm-dd";
        String fname12 = "GLR2007-04-14 23:16:17.txt";
        String mypat12 = "GLRyyyy-mm-dd hh:nn:ss";
        DatePattern p = new DatePattern(mypat);
        DatePattern.printDetails(fname, p);
        System.out.println(p.match(fname2));
        DatePattern.printDetails(fname2, p);
        System.out.println(p.match(fname3));
        DatePattern.printDetails(fname3, p);
        p = new DatePattern(mypat2);
        DatePattern.printDetails(fname4, p);
        p = new DatePattern(mypat11);
        DatePattern.printDetails(fname11, p);
        p = new DatePattern(mypat12);
        DatePattern.printDetails(fname12, p);
    }

    private static void printDetails(String fname4, DatePattern p) {
        System.out.println(p.match(fname4));
        System.out.println(p.getValidFields());
        System.out.println(fname4);
        System.out.println(p.getRegex());
        System.out.println(p.get('y'));
        System.out.println(p.get('m'));
        System.out.println(p.get('d'));
        System.out.println(p.get('h'));
        System.out.println(p.get('n'));
        System.out.println(p.get('s'));
        System.out.println(p.getDateTime());
    }

    public class DmyPattern {
        private char dt_type;
        private String reg;

        public DmyPattern(char dtType, String reg) {
            this.dt_type = dtType;
            this.reg = reg;
        }

        public char getDt_type() {
            return this.dt_type;
        }

        public String getReg() {
            return this.reg;
        }
    }
}

