/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.util.List;
import java.util.StringTokenizer;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;

public class ContourInfo {
    public static final boolean DEFAULT_LABEL = true;
    public static final boolean DEFAULT_LABEL_ALIGNMENT = true;
    public static final boolean DEFAULT_DASH = false;
    public static final boolean DEFAULT_FILL = false;
    public static final int DEFAULT_LINE_WIDTH = 1;
    public static final int DASH_STYLE = 1;
    public static final int DOT_STYLE = 2;
    public static final int DASH_DOT_STYLE = 3;
    public static final int DEFAULT_DASHED_STYLE = 1;
    public static final int DEFAULT_LABEL_SIZE = 12;
    public static final int DEFAULT_LABEL_FREQ = 1;
    private float interval;
    private float base;
    private float min;
    private float max;
    private int labelFreq = 1;
    private int labelLineSkip = 2;
    private int labelSize = 12;
    private Object font;
    private boolean alignLabels = true;
    private boolean isLabeled = true;
    private boolean dashOn = false;
    private boolean isColorFilled = false;
    private int lineWidth = 1;
    private int dashedStyle = 1;
    private String levelsString = null;

    public ContourInfo(float interval, float base, float min, float max, boolean labelOn, boolean dashOn, boolean isColorFilled) {
        this(interval, base, min, max, labelOn, dashOn, isColorFilled, 1);
    }

    public ContourInfo(float interval, float base, float min, float max, boolean labelOn, boolean dashOn, boolean isColorFilled, int width) {
        this(String.valueOf(interval), base, min, max, labelOn, dashOn, isColorFilled, width);
    }

    public ContourInfo(String levelsString, float base, float min, float max, boolean labelOn, boolean dashOn, boolean isColorFilled, int width) {
        this(levelsString, base, min, max, labelOn, dashOn, isColorFilled, width, 1);
    }

    public ContourInfo(String levelsString, float base, float min, float max, boolean labelOn, boolean dashOn, boolean isColorFilled, int width, int dashedStyle) {
        this(levelsString, base, min, max, labelOn, dashOn, isColorFilled, width, 1, 1, 2, 12, null, true);
    }

    public ContourInfo(String levelsString, float base, float min, float max, boolean labelOn, boolean dashOn, boolean isColorFilled, int width, int dashedStyle, int labelFreq, int labelSize, Object font, boolean align) {
        this(levelsString, base, min, max, labelOn, dashOn, isColorFilled, width, dashedStyle, labelFreq, 2, labelSize, font, align);
    }

    public ContourInfo(String levelsString, float base, float min, float max, boolean labelOn, boolean dashOn, boolean isColorFilled, int width, int dashedStyle, int labelFreq, int labelLineSkip, int labelSize, Object font, boolean align) {
        if (ContourInfo.isIrregularInterval(levelsString)) {
            this.levelsString = levelsString;
            this.interval = Float.NaN;
        } else {
            this.levelsString = null;
            this.interval = Misc.parseFloat(levelsString);
        }
        this.min = min;
        this.max = max;
        this.base = base;
        this.isLabeled = labelOn;
        this.dashOn = dashOn;
        this.isColorFilled = isColorFilled;
        this.lineWidth = width;
        this.dashedStyle = dashedStyle;
        this.labelFreq = labelFreq;
        this.labelLineSkip = labelLineSkip;
        this.labelSize = labelSize;
        this.font = font;
        this.alignLabels = align;
    }

    public ContourInfo() {
        this(0.0f, 0.0f, 0.0f, 0.0f, true, false, false, 1);
    }

    public ContourInfo(double interval, double base, double min, double max) {
        this((float)interval, (float)base, (float)min, (float)max);
    }

    public ContourInfo(double interval, double base, double min, double max, boolean labelOn, boolean dashOn) {
        this(String.valueOf(interval), base, min, max, labelOn, dashOn, false, 1.0);
    }

    public ContourInfo(String levelsString, double base, double min, double max, boolean labelOn, boolean dashOn, boolean isColorFilled, double width) {
        this(levelsString, (float)base, (float)min, (float)max, labelOn, dashOn, isColorFilled, (int)width);
    }

    public ContourInfo(double interval, double base, double min, double max, boolean labelOn, boolean dashOn, int width) {
        this((float)interval, (float)base, (float)min, (float)max, labelOn, dashOn, false, width);
    }

    public ContourInfo(float interval, float base, float min, float max) {
        this(interval, base, min, max, true, false);
    }

    public ContourInfo(ContourInfo s) {
        this.set(s);
    }

    public ContourInfo(float[] values) {
        this(values[0], values[1], values[2], values[3]);
    }

    public ContourInfo(String params) {
        this.processParamString(params);
    }

    public void processParamString(String params) {
        List<String> toks = StringUtil.split(params, ";", true, true);
        if (params.indexOf("=") >= 0) {
            for (int i = 0; i < toks.size(); ++i) {
                List<String> subToks = StringUtil.split(toks.get(i).toString(), "=");
                if (subToks.size() != 2) {
                    throw new IllegalArgumentException("Bad contour info format: " + params);
                }
                String name = subToks.get(0).toString().trim();
                String value = subToks.get(1).toString().trim();
                if (name.equals("interval")) {
                    this.interval = new Float(value).floatValue();
                    continue;
                }
                if (name.equals("levels")) {
                    value = value.replaceAll(",", ";");
                    this.setLevelsString(value);
                    continue;
                }
                if (name.equals("min")) {
                    this.min = new Float(value).floatValue();
                    continue;
                }
                if (name.equals("max")) {
                    this.max = new Float(value).floatValue();
                    continue;
                }
                if (name.equals("base")) {
                    this.base = new Float(value).floatValue();
                    continue;
                }
                if (name.equals("dashed")) {
                    this.dashOn = new Boolean(value);
                    continue;
                }
                if (name.equals("width")) {
                    this.lineWidth = new Integer(value);
                    continue;
                }
                if (name.equals("labels")) {
                    this.isLabeled = new Boolean(value);
                    continue;
                }
                if (name.equals("labelsize")) {
                    this.labelSize = new Integer(value);
                    continue;
                }
                if (name.equals("labelfreq")) {
                    this.labelFreq = new Integer(value);
                    continue;
                }
                if (name.equals("labellineskip")) {
                    this.labelLineSkip = new Integer(value);
                    continue;
                }
                if (name.equals("font")) continue;
                if (name.equals("align")) {
                    this.alignLabels = new Boolean(value);
                    continue;
                }
                throw new IllegalArgumentException("Unknown ContourInfo parameter:" + name);
            }
        } else {
            if (toks.size() != 4) {
                throw new IllegalArgumentException("Bad ContourInfo parameters:" + params + "\n Needs to be of the form interval;base;min;max");
            }
            this.interval = new Float(toks.get(0).toString()).floatValue();
            this.base = new Float(toks.get(1).toString()).floatValue();
            this.min = new Float(toks.get(2).toString()).floatValue();
            this.max = new Float(toks.get(3).toString()).floatValue();
        }
    }

    public boolean isDefined() {
        return this.getIntervalDefined() && this.getBaseDefined() && this.getMinDefined() && this.getMaxDefined();
    }

    public boolean getIntervalDefined() {
        return !Float.isNaN(this.interval);
    }

    public boolean getBaseDefined() {
        return !Float.isNaN(this.base);
    }

    public boolean getMinDefined() {
        return !Float.isNaN(this.min);
    }

    public boolean getMaxDefined() {
        return !Float.isNaN(this.max);
    }

    public float getInterval() {
        return this.interval;
    }

    public float getBase() {
        return this.base;
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public void setIsLabeled(boolean v) {
        this.isLabeled = v;
    }

    public boolean getIsLabeled() {
        return this.isLabeled;
    }

    public void setDashOn(boolean v) {
        this.dashOn = v;
    }

    public boolean getDashOn() {
        return this.dashOn;
    }

    public void setInterval(float v) {
        this.interval = v;
        if (!Float.isNaN(v)) {
            this.levelsString = null;
        }
    }

    public void setLevelsString(String v) {
        if (ContourInfo.isIrregularInterval(v)) {
            this.interval = Float.NaN;
        } else if (v != null) {
            this.interval = (float)Misc.parseDouble(v);
        }
        this.levelsString = v;
    }

    public String getLevelsString() {
        return this.levelsString;
    }

    public void setBase(float v) {
        this.base = v;
    }

    public void setMin(float v) {
        this.min = v;
    }

    public void setMax(float v) {
        this.max = v;
    }

    public void set(ContourInfo that) {
        this.interval = that.interval;
        this.levelsString = that.levelsString;
        this.base = that.base;
        this.min = that.min;
        this.max = that.max;
        this.isLabeled = that.isLabeled;
        this.dashOn = that.dashOn;
        this.isColorFilled = that.isColorFilled;
        this.lineWidth = that.lineWidth;
        this.dashedStyle = that.dashedStyle;
        this.labelFreq = that.labelFreq;
        this.labelLineSkip = that.labelLineSkip;
        this.labelSize = that.labelSize;
        this.font = that.font;
        this.alignLabels = that.alignLabels;
    }

    public void setIfDefined(ContourInfo that) {
        if (that.getIntervalDefined()) {
            this.interval = that.interval;
        }
        if (that.getBaseDefined()) {
            this.base = that.base;
        }
        if (that.getMinDefined()) {
            this.min = that.min;
        }
        if (that.getMaxDefined()) {
            this.max = that.max;
        }
        this.levelsString = that.levelsString;
        this.isLabeled = this.isColorFilled ? false : that.isLabeled;
        this.dashOn = that.dashOn;
        this.lineWidth = that.lineWidth;
        this.dashedStyle = that.dashedStyle;
        this.labelSize = that.labelSize;
        this.labelFreq = that.labelFreq;
        this.labelLineSkip = that.labelLineSkip;
        this.font = that.font;
        this.alignLabels = that.alignLabels;
    }

    public float[] asArray() {
        return new float[]{this.interval, this.base, this.min, this.max};
    }

    public void tweakIntervalForDash() {
        if ((double)this.interval < 0.0) {
            this.interval = -this.interval;
        }
        if (this.dashOn) {
            this.interval = -this.interval;
        }
    }

    public String getIntervalString() {
        return this.getIntervalString(false);
    }

    public String getIntervalString(boolean useDecimalFormat) {
        return this.levelsString != null ? this.levelsString : (useDecimalFormat ? String.valueOf(this.interval) : Misc.format(this.interval));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" interval= ");
        sb.append(this.interval);
        sb.append(" irregular intervals= ");
        sb.append(this.levelsString);
        sb.append(" base = ");
        sb.append(this.base);
        sb.append(" min  = ");
        sb.append(this.min);
        sb.append(" max = ");
        sb.append(this.max);
        sb.append(" dash = ");
        sb.append(this.dashOn);
        sb.append(" labeling = ");
        sb.append(this.isLabeled);
        sb.append(" isColorFilled = ");
        sb.append(this.isColorFilled);
        sb.append(" lineWidth = ");
        sb.append(this.lineWidth);
        return sb.toString();
    }

    public void setIsFilled(boolean fill) {
        this.isColorFilled = fill;
    }

    public boolean getIsFilled() {
        return this.isColorFilled;
    }

    public void setLineWidth(int width) {
        this.lineWidth = width;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setDashedStyle(int v) {
        this.dashedStyle = v;
    }

    public int getDashedStyle() {
        return this.dashedStyle;
    }

    public float[] getContourLevels() {
        return this.getContourLevels(this.levelsString == null ? this.makeLevelsString() : this.levelsString);
    }

    public float[] getContourLevels(String levelString) {
        List<String> tokens = StringUtil.split(levelString, ";", true, true);
        float[] levels = null;
        for (int i = 0; i < tokens.size(); ++i) {
            String tok = tokens.get(i);
            float[] vals = this.getLevelsFromDefString(tok);
            if (vals == null) continue;
            levels = levels == null ? vals : this.appendToArray(levels, vals);
        }
        if (levels == null) {
            levels = new float[]{0.0f};
        }
        return levels;
    }

    public int getLabelFreq() {
        return this.labelFreq;
    }

    public void setLabelFreq(int freq) {
        this.labelFreq = freq;
    }

    public int getLabelLineSkip() {
        return this.labelLineSkip;
    }

    public void setLabelLineSkip(int labelLineSkip) {
        this.labelLineSkip = labelLineSkip;
    }

    public int getLabelSize() {
        return this.labelSize;
    }

    public void setLabelSize(int size) {
        this.labelSize = size;
    }

    public Object getFont() {
        return this.font;
    }

    public void setFont(Object font) {
        this.font = font;
    }

    public boolean getAlignLabels() {
        return this.alignLabels;
    }

    public void setAlignLabels(boolean align) {
        this.alignLabels = align;
    }

    public static String cleanupUserLevelString(String levelString) {
        if (levelString == null) {
            return null;
        }
        List<String> tokens = StringUtil.split(levelString, ";", true, true);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < tokens.size(); ++i) {
            String tok = tokens.get(i);
            List<String> subTokens = StringUtil.split(tok, "/", true, true);
            if (i > 0) {
                sb.append(";");
            }
            for (int j = 0; j < subTokens.size(); ++j) {
                String subTok = subTokens.get(j);
                if (j > 0) {
                    sb.append("/");
                }
                double d = Misc.parseDouble(subTok);
                sb.append(String.valueOf(d));
            }
        }
        return sb.toString();
    }

    public static boolean isIrregularInterval(String intervalString) {
        return intervalString != null && (intervalString.indexOf(";") > 0 || intervalString.indexOf("/") > 0);
    }

    private String makeLevelsString() {
        return this.interval + "/" + this.min + "/" + this.max + "/" + this.base;
    }

    private float[] getLevelsFromDefString(String defString) {
        StringTokenizer tok = new StringTokenizer(defString, "/");
        float intv = this.getInterval();
        float min = this.getMin();
        float max = this.getMax();
        float base = this.getBase();
        if (tok.hasMoreTokens()) {
            intv = this.getValue(tok.nextToken(), intv);
        }
        if (!tok.hasMoreTokens()) {
            return new float[]{intv};
        }
        min = this.getValue(tok.nextToken(), min);
        if (tok.hasMoreTokens()) {
            max = this.getValue(tok.nextToken(), max);
        }
        base = tok.hasMoreTokens() ? this.getValue(tok.nextToken(), base) : min;
        return Misc.computeTicks(max, min, base, intv);
    }

    private float getValue(String valString, float def) {
        if (valString.trim().equals("")) {
            return def;
        }
        return Misc.parseFloat(valString);
    }

    private float[] appendToArray(float[] orig, float[] newStuff) {
        float[] newArray = new float[orig.length + newStuff.length];
        System.arraycopy(orig, 0, newArray, 0, orig.length);
        System.arraycopy(newStuff, 0, newArray, orig.length, newStuff.length);
        return newArray;
    }
}

