/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ucar.unidata.util.Misc;
import ucar.unidata.util.NamedObject;
import ucar.unidata.util.Range;

public class ColorTable
implements NamedObject {
    public static final int IDX_RED = 0;
    public static final int IDX_GREEN = 1;
    public static final int IDX_BLUE = 2;
    public static final int IDX_ALPHA = 3;
    private String id;
    private String name;
    private String description;
    private String category = "Basic";
    private boolean active = true;
    private float[][] tableArray;
    private float[] scaleFactor;
    private ArrayList<Color> colorList;
    private ArrayList breakpoints;
    private Range range;
    public static final String CATEGORY_BASIC = "Basic";
    public static final String CATEGORY_MISC = "Misc.";
    public static final String CATEGORY_SATELLITE = "Satellite";
    public static final String CATEGORY_RADAR = "Radar";
    public static final String CATEGORY_SOLID = "Solid";
    public static final String CATEGORY_ATD_RADAR = "Radar>ATD";

    public ColorTable(ColorTable otherTable) {
        if (otherTable != null) {
            this.name = otherTable.name;
            this.description = otherTable.description;
            this.category = otherTable.category;
            if (otherTable.tableArray != null) {
                this.tableArray = new float[otherTable.tableArray.length][];
                for (int i = 0; i < otherTable.tableArray.length; ++i) {
                    this.tableArray[i] = (float[])otherTable.tableArray[i].clone();
                }
            }
            if (otherTable.breakpoints != null) {
                this.breakpoints = new ArrayList(otherTable.breakpoints);
            }
            this.range = new Range(otherTable.range);
        }
    }

    public ColorTable() {
        this(null, CATEGORY_BASIC, null);
    }

    public ColorTable(String name, String category, float[][] table) {
        this(name, name, category, table);
    }

    public ColorTable(String id, String name, String category, float[][] table) {
        this.id = id;
        this.tableArray = table;
        this.name = name;
        this.category = category;
    }

    public ColorTable(String id, String name, String category, float[][] table, boolean tableFlipped) {
        this.id = id;
        this.name = name;
        this.category = category;
        if (!tableFlipped) {
            this.tableArray = table;
        } else {
            this.tableArray = new float[table[0].length][table.length];
            for (int i = 0; i < table.length; ++i) {
                for (int j = 0; j < table[0].length; ++j) {
                    this.tableArray[j][i] = table[i][j];
                }
            }
        }
    }

    public ColorTable init(String name, String category, ArrayList colors, ArrayList breakpoints, Range r) {
        return this.init(name, category, colors, null, breakpoints, r);
    }

    public ColorTable init(String name, String category, ArrayList colors, ArrayList scales, ArrayList breakpoints, Range r) {
        this.colorList = null;
        this.range = new Range(r);
        this.name = name;
        this.category = category;
        this.breakpoints = breakpoints;
        this.scaleFactor = null;
        if (scales != null && scales.size() == colors.size()) {
            this.scaleFactor = new float[scales.size()];
            for (int i = 0; i < scales.size(); ++i) {
                this.scaleFactor[i] = ((Float)scales.get(i)).floatValue();
            }
        }
        this.setTable(colors);
        return this;
    }

    public boolean equalsTable(ColorTable other) {
        if (other == null) {
            return false;
        }
        if (!Misc.equals(this.getName(), other.getName())) {
            return false;
        }
        int max = 3;
        if (this.tableArray == null || other.tableArray == null) {
            return false;
        }
        if (this.tableArray.length == other.tableArray.length) {
            max = this.tableArray.length;
        }
        for (int row = 0; row < max; ++row) {
            if (Arrays.equals(this.tableArray[row], other.tableArray[row])) continue;
            return false;
        }
        if (this.tableArray.length != other.tableArray.length) {
            if (this.tableArray.length == 4) {
                return this.allEquals(this.tableArray[3], 1.0f);
            }
            return this.allEquals(other.tableArray[3], 1.0f);
        }
        return true;
    }

    private boolean allEquals(float[] a, float num) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == num) continue;
            return false;
        }
        return true;
    }

    public void setRange(Range r) {
        this.range = r;
    }

    public Range getRange() {
        return this.range;
    }

    public void setActive(boolean a) {
        this.active = a;
    }

    public boolean getActive() {
        return this.active;
    }

    public void setBreakpoints(ArrayList l) {
        this.breakpoints = l;
    }

    public ArrayList getBreakpoints() {
        return this.breakpoints;
    }

    public float[][] getNonAlphaTable() {
        return ColorTable.removeAlpha(this.getColorTable());
    }

    public float[][] getAlphaTable() {
        return ColorTable.addAlpha(this.getColorTable());
    }

    public float[][] getColorTable() {
        if (this.scaleFactor != null) {
            float[][] newArray = new float[this.tableArray.length][];
            for (int i = 0; i < this.tableArray.length; ++i) {
                newArray[i] = (float[])this.tableArray[i].clone();
                for (int j = 0; j < newArray[i].length; ++j) {
                    if (j >= this.scaleFactor.length) continue;
                    newArray[i][j] = Math.min(1.0f, this.scaleFactor[j] * newArray[i][j]);
                }
            }
            return newArray;
        }
        return this.tableArray;
    }

    public void setTable(float[][] table) {
        this.tableArray = table;
    }

    public float[][] getTable() {
        return this.tableArray;
    }

    public void setTableArray(float[][] table) {
        this.tableArray = table;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        if (this.id == null) {
            this.id = name;
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
        if (category == null) {
            this.category = CATEGORY_BASIC;
        }
    }

    public String dataToString() {
        StringBuffer sb = new StringBuffer();
        float[][] table = this.getColorTable();
        for (int i = 0; i < table.length; ++i) {
            for (int j = 0; j < table[0].length; ++j) {
                if (j > 0) {
                    sb.append(",");
                }
                sb.append("" + table[i][j]);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public String print() {
        return this + " size:" + this.tableArray[0].length;
    }

    public String toString() {
        return this.name;
    }

    public void setTable(ArrayList colors) {
        int length = 3;
        if (this.tableArray != null) {
            length = this.tableArray.length;
        }
        length = 4;
        float[][] oldTable = this.tableArray;
        this.tableArray = new float[length][colors.size()];
        float[] comps = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        for (int i = 0; i < colors.size(); ++i) {
            Color c = (Color)colors.get(i);
            comps = c.getRGBComponents(comps);
            this.tableArray[0][i] = comps[0];
            this.tableArray[1][i] = comps[1];
            this.tableArray[2][i] = comps[2];
            this.tableArray[3][i] = comps[3];
        }
        this.colorList = null;
    }

    public ArrayList<Color> getColorList() {
        return this.getColorList(true);
    }

    public ArrayList<Color> getColorList(boolean includeAlpha) {
        if (this.colorList == null && this.tableArray != null) {
            this.colorList = new ArrayList();
            boolean haveAlpha = this.tableArray.length == 4 && includeAlpha;
            int length = this.tableArray[0].length;
            for (int i = 0; i < length; ++i) {
                this.colorList.add(new Color(this.tableArray[0][i], this.tableArray[1][i], this.tableArray[2][i], haveAlpha ? this.tableArray[3][i] : 1.0f));
            }
        }
        return this.colorList;
    }

    public static final float[][] addAlpha(ColorTable colorTable) {
        return ColorTable.addAlpha(colorTable.getColorTable());
    }

    public static final float[][] removeAlpha(float[][] colorTable) {
        if (colorTable == null) {
            return colorTable;
        }
        if (colorTable.length == 3) {
            return colorTable;
        }
        int len = colorTable[0].length;
        float[][] newTable = new float[3][len];
        for (int n = 0; n < 3; ++n) {
            for (int m = 0; m < len; ++m) {
                newTable[n][m] = colorTable[n][m];
            }
        }
        return newTable;
    }

    public static final float[][] addAlpha(float[][] colorTable) {
        int m;
        int n;
        if (colorTable.length == 4) {
            return colorTable;
        }
        int len = colorTable[0].length;
        float[][] caTable = new float[4][len];
        for (n = 0; n < 3; ++n) {
            for (m = 0; m < len; ++m) {
                caTable[n][m] = colorTable[n][m];
            }
        }
        n = 3;
        for (m = 0; m < len; ++m) {
            caTable[n][m] = 1.0f;
        }
        return caTable;
    }

    public void setTransparency(float alpha) {
        this.tableArray = ColorTable.changeTransparency(this.tableArray, alpha);
        this.colorList = null;
    }

    public static final float[][] changeTransparency(float[][] colorTable, float alpha) {
        int m;
        int n;
        int len = colorTable[0].length;
        float[][] newCT = new float[4][len];
        for (n = 0; n < 3; ++n) {
            for (m = 0; m < len; ++m) {
                newCT[n][m] = colorTable[n][m];
            }
        }
        n = 3;
        for (m = 0; m < len; ++m) {
            newCT[n][m] = alpha;
        }
        return newCT;
    }

    public void setScaleFactor(float[] value) {
        this.scaleFactor = value;
    }

    public float[] getScaleFactor() {
        return this.scaleFactor;
    }

    public static class Breakpoint {
        private double value = 0.0;
        private boolean locked = false;

        public Breakpoint() {
        }

        public Breakpoint(double v) {
            this(v, false);
        }

        public Breakpoint(double v, boolean locked) {
            this.value = v;
            this.locked = locked;
        }

        public Breakpoint(Breakpoint that) {
            if (that != null) {
                this.value = that.value;
                this.locked = that.locked;
            }
        }

        public void setValue(double value) {
            this.value = value;
        }

        public double getValue() {
            return this.value;
        }

        public void setLocked(boolean value) {
            this.locked = value;
        }

        public boolean getLocked() {
            return this.locked;
        }

        public static ArrayList cloneList(List l) {
            if (l == null || l.size() == 0) {
                return new ArrayList();
            }
            ArrayList<Breakpoint> tmp = l;
            l = new ArrayList<Breakpoint>();
            if (tmp.get(0) instanceof Double) {
                for (int i = 0; i < tmp.size(); ++i) {
                    l.add(new Breakpoint((Double)tmp.get(i)));
                }
            } else {
                for (int i = 0; i < tmp.size(); ++i) {
                    l.add(new Breakpoint((Breakpoint)tmp.get(i)));
                }
            }
            return new ArrayList(l);
        }

        public String toString() {
            return "" + this.value + " " + this.locked;
        }
    }
}

