/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.xerces.dom.DeferredElementImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.ui.XmlTree;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.xml.XmlUtil;

public class CatalogUtil {
    public static final String PROP_TITLE = "TITLE";
    public static final String PROP_SERVICE_HTTP = "prop.service.http";
    public static final String PROP_CATALOGURL = "Thredds.CatalogUrl";
    public static final String PROP_DATASETID = "Thredds.DataSetId";
    public static final String PROP_DATASETGROUP = "Thredds.DataGroup";
    public static final String PROP_ANNOTATIONSERVER = "Thredds.AnnotationServer";
    public static final String ATTR_CATALOGURL = "catalogurl";
    public static final String ATTR_DATASETGROUP = "group";
    public static final String ATTR_DATASETID = "id";
    public static final String ATTR_METADATATYPE = "metadataType";
    public static final String VALUE_ANNOTATIONSERVER = "annotationServer";
    public static final String VALUE_SUMMARY = "summary";
    public static final String VALUE_RIGHTS = "rights";
    public static final String NULL_STRING = null;
    public static final String SERVICE_RESOLVER = "Resolver";
    public static final String SERVICE_COMPOUND = "Compound";
    public static final String SERVICE_FILE = "FILE";
    public static final String SERVICE_HTTP = "HTTPServer";
    public static final String SERVICE_DODS = "DODS";
    public static final String SERVICE_ADDE = "ADDE";
    public static final String SERVICE_OPENDAP = "OPENDAP";
    public static final double THREDDS_VERSION_0_4 = 0.4;
    public static final double THREDDS_VERSION_0_5 = 0.5;
    public static final double THREDDS_VERSION_0_6 = 0.6;
    public static final double THREDDS_VERSION_1_0 = 1.0;
    public static final String TAG_LATLONBOX = "LatLonBox";
    public static final String TAG_NORTH = "north";
    public static final String TAG_SOUTH = "south";
    public static final String TAG_EAST = "east";
    public static final String TAG_WEST = "west";
    public static final String TAG_NAME = "name";
    public static final String TAG_CONTACT = "contact";
    public static final String TAG_GEOSPATIALCOVERAGE = "geospatialCoverage";
    public static final String TAG_TIMECOVERAGE = "timeCoverage";
    public static final String TAG_START = "start";
    public static final String TAG_END = "end";
    public static final String TAG_DATASIZE = "dataSize";
    public static final String TAG_DATE = "date";
    public static final String TAG_ACCESS = "access";
    public static final String TAG_DOCUMENTATION = "documentation";
    public static final String TAG_DOCPARENT = "docparent";
    public static final String TAG_CATALOG = "catalog";
    public static final String TAG_CATALOGREF = "catalogRef";
    public static final String TAG_COLLECTION = "collection";
    public static final String TAG_DATASET = "dataset";
    public static final String TAG_DATATYPE = "dataType";
    public static final String TAG_METADATA = "metadata";
    public static final String TAG_QUERYCAPABILITY = "queryCapability";
    public static final String TAG_SERVER = "server";
    public static final String TAG_SERVICE = "service";
    public static final String TAG_SERVICENAME = "serviceName";
    public static final String ATTR_UNITS = "units";
    public static final String TAG_PROPERTY = "property";
    public static final String ATTR_ACTION = "action";
    public static final String ATTR_DATATYPE = "dataType";
    public static final String ATTR_BASE = "base";
    public static final String ATTR_ID = "ID";
    public static final String ATTR_INHERITED = "inherited";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_SERVERID = "serverID";
    public static final String ATTR_SERVICENAME = "serviceName";
    public static final String ATTR_SERVICETYPE = "serviceType";
    public static final String ATTR_SUFFIX = "suffix";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_URL = "url";
    public static final String ATTR_URLPATH = "urlPath";
    public static final String ATTR_VERSION = "version";
    public static final String ATTR_XLINK_HREF = "xlink:href";
    public static final String ATTR_XLINK_TITLE = "xlink:title";

    public static double getVersion(Element node) {
        if (!XmlUtil.hasAttribute(node, ATTR_VERSION)) {
            Node parent = node.getParentNode();
            if (parent == null || !(parent instanceof Element)) {
                return 1.0;
            }
            return CatalogUtil.getVersion((Element)parent);
        }
        String version = XmlUtil.getAttribute((Node)node, ATTR_VERSION, String.valueOf(1.0));
        while (version.indexOf(".") != version.lastIndexOf(".")) {
            version = version.substring(0, version.lastIndexOf("."));
        }
        return new Double(version);
    }

    public static boolean haveChildDatasets(Element node) {
        return XmlUtil.findChild(node, TAG_DATASET) != null;
    }

    public static boolean haveChildCatalogs(Element node) {
        return XmlUtil.findChild(node, TAG_CATALOGREF) != null;
    }

    public static String getServiceType(Element serviceNode) {
        String serviceType = XmlUtil.getAttribute((Node)serviceNode, ATTR_SERVICETYPE, NULL_STRING);
        if (serviceType == null) {
            serviceType = XmlUtil.getAttribute((Node)serviceNode, ATTR_TYPE, NULL_STRING);
        }
        return serviceType;
    }

    private static String getDataType(Element datasetNode) {
        String dataType = XmlUtil.getAttribute((Node)datasetNode, "dataType", NULL_STRING);
        if (dataType == null) {
            // empty if block
        }
        return dataType;
    }

    public static String getTitleFromDataset(Element datasetNode) {
        String ext;
        Hashtable tags = Misc.newHashtable(TAG_DATASET, TAG_DATASET, TAG_COLLECTION, TAG_COLLECTION);
        List titleAttrs = XmlUtil.getAttributesFromTree(datasetNode, "name", tags);
        String title = null;
        if (titleAttrs != null && titleAttrs.size() >= 1) {
            title = titleAttrs.get(titleAttrs.size() - 1).toString().replace("_", " ");
        }
        if (title != null && (ext = IOUtil.getFileExtension(title)) != null && ext.length() <= 6) {
            title = IOUtil.stripExtension(title);
        }
        return title;
    }

    private static void findChildServiceNode(List nodes, Element datasetNode, String serviceName) {
        if (datasetNode == null) {
            return;
        }
        for (Element serviceNode : XmlUtil.findChildren(datasetNode, TAG_SERVICE)) {
            String serviceType = XmlUtil.getAttribute((Node)serviceNode, ATTR_SERVICETYPE, NULL_STRING);
            if (!Misc.equals(XmlUtil.getAttribute((Node)serviceNode, "name", NULL_STRING), serviceName)) {
                if (!Misc.equals(serviceType, SERVICE_COMPOUND)) continue;
                for (Element child : XmlUtil.findChildren(serviceNode, TAG_SERVICE)) {
                    if (!Misc.equals(XmlUtil.getAttribute((Node)child, "name", NULL_STRING), serviceName)) continue;
                    nodes.add(child);
                }
                continue;
            }
            if (Misc.equals(serviceType, SERVICE_COMPOUND)) {
                for (Element child : XmlUtil.findChildren(serviceNode, TAG_SERVICE)) {
                    nodes.add(child);
                }
                continue;
            }
            nodes.add(serviceNode);
        }
        Node node = datasetNode.getParentNode();
        if (node instanceof Element) {
            CatalogUtil.findChildServiceNode(nodes, (Element)node, serviceName);
        }
    }

    public static void errorMessage(String msg) {
        LogUtil.userErrorMessage(msg);
    }

    public static Element findServiceNodeForDataset(Element datasetNode, boolean showErrors, String type) {
        boolean typeWasNull;
        double version = CatalogUtil.getVersion(datasetNode);
        String serviceName = CatalogUtil.findServiceNameForDataset(datasetNode, version, true);
        if (serviceName == null) {
            if (showErrors) {
                CatalogUtil.errorMessage("Could not find service name");
            }
            return null;
        }
        ArrayList serviceNodes = new ArrayList();
        CatalogUtil.findChildServiceNode(serviceNodes, datasetNode, serviceName);
        if (serviceNodes.size() == 0) {
            if (showErrors) {
                CatalogUtil.errorMessage("No service found with id = " + serviceName);
            }
            return null;
        }
        boolean bl = typeWasNull = type == null;
        if (type == null) {
            type = "DODS|OPENDAP|ADDE|Resolver|FILE";
        }
        type = type.toLowerCase();
        for (int i = 0; i < serviceNodes.size(); ++i) {
            Element serviceNode = (Element)serviceNodes.get(i);
            String serviceType = XmlUtil.getAttribute((Node)serviceNode, ATTR_SERVICETYPE, NULL_STRING);
            if (serviceType == null || !StringUtil.stringMatch(serviceType = serviceType.toLowerCase(), type)) continue;
            return serviceNode;
        }
        if (typeWasNull && serviceNodes.size() > 0) {
            return (Element)serviceNodes.get(0);
        }
        if (showErrors) {
            CatalogUtil.errorMessage("No service found with id = " + serviceName);
        }
        return null;
    }

    public static String findBaseForDataset(Element datasetNode, Element root) {
        Element serviceNode = CatalogUtil.findServiceNodeForDataset(datasetNode, true, null);
        if (serviceNode == null) {
            return null;
        }
        String base = XmlUtil.getAttribute((Node)serviceNode, ATTR_BASE, NULL_STRING);
        if (base == null) {
            CatalogUtil.errorMessage("No base found for dataset.");
            return null;
        }
        return base;
    }

    private static String findCatalogSource(Element node) {
        String source = XmlUtil.getAttribute((Node)node, ATTR_CATALOGURL, (String)null);
        if (source != null) {
            return source;
        }
        Node parent = node.getParentNode();
        if (parent == null || !(parent instanceof Element)) {
            return null;
        }
        return CatalogUtil.findCatalogSource((Element)parent);
    }

    private static String findServiceNameForDataset(Element datasetNode, double version, boolean firstCall) {
        String serviceName = XmlUtil.getAttribute((Node)datasetNode, "serviceName", NULL_STRING);
        if (serviceName != null) {
            return serviceName;
        }
        Element accessNode = XmlUtil.findChild(datasetNode, TAG_ACCESS);
        if (accessNode != null && (serviceName = XmlUtil.getAttribute(accessNode, "serviceName")) != null) {
            return serviceName;
        }
        serviceName = CatalogUtil.findServiceNameTagValue(datasetNode);
        if (serviceName != null) {
            return serviceName;
        }
        if (version >= 1.0) {
            return CatalogUtil.findServiceNameFromMetaData(datasetNode, version, true);
        }
        Element parent = (Element)datasetNode.getParentNode();
        if (parent == null || !XmlUtil.isTag(parent, TAG_DATASET)) {
            return null;
        }
        return CatalogUtil.findServiceNameForDataset(parent, version, false);
    }

    public static String findDataTypeForDataset(Element datasetNode, Element root, double version, boolean firstCall) {
        String dataType = XmlUtil.getAttributeFromTree((Node)datasetNode, "dataType", null);
        if (dataType != null) {
            return dataType;
        }
        dataType = CatalogUtil.findTagValue(datasetNode, "dataType");
        if (dataType != null) {
            return dataType;
        }
        if (version >= 1.0) {
            return CatalogUtil.findTagValueFromMetaData(datasetNode, version, true, "dataType");
        }
        Element parent = (Element)datasetNode.getParentNode();
        if (parent == null || !XmlUtil.isTag(parent, TAG_DATASET)) {
            return null;
        }
        return CatalogUtil.findDataTypeForDataset(parent, root, version, false);
    }

    private static String findServiceNameTagValue(Element datasetNode) {
        return CatalogUtil.findTagValue(datasetNode, "serviceName");
    }

    private static String findTagValue(Element datasetNode, String tagName) {
        String value;
        Element tagNode = XmlUtil.findChild(datasetNode, tagName);
        if (tagNode != null && (value = XmlUtil.getChildText(tagNode)) != null && value.trim().length() > 0) {
            return value.trim();
        }
        return null;
    }

    private static String findServiceNameFromMetaData(Element datasetNode, double version, boolean first) {
        return CatalogUtil.findTagValueFromMetaData(datasetNode, version, first, "serviceName");
    }

    private static String findTagValueFromMetaData(Element datasetNode, double version, boolean first, String tagName) {
        List children = XmlUtil.findChildren(datasetNode, TAG_METADATA);
        for (int i = 0; i < children.size(); ++i) {
            String value;
            Element metaDataNode = (Element)children.get(i);
            if (!first && !XmlUtil.getAttribute((Node)metaDataNode, ATTR_INHERITED, false) || (value = CatalogUtil.findTagValue(metaDataNode, tagName)) == null) continue;
            return value;
        }
        Element parent = (Element)datasetNode.getParentNode();
        if (parent == null || !XmlUtil.isTag(parent, TAG_DATASET)) {
            return null;
        }
        return CatalogUtil.findTagValueFromMetaData(parent, version, false, tagName);
    }

    public static String getAbsoluteUrl(Element serviceNode, String urlPath) {
        String base = XmlUtil.getAttribute((Node)serviceNode, ATTR_BASE, NULL_STRING);
        if (base == null) {
            CatalogUtil.errorMessage("No base found for dataset.");
            return null;
        }
        String suffix = XmlUtil.getAttribute((Node)serviceNode, ATTR_SUFFIX, NULL_STRING);
        if (suffix != null) {
            urlPath = urlPath + suffix;
        }
        base = base + urlPath;
        String catalogSource = CatalogUtil.findCatalogSource(serviceNode);
        if (catalogSource != null) {
            base = XmlTree.expandRelativeUrl(base, catalogSource);
        }
        return base;
    }

    public static String getUrlPath(Element datasetNode) {
        Element accessNode;
        String urlPath = XmlUtil.getAttribute((Node)datasetNode, ATTR_URLPATH, NULL_STRING);
        if (urlPath == null && (accessNode = XmlUtil.findChild(datasetNode, TAG_ACCESS)) != null) {
            urlPath = XmlUtil.getAttribute(accessNode, ATTR_URLPATH);
        }
        return urlPath;
    }

    public static Object[] getResolverData(String resolverUrl, Hashtable properties) {
        Element datasetNode;
        Element serviceNode;
        Element newRoot = null;
        try {
            String contents = IOUtil.readContents(resolverUrl);
            if (contents == null) {
                CatalogUtil.errorMessage("Failed to read the catalog:" + resolverUrl);
                return null;
            }
            newRoot = XmlUtil.getRoot(contents);
            newRoot.setAttribute(ATTR_CATALOGURL, resolverUrl);
        }
        catch (Exception exc) {
            CatalogUtil.errorMessage("Error reading catalog:" + resolverUrl + "\n" + exc);
            return null;
        }
        if (newRoot == null) {
            CatalogUtil.errorMessage("Failed to retrieve the catalog:" + resolverUrl);
            return null;
        }
        List datasetNodes = XmlUtil.findDescendants(newRoot, TAG_DATASET);
        if (datasetNodes.size() == 0) {
            CatalogUtil.errorMessage("No dataset nodes found in the  catalog:" + resolverUrl);
            return null;
        }
        if (datasetNodes.size() > 1) {
            Object dn = datasetNodes.get(0);
            if (dn instanceof DeferredElementImpl) {
                DeferredElementImpl dei = (DeferredElementImpl)dn;
                if (!dei.hasAttribute(ATTR_URLPATH)) {
                    CatalogUtil.errorMessage("Too many dataset nodes found in the  catalog:" + resolverUrl);
                    return null;
                }
            } else {
                CatalogUtil.errorMessage("Too many dataset nodes found in the  catalog:" + resolverUrl);
                return null;
            }
        }
        if ((serviceNode = CatalogUtil.findServiceNodeForDataset(datasetNode = (Element)datasetNodes.get(0), false, null)) == null) {
            CatalogUtil.errorMessage("Could not find service node");
            return null;
        }
        String urlPath = CatalogUtil.getUrlPath(datasetNode);
        if (properties != null) {
            CatalogUtil.addServiceProperties(datasetNode, properties, urlPath);
        }
        return new Object[]{newRoot, datasetNode, serviceNode, CatalogUtil.getAbsoluteUrl(serviceNode, urlPath)};
    }

    public static String resolveUrl(String resolverUrl, Hashtable properties) {
        String title;
        Object[] result = CatalogUtil.getResolverData(resolverUrl, properties);
        if (result == null) {
            return null;
        }
        if (properties != null && (title = CatalogUtil.getTitleFromDataset((Element)result[1])) != null) {
            properties.put(PROP_TITLE, title);
        }
        return (String)result[3];
    }

    public static void addServiceProperties(Element datasetNode, Hashtable properties, String urlPath) {
        String serviceUrl;
        Element dataServiceNode = CatalogUtil.findServiceNodeForDataset(datasetNode, false, SERVICE_HTTP);
        if (dataServiceNode != null && (serviceUrl = CatalogUtil.getAbsoluteUrl(dataServiceNode, urlPath)) != null) {
            properties.put(PROP_SERVICE_HTTP, serviceUrl);
        }
    }

    public static int generateHtml(Element root, Element datasetNode, int cnt, String bundleTemplate, String jnlpTemplate) {
        ++cnt;
        String name = XmlUtil.getAttribute(datasetNode, "name");
        Element serviceNode = CatalogUtil.findServiceNodeForDataset(datasetNode, false, null);
        if (serviceNode == null) {
            System.out.println("<li> " + name + "\n");
        } else {
            String serviceType = CatalogUtil.getServiceType(serviceNode);
            Hashtable properties = new Hashtable();
            boolean isResolver = SERVICE_RESOLVER.equals(serviceType);
            if (!isResolver) {
                String urlPath = CatalogUtil.getUrlPath(datasetNode);
                String dataUrl = CatalogUtil.getAbsoluteUrl(serviceNode, urlPath);
                String jnlpFile = "generated" + cnt + ".jnlp";
                String bundleFile = "generated" + cnt + ".xidv";
                System.out.println("<li> <a href=\"" + jnlpFile + "\">" + name + "</a>\n");
                try {
                    String bundle = StringUtil.replace(bundleTemplate, "%datasource%", dataUrl);
                    bundle = StringUtil.replace(bundle, "%title%", name);
                    IOUtil.writeFile(bundleFile, bundle);
                    String jnlp = StringUtil.replace(jnlpTemplate, "%title%", "Generated bundle for:" + name);
                    jnlp = StringUtil.replace(jnlp, "%jnlpfile%", jnlpFile);
                    jnlp = StringUtil.replace(jnlp, "%bundle%", "http://www.unidata.ucar.edu/projects/metapps/testgen/" + bundleFile);
                    IOUtil.writeFile(jnlpFile, jnlp);
                }
                catch (Exception exc) {
                    System.err.println("error:" + exc);
                    System.exit(1);
                }
            }
        }
        List children = XmlUtil.findChildren(datasetNode, TAG_DATASET);
        for (int i = 0; i < children.size(); ++i) {
            if (i == 0) {
                System.out.println("<ul>");
            }
            Element child = (Element)children.get(i);
            cnt = CatalogUtil.generateHtml(root, child, cnt, bundleTemplate, jnlpTemplate);
        }
        if (children.size() > 0) {
            System.out.println("</ul>");
        }
        return cnt;
    }
}

