/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.StringUtil;

public class CacheManager {
    private static File cacheDir;
    private static File tmpDir;
    private static boolean doCache;
    static LogUtil.LogCategory log_;
    private static Object MUTEX;
    private static Hashtable caches;
    private static boolean haveInitialized;
    private static int fileCount;
    private static long maxCacheSize;
    private static long currentCacheSize;
    private static List cacheListeners;

    public static void setDoCache(boolean cache) {
        doCache = cache;
        if (!doCache) {
            CacheManager.clearCache();
        }
    }

    public static boolean getDoCache() {
        return doCache;
    }

    public static void setCacheDir(File dir) {
        cacheDir = dir;
    }

    public static void setTmpDir(File dir) {
        tmpDir = dir;
    }

    public static File getTmpDir() {
        return tmpDir;
    }

    public static File getTmpFile(String prefix) {
        return new File(IOUtil.joinDir(tmpDir, prefix + "_" + System.currentTimeMillis() + "_" + fileCount++));
    }

    public static File getCacheGroupDir(String group) {
        if (cacheDir == null) {
            return null;
        }
        if (!cacheDir.exists()) {
            return null;
        }
        File f = cacheDir;
        List<String> subdirs = StringUtil.split(group, "/");
        for (int i = 0; i < subdirs.size(); ++i) {
            f = new File(IOUtil.joinDir(f, subdirs.get(i).toString()));
            IOUtil.makeDir(f);
        }
        return f;
    }

    private static String prepareCacheFilename(String name) {
        return StringUtil.replaceList(name, new String[]{"http:", ":", "/", "\\", "?", "&", ",", "="}, new String[]{"", "_", "_", "_", "_", "_", "_", "_"});
    }

    public static File getCachedFilePath(String group, String id) {
        File f = CacheManager.getCacheGroupDir(group);
        if (f == null) {
            return null;
        }
        id = CacheManager.prepareCacheFilename(id);
        f = new File(IOUtil.joinDir(f, id));
        return f;
    }

    public static byte[] getCachedFile(String group, String id) {
        try {
            File f = CacheManager.getCachedFilePath(group, id);
            if (f == null) {
                return null;
            }
            if (!f.exists()) {
                return null;
            }
            f.setLastModified(System.currentTimeMillis());
            return IOUtil.readBytes(new FileInputStream(f));
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Error reading cache:" + exc);
        }
    }

    public static void setMaxFileCacheSize(long maxSize) {
        maxCacheSize = maxSize;
        CacheManager.checkCacheSize();
    }

    public static void putCachedFile(String group, String id, byte[] bytes) {
        try {
            if (!doCache) {
                return;
            }
            File f = CacheManager.getCacheGroupDir(group);
            if (f == null) {
                return;
            }
            id = CacheManager.prepareCacheFilename(id);
            f = new File(IOUtil.joinDir(f, id));
            IOUtil.writeBytes(f, bytes);
            currentCacheSize = CacheManager.getCacheSize() + (long)bytes.length;
            CacheManager.checkCacheSize();
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Error reading cache:" + exc);
        }
    }

    private static void checkCacheSize() {
        currentCacheSize = CacheManager.getCacheSize();
        if (currentCacheSize > maxCacheSize) {
            File[] allFiles = IOUtil.sortFilesOnAge(IOUtil.toFiles(IOUtil.getFiles(cacheDir, true)), false);
            long limit = (long)((double)maxCacheSize * 0.75);
            for (int fileIdx = 0; currentCacheSize > limit && fileIdx < allFiles.length; currentCacheSize -= allFiles[fileIdx].length(), ++fileIdx) {
                allFiles[fileIdx].delete();
            }
            currentCacheSize = CacheManager.findCacheSize();
        }
    }

    private static long getCacheSize() {
        if (currentCacheSize < 0L) {
            currentCacheSize = CacheManager.findCacheSize();
        }
        return currentCacheSize;
    }

    private static int findCacheSize() {
        if (cacheDir == null) {
            return 0;
        }
        List<File> files = IOUtil.getFiles(cacheDir, true);
        int size = 0;
        for (int i = 0; i < files.size(); ++i) {
            size = (int)((long)size + files.get(i).length());
        }
        return size;
    }

    private static void init() {
        if (haveInitialized) {
            return;
        }
        haveInitialized = true;
    }

    public static void put(Object owner, Object key, Object value) {
        CacheManager.put(owner, key, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void put(Object owner, Object key, Object value, boolean force) {
        Object object = MUTEX;
        synchronized (object) {
            if (doCache || force) {
                Hashtable ht = CacheManager.findOrCreate(owner);
                ht.put(key, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Object object = MUTEX;
        synchronized (object) {
            caches = new Hashtable();
            for (int i = 0; i < cacheListeners.size(); ++i) {
                ActionListener al = (ActionListener)cacheListeners.get(i);
                al.actionPerformed(new ActionEvent("CacheManager", 0, "cacheclear"));
            }
        }
    }

    public static void addCacheListener(ActionListener a) {
        cacheListeners.add(a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable findOrCreate(Object owner) {
        Object object = MUTEX;
        synchronized (object) {
            return CacheManager.find(owner, true);
        }
    }

    private static Hashtable find(Object owner) {
        return CacheManager.find(owner, false);
    }

    private static Hashtable find(Object owner, boolean orCreate) {
        CacheManager.init();
        Hashtable ht = (Hashtable)caches.get(owner);
        if (ht == null && orCreate) {
            ht = new Hashtable();
            caches.put(owner, ht);
        }
        return ht;
    }

    public static Object get(Object owner, Object key) {
        return CacheManager.get(owner, key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object get(Object owner, Object key, boolean force) {
        Object object = MUTEX;
        synchronized (object) {
            if (doCache || force) {
                Hashtable ht = CacheManager.find(owner);
                if (ht == null) {
                    return null;
                }
                return ht.get(key);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Object owner) {
        Object object = MUTEX;
        synchronized (object) {
            caches.remove(owner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Object owner, Object key) {
        Object object = MUTEX;
        synchronized (object) {
            Hashtable ht = CacheManager.find(owner);
            if (ht != null) {
                ht.remove(key);
            }
        }
    }

    public static void printStats() {
        System.err.println("\tCacheManager: #caches:" + caches.size());
        Enumeration keys = caches.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Hashtable cache = (Hashtable)caches.get(key);
            System.err.println("\tKey:" + key + " size:" + cache.size());
        }
    }

    static {
        doCache = true;
        log_ = LogUtil.getLogInstance(CacheManager.class.getName());
        MUTEX = new Object();
        caches = new Hashtable();
        haveInitialized = false;
        fileCount = 0;
        maxCacheSize = Integer.MAX_VALUE;
        currentCacheSize = -1L;
        cacheListeners = new ArrayList();
    }
}

