/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class Cache<KeyType, ValueType> {
    private Hashtable<KeyType, ValueType> cache = new Hashtable();
    private List<KeyType> keys = new ArrayList<KeyType>();
    private int cacheSize = 100;

    public Cache(int size) {
        this.cacheSize = size;
    }

    public synchronized ValueType get(KeyType key) {
        return this.cache.get(key);
    }

    public synchronized ValueType getAndRemove(KeyType key) {
        return this.cache.remove(key);
    }

    public synchronized void put(KeyType key, ValueType value) {
        this.keys.remove(key);
        this.keys.add(key);
        while (this.keys.size() > this.cacheSize) {
            KeyType keyToRemove = this.keys.get(0);
            ValueType valueToRemove = this.cache.get(keyToRemove);
            this.removeValue(keyToRemove, valueToRemove);
            this.keys.remove(0);
            this.cache.remove(keyToRemove);
        }
        this.cache.put(key, value);
    }

    public synchronized void clear() {
        for (KeyType key : this.keys) {
            ValueType value = this.cache.get(key);
            this.removeValue(key, value);
        }
        this.cache = new Hashtable();
        this.keys = new ArrayList<KeyType>();
    }

    protected void removeValue(KeyType key, ValueType object) {
    }
}

