/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.io.InputStream;
import ucar.unidata.util.ByteString;

public class ByteStringInputStream
extends InputStream {
    protected final ByteString bs_;
    protected int pos_ = 0;
    protected int mark_ = 0;

    public ByteStringInputStream(ByteString bs) {
        this.bs_ = bs;
    }

    @Override
    public int read() {
        return this.pos_ < this.bs_.getLength() ? this.bs_.byteAt(this.pos_++) & 0xFF : -1;
    }

    @Override
    public int read(byte[] dst, int off, int nbytes) {
        if (dst == null) {
            throw new NullPointerException();
        }
        int length = this.bs_.getLength();
        int end = off + nbytes;
        if (off < 0 || nbytes < 0 || end > dst.length || end < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos_ >= length) {
            return -1;
        }
        if (end > length) {
            nbytes = length - this.pos_;
        }
        if (nbytes <= 0) {
            return 0;
        }
        this.bs_.copyBytes(this.pos_, dst, off, nbytes);
        this.pos_ += nbytes;
        return nbytes;
    }

    @Override
    public long skip(long nbytes) {
        int length = this.bs_.getLength();
        if ((long)this.pos_ + nbytes > (long)length) {
            nbytes = length - this.pos_;
        }
        if (nbytes < 0L) {
            return 0L;
        }
        this.pos_ = (int)((long)this.pos_ + nbytes);
        return nbytes;
    }

    @Override
    public int available() {
        return this.bs_.getLength() - this.pos_;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) {
        this.mark_ = this.pos_;
    }

    @Override
    public void reset() {
        this.pos_ = this.mark_;
    }
}

