/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;

public abstract class ByteString
implements Comparable,
Serializable {
    public static final byte[] nada = new byte[0];

    public static final char ByteToChar8859_1(byte bb) {
        if (bb < 0) {
            return (char)(256 + bb);
        }
        return (char)bb;
    }

    public static final byte CharToByte8859_1(char cc) {
        if (cc > '\u00ff') {
            throw new IllegalArgumentException();
        }
        return (byte)cc;
    }

    public static int compare(ByteString bs1, ByteString bs2) {
        int len1 = bs1.getLength();
        int len2 = bs2.getLength();
        int nn = Math.min(len1, len2);
        for (int ii = 0; ii < nn; ++ii) {
            char c2;
            char c1 = bs1.charAt(ii);
            if (c1 == (c2 = bs2.charAt(ii))) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    public static int compare(ByteString bs1, String s2) {
        int len1 = bs1.getLength();
        int len2 = s2.length();
        int nn = Math.min(len1, len2);
        for (int ii = 0; ii < nn; ++ii) {
            char c2;
            char c1 = bs1.charAt(ii);
            if (c1 == (c2 = s2.charAt(ii))) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    public static byte[] concat(byte[] b1, byte[] b2, byte sep) {
        byte[] ba = new byte[b1.length + b2.length + 1];
        if (b1.length > 0) {
            System.arraycopy(b1, 0, ba, 0, b1.length);
        }
        ba[b1.length] = sep;
        if (b2.length > 0) {
            System.arraycopy(b2, 0, ba, b1.length + 1, b2.length);
        }
        return ba;
    }

    public static ByteString concat(ByteString bs1, ByteString bs2, char sep) {
        int l1 = bs1.getLength();
        int l2 = bs2.getLength();
        byte[] ba = new byte[l1 + l2 + 1];
        bs1.copyBytes(0, ba, 0, l1);
        ba[l1] = ByteString.CharToByte8859_1(sep);
        bs2.copyBytes(0, ba, l1 + 1, l2);
        return new Concrete(ba, true);
    }

    protected ByteString() {
    }

    public abstract int getLength();

    public abstract byte byteAt(int var1);

    public char charAt(int ii) {
        return ByteString.ByteToChar8859_1(this.byteAt(ii));
    }

    public byte[] copyBytes(int srcpos, byte[] dst, int dstpos, int nbytes) {
        int last = srcpos + nbytes;
        while (srcpos < last) {
            dst[dstpos++] = this.byteAt(srcpos++);
        }
        return dst;
    }

    public byte[] toArray() {
        int nbytes = this.getLength();
        byte[] ba = new byte[nbytes];
        return this.copyBytes(0, ba, 0, nbytes);
    }

    public ByteString subByteString(int beginIndex, int length) {
        if (beginIndex < 0) {
            throw new IllegalArgumentException("beginIndex < 0");
        }
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        if (beginIndex == 0) {
            if (length == this.getLength()) {
                return this;
            }
            return new Concrete(this, length);
        }
        return new Concrete(this, beginIndex, length);
    }

    public ByteString substring(int beginIndex, int endindex) {
        return this.subByteString(beginIndex, endindex - beginIndex);
    }

    public ByteString substring(int beginIndex) {
        if (beginIndex < 0) {
            throw new IllegalArgumentException("beginIndex < 0");
        }
        if (beginIndex == 0) {
            return this;
        }
        return new Concrete(this, beginIndex, this.getLength() - beginIndex);
    }

    public final int length() {
        return this.getLength();
    }

    public int compareTo(ByteString bs) {
        return ByteString.compare(this, bs);
    }

    public int compareTo(String ss) {
        return ByteString.compare(this, ss);
    }

    public int compareTo(Object oo) {
        return this.compareTo((ByteString)oo);
    }

    public StringBuffer format(StringBuffer buf) {
        int len = this.getLength();
        for (int ii = 0; ii < len; ++ii) {
            buf.append(this.charAt(ii));
        }
        return buf;
    }

    public int hashCode() {
        int hash = 0;
        int len = this.getLength();
        for (int ii = 0; ii < len; ++ii) {
            hash = 31 * hash + this.charAt(ii);
        }
        return hash;
    }

    public boolean equals(Object oo) {
        if (this == oo) {
            return true;
        }
        if (oo != null && oo instanceof ByteString) {
            ByteString other = (ByteString)oo;
            int len = this.getLength();
            if (len != other.getLength()) {
                return false;
            }
            for (int ii = 0; ii < len; ++ii) {
                if (this.byteAt(ii) == other.byteAt(ii)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equalS(String ss) {
        if (ss != null) {
            return this.compareTo(ss) == 0;
        }
        return false;
    }

    public String toString() {
        return this.format(new StringBuffer(this.getLength())).toString();
    }

    public static void main(String[] args) {
        try {
            BufferedReader rdr = new BufferedReader(new InputStreamReader(System.in));
            Concrete prev = null;
            String line = rdr.readLine();
            while (line != null) {
                Concrete bs = new Concrete(line);
                System.out.println("String hash: " + line.hashCode());
                System.out.print("       hash: " + bs.hashCode());
                System.out.println(" \"" + bs + "\"");
                if (prev != null) {
                    System.out.println("cmp " + bs.compareTo((Object)prev));
                }
                prev = bs;
                line = rdr.readLine().trim();
            }
        }
        catch (Exception ee) {
            ee.printStackTrace(System.err);
            System.exit(1);
        }
        System.exit(0);
    }

    public static class SubString
    extends TrSubString {
        protected final int origin_;

        public SubString(byte[] ba, boolean share, int origin, int length) {
            super(ba, share, length);
            if (origin > this.ba_.length) {
                throw new IllegalArgumentException("Invalid origin");
            }
            this.origin_ = origin;
            if (origin + this.length_ > this.ba_.length) {
                throw new IllegalArgumentException("Invalid length");
            }
        }

        public SubString(SubString sbs, int origin, int length) {
            super(sbs.ba_, true, length);
            int len = sbs.getLength();
            if ((origin += sbs.origin_) > len) {
                throw new IllegalArgumentException("Invalid origin");
            }
            this.origin_ = origin;
            if (origin + length > len) {
                throw new IllegalArgumentException("Invalid length");
            }
        }

        public SubString(Concrete bs, int origin, int length) {
            super(bs.ba_, true, length);
            int len = bs.getLength();
            if (origin > len) {
                throw new IllegalArgumentException("Invalid origin");
            }
            this.origin_ = origin;
            if (origin + length > len) {
                throw new IllegalArgumentException("Invalid length");
            }
        }

        @Override
        public byte byteAt(int ii) {
            if (ii < 0 || ii > this.length_) {
                throw new IndexOutOfBoundsException();
            }
            return this.ba_[this.origin_ + ii];
        }

        @Override
        public byte[] copyBytes(int srcpos, byte[] dst, int dstpos, int nbytes) {
            if (srcpos < 0 || srcpos > this.length_ || srcpos + nbytes > this.length_) {
                throw new IndexOutOfBoundsException();
            }
            System.arraycopy(this.ba_, srcpos + this.origin_, dst, dstpos, nbytes);
            return dst;
        }

        @Override
        public byte[] toArray() {
            byte[] ba = new byte[this.length_];
            System.arraycopy(this.ba_, this.origin_, ba, 0, this.length_);
            return ba;
        }
    }

    public static class TrSubString
    extends Concrete {
        protected final int length_;

        public TrSubString(byte[] ba, boolean share, int length) {
            super(ba, share);
            if (length > this.ba_.length) {
                throw new IllegalArgumentException("Invalid length");
            }
            this.length_ = length;
        }

        public TrSubString(Concrete bs, int length) {
            super(bs.ba_, true);
            if (length > bs.getLength()) {
                throw new IllegalArgumentException("Invalid length");
            }
            this.length_ = length;
        }

        @Override
        public int getLength() {
            return this.length_;
        }

        @Override
        public byte byteAt(int ii) {
            if (ii > this.length_) {
                throw new IndexOutOfBoundsException();
            }
            return this.ba_[ii];
        }

        @Override
        public byte[] copyBytes(int srcpos, byte[] dst, int dstpos, int nbytes) {
            System.arraycopy(this.ba_, srcpos, dst, dstpos, nbytes);
            return dst;
        }

        @Override
        public byte[] toArray() {
            return (byte[])this.ba_.clone();
        }
    }

    public static class Concrete
    extends ByteString
    implements Serializable {
        protected final byte[] ba_;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Concrete(byte[] ba, boolean share) {
            if (share) {
                this.ba_ = ba;
                return;
            }
            byte[] byArray = ba;
            synchronized (ba) {
                this.ba_ = new byte[ba.length];
                System.arraycopy(ba, 0, this.ba_, 0, ba.length);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        public Concrete(ByteString bs) {
            this.ba_ = bs.toArray();
        }

        protected Concrete(Concrete bs, boolean share) {
            this.ba_ = share ? bs.ba_ : bs.toArray();
        }

        public Concrete(ByteString bs, int length) {
            if (length > bs.getLength()) {
                throw new IllegalArgumentException("Invalid length");
            }
            this.ba_ = new byte[length];
            bs.copyBytes(0, this.ba_, 0, length);
        }

        public Concrete(ByteString bs, int origin, int length) {
            int len = bs.getLength();
            if (origin > len) {
                throw new IllegalArgumentException("Invalid origin");
            }
            if (origin + length > len) {
                throw new IllegalArgumentException("Invalid length");
            }
            this.ba_ = new byte[length];
            bs.copyBytes(origin, this.ba_, 0, length);
        }

        public Concrete(String str) {
            this.ba_ = str.getBytes();
        }

        @Override
        public int getLength() {
            return this.ba_.length;
        }

        @Override
        public byte byteAt(int ii) {
            return this.ba_[ii];
        }

        @Override
        public byte[] copyBytes(int srcpos, byte[] dst, int dstpos, int nbytes) {
            System.arraycopy(this.ba_, srcpos, dst, dstpos, nbytes);
            return dst;
        }

        @Override
        public byte[] toArray() {
            return (byte[])this.ba_.clone();
        }

        @Override
        public ByteString subByteString(int beginIndex, int length) {
            if (beginIndex < 0) {
                throw new IllegalArgumentException("beginIndex < 0");
            }
            if (length < 0) {
                throw new IllegalArgumentException();
            }
            if (beginIndex == 0) {
                if (length == this.getLength()) {
                    return this;
                }
                return new TrSubString(this, length);
            }
            return new SubString(this, beginIndex, length);
        }

        @Override
        public ByteString substring(int beginIndex) {
            if (beginIndex < 0) {
                throw new IllegalArgumentException("beginIndex < 0");
            }
            if (beginIndex == 0) {
                return this;
            }
            return new SubString(this, beginIndex, this.getLength() - beginIndex);
        }
    }

    public static class Empty
    extends ByteString {
        @Override
        public int getLength() {
            return 0;
        }

        @Override
        public byte byteAt(int pos) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public byte[] copyBytes(int srcpos, byte[] dst, int dstpos, int nbytes) {
            if (nbytes > 0) {
                throw new IndexOutOfBoundsException();
            }
            return dst;
        }

        @Override
        public byte[] toArray() {
            return nada;
        }
    }
}

