/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;

public class BooleanProperty {
    protected boolean okToPropagatePropertyChange = true;
    String id;
    String name;
    String desc;
    Boolean value;
    boolean dflt;
    List menuItems = new ArrayList();
    boolean haveBeenInitialized = false;

    public BooleanProperty(BooleanProperty that) {
        this(that.id, that.name, that.desc, that.value, that.dflt);
    }

    public BooleanProperty(String id, String name, boolean dflt) {
        this(id, name, null, dflt);
    }

    public BooleanProperty(String id, String name, String desc, boolean dflt) {
        this(id, name, desc, null, dflt);
    }

    public BooleanProperty(String id, String name, String desc, Boolean value, boolean dflt) {
        if (desc == null || desc.length() == 0) {
            desc = "Toggle " + name.toLowerCase() + " on/off";
        }
        this.id = id;
        this.name = name;
        this.desc = desc;
        this.dflt = dflt;
        this.value = value;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean getDefault() {
        return this.dflt;
    }

    public void setDefault(boolean d) {
        this.dflt = d;
    }

    public boolean getValue() {
        if (this.value == null) {
            return this.getDefault();
        }
        return this.value;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public boolean getHaveBeenInitialized() {
        return this.haveBeenInitialized;
    }

    public final void setValue(boolean newValue) {
        try {
            this.haveBeenInitialized = true;
            this.setValueInner(newValue);
        }
        catch (Exception excp) {
            LogUtil.logException("setting value of " + this.name, excp);
        }
    }

    public void setValueInner(boolean newValue) throws Exception {
        this.value = new Boolean(newValue);
        this.okToPropagatePropertyChange = false;
        for (int i = 0; i < this.menuItems.size(); ++i) {
            ((JCheckBoxMenuItem)this.menuItems.get(i)).setSelected(newValue);
        }
        this.okToPropagatePropertyChange = true;
    }

    public void addItem(JCheckBoxMenuItem mi) {
        this.menuItems.add(mi);
    }

    public JCheckBoxMenuItem createCBMI() {
        final JCheckBoxMenuItem mi = new JCheckBoxMenuItem(this.name, this.getValue());
        mi.setToolTipText(this.desc);
        this.addItem(mi);
        mi.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (BooleanProperty.this.okToPropagatePropertyChange) {
                    BooleanProperty.this.setValue(mi.isSelected());
                }
            }
        });
        return mi;
    }

    public String toString() {
        return this.id + "=" + this.getValue();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BooleanProperty)) {
            return false;
        }
        BooleanProperty that = (BooleanProperty)obj;
        return Misc.equals(this.id, that.id) && Misc.equals(this.name, that.name) && Misc.equals(this.desc, that.desc) && Misc.equals(this.value, that.value) && this.dflt == that.dflt;
    }
}

