/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.UserInfo;
import ucar.unidata.xml.XmlEncoder;
import ucar.unidata.xml.XmlUtil;

public class AccountManager
implements CredentialsProvider,
IOUtil.UserAccountManager {
    private static AccountManager accountManager;
    private JLabel serverLabel;
    private JDialog dialog;
    private JTextField nameFld;
    private JPasswordField passwdFld;
    private JCheckBox saveCbx;
    private boolean ok;
    private Hashtable<String, UserInfo> table;
    private Hashtable currentlyUsedOnes = new Hashtable();
    private File stateDir;
    private Credentials currentCredentials = null;
    private String currentKey = null;

    public AccountManager(File stateDir) {
        this.stateDir = stateDir;
    }

    @Override
    public void clear() {
        this.currentCredentials = null;
    }

    public static AccountManager getGlobalAccountManager() {
        return accountManager;
    }

    public static void setGlobalAccountManager(AccountManager manager) {
        if (accountManager != null) {
            throw new IllegalArgumentException("Already have an account manager");
        }
        accountManager = manager;
        IOUtil.setUserAccountManager(accountManager);
    }

    @Override
    public void setCredentials(AuthScope scope, Credentials creds) {
    }

    @Override
    public Credentials getCredentials(AuthScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Authentication scope may not be null");
        }
        if (this.currentCredentials == null) {
            String host = scope.getHost();
            int port = scope.getPort();
            String key = host + ":" + port + ":" + scope.getRealm();
            UserInfo userInfo = this.getUserNamePassword(key, "The server " + host + ":" + port + " requires a username/password");
            if (userInfo == null) {
                return null;
            }
            this.currentCredentials = new UsernamePasswordCredentials(userInfo.getUserId(), userInfo.getPassword());
            this.currentKey = key;
        }
        return this.currentCredentials;
    }

    public Credentials getCredentials() {
        return this.currentCredentials;
    }

    public Credentials getCredentialsnew(AuthScope scope) {
        String host = scope.getHost();
        int port = scope.getPort();
        String realm = scope.getRealm();
        if (scope == null) {
            throw new IllegalArgumentException("Null scope");
        }
        String key = host + realm;
        UserInfo userInfo = this.getUserNamePassword(key, "The server " + host + ":" + port + " requires a username/password");
        if (userInfo == null) {
            return null;
        }
        return new UsernamePasswordCredentials(userInfo.getUserId(), userInfo.getPassword());
    }

    @Override
    public UserInfo getUserNamePassword(String key, String label) {
        UserInfo userInfo = this.getTable().get(key);
        if (userInfo != null && this.currentlyUsedOnes.get(userInfo) != null) {
            userInfo = null;
        }
        if (userInfo == null) {
            if (this.dialog == null) {
                this.makeDialog();
            }
            this.serverLabel.setText(label);
            this.ok = false;
            this.dialog.pack();
            this.nameFld.requestFocus();
            this.dialog.setVisible(true);
            if (!this.ok) {
                return null;
            }
            userInfo = new UserInfo(key, this.nameFld.getText().trim(), new String(this.passwdFld.getPassword()).trim());
            if (this.saveCbx.isSelected()) {
                this.table.put(key, userInfo);
                this.writeTable();
            }
        }
        this.currentlyUsedOnes.put(userInfo, "");
        return userInfo;
    }

    public void removeUserNamePassword() {
        if (this.currentKey == null) {
            return;
        }
        UserInfo userInfo = this.getTable().get(this.currentKey);
        if (userInfo != null) {
            if (this.currentlyUsedOnes.get(userInfo) != null) {
                this.currentlyUsedOnes.remove(userInfo);
            }
            if (this.table.get(this.currentKey) != null) {
                this.table.remove(this.currentKey);
                this.writeTable();
            }
        }
    }

    protected void writeTable() {
        try {
            String xml = XmlEncoder.encodeObject(this.getTable());
            IOUtil.writeFile(IOUtil.joinDir(this.stateDir, "authentication.xml"), xml);
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    protected Hashtable<String, UserInfo> getTable() {
        if (this.table == null) {
            try {
                String xml = IOUtil.readContents(IOUtil.joinDir(this.stateDir, "authentication.xml"), (String)null);
                Hashtable tmp = null;
                if (xml != null) {
                    tmp = (Hashtable)XmlEncoder.decodeXml(xml);
                }
                if (tmp == null) {
                    tmp = new Hashtable();
                }
                this.table = new Hashtable();
                Enumeration keys = tmp.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    Object value = tmp.get(key);
                    if (!(value instanceof UserInfo)) {
                        String[] pair = this.decode(value);
                        value = new UserInfo(key, pair[0], pair[1]);
                    }
                    this.table.put(key, (UserInfo)value);
                }
            }
            catch (Exception exc) {
                throw new RuntimeException(exc);
            }
        }
        return this.table;
    }

    private String[] decode(Object obj) {
        String s = (String)obj;
        byte[] bytes = XmlUtil.decodeBase64(s);
        return (String[])Misc.deserialize(bytes);
    }

    private void makeDialog() {
        this.serverLabel = new JLabel("                                                ");
        this.nameFld = new JTextField("", 10);
        this.passwdFld = new JPasswordField("", 10);
        this.saveCbx = new JCheckBox("Save Password");
        JButton okBtn = new JButton("OK");
        ActionListener okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AccountManager.this.ok = true;
                AccountManager.this.dialog.dispose();
            }
        };
        this.nameFld.addActionListener(okListener);
        this.passwdFld.addActionListener(okListener);
        okBtn.addActionListener(okListener);
        JButton cancelBtn = new JButton("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AccountManager.this.ok = false;
                AccountManager.this.dialog.dispose();
            }
        });
        GuiUtils.tmpInsets = GuiUtils.INSETS_5;
        JPanel contents = GuiUtils.doLayout(new Component[]{GuiUtils.rLabel("Name:"), this.nameFld, GuiUtils.rLabel("Password:"), this.passwdFld, GuiUtils.filler(), this.saveCbx}, 2, GuiUtils.WT_N, GuiUtils.WT_N);
        contents = GuiUtils.topCenterBottom(this.serverLabel, contents, GuiUtils.wrap(GuiUtils.doLayout(new Component[]{okBtn, new JLabel(" "), cancelBtn}, 3, GuiUtils.WT_N, GuiUtils.WT_N)));
        this.dialog = GuiUtils.createDialog("Server Authentication", true);
        this.dialog.getContentPane().add(GuiUtils.inset((Component)contents, 5));
        this.dialog.pack();
        this.dialog.setLocation(200, 200);
    }
}

