/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui.symbol;

import java.awt.Graphics2D;
import ucar.unidata.ui.drawing.DisplayCanvas;
import ucar.unidata.ui.symbol.WindBarbSymbol;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADLineArray;

public class WindVectorSymbol
extends WindBarbSymbol {
    private static final float BACK_SCALE = -0.15f;
    private static final float PERP_SCALE = 0.15f;

    public WindVectorSymbol() {
    }

    public WindVectorSymbol(DisplayCanvas canvas, int x, int y) {
        this(canvas, x, y, "U", "U or speed parameter", "V", "V or direction parameter");
    }

    public WindVectorSymbol(int x, int y, String uOrSpeedParam, String uOrSpeedDescr, String vOrDirParam, String vOrDirDescr) {
        this(null, x, y, uOrSpeedParam, uOrSpeedDescr, vOrDirParam, vOrDirDescr);
    }

    public WindVectorSymbol(DisplayCanvas canvas, int x, int y, String uOrSpeedParam, String uOrSpeedDescr, String vOrDirParam, String vOrDirDescr) {
        super(canvas, x, y, uOrSpeedParam, uOrSpeedDescr, vOrDirParam, vOrDirDescr);
    }

    @Override
    protected WindBarbSymbol.WindDrawer makeDrawer() {
        return new VectorDrawer();
    }

    public VisADGeometryArray[] makeVector(float[][] flow_values, float flowScale, float[][] spatial_values, byte[][] color_values, boolean[][] range_select) throws VisADException {
        if (flow_values[0] == null) {
            return null;
        }
        if (spatial_values[0] == null) {
            return null;
        }
        VisADLineArray array = new VisADLineArray();
        int len = spatial_values[0].length;
        int flen = flow_values[0].length;
        int rlen = 0;
        if (range_select[0] == null) {
            rlen = len;
        } else {
            for (int j = 0; j < range_select[0].length; ++j) {
                if (!range_select[0][j]) continue;
                ++rlen;
            }
        }
        if (rlen == 0) {
            return null;
        }
        array.vertexCount = 6 * rlen;
        float[] coordinates = new float[18 * rlen];
        int m = 0;
        float f0 = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        float a0 = 0.0f;
        float a1 = 0.0f;
        float a2 = 0.0f;
        float b0 = 0.0f;
        float b1 = 0.0f;
        float b2 = 0.0f;
        for (int j = 0; j < len; ++j) {
            if (range_select[0] != null && !range_select[0][j]) continue;
            if (flen == 1) {
                f0 = flowScale * flow_values[0][0];
                f1 = flowScale * flow_values[1][0];
                f2 = flowScale * flow_values[2][0];
            } else {
                f0 = flowScale * flow_values[0][j];
                f1 = flowScale * flow_values[1][j];
                f2 = flowScale * flow_values[2][j];
            }
            int k = m;
            coordinates[m++] = spatial_values[0][j];
            coordinates[m++] = spatial_values[1][j];
            coordinates[m++] = spatial_values[2][j];
            int n = m;
            coordinates[m++] = coordinates[k++] + f0;
            coordinates[m++] = coordinates[k++] + f1;
            coordinates[m++] = coordinates[k++] + f2;
            k = n;
            coordinates[m++] = coordinates[n++];
            coordinates[m++] = coordinates[n++];
            coordinates[m++] = coordinates[n++];
            b0 = a0 = -0.15f * f0;
            b1 = a1 = -0.15f * f1;
            b2 = a2 = -0.15f * f2;
            b0 -= 0.15f * f1;
            b1 += 0.15f * f0;
            k = n;
            coordinates[m++] = coordinates[n++] + (a0 += 0.15f * f1);
            coordinates[m++] = coordinates[n++] + (a1 -= 0.15f * f0);
            coordinates[m++] = coordinates[n++] + a2;
            n = k;
            coordinates[m++] = coordinates[k++];
            coordinates[m++] = coordinates[k++];
            coordinates[m++] = coordinates[k++];
            coordinates[m++] = coordinates[n++] + b0;
            coordinates[m++] = coordinates[n++] + b1;
            coordinates[m++] = coordinates[n++] + b2;
        }
        array.coordinates = coordinates;
        return new VisADGeometryArray[]{array};
    }

    public static class VectorDrawer
    extends WindBarbSymbol.WindDrawer {
        @Override
        public void draw(Graphics2D g, int x, int y, int width, int height, double speed, double dirDegrees) {
            this.windSpeed = speed;
            this.x0 = this.x0;
            this.y0 = this.y0;
            double theta = dirDegrees * (Math.PI / 180);
            this.sint = Math.sin(theta);
            this.cost = Math.cos(theta);
            double lenVect = width;
            this.drawRotatedLine(g, 0.0, 0.0, 0.0, lenVect);
            this.drawRotatedLine(g, 0.0, lenVect, lenVect / 4.0, 3.0 * lenVect / 4.0);
            this.drawRotatedLine(g, 0.0, lenVect, -lenVect / 4.0, 3.0 * lenVect / 4.0);
        }
    }
}

