/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui.symbol;

import java.awt.Graphics2D;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.ui.drawing.DisplayCanvas;
import ucar.unidata.ui.symbol.MetSymbol;

public class WindBarbSymbol
extends MetSymbol {
    public static final double DEG_TO_RAD = Math.PI / 180;
    private double windSpeed;
    private double windDirection;
    private int lenBarb;
    private double sint;
    private double cost;
    private WindDrawer drawer;

    public WindBarbSymbol() {
    }

    public WindBarbSymbol(DisplayCanvas canvas, int x, int y) {
        this(canvas, x, y, "U", "U or windspeed parameter", "V", "V or direction parameter");
    }

    public WindBarbSymbol(int x, int y, String uOrSpeedParam, String uOrSpeedDescr, String vOrDirParam, String vOrDirDescr) {
        this(null, x, y, uOrSpeedParam, uOrSpeedDescr, vOrDirParam, vOrDirDescr);
    }

    public WindBarbSymbol(DisplayCanvas canvas, int x, int y, String uOrSpeedParam, String uOrSpeedDescr, String vOrDirParam, String vOrDirDescr) {
        super(canvas, x, y, new String[]{uOrSpeedParam, vOrDirParam}, new String[]{uOrSpeedDescr, vOrDirDescr});
        this.setSize(20, 20);
        this.setWindDirection(300.0);
        this.setWindSpeed(65.0);
    }

    @Override
    public boolean shouldScaleShape() {
        return false;
    }

    @Override
    public boolean shouldOffsetShape() {
        return false;
    }

    @Override
    public boolean doAlignmentMenu() {
        return false;
    }

    @Override
    public Object getParamValue(int index) {
        return index == 0 ? new Double(this.windSpeed) : new Double(this.windDirection);
    }

    @Override
    public void setParamValue(int index, Object v) {
        if (index == 0) {
            this.setWindSpeed(new Double(v.toString()));
        } else {
            this.setWindDirection(new Double(v.toString()));
        }
    }

    public String getSpeedName() {
        return this.getParam(0);
    }

    public String getDirectionName() {
        return this.getParam(1);
    }

    @Override
    public boolean getStretchy() {
        return !this.getBeingCreated();
    }

    @Override
    public boolean getEqualSides() {
        return true;
    }

    @Override
    public boolean getSymetricReshape() {
        return true;
    }

    public double getWindSpeed() {
        return this.windSpeed;
    }

    public void setWindSpeed(double windSpeed) {
        this.windSpeed = windSpeed;
    }

    public double getWindDirection() {
        return this.windDirection;
    }

    public void setWindDirection(double windDirection) {
        this.windDirection = LatLonPointImpl.lonNormal360(windDirection);
    }

    @Override
    public void draw(Graphics2D g, int x, int y, int width, int height) {
        g.setColor(this.getForeground());
        if (this.drawer == null) {
            this.drawer = this.makeDrawer();
        }
        this.drawer.draw(g, x, y, width, height, this.windSpeed, this.windDirection);
    }

    protected WindDrawer makeDrawer() {
        return new WindDrawer();
    }

    @Override
    public boolean rotateOnEarth() {
        return false;
    }

    public static class WindDrawer {
        int x0;
        int y0;
        double lenBarb;
        double sint;
        double cost;
        double windSpeed;
        boolean isSouth = false;

        public WindDrawer() {
        }

        public WindDrawer(boolean isSouth) {
            this.isSouth = isSouth;
        }

        public void draw(Graphics2D g, int x, int y, int width, int height, double speed, double dirDegrees) {
            this.windSpeed = speed;
            this.x0 = this.x0;
            this.y0 = this.y0;
            double theta = dirDegrees * (Math.PI / 180);
            this.sint = Math.sin(theta);
            this.cost = Math.cos(theta);
            this.x0 = x + width / 2;
            this.y0 = y + height / 2;
            int len = 0;
            while (speed >= 47.5) {
                len += 6;
                speed -= 50.0;
            }
            while (speed >= 7.5) {
                len += 3;
                speed -= 10.0;
            }
            if (speed >= 2.5) {
                len += 3;
            }
            this.lenBarb = Math.max(len, width);
            if (this.windSpeed < 0.5) {
                int radius = 10;
                g.drawArc(this.x0 - radius / 2, this.y0 - radius / 2, radius, radius, 0, 360);
                return;
            }
            this.drawRotatedLine(g, 0.0, 0.0, 0.0, -this.lenBarb);
            int start = 0;
            for (speed = this.windSpeed; speed >= 47.5; speed -= 50.0) {
                start = this.draw50knotFlag(g, start);
            }
            while (speed >= 7.5) {
                start = this.draw10knotLine(g, start);
                speed -= 10.0;
            }
            if (speed >= 2.5) {
                if (this.windSpeed >= 2.5 && this.windSpeed < 7.5) {
                    start = 3;
                }
                this.drawRotatedBarbLine(g, 0.0, -this.lenBarb + (double)start, 0.2 * this.lenBarb, -this.lenBarb + (double)start - 1.5);
            }
        }

        private int draw10knotLine(Graphics2D g, int start) {
            this.drawRotatedBarbLine(g, 0.0, -this.lenBarb + (double)start, 0.4 * this.lenBarb, -this.lenBarb + (double)start - 3.0);
            return start + 3;
        }

        private int draw50knotFlag(Graphics2D g, int start) {
            this.drawRotatedTriangle(g, 0.0, -this.lenBarb + (double)start + 4.0, 0.4 * this.lenBarb + 2.0, -this.lenBarb + (double)start - 1.0, 0.0, -this.lenBarb + (double)start - 1.0);
            return start + 6;
        }

        void drawRotatedLine(Graphics2D g, double x1, double y1, double x2, double y2) {
            int begx = (int)(x1 * this.cost - y1 * this.sint);
            int begy = (int)(x1 * this.sint + y1 * this.cost);
            int endx = (int)(x2 * this.cost - y2 * this.sint);
            int endy = (int)(x2 * this.sint + y2 * this.cost);
            g.drawLine(this.x0 + begx, this.y0 + begy, this.x0 + endx, this.y0 + endy);
        }

        void drawRotatedBarbLine(Graphics2D g, double x1, double y1, double x2, double y2) {
            int begx = (int)(x1 * this.cost - y1 * this.sint);
            int begy = (int)(x1 * this.sint + y1 * this.cost);
            double s = this.isSouth ? -1.0 : 1.0;
            int endx = (int)(x2 * s * this.cost - y2 * this.sint);
            int endy = (int)(x2 * s * this.sint + y2 * this.cost);
            g.drawLine(this.x0 + begx, this.y0 + begy, this.x0 + endx, this.y0 + endy);
        }

        private void drawRotatedTriangle(Graphics2D g, double x1, double y1, double x2, double y2, double x3, double y3) {
            int[] xPoint = new int[3];
            int[] yPoint = new int[3];
            xPoint[0] = this.x0 + (int)(x1 * this.cost - y1 * this.sint);
            yPoint[0] = this.y0 + (int)(x1 * this.sint + y1 * this.cost);
            double s = this.isSouth ? -1.0 : 1.0;
            xPoint[1] = this.x0 + (int)(x2 * s * this.cost - y2 * this.sint);
            yPoint[1] = this.y0 + (int)(x2 * s * this.sint + y2 * this.cost);
            xPoint[2] = this.x0 + (int)(x3 * this.cost - y3 * this.sint);
            yPoint[2] = this.y0 + (int)(x3 * this.sint + y3 * this.cost);
            g.fillPolygon(xPoint, yPoint, 3);
        }
    }
}

