/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui.symbol;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.ImageObserver;
import ucar.unidata.ui.drawing.DisplayCanvas;
import ucar.unidata.ui.symbol.MetSymbol;
import ucar.unidata.util.GuiUtils;
import visad.VisADLineArray;
import visad.meteorology.WeatherSymbols;

public class WeatherSymbol
extends MetSymbol
implements ImageObserver {
    public static final int SYMBOL_CLOUDCOVERAGE = 0;
    public static final int SYMBOL_PRESENTWEATHER = 1;
    public static final int SYMBOL_LOWCLOUD = 2;
    public static final int SYMBOL_MIDCLOUD = 3;
    public static final int SYMBOL_HIGHCLOUD = 4;
    public static final int SYMBOL_PRESSURETENDENCY = 5;
    public static final int SYMBOL_ICING = 6;
    public static final int SYMBOL_TURBULENCE = 7;
    public static final int SYMBOL_LIGHTNING = 8;
    public static final int SYMBOL_MISC = 9;
    public static final int SYMBOL_ALL = 10;
    public static final String[] SYMBOLNAMES = new String[]{"cloudcoverage", "presentweather", "lowcloud", "midcloud", "highcloud", "pressuretendency", "icing", "turbulence", "lightning", "all"};
    public static final String ATTR_SYMBOLTYPE = "symboltype";
    private Image image = null;
    private int symbolType = 1;
    private int code = 0;
    private VisADLineArray lines;

    public WeatherSymbol() {
    }

    public WeatherSymbol(int x, int y) {
        this(null, x, y);
    }

    public WeatherSymbol(DisplayCanvas canvas, int x, int y) {
        this(canvas, x, y, "CC", "Parameter");
    }

    public WeatherSymbol(int x, int y, String param, String paramDesc) {
        this(null, x, y, param, paramDesc);
    }

    public WeatherSymbol(DisplayCanvas canvas, int x, int y, String param, String paramDesc) {
        super(canvas, x, y, new String[]{param}, new String[]{paramDesc});
        this.setSize(20, 20);
    }

    @Override
    public String getLabel() {
        return "Weather Symbol: " + SYMBOLNAMES[this.symbolType];
    }

    @Override
    public boolean imageUpdate(Image img, int flags, int x, int y, int width, int height) {
        return (flags & 0x40) == 0;
    }

    public void setSymbolType(int value) {
        this.symbolType = value;
        this.image = null;
        this.lines = null;
    }

    private Image getImage() {
        if (this.image == null && this.symbolType < SYMBOLNAMES.length && this.symbolType >= 0) {
            this.image = GuiUtils.getImage("/ucar/unidata/ui/symbol/images/" + SYMBOLNAMES[this.symbolType] + ".gif");
        }
        return this.image;
    }

    private VisADLineArray getMyLines() {
        if (this.lines == null) {
            this.lines = WeatherSymbol.getLines(this.symbolType, this.code);
        }
        return this.lines;
    }

    public VisADLineArray getLines(int index) {
        return WeatherSymbol.getLines(this.symbolType, index);
    }

    public static VisADLineArray getLines(int symbolType, int code) {
        try {
            switch (symbolType) {
                case 1: {
                    return code > 3 && code < 100 ? WeatherSymbols.getPresentWeatherSymbol(code) : null;
                }
                case 2: {
                    if (code < 1 || code > 9) {
                        return null;
                    }
                    return WeatherSymbols.getLowCloudSymbol(code);
                }
                case 3: {
                    if (code < 1 || code > 9) {
                        return null;
                    }
                    return WeatherSymbols.getMidCloudSymbol(code);
                }
                case 4: {
                    if (code < 1 || code > 9) {
                        return null;
                    }
                    return WeatherSymbols.getHighCloudSymbol(code);
                }
                case 5: {
                    if (code < 0 || code >= 9) {
                        return null;
                    }
                    return WeatherSymbols.getPressureTendencySymbol(code);
                }
                case 0: {
                    if (code < 0 || code >= 11) {
                        return null;
                    }
                    return WeatherSymbols.getCloudCoverageSymbol(code);
                }
                case 6: {
                    if (code < 0 || code >= 9) {
                        return null;
                    }
                    return WeatherSymbols.getIcingSymbol(code);
                }
                case 7: {
                    if (code < 0 || code >= 11) {
                        return null;
                    }
                    return WeatherSymbols.getTurbulenceSymbol(code);
                }
                case 8: {
                    return code >= 0 ? WeatherSymbols.getLightningSymbol(0) : WeatherSymbols.getLightningSymbol(1);
                }
                case 9: {
                    if (code < 0) {
                        return null;
                    }
                    return WeatherSymbols.getMiscSymbol(code);
                }
                case 10: {
                    VisADLineArray[] vla = WeatherSymbols.getAllMetSymbols();
                    if (code < 0 || code >= vla.length) {
                        return null;
                    }
                    return vla[code];
                }
            }
            throw new IllegalStateException("Unknown symbol type:" + symbolType);
        }
        catch (IllegalArgumentException iae) {
            System.err.println("bad value: " + code + " for symbol:" + symbolType);
            return null;
        }
    }

    @Override
    public Object getParamValue(int index) {
        return new Integer(this.code);
    }

    @Override
    public void setParamValue(int index, Object v) {
        this.setCode(new Integer(v.toString()));
    }

    public int getSymbolType() {
        return this.symbolType;
    }

    public void setCode(int value) {
        this.code = value;
    }

    public int getCode() {
        return this.code;
    }

    @Override
    public boolean getStretchy() {
        return !this.getBeingCreated();
    }

    @Override
    public boolean getEqualSides() {
        return true;
    }

    @Override
    public boolean getSymetricReshape() {
        return true;
    }

    @Override
    public void draw(Graphics2D g, int x, int y, int width, int height) {
        g.drawImage(this.getImage(), x, y, width, height, this);
        g.setColor(this.getForeground());
        g.drawRect(x, y, width, height);
    }

    @Override
    public void setAttr(String name, String value) {
        if (name.equals(ATTR_SYMBOLTYPE)) {
            for (int i = 0; i < SYMBOLNAMES.length; ++i) {
                if (!SYMBOLNAMES[i].equals(value)) continue;
                this.setSymbolType(i);
                return;
            }
            throw new IllegalArgumentException("Unknown symbol:" + name);
        }
        super.setAttr(name, value);
    }
}

