/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui.symbol;

import ucar.unidata.ui.drawing.DisplayCanvas;
import ucar.unidata.ui.symbol.TextSymbol;
import ucar.unidata.util.Misc;
import visad.Unit;

public class ValueSymbol
extends TextSymbol {
    private double value;

    public ValueSymbol() {
    }

    public ValueSymbol(DisplayCanvas canvas, int x, int y) {
        this(canvas, x, y, "", "Parameter");
    }

    public ValueSymbol(int x, int y, String param, String paramDesc, Unit unit) {
        this(null, x, y, param, paramDesc, unit);
    }

    public ValueSymbol(int x, int y, String param, String paramDesc) {
        this(null, x, y, param, paramDesc);
    }

    public ValueSymbol(DisplayCanvas canvas, int x, int y, String param, String paramDesc) {
        this(canvas, x, y, param, paramDesc, null);
    }

    public ValueSymbol(DisplayCanvas canvas, int x, int y, String param, String paramDesc, Unit u) {
        super(canvas, x, y, param, paramDesc);
        this.setTheDisplayUnit(u);
        this.setDoubleValue(123.0);
    }

    @Override
    protected boolean showDisplayUnitInProperties() {
        return true;
    }

    @Override
    public String getLabel() {
        return "Value Symbol: " + this.getName();
    }

    @Override
    public Object getParamValue(int index) {
        return Misc.format(this.value);
    }

    @Override
    public void setParamValue(int index, Object v) {
        this.setDoubleValue(Misc.parseNumber(v.toString()));
    }

    public double getDoubleValue() {
        return this.value;
    }

    public void setDoubleValue(double value) {
        this.value = value;
        super.setValue(this.formatNumber(value));
    }
}

