/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui.symbol;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.List;
import ucar.unidata.data.point.PointOb;
import ucar.unidata.ui.drawing.DisplayCanvas;
import ucar.unidata.ui.symbol.MetSymbol;
import ucar.visad.ShapeUtility;
import visad.Real;
import visad.Tuple;
import visad.TupleType;
import visad.VisADGeometryArray;
import visad.VisADLineArray;

public class ThreeDCrossSymbol
extends MetSymbol {
    boolean stretchy = true;
    VisADGeometryArray[] shapes = null;
    int x0;
    int y0;

    public ThreeDCrossSymbol() {
    }

    public ThreeDCrossSymbol(int x, int y) {
        this(null, x, y);
    }

    public ThreeDCrossSymbol(DisplayCanvas canvas, int x, int y) {
        this(canvas, x, y, "CC", "3d Cross Symbol");
        this.setSize(20, 20);
    }

    public ThreeDCrossSymbol(int x, int y, String param, String paramDesc) {
        this(null, x, y, param, paramDesc);
    }

    public ThreeDCrossSymbol(DisplayCanvas canvas, int x, int y, String param, String paramDesc) {
        super(canvas, x, y, new String[]{param}, new String[]{paramDesc});
    }

    @Override
    public boolean shouldOffsetShape() {
        return false;
    }

    @Override
    protected void initPropertyComponents(List comps) {
        super.initPropertyComponents(comps);
    }

    @Override
    protected void applyProperties() {
        super.applyProperties();
    }

    @Override
    public boolean getStretchy() {
        return this.stretchy;
    }

    @Override
    public void setStretchy(boolean s) {
        this.stretchy = s;
    }

    @Override
    public boolean getEqualSides() {
        return true;
    }

    @Override
    public Object getParamValue(int index) {
        return new Double(0.0);
    }

    @Override
    public void setParamValue(int index, Object v) {
    }

    @Override
    public boolean doAllObs() {
        return true;
    }

    @Override
    public boolean shouldBeColored() {
        return false;
    }

    @Override
    public VisADGeometryArray[] makeShapes(PointOb ob) {
        Tuple data = (Tuple)ob.getData();
        Real[] reals = null;
        try {
            reals = data.getRealComponents();
        }
        catch (Exception t) {
            System.out.println("    ThreeDCrossSymbol: makeShapes() : the PointOb  " + ob + " failed in getRealComponents");
        }
        TupleType tType = (TupleType)data.getType();
        if (reals == null) {
            System.out.println(" one point obs' data is missing. The PointOb data object is " + ob.toString());
            return null;
        }
        String source = null;
        for (int k = 0; k < reals.length; ++k) {
            try {
                source = tType.getComponent(k).toString();
            }
            catch (Exception t) {
                System.out.println(" failed in ThreeDCross symbols source= (tType.getComponent(k)).toString()");
            }
            VisADLineArray shape7 = null;
            Object shape3 = null;
            float xs = 0.0f;
            float ys = 0.0f;
            float zs = 0.0f;
            float dx = 1.0f;
            float dy = 1.0f;
            float dz = 1.0f;
            float sizer = 0.5f;
            shape7 = new VisADLineArray();
            shape7.coordinates = new float[]{xs + (dx *= sizer), ys, zs, xs - dx, ys, zs, xs - dx, ys, zs, xs, ys, zs, xs, ys, zs, xs, ys + (dy *= sizer), zs, xs, ys + dy, zs, xs, ys - dy, zs, xs, ys - dy, zs, xs, ys, zs, xs, ys, zs, xs, ys, zs + (dz *= sizer), xs, ys, zs + dz, xs, ys, zs - dz};
            shape7.vertexCount = shape7.coordinates.length / 3;
            ShapeUtility.setColor((VisADGeometryArray)shape7, new Color(65, 105, 205));
            this.shapes = new VisADGeometryArray[]{shape7};
        }
        return this.shapes;
    }

    @Override
    public void draw(Graphics2D g, int x, int y, int width, int height) {
        int cx = x;
        int cy = y;
        this.x0 = cx;
        this.y0 = cy;
        int begx = -15;
        int begy = 0;
        int endx = 15;
        int endy = 0;
        g.drawLine(this.x0 + begx, this.y0 + begy, this.x0 + endx, this.y0 + endy);
        begx = 0;
        begy = -15;
        endx = 0;
        endy = 15;
        g.drawLine(this.x0 + begx, this.y0 + begy, this.x0 + endx, this.y0 + endy);
    }
}

