/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui.symbol;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import ucar.unidata.ui.drawing.DisplayCanvas;
import ucar.unidata.ui.symbol.MetSymbol;
import visad.DateTime;
import visad.Real;

public class TextSymbol
extends MetSymbol {
    private static String FONTNAME = "monospaced PLAIN ";
    private static Font[] fonts = null;
    private FontMetrics fontMetrics;
    private int currFontNo = 4;
    private int currFontSize = 12;
    private Font currFont = null;
    private NumberFormat numberFormat;
    private String valStr = "";
    protected String numberFormatString = "###0.#";
    public static final String[] FONT_SIZES = new String[]{"8", "9", "10", "11", "12", "13", "14", "15", "16", "18", "20", "24", "26", "28", "32", "36", "40", "48", "56", "64", "72"};
    private static final int[] fontSizes = new int[]{8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 20, 24, 26, 28, 32, 36, 40, 48, 56, 64, 72};

    public TextSymbol() {
    }

    public TextSymbol(int x, int y) {
        this(null, x, y, "param", "Parameter");
    }

    public TextSymbol(DisplayCanvas canvas, int x, int y) {
        this(canvas, x, y, "param", "Parameter");
    }

    public TextSymbol(String param, String paramDesc) {
        this(0, 0, param, paramDesc);
    }

    public TextSymbol(int x, int y, String param, String paramDesc) {
        this(null, x, y, param, paramDesc);
    }

    public TextSymbol(DisplayCanvas canvas, int x, int y, String param, String paramDesc) {
        super(canvas, x, y, new String[]{param}, new String[]{paramDesc});
        this.setStretchy(false);
        this.calculateBounds();
    }

    @Override
    public String getLabel() {
        return "Text Symbol: " + this.getName();
    }

    public void setFont(Font font) {
        this.currFont = font;
        this.setFontSize(font == null ? this.currFontSize : font.getSize());
    }

    public Font getFont() {
        return this.currFont;
    }

    public void incrFontSize() {
        ++this.currFontNo;
        if (this.currFontNo >= fontSizes.length) {
            this.currFontNo = fontSizes.length - 1;
        }
        this.setFontSize(fontSizes[this.currFontNo]);
    }

    public void decrFontSize() {
        --this.currFontNo;
        if (this.currFontNo < 0) {
            this.currFontNo = 0;
        }
        this.setFontSize(fontSizes[this.currFontNo]);
    }

    public static Font[] getFontList() {
        if (fonts == null) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            fonts = ge.getAllFonts();
        }
        return fonts;
    }

    public void setCurrFontNo(int index) {
        this.currFontNo = index > fontSizes.length ? fontSizes.length - 1 : (index < 0 ? 0 : index);
        this.setFontSize(fontSizes[this.currFontNo]);
    }

    public int getCurrFontNo() {
        return this.currFontNo;
    }

    private void setFontMetrics() {
        this.fontMetrics = this.currFont != null ? Toolkit.getDefaultToolkit().getFontMetrics(this.currFont) : Toolkit.getDefaultToolkit().getFontMetrics(this.makeDefaultFont());
    }

    public FontMetrics getFontMetrics() {
        if (this.fontMetrics == null) {
            this.setFontMetrics();
        }
        return this.fontMetrics;
    }

    public void setFontSize(int size) {
        this.currFontSize = size;
        this.currFontNo = Arrays.binarySearch(fontSizes, size);
        if (this.currFont != null && this.currFontSize != this.currFont.getSize()) {
            this.currFont = this.currFont.deriveFont((float)this.currFontSize);
        }
        this.setFontMetrics();
        this.calculateBounds();
    }

    public int getFontSize() {
        return this.currFontSize;
    }

    private void calculateBounds() {
        if (this.valStr == null) {
            this.bounds.width = 0;
            this.bounds.height = 0;
            return;
        }
        FontMetrics fm = this.getFontMetrics();
        this.bounds.width = fm.stringWidth(this.getValueString());
        this.bounds.height = fm.getMaxDescent() + fm.getMaxAscent();
    }

    protected String getValueString() {
        String[] ids;
        String v = null;
        if (this.valStr != null && this.valStr.length() > 0) {
            v = this.valStr;
        }
        if (v == null && (ids = this.getParamIds()) != null) {
            v = ids[0];
        }
        if (v == null || v.length() == 0) {
            v = "";
        }
        return v;
    }

    public String getNumberFormatString() {
        return this.numberFormatString;
    }

    public void setNumberFormatString(String s) {
        this.numberFormatString = s;
        this.numberFormat = null;
    }

    public String formatNumber(double d) {
        if (this.numberFormat == null) {
            this.numberFormat = new DecimalFormat(this.numberFormatString);
        }
        return this.numberFormat.format(d);
    }

    public String format(Real d) {
        String fmtString = null;
        try {
            fmtString = d instanceof DateTime ? ((DateTime)d).toString() : this.formatNumber(d.getValue());
        }
        catch (Exception exc) {
            return "error: " + exc;
        }
        return fmtString;
    }

    public String format(double d) {
        return this.formatNumber(d);
    }

    public String format(float d) {
        return this.formatNumber(d);
    }

    public String getValue() {
        return this.valStr;
    }

    public void setValue(double d) {
        this.setValue(this.formatNumber(d));
    }

    public void setValue(String s) {
        this.valStr = s;
        this.calculateBounds();
    }

    @Override
    public Object getParamValue(int index) {
        return this.valStr;
    }

    @Override
    public void setParamValue(int index, Object v) {
        this.setValue(v.toString());
    }

    @Override
    public void draw(Graphics2D g, int x, int y, int width, int height) {
        g.setFont(this.currFont != null ? this.getFont() : this.makeDefaultFont());
        g.setColor(this.getForeground());
        g.drawString(this.getValueString(), x, y + height);
    }

    @Override
    public String toString() {
        return "TextSymbol " + this.valStr;
    }

    protected Font makeDefaultFont() {
        return Font.decode(FONTNAME + this.getFontSize());
    }
}

