/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui.symbol;

import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import ucar.unidata.ui.symbol.StationModel;
import ucar.unidata.ui.symbol.StationModelCanvas;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.PatternFileFilter;
import ucar.unidata.util.ResourceCollection;
import ucar.unidata.util.ResourceManager;
import ucar.unidata.xml.XmlEncoder;
import ucar.unidata.xml.XmlResourceCollection;

public class StationModelManager
extends ResourceManager {
    public static final PatternFileFilter FILTER_ISM = new PatternFileFilter(".+\\.ism", "IDV station model file (*.ism)", ".ism");
    StationModelCanvas smc;
    JFrame frame;
    protected XmlResourceCollection symbolTypes;

    public StationModelManager() {
    }

    public StationModelManager(XmlEncoder encoder) {
        super(encoder);
    }

    public void init(XmlResourceCollection symbolTypes, ResourceCollection stationModels) {
        this.symbolTypes = symbolTypes;
        this.init(stationModels);
    }

    public void addStationModel(StationModel stationModel) {
        this.addUsers(stationModel);
    }

    @Override
    public List getFileFilters() {
        return Misc.newList(FILTER_ISM);
    }

    @Override
    public String getTitle() {
        return "Layout Model";
    }

    public void show() {
        this.show((StationModel)null);
    }

    public void show(String modelName) {
        this.show(this.getStationModel(modelName));
    }

    public boolean checkCloseWindow() {
        if (this.frame == null || this.smc == null) {
            return true;
        }
        if (!this.smc.okToChange()) {
            return false;
        }
        this.smc.closeDialogs();
        JFrame tmp = this.frame;
        this.frame = null;
        this.smc = null;
        tmp.dispose();
        return true;
    }

    public void show(StationModel initModel) {
        if (this.frame == null) {
            this.frame = GuiUtils.createFrame(GuiUtils.getApplicationTitle() + "Layout Model Editor");
            this.frame.setDefaultCloseOperation(0);
            this.smc = new StationModelCanvas(this, this.frame){

                @Override
                protected void doClose() {
                    StationModelManager.this.checkCloseWindow();
                }
            };
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    StationModelManager.this.checkCloseWindow();
                }
            });
            this.smc.setPreferredSize(new Dimension(250, 250));
            this.frame.setJMenuBar(this.smc.getMenuBar());
            GuiUtils.packWindow(this.frame, this.smc.getContents(), true);
        }
        if (initModel != null) {
            this.smc.setStationModel(initModel);
        }
        this.frame.setVisible(true);
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public StationModel getDefaultStationModel() {
        StationModel dflt = (StationModel)this.getDefault();
        return dflt;
    }

    public StationModel getStationModel() {
        if (this.smc == null) {
            return null;
        }
        return this.smc.getStationModel();
    }

    public String getStationModelName() {
        StationModel sm = this.smc.getStationModel();
        return sm != null ? sm.getName() : null;
    }

    public StationModel getSelectedStationModel() {
        return this.getStationModel("Selected");
    }

    public StationModel getStationModel(String name) {
        if (name == null || name.equals("")) {
            return null;
        }
        StationModel stationModel = (StationModel)this.getObject(name);
        if (stationModel == null && name.indexOf(">") < 0) {
            name = ">" + name;
            for (int i = 0; i < this.resources.size(); ++i) {
                String modelName = this.resources.get(i).toString();
                if (!modelName.endsWith(name)) continue;
                return (StationModel)this.resources.get(i);
            }
        }
        return stationModel;
    }

    public List getStationModels() {
        return this.getResources();
    }

    public static void main(String[] args) {
        ArrayList<String> files = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            files.add(args[i]);
        }
        ResourceCollection rc = new ResourceCollection("station models", files);
        StationModelManager smm = new StationModelManager();
        smm.init(rc);
        smm.show();
    }
}

