/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui.symbol;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.ui.FineLineBorder;
import ucar.unidata.ui.Help;
import ucar.unidata.ui.drawing.EditCanvas;
import ucar.unidata.ui.drawing.Glyph;
import ucar.unidata.ui.symbol.MetSymbol;
import ucar.unidata.ui.symbol.PropertiesDialog;
import ucar.unidata.ui.symbol.StationModel;
import ucar.unidata.ui.symbol.StationModelManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.ObjectListener;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.xml.XmlNodeList;
import ucar.unidata.xml.XmlResourceCollection;
import ucar.unidata.xml.XmlUtil;

public class StationModelCanvas
extends EditCanvas {
    private static final String CMD_BLACKBG = "cmd.blackbg";
    private static final String CMD_WHITEBG = "cmd.whitebg";
    private static final String TAG_SYMBOL = "symbol";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_ICON = "icon";
    private static final String ATTR_ATTRS = "attrs";
    private StationModelManager smm;
    private List shapeDescriptors;
    private JCheckBoxMenuItem showAlignmentPointsMI;
    private JMenu stationModelMenu;
    private JMenu fileMenu;
    private StationModel stationModel;
    private JFrame frame;
    private JLabel nameLabel;
    private JComponent labelComponent;
    private JLabel highlightLabel;
    private MetSymbol highlightedMetSymbol;
    private static String HELP_TOP_DIR = "/auxdata/docs/userguide";

    public StationModelCanvas(StationModelManager smm, JFrame frame) {
        this(smm, true, frame);
    }

    public StationModelCanvas(StationModelManager smm, boolean editable, JFrame frame) {
        this.smm = smm;
        this.frame = frame;
        this.initFromDefault();
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent event) {
                int notches = event.getWheelRotation();
                if (notches < 0) {
                    StationModelCanvas.this.doZoomIn();
                } else {
                    StationModelCanvas.this.doZoomOut();
                }
            }
        });
    }

    @Override
    public void setHighlight(Glyph g) {
        super.setHighlight(g);
        if (g == null || !(g instanceof MetSymbol)) {
            this.highlightLabel.setText("   ");
            return;
        }
        this.highlightLabel.setText(" " + ((MetSymbol)g).getLabel());
    }

    @Override
    protected JComponent getLabelComponent() {
        if (this.nameLabel == null) {
            this.nameLabel = new JLabel();
            Font font = this.nameLabel.getFont();
            this.nameLabel.setFont(font.deriveFont(3));
            this.labelComponent = GuiUtils.hflow(Misc.newList(new JLabel("Layout Model: "), this.nameLabel));
        }
        return this.labelComponent;
    }

    @Override
    public void setName(String n) {
        this.getLabelComponent();
        if (this.nameLabel != null) {
            this.nameLabel.setText(n);
        }
    }

    private void initFromDefault() {
        this.stationModel = this.smm.getDefaultStationModel();
        if (this.stationModel == null) {
            this.stationModel = new StationModel("Default model", new ArrayList());
        }
        this.setStationModel(this.stationModel, true);
    }

    boolean okToChange() {
        if (this.getHaveChanged()) {
            int result = GuiUtils.showYesNoCancelDialog(null, "Save changes to station model: " + this.stationModel.getName(), "Save station model changes");
            if (result == 2) {
                return false;
            }
            if (result == 0) {
                this.doSave();
            }
        }
        return true;
    }

    public void setStationModel(StationModel l) {
        this.setStationModel(l, true);
    }

    public void setStationModel(StationModel newModel, boolean closeDialogs) {
        if (closeDialogs) {
            this.closeDialogs();
        }
        if (!this.smm.isUsers(newModel)) {
            List newGlyphs = this.cloneGlyphs(newModel.getList());
            newModel = new StationModel(newModel.getName(), newGlyphs);
        }
        this.stationModel = newModel;
        this.setGlyphs(this.cloneGlyphs(newModel.getList()));
        this.setName(this.stationModel.getDisplayName());
        this.setHaveChanged(false);
        this.frame.setTitle(GuiUtils.getApplicationTitle() + "Layout Model Editor -- " + this.stationModel.getName());
    }

    @Override
    public boolean doGroup() {
        return false;
    }

    public StationModel getStationModel() {
        this.stationModel.setList(this.getGlyphs());
        return this.stationModel;
    }

    @Override
    public String toString() {
        return this.stationModel.toString();
    }

    @Override
    public void initMenuBar(JMenuBar menuBar) {
        this.stationModelMenu = new JMenu("Layout Models");
        this.stationModelMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuSelected(MenuEvent e) {
                StationModelCanvas.this.makeStationModelMenu();
            }
        });
        this.fileMenu = new JMenu("File");
        this.fileMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuSelected(MenuEvent e) {
                StationModelCanvas.this.makeFileMenu();
            }
        });
        menuBar.add(this.fileMenu);
        super.initMenuBar(menuBar);
        menuBar.add(this.stationModelMenu);
        JMenu helpMenu = new JMenu("Help");
        JMenuItem helpMenuItem = new JMenuItem("Layout Models");
        helpMenu.add(helpMenuItem);
        helpMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                StationModelCanvas.this.showHelp();
            }
        });
        menuBar.add(helpMenu);
    }

    @Override
    public JMenu makeEditMenu(JMenu editMenu) {
        editMenu.add(GuiUtils.makeDynamicMenu("Symbols", this, "initSymbolsMenu"));
        editMenu.add(GuiUtils.makeMenuItem("Set properties on selected", this, "setPropertiesOnSelected"));
        editMenu.addSeparator();
        return super.makeEditMenu(editMenu);
    }

    public void setPropertiesOnSelected() {
        List selected = this.getSelection();
        if (selected == null || selected.size() == 0) {
            GuiUtils.showOkDialog(null, "Set range on selected", new JLabel("No shapes are selected"), null);
            return;
        }
        PropertiesDialog propertiesDialog = new PropertiesDialog(selected, this);
        propertiesDialog.show();
    }

    public void initSymbolsMenu(JMenu m) {
        m.removeAll();
        for (int i = 0; i < this.glyphs.size(); ++i) {
            final MetSymbol metSymbol = (MetSymbol)this.glyphs.get(i);
            JMenuItem mi = GuiUtils.makeMenuItem(metSymbol.getLabel(), this, "showProperties", metSymbol);
            mi.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    StationModelCanvas.this.highlightedMetSymbol = null;
                    StationModelCanvas.this.repaint();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    StationModelCanvas.this.highlightedMetSymbol = null;
                    StationModelCanvas.this.repaint();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    StationModelCanvas.this.highlightedMetSymbol = metSymbol;
                    StationModelCanvas.this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    StationModelCanvas.this.highlightedMetSymbol = null;
                    StationModelCanvas.this.repaint();
                }
            });
            m.add(mi);
        }
    }

    public boolean shouldShowAlignmentPoints() {
        if (this.showAlignmentPointsMI != null) {
            return this.showAlignmentPointsMI.isSelected();
        }
        return true;
    }

    private void makeFileMenu() {
        this.fileMenu.removeAll();
        this.fileMenu.add(this.makeMenuItem("New", 'n', GuiUtils.CMD_NEW));
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.makeMenuItem("Save", 's', GuiUtils.CMD_SAVE));
        this.fileMenu.add(this.makeMenuItem("Save As...", GuiUtils.CMD_SAVEAS));
        this.fileMenu.add(this.makeMenuItem("Rename...", GuiUtils.CMD_RENAME));
        this.fileMenu.addSeparator();
        JMenuItem removeMenuItem = this.makeMenuItem("Remove", GuiUtils.CMD_REMOVE);
        removeMenuItem.setEnabled(this.smm.isUsers(this.stationModel));
        this.fileMenu.add(removeMenuItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.makeMenuItem("Import...", GuiUtils.CMD_IMPORT));
        this.fileMenu.add(this.makeMenuItem("Export...", GuiUtils.CMD_EXPORT));
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.makeMenuItem("Close", GuiUtils.CMD_CLOSE));
    }

    @Override
    public JMenu makeViewMenu(JMenu viewMenu) {
        this.showAlignmentPointsMI = new JCheckBoxMenuItem("Show Alignment Points", true);
        viewMenu.add(this.showAlignmentPointsMI);
        this.showAlignmentPointsMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                StationModelCanvas.this.repaint();
            }
        });
        viewMenu.addSeparator();
        super.makeViewMenu(viewMenu);
        viewMenu.addSeparator();
        viewMenu.add(this.makeMenuItem("Black background", CMD_BLACKBG));
        viewMenu.add(this.makeMenuItem("White background", CMD_WHITEBG));
        return viewMenu;
    }

    public static void setHelpTopDir(String topDir) {
        HELP_TOP_DIR = topDir;
    }

    private void showHelp() {
        Help.setTopDir(HELP_TOP_DIR);
        Help.getDefaultHelp().gotoTarget("idv.tools.stationmodeleditor");
    }

    private void makeStationModelMenu() {
        this.stationModelMenu.removeAll();
        List symbols = this.smm.getResources();
        ArrayList items = new ArrayList();
        ObjectListener listener = new ObjectListener(null){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (!StationModelCanvas.this.okToChange()) {
                    return;
                }
                StationModelCanvas.this.setStationModel((StationModel)this.theObject, true);
            }
        };
        GuiUtils.makeMenu(this.stationModelMenu, StationModelCanvas.makeStationModelMenuItems(symbols, listener, this.smm));
    }

    public static List makeStationModelMenuItems(List symbols, final ObjectListener listener, StationModelManager smm) {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        ArrayList<JMenu> subMenus = new ArrayList<JMenu>();
        Hashtable<String, JMenu> categories = new Hashtable<String, JMenu>();
        for (int i = 0; i < symbols.size(); ++i) {
            StationModel sm = (StationModel)symbols.get(i);
            boolean isUsers = smm.isUsers(sm);
            String name = sm.getName();
            if (name.equals("")) continue;
            List<String> toks = StringUtil.split(name, ">", true, true);
            if (toks.size() > 0) {
                name = toks.get(toks.size() - 1);
            }
            JMenuItem item = new JMenuItem(GuiUtils.getLocalName(name, isUsers));
            item.addActionListener(new ObjectListener(sm){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    listener.setObject(this.theObject);
                    listener.actionPerformed(ae);
                }
            });
            toks.remove(toks.size() - 1);
            if (toks.size() == 0) {
                items.add(item);
                continue;
            }
            JMenu categoryMenu = null;
            String catSoFar = "";
            String menuCategory = "";
            for (int catIdx = 0; catIdx < toks.size(); ++catIdx) {
                String subCat = toks.get(catIdx);
                JMenu m = (JMenu)categories.get(catSoFar = catSoFar + "/" + subCat);
                if (m == null) {
                    m = new JMenu(subCat);
                    menuCategory = catSoFar;
                    categories.put(catSoFar, m);
                    if (categoryMenu != null) {
                        categoryMenu.add((Component)m, 0);
                    } else {
                        subMenus.add(m);
                    }
                }
                categoryMenu = m;
            }
            if (categoryMenu == null) {
                categoryMenu = new JMenu("");
                categories.put(toks.toString(), categoryMenu);
                subMenus.add(categoryMenu);
                menuCategory = toks.toString();
            }
            categoryMenu.add(item);
        }
        items.addAll(subMenus);
        return items;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String action = event.getActionCommand();
        if (action.equals(GuiUtils.CMD_SAVE)) {
            this.doSave();
        } else if (action.equals(GuiUtils.CMD_SAVEAS)) {
            this.doSaveAs();
        } else if (action.equals(GuiUtils.CMD_RENAME)) {
            this.doRename();
        } else if (action.equals(GuiUtils.CMD_NEW)) {
            this.doNew();
        } else if (action.equals(GuiUtils.CMD_IMPORT)) {
            this.doImport();
        } else if (action.equals(GuiUtils.CMD_EXPORT)) {
            this.doExport();
        } else if (action.equals(GuiUtils.CMD_REMOVE)) {
            this.doRemove();
        } else if (action.equals(GuiUtils.CMD_CLOSE)) {
            this.doClose();
        } else if (action.equals(CMD_BLACKBG)) {
            this.setCanvasBackground(Color.BLACK);
        } else if (action.equals(CMD_WHITEBG)) {
            this.setCanvasBackground(Color.WHITE);
        } else {
            super.actionPerformed(event);
        }
    }

    protected void closeDialogs() {
        for (int i = 0; i < this.glyphs.size(); ++i) {
            MetSymbol metSymbol = (MetSymbol)this.glyphs.get(i);
            metSymbol.closePropertiesDialog();
        }
    }

    protected void doClose() {
    }

    private void doSaveAs() {
        StationModel nl = this.getStationModel();
        String newName = this.smm.doSaveAs(nl, this);
        if (newName == null) {
            return;
        }
        nl = new StationModel(newName, new ArrayList(nl.getList()));
        this.setStationModel(nl, false);
        this.smm.addUsers(nl);
    }

    public void doSave() {
        this.doSave(true);
    }

    private void doSave(boolean fireChangeEvent) {
        StationModel sm = this.getStationModel();
        this.smm.addUsers(sm);
        if (fireChangeEvent) {
            // empty if block
        }
        this.setHaveChanged(false);
    }

    protected void doRemove() {
        if (!GuiUtils.showYesNoDialog(null, "Are you sure you want to remove the station model: " + this.stationModel.getName() + "?", "Confirm")) {
            return;
        }
        this.smm.removeUsers(this.stationModel);
        this.initFromDefault();
    }

    protected void doRename() {
        if (!this.okToChange()) {
            return;
        }
        String newName = this.smm.doNew(this, "Rename", this.stationModel.getName(), "Use '>' to add categories");
        if (newName == null) {
            return;
        }
        this.doSave(false);
        StationModel sm = this.getStationModel();
        sm.setName(newName);
        this.setStationModel(sm, false);
        this.doSave(true);
    }

    protected void doNew() {
        if (!this.okToChange()) {
            return;
        }
        String newName = this.smm.doNew(this, "New", "model", "Provide a name for the model");
        if (newName == null) {
            return;
        }
        this.setStationModel(new StationModel(newName, new ArrayList()), true);
        this.smm.addUsers(this.getStationModel());
    }

    private void doImport() {
        if (!this.okToChange()) {
            return;
        }
        StationModel nl = (StationModel)this.smm.doImport(true);
        if (nl == null) {
            return;
        }
        this.setStationModel(nl, true);
    }

    private void doExport() {
        this.smm.doExport(this.getStationModel());
    }

    @Override
    public List getShapeDescriptors() {
        if (this.shapeDescriptors == null) {
            this.shapeDescriptors = new ArrayList();
            List sds = this.shapeDescriptors;
            XmlResourceCollection symbolTypes = this.smm.symbolTypes;
            for (int i = 0; i < symbolTypes.size(); ++i) {
                Element root = symbolTypes.getRoot(i);
                if (root == null) continue;
                XmlNodeList symbols = XmlUtil.getElements(root, TAG_SYMBOL);
                for (int j = 0; j < symbols.size(); ++j) {
                    final Element symbolNode = (Element)symbols.item(j);
                    EditCanvas.ShapeDescriptor sd = new EditCanvas.ShapeDescriptor(XmlUtil.getAttribute(symbolNode, ATTR_CLASS), XmlUtil.getAttribute(symbolNode, ATTR_NAME), XmlUtil.getAttribute((Node)symbolNode, ATTR_ICON, "/ucar/unidata/ui/symbol/images/default.gif"), XmlUtil.getAttribute((Node)symbolNode, ATTR_ATTRS, "")){

                        @Override
                        public void initializeGlyph(Glyph g) {
                            super.initializeGlyph(g);
                            StationModelCanvas.this.initializeGlyphFromXml(g, symbolNode);
                        }
                    };
                    sds.add(sd);
                }
            }
        }
        return this.shapeDescriptors;
    }

    protected void initializeGlyphFromXml(Glyph g, Element symbolNode) {
        if (!(g instanceof MetSymbol)) {
            return;
        }
        ((MetSymbol)g).initialize(symbolNode);
    }

    @Override
    protected Component doMakeContents() {
        JComponent comp = (JComponent)super.doMakeContents();
        this.highlightLabel = new JLabel(" ");
        this.highlightLabel.setBorder(new FineLineBorder(1));
        return GuiUtils.centerBottom(comp, GuiUtils.inset((Component)this.highlightLabel, new Insets(2, 0, 2, 0)));
    }

    @Override
    public void paint(Graphics g) {
        Rectangle b = this.getBounds();
        g.setColor(this.canvasBg);
        g.fillRect(0, 0, b.width, b.height);
        this.paintGrid(g);
        Point center = this.getCenter();
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).translate(center.x, center.y);
        }
        super.paint(g);
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).scale(1.0, 1.0);
        }
        g.setColor(Color.gray);
        g.drawLine(0, -10 * b.height, 0, 10 * b.height);
        g.drawLine(-10 * b.width, 0, 10 * b.width, 0);
        MetSymbol tmp = this.highlightedMetSymbol;
        if (tmp != null) {
            Rectangle tb = tmp.getBounds();
            g.setColor(Color.red);
            g.drawRect(tb.x - 2, tb.y - 2, tb.width + 4, tb.height + 4);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.isControlDown() && e.getKeyCode() == 80) {
            List selectionSet = this.getSelection();
            if (selectionSet.size() == 1) {
                this.showProperties((MetSymbol)selectionSet.get(0));
            }
            return;
        }
        super.keyReleased(e);
    }

    @Override
    public List doMakeMenuItems(Glyph g, List l) {
        l = super.doMakeMenuItems(g, l);
        if (!(g instanceof MetSymbol)) {
            return l;
        }
        return this.doMakeMetSymbolMenu((MetSymbol)g, l, true);
    }

    protected List doMakeMetSymbolMenu(final MetSymbol metSymbol, List l, boolean forPopup) {
        if (l == null) {
            l = new ArrayList<JMenuItem>();
        }
        if (!forPopup) {
            l = super.doMakeMenuItems(metSymbol, l);
        }
        JMenuItem mi = new JMenuItem(metSymbol.getActive() ? "Hide" : "Show");
        l.add((JMenu)mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                metSymbol.setActive(!metSymbol.getActive());
            }
        });
        if (metSymbol.doAlignmentMenu()) {
            JMenu rectPtMenu = new JMenu("Alignment Point (" + Glyph.getRectPointName(metSymbol.getRectPoint()) + ")");
            l.add(rectPtMenu);
            for (int i = 0; i < Glyph.RECTPOINTNAMES.length; ++i) {
                mi = new JMenuItem(Glyph.RECTPOINTNAMES[i]);
                rectPtMenu.add(mi);
                mi.addActionListener(new ObjectListener(Glyph.RECTPOINTS[i]){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        metSymbol.setRectPoint(this.theObject.toString());
                        StationModelCanvas.this.setHaveChanged(true);
                        StationModelCanvas.this.repaint();
                    }
                });
            }
        }
        JMenu alignMenu = new JMenu("Center");
        l.add(alignMenu);
        mi = new JMenuItem("Center");
        alignMenu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Rectangle b = metSymbol.getBounds();
                Point2D rp = Glyph.getPointOnRect(metSymbol.getRectPoint(), b);
                metSymbol.moveBy((int)(-rp.getX()), (int)(-rp.getY()));
                StationModelCanvas.this.repaint();
                StationModelCanvas.this.setHaveChanged(true);
            }
        });
        mi = new JMenuItem("Center Vertically");
        alignMenu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Rectangle b = metSymbol.getBounds();
                Point2D rp = Glyph.getPointOnRect(metSymbol.getRectPoint(), b);
                metSymbol.moveBy(0, (int)(-rp.getY()));
                StationModelCanvas.this.repaint();
                StationModelCanvas.this.setHaveChanged(true);
            }
        });
        mi = new JMenuItem("Center Horizontally");
        alignMenu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Rectangle b = metSymbol.getBounds();
                Point2D rp = Glyph.getPointOnRect(metSymbol.getRectPoint(), b);
                metSymbol.moveBy((int)(-rp.getX()), 0);
                StationModelCanvas.this.repaint();
                StationModelCanvas.this.setHaveChanged(true);
            }
        });
        if (forPopup) {
            l.add((JMenu)((Object)"separator"));
            mi = new JMenuItem("Properties...");
            l.add((JMenu)mi);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    StationModelCanvas.this.showProperties(metSymbol);
                }
            });
        }
        return l;
    }

    @Override
    public boolean showTextInPalette() {
        return true;
    }

    @Override
    protected void doDoubleClick(Glyph glyph) {
        if (glyph instanceof MetSymbol) {
            this.showProperties((MetSymbol)glyph);
        }
    }

    public boolean getShowParams() {
        return false;
    }

    @Override
    public void notifyGlyphCreateComplete(Glyph newGlyph, boolean diddleSelection, boolean fromPaste) {
        super.notifyGlyphCreateComplete(newGlyph, diddleSelection, fromPaste);
        if (fromPaste) {
            return;
        }
        if (newGlyph instanceof MetSymbol) {
            this.showProperties((MetSymbol)newGlyph);
        }
    }

    public void showProperties(MetSymbol metSymbol) {
        metSymbol.showPropertiesDialog(this);
        this.repaint();
    }

    private static TwoFacedObject getFormat(double value, String formatString) {
        DecimalFormat df = new DecimalFormat(formatString);
        return new TwoFacedObject((Object)(df.format(value) + " (" + formatString + ")"), formatString);
    }

    public static List getDefaultFormatList(double value) {
        ArrayList<String> formatList = new ArrayList<String>();
        String[] formats = new String[]{"###0.#", "###0.0#", "###,###.###", "###.##", "000000.000"};
        for (int i = 0; i < formats.length; ++i) {
            formatList.add(formats[i]);
        }
        return formatList;
    }

    public static List getDefaultUnitList() {
        return Misc.newList(new Object[]{new TwoFacedObject((Object)"Default", null), "Celsius", "Fahrenheit", "Kelvin", "millibars", "hectoPascals", "meters", "kilometers", "feet", "knots", "meters/second", "miles/hour", "kilometers/hour", "furlongs/fortnight"});
    }

    public Point getCenter() {
        Rectangle b = this.getBounds();
        return new Point(b.width / 2, b.height / 2);
    }

    @Override
    public int transformInputX(int x) {
        Point center = this.getCenter();
        x -= center.x;
        x = (int)((double)x / this.scaleFactor);
        return x;
    }

    @Override
    public int transformInputY(int y) {
        Point center = this.getCenter();
        y -= center.y;
        y = (int)((double)y / this.scaleFactor);
        return y;
    }

    public int xxxtransformOutputX(int x) {
        Point center = this.getCenter();
        return center.x + x;
    }

    public int xxxtransformOutputY(int y) {
        Point center = this.getCenter();
        return center.y + y;
    }

    public Rectangle xxxtransformOutput(Rectangle r) {
        return new Rectangle(this.transformOutputX(r.x), this.transformOutputY(r.y), r.width, r.height);
    }

    @Override
    public Rectangle transformInput(Rectangle r) {
        return new Rectangle(this.transformInputX(r.x), this.transformInputY(r.y), r.width, r.height);
    }

    public Point xxxtransformOutput(Point r) {
        return new Point(this.transformOutputX(r.x), this.transformOutputY(r.y));
    }

    @Override
    public Point transformInput(Point r) {
        return new Point(this.transformInputX(r.x), this.transformInputY(r.y));
    }
}

