/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui.symbol;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ucar.unidata.ui.drawing.Glyph;
import ucar.unidata.ui.symbol.MetSymbol;
import ucar.unidata.util.NamedList;
import ucar.unidata.util.StringUtil;

public class StationModel
extends NamedList {
    private Rectangle bounds;
    private List listeners = new ArrayList();

    public StationModel() {
        this("");
    }

    public StationModel(String name) {
        this(name, new ArrayList());
    }

    public StationModel(String name, List l) {
        super(name, l);
    }

    public List getSymbols() {
        return this.getList();
    }

    public void addSymbol(MetSymbol s) {
        this.getList().add(s);
        this.bounds = null;
    }

    public void removeSymbol(MetSymbol s) {
        this.getList().remove(s);
        this.bounds = null;
    }

    public Rectangle getBounds() {
        Rectangle tmpBounds = null;
        List glyphs = this.getList();
        for (int i = 0; i < glyphs.size(); ++i) {
            Rectangle gb = ((Glyph)glyphs.get(i)).getBounds();
            if (tmpBounds == null) {
                tmpBounds = new Rectangle(gb);
                continue;
            }
            tmpBounds.add(gb);
        }
        if (tmpBounds == null) {
            tmpBounds = new Rectangle(0, 0, 0, 0);
        }
        this.bounds = tmpBounds;
        return tmpBounds;
    }

    public String getDisplayName() {
        List<String> toks = StringUtil.split(this.getName(), ">", true, true);
        if (toks.size() > 0) {
            return toks.get(toks.size() - 1);
        }
        return this.getName();
    }

    public MetSymbol findSymbolByName(String name) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            MetSymbol ms = (MetSymbol)iter.next();
            if (!name.equals(ms.getName())) continue;
            return ms;
        }
        return null;
    }

    public void draw(Graphics2D g, Point2D loc) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            MetSymbol ms = (MetSymbol)iter.next();
            if (!ms.getActive() || ms.getMissing()) continue;
            ms.draw(g, loc);
        }
    }
}

