/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui.symbol;

import java.awt.Graphics2D;
import java.util.List;
import javax.swing.JComboBox;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.data.point.PointOb;
import ucar.unidata.ui.drawing.DisplayCanvas;
import ucar.unidata.ui.symbol.MetSymbol;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.ShapeUtility;
import visad.VisADGeometryArray;
import visad.VisADLineArray;
import visad.VisADQuadArray;
import visad.VisADTriangleArray;

public class ShapeSymbol
extends MetSymbol {
    public static final String ATTR_POINTS = "points";
    public static final String ATTR_SHAPE = "shape";
    public static final String ATTR_SHAPETYPE = "shapetype";
    public static final String TYPE_LINE = "line";
    public static final String TYPE_TRIANGLE = "triangle";
    public static final String TYPE_QUAD = "quad";
    private VisADGeometryArray sample;
    private JComboBox shapeBox;
    private String shape;
    float[] points;
    String shapeType;
    boolean stretchy = true;

    public ShapeSymbol() {
    }

    public ShapeSymbol(int x, int y) {
        this(null, x, y);
    }

    public ShapeSymbol(DisplayCanvas canvas, int x, int y) {
        super(canvas, x, y, new String[0], new String[0]);
        this.setSize(20, 20);
    }

    @Override
    public String getLabel() {
        return "Shape Symbol: " + this.shape;
    }

    @Override
    public void initialize(Element symbolNode) {
        super.initialize(symbolNode);
        this.stretchy = XmlUtil.getAttribute((Node)symbolNode, "stretchy", true);
        this.setScale(XmlUtil.getAttribute((Node)symbolNode, "scale", 1.0));
        this.shape = XmlUtil.getAttribute((Node)symbolNode, ATTR_SHAPE, "SQUARE");
        this.shapeType = XmlUtil.getAttribute((Node)symbolNode, ATTR_SHAPETYPE, TYPE_LINE);
        String pointsString = XmlUtil.getAttribute((Node)symbolNode, ATTR_POINTS, (String)null);
        if (pointsString != null) {
            this.points = Misc.parseFloats(pointsString);
        }
    }

    @Override
    protected void initPropertyComponents(List comps) {
        super.initPropertyComponents(comps);
        if (this.points != null) {
            return;
        }
        this.makeShapePropertyComponents(comps);
    }

    protected void makeShapePropertyComponents(List comps) {
        this.shapeBox = new JComboBox<TwoFacedObject>(ShapeUtility.SHAPES);
        TwoFacedObject tfo = new TwoFacedObject((Object)this.shape, this.shape);
        int index = Misc.toList(ShapeUtility.SHAPES).indexOf(tfo);
        if (index >= 0) {
            this.shapeBox.setSelectedIndex(index);
        } else {
            this.shapeBox.setSelectedItem(tfo);
        }
        comps.add(GuiUtils.rLabel("Shape:"));
        comps.add(GuiUtils.left(this.shapeBox));
    }

    @Override
    protected void applyProperties() {
        this.sample = null;
        if (this.shapeBox != null) {
            this.shape = TwoFacedObject.getIdString(this.shapeBox.getSelectedItem());
        }
        super.applyProperties();
    }

    @Override
    public boolean getStretchy() {
        return this.stretchy;
    }

    @Override
    public void setStretchy(boolean s) {
        this.stretchy = s;
    }

    @Override
    public Object getParamValue(int index) {
        return null;
    }

    @Override
    public void setParamValue(int index, Object v) {
        if (index == 0) {
            // empty if block
        }
    }

    @Override
    public boolean getEqualSides() {
        return true;
    }

    @Override
    public void draw(Graphics2D g, int x, int y, int width, int height) {
        g.setColor(this.getForeground());
        if (this.sample == null) {
            this.sample = this.makeShapes(null)[0];
        }
        double scale = this.getScale() * 10.0;
        float[] pts = this.sample.coordinates;
        int mx = x + width / 2;
        int my = y + width / 2;
        if (this.sample instanceof VisADLineArray) {
            for (int i = 0; i < pts.length - 6; i += 6) {
                g.drawLine(mx + (int)(scale * (double)pts[i]), my - (int)(scale * (double)pts[i + 1]), mx + (int)(scale * (double)pts[i + 3]), my - (int)(scale * (double)pts[i + 3 + 1]));
            }
        } else if (this.sample instanceof VisADTriangleArray) {
            int[] xpoints = new int[]{0, 0, 0};
            int[] ypoints = new int[]{0, 0, 0};
            for (int i = 0; i < pts.length; i += 9) {
                xpoints[0] = mx + (int)(scale * (double)pts[i]);
                xpoints[1] = mx + (int)(scale * (double)pts[i + 3]);
                xpoints[2] = mx + (int)(scale * (double)pts[i + 6]);
                ypoints[0] = my - (int)(scale * (double)pts[i + 1]);
                ypoints[1] = my - (int)(scale * (double)pts[i + 1 + 3]);
                ypoints[2] = my - (int)(scale * (double)pts[i + 1 + 6]);
                g.fillPolygon(xpoints, ypoints, 3);
            }
        } else if (this.sample instanceof VisADQuadArray) {
            int[] xpoints = new int[]{0, 0, 0, 0};
            int[] ypoints = new int[]{0, 0, 0, 0};
            for (int i = 0; i < pts.length; i += 12) {
                xpoints[0] = mx + (int)(scale * (double)pts[i]);
                xpoints[1] = mx + (int)(scale * (double)pts[i + 3]);
                xpoints[2] = mx + (int)(scale * (double)pts[i + 6]);
                xpoints[3] = mx + (int)(scale * (double)pts[i + 9]);
                ypoints[0] = my - (int)(scale * (double)pts[i + 1]);
                ypoints[1] = my - (int)(scale * (double)pts[i + 1 + 3]);
                ypoints[2] = my - (int)(scale * (double)pts[i + 1 + 6]);
                ypoints[3] = my - (int)(scale * (double)pts[i + 1 + 9]);
                g.fillPolygon(xpoints, ypoints, 4);
            }
        } else {
            g.drawRect(x, y, width, height);
        }
    }

    public void setShape(String value) {
        this.shape = value;
    }

    public String getShape() {
        return this.shape;
    }

    @Override
    public boolean doAllObs() {
        return true;
    }

    @Override
    public VisADGeometryArray[] makeShapes(PointOb ob) {
        if (this.points != null) {
            VisADGeometryArray shape = null;
            if (this.shapeType.equals(TYPE_LINE)) {
                shape = new VisADLineArray();
            } else if (this.shapeType.equals(TYPE_TRIANGLE)) {
                shape = new VisADTriangleArray();
            } else if (this.shapeType.equals(TYPE_QUAD)) {
                shape = new VisADQuadArray();
            } else {
                throw new IllegalStateException("Unknown shape:" + this.shapeType);
            }
            shape.coordinates = (float[])this.points.clone();
            shape.vertexCount = shape.coordinates.length / 3;
            return new VisADGeometryArray[]{shape};
        }
        return ShapeUtility.createShape(this.shape);
    }

    public String getShapeType() {
        return this.shapeType;
    }

    public void setShapeType(String type) {
        this.shapeType = type;
    }

    public float[] getPoints() {
        return this.points;
    }

    public void setPoints(float[] p) {
        this.points = p;
    }
}

