/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui.symbol;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import ucar.unidata.data.DataAlias;
import ucar.unidata.idv.DisplayConventions;
import ucar.unidata.ui.ParamField;
import ucar.unidata.ui.colortable.ColorTableCanvas;
import ucar.unidata.ui.colortable.ColorTableManager;
import ucar.unidata.ui.symbol.ColorMap;
import ucar.unidata.ui.symbol.LabelSymbol;
import ucar.unidata.ui.symbol.MetSymbol;
import ucar.unidata.ui.symbol.RotateInfo;
import ucar.unidata.ui.symbol.StationModelCanvas;
import ucar.unidata.ui.symbol.TextSymbol;
import ucar.unidata.ui.symbol.ValueSymbol;
import ucar.unidata.ui.symbol.WeatherSymbol;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.ObjectListener;
import ucar.unidata.util.Range;
import ucar.unidata.util.TwoFacedObject;
import ucar.visad.Util;
import visad.Unit;

public class PropertiesDialog
implements ActionListener {
    boolean initialized = false;
    private MetSymbol symbol;
    private List<MetSymbol> selected;
    private StationModelCanvas canvas;
    JDialog dialog;
    private ColorTable tmpColorTable;
    private Hashtable paramMap;
    private JTextField scaleFld;
    private GuiUtils.ColorSwatch bgColorSwatch;
    private GuiUtils.ColorSwatch fgColorSwatch;
    private JTextField scaleMinFld;
    private JTextField scaleMaxFld;
    private JTextField scaleDataMinFld;
    private JTextField scaleDataMaxFld;
    private ParamField scaleParamFld;
    private ParamField colorTableParamFld;
    private List colorMappings;
    private JPanel mappingHolder;
    private JComboBox scaleUnitFld = null;
    private JButton colorPopupBtn;
    private JLabel colorLbl;
    private JCheckBox shownCheckbox;
    private JLabel colorBarLbl;
    private ParamField colorParamFld;
    private JTextField colorMinFld;
    private JTextField colorMaxFld;
    private JComboBox colorUnitFld = null;
    private List paramFields = new ArrayList();
    private List valueFields = new ArrayList();
    private List unitFields = new ArrayList();
    private List formatFields = new ArrayList();
    private List fontFields = new ArrayList();
    private List fontSizeFields = new ArrayList();
    RotateGui rotateZGui;
    RotateGui rotateXGui;
    RotateGui rotateYGui;
    private ActionListener formatListener;
    private boolean inError = false;
    private String what = "";

    public PropertiesDialog(MetSymbol symbol, StationModelCanvas canvas) {
        this.symbol = symbol;
        this.canvas = canvas;
    }

    public PropertiesDialog(List<MetSymbol> selected, StationModelCanvas canvas) {
        this.selected = selected;
        this.symbol = selected.get(0);
        this.canvas = canvas;
    }

    public boolean doMultiple() {
        return this.selected != null;
    }

    public void close() {
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }

    public void show() {
        if (this.dialog == null) {
            this.doMakeContents();
            this.initialized = true;
        }
        this.dialog.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals(GuiUtils.CMD_SAVE) || cmd.equals(GuiUtils.CMD_APPLY) || cmd.equals(GuiUtils.CMD_OK)) {
            try {
                this.doApply();
                this.setDialogTitle();
            }
            catch (NumberFormatException nfe) {
                LogUtil.userErrorMessage("Bad format for " + this.what);
                return;
            }
            catch (Exception exc) {
                LogUtil.logException("Error processing  " + this.what, exc);
                return;
            }
            this.canvas.repaint();
        }
        if (cmd.equals(GuiUtils.CMD_APPLY)) {
            this.canvas.doSave();
        }
        if (cmd.equals(GuiUtils.CMD_CANCEL) || cmd.equals(GuiUtils.CMD_OK)) {
            this.dialog.setVisible(false);
        }
    }

    private String getParam(ParamField paramField) {
        String t = paramField.getText().trim();
        if (t.length() == 0) {
            return null;
        }
        return t;
    }

    protected void doApply() throws Exception {
        if (this.formatListener != null) {
            this.inError = false;
            this.formatListener.actionPerformed(null);
            if (this.inError) {
                return;
            }
        }
        if (!this.doMultiple()) {
            this.doApply(this.symbol);
        } else {
            for (MetSymbol selectedSymbol : this.selected) {
                this.doApply(selectedSymbol);
            }
        }
    }

    protected void doApplyColorSettings(MetSymbol symbol) throws Exception {
        if (symbol.shouldShowColorTableGui()) {
            if (!this.doMultiple()) {
                symbol.setColorTableParam(this.getParam(this.colorTableParamFld));
            }
            this.what = "Color table properties";
            symbol.setColorTable(this.tmpColorTable);
            this.what = "color table minimum range";
            symbol.getColorTableRange().setMin(Misc.parseNumber(this.colorMinFld.getText()));
            this.what = "color table maximum range";
            symbol.getColorTableRange().setMax(Misc.parseNumber(this.colorMaxFld.getText()));
            String tmpUnitName = TwoFacedObject.getIdString(this.colorUnitFld.getSelectedItem());
            this.what = "color table unit";
            if (tmpUnitName != null) {
                Unit unit = Util.parseUnit(tmpUnitName);
            }
            symbol.setColorTableUnitName(tmpUnitName);
        }
        if (this.doMultiple()) {
            return;
        }
        if (this.colorParamFld != null) {
            this.what = "Color by properties";
            symbol.setColorParam(this.getParam(this.colorParamFld));
            symbol.setColorMappings(ColorMap.applyProperties(this.colorMappings));
        }
    }

    protected void doApply(MetSymbol symbol) throws Exception {
        this.doApplyColorSettings(symbol);
        if (this.doMultiple()) {
            return;
        }
        String[] descrs = symbol.getParamDescs();
        String[] ids = symbol.getParamIds();
        boolean doUnits = symbol.showDisplayUnitInProperties();
        boolean doFont = symbol instanceof TextSymbol;
        if (!this.doMultiple()) {
            symbol.applyProperties();
            symbol.setActive(this.shownCheckbox.isSelected());
        }
        this.what = "scale field";
        symbol.setScale(Misc.parseNumber(this.scaleFld.getText()));
        if (this.fgColorSwatch.getSwatchColor() == null) {
            symbol.setForeground(null);
        } else {
            symbol.setForeground(this.fgColorSwatch.getSwatchColor());
        }
        symbol.setBackground(this.bgColorSwatch.getSwatchColor());
        if (symbol.shouldShowScaleGui()) {
            symbol.setScaleParam(this.getParam(this.scaleParamFld));
            String tmpUnitName = TwoFacedObject.getIdString(this.scaleUnitFld.getSelectedItem());
            this.what = "scale";
            symbol.getScaleDataRange().setMin(Misc.parseNumber(this.scaleDataMinFld.getText()));
            symbol.getScaleDataRange().setMax(Misc.parseNumber(this.scaleDataMaxFld.getText()));
            symbol.getScaleRange().setMin(Misc.parseNumber(this.scaleMinFld.getText()));
            symbol.getScaleRange().setMax(Misc.parseNumber(this.scaleMaxFld.getText()));
            this.what = "scale unit";
            if (tmpUnitName != null) {
                Unit unit = Util.parseUnit(tmpUnitName);
            }
            symbol.setScaleUnitName(tmpUnitName);
        }
        if (symbol.shouldShowRotateGui()) {
            this.rotateZGui.apply();
            this.rotateXGui.apply();
            this.rotateYGui.apply();
        }
        for (int i = 0; i < this.paramFields.size(); ++i) {
            Object fld;
            ParamField paramBox = (ParamField)this.paramFields.get(i);
            ids[i] = this.getParam(paramBox);
            if (doUnits) {
                String unitName = TwoFacedObject.getIdString(((JComboBox)this.unitFields.get(i)).getSelectedItem());
                this.what = "display unit";
                if (unitName != null) {
                    Unit unit = Util.parseUnit(unitName);
                }
                symbol.setDisplayUnitName(unitName);
                if (symbol instanceof ValueSymbol) {
                    String formatString = ((JComboBox)this.formatFields.get(i)).getSelectedItem().toString();
                    formatString = formatString.trim();
                    ((ValueSymbol)symbol).setNumberFormatString(formatString);
                }
            }
            if (symbol instanceof WeatherSymbol || !((fld = this.valueFields.get(i)) instanceof JTextField)) continue;
            symbol.setParamValue(i, ((JTextField)fld).getText().trim());
        }
        if (doFont) {
            TwoFacedObject fontTFO = (TwoFacedObject)((JComboBox)this.fontFields.get(0)).getSelectedItem();
            Font f = (Font)fontTFO.getId();
            String fontSize = (String)((JComboBox)this.fontSizeFields.get(0)).getSelectedItem();
            int size = f == null ? ((TextSymbol)symbol).getFontSize() : f.getSize();
            this.what = "font size";
            size = Integer.parseInt(fontSize);
            ((TextSymbol)symbol).setFontSize(size);
            Font newF = f == null ? null : f.deriveFont((float)size);
            ((TextSymbol)symbol).setFont(newF);
        }
        symbol.setParamIds(ids);
        symbol.setParamDescs(descrs);
        this.canvas.repaint();
        this.updateMappings();
    }

    private List getParameterList(boolean addNull) {
        ArrayList<TwoFacedObject> ids = new ArrayList<TwoFacedObject>(DataAlias.getLabelIdList());
        ids.add(0, new TwoFacedObject((Object)"Observation time", "time"));
        ids.add(0, new TwoFacedObject((Object)"Latitude", "lat"));
        ids.add(0, new TwoFacedObject((Object)"Longitude", "lon"));
        ids.add(0, new TwoFacedObject((Object)"Altitude", "alt"));
        if (addNull) {
            ids.add(0, new TwoFacedObject((Object)"-none-", null));
        }
        return ids;
    }

    public void doMakeContents() {
        ArrayList<JComponent> rightComps;
        boolean doValueFields;
        JTabbedPane tabbedPane = new JTabbedPane();
        boolean doUnits = this.symbol.showDisplayUnitInProperties();
        boolean doFont = this.symbol instanceof TextSymbol;
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        this.symbol.initPropertyComponents(comps);
        List labelIds = this.getParameterList(false);
        this.paramMap = new Hashtable();
        for (int i = 0; i < labelIds.size(); ++i) {
            Object o = labelIds.get(i);
            this.paramMap.put(o.toString(), o);
        }
        boolean bl = doValueFields = !this.symbol.doAllObs();
        if (this.symbol instanceof LabelSymbol) {
            doValueFields = false;
        }
        String[] ids = this.symbol.getParamIds();
        String[] descrs = this.symbol.getParamDescs();
        for (int i = 0; i < ids.length; ++i) {
            JTextField tmpFld = null;
            rightComps = new ArrayList<JComponent>();
            if (doValueFields) {
                ParamField tfld = new ParamField(",");
                tfld.setToolTipText("<html>Comma separated list of parameters.<br>Right mouse to add aliases or current fields</html>");
                tfld.setText(ids[i]);
                this.paramFields.add(tfld);
                comps.add(GuiUtils.rLabel(descrs[i] + ":  "));
                rightComps.add(tfld);
                Object paramValue = this.symbol.getParamValue(i);
                tmpFld = new JTextField(paramValue == null ? "" : paramValue.toString(), 10);
                this.valueFields.add(tmpFld);
                rightComps.add(GuiUtils.rLabel(" Ex. value:  "));
                rightComps.add(tmpFld);
                comps.add(GuiUtils.left(GuiUtils.hbox(rightComps, 5)));
            }
            final JTextField vfld = tmpFld;
            if (doUnits) {
                String unitName = this.symbol.getDisplayUnitName();
                PropertiesDialog propertiesDialog = this;
                JComboBox ufld = GuiUtils.getEditableBox(propertiesDialog.canvas.getDefaultUnitList(), unitName);
                this.unitFields.add(ufld);
                comps.add(GuiUtils.rLabel(" Unit:"));
                rightComps = new ArrayList();
                rightComps.add(GuiUtils.left(ufld));
                if (this.symbol instanceof ValueSymbol) {
                    String formatString = ((ValueSymbol)this.symbol).getNumberFormatString();
                    double value = ((ValueSymbol)this.symbol).getDoubleValue();
                    final JComboBox ffld = GuiUtils.getEditableBox(StationModelCanvas.getDefaultFormatList(value), formatString);
                    this.what = "format string";
                    DecimalFormat df = new DecimalFormat(formatString);
                    final JLabel formatLabel = new JLabel(" ex: " + df.format(value));
                    this.formatListener = new ObjectListener(vfld){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            String pattern = ffld.getSelectedItem().toString();
                            try {
                                PropertiesDialog.this.inError = false;
                                double value = Misc.parseNumber(vfld.getText().trim());
                                DecimalFormat df = new DecimalFormat(pattern);
                                formatLabel.setText(" ex: " + df.format(value));
                            }
                            catch (NumberFormatException nfe) {
                                PropertiesDialog.this.inError = true;
                                LogUtil.userMessage("Bad example value:" + vfld.getText());
                            }
                            catch (IllegalArgumentException iae) {
                                LogUtil.userMessage("Bad number format:" + pattern);
                            }
                        }
                    };
                    if (vfld != null) {
                        vfld.addActionListener(this.formatListener);
                    }
                    ffld.addActionListener(this.formatListener);
                    rightComps.add(GuiUtils.rLabel(" Format:"));
                    this.formatFields.add(ffld);
                    rightComps.add(GuiUtils.hgrid(Misc.newList(ffld, formatLabel), 0));
                }
                comps.add(GuiUtils.left(GuiUtils.hbox(rightComps, 5)));
            }
            if (!doFont) continue;
            Font font = ((TextSymbol)this.symbol).getFont();
            TextSymbol cfr_ignored_0 = (TextSymbol)this.symbol;
            Font[] fonts = TextSymbol.getFontList();
            Vector<TwoFacedObject> fontList = new Vector<TwoFacedObject>(fonts.length + 1);
            fontList.add(this.makeFontTFO(null));
            for (int f = 0; f < fonts.length; ++f) {
                fontList.add(this.makeFontTFO(fonts[f]));
            }
            JComboBox ffld = GuiUtils.getEditableBox(fontList, this.makeFontTFO(font));
            ffld.setEditable(false);
            this.fontFields.add(ffld);
            int fontSize = ((TextSymbol)this.symbol).getFontSize();
            TextSymbol cfr_ignored_1 = (TextSymbol)this.symbol;
            JComboBox sfld = GuiUtils.getEditableBox(Misc.newList(TextSymbol.FONT_SIZES), String.valueOf(fontSize));
            this.fontSizeFields.add(sfld);
            comps.add(GuiUtils.rLabel("Font:"));
            rightComps = new ArrayList();
            rightComps.add(ffld);
            rightComps.add(new JLabel(" Size:"));
            rightComps.add(sfld);
            comps.add(GuiUtils.left(GuiUtils.hbox(rightComps, 5)));
        }
        this.shownCheckbox = new JCheckBox("", this.symbol.getActive());
        comps.add(GuiUtils.rLabel("Shown:"));
        comps.add(GuiUtils.left(this.shownCheckbox));
        JComponent[] fgSwatch = GuiUtils.makeColorSwatchWidget(this.symbol.getForeground(), "");
        this.fgColorSwatch = (GuiUtils.ColorSwatch)fgSwatch[0];
        JPanel fgColorPanel = GuiUtils.hbox(fgSwatch[0], fgSwatch[2]);
        comps.add(GuiUtils.rLabel("Foreground Color:"));
        comps.add(GuiUtils.left(fgColorPanel));
        JComponent[] bgSwatch = GuiUtils.makeColorSwatchWidget(this.symbol.getBackground(), "");
        this.bgColorSwatch = (GuiUtils.ColorSwatch)bgSwatch[0];
        JPanel bgColorPanel = GuiUtils.hbox(bgSwatch[0], bgSwatch[2]);
        comps.add(GuiUtils.rLabel("Background Color:"));
        comps.add(GuiUtils.left(bgColorPanel));
        this.scaleFld = new JTextField("", 5);
        this.scaleFld.setText(Misc.format(this.symbol.getScale()));
        comps.add(GuiUtils.rLabel("Scale Size By:"));
        comps.add(GuiUtils.left(this.scaleFld));
        if (!this.doMultiple()) {
            GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
            tabbedPane.add("Display", GuiUtils.topLeft(GuiUtils.doLayout(comps, 2, GuiUtils.WT_N, GuiUtils.WT_N)));
        }
        if (this.symbol.shouldShowColorTableGui()) {
            JTabbedPane colorTabbedPane = new JTabbedPane();
            tabbedPane.add("Color By", colorTabbedPane);
            comps = new ArrayList();
            PropertiesDialog propertiesDialog = this;
            this.colorUnitFld = GuiUtils.getEditableBox(propertiesDialog.canvas.getDefaultUnitList(), this.symbol.getColorTableUnitName());
            if (this.colorPopupBtn == null) {
                this.colorMaxFld = new JTextField("", 5);
                this.colorMinFld = new JTextField("", 5);
                this.colorTableParamFld = new ParamField();
                this.colorTableParamFld.setToolTipText("<html>Parameter name to color by.<br>Right mouse to use aliases or current fields</html>");
                this.colorLbl = new JLabel("-none-");
                this.colorBarLbl = new JLabel();
                this.colorPopupBtn = new JButton("Set");
                this.colorPopupBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        PropertiesDialog.this.showColorTableMenu(PropertiesDialog.this.colorPopupBtn);
                    }
                });
                this.colorTableParamFld.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        PropertiesDialog.this.colorTableParamChanged();
                    }
                });
            }
            this.colorMinFld.setText(Misc.format(this.symbol.getColorTableRange().getMin()));
            this.colorMaxFld.setText(Misc.format(this.symbol.getColorTableRange().getMax()));
            this.setTmpColorTable(this.symbol.getColorTable());
            this.colorTableParamFld.setText(this.symbol.getColorTableParam());
            if (!this.doMultiple()) {
                comps.add(GuiUtils.rLabel("Map Value of:"));
                comps.add(GuiUtils.left(this.colorTableParamFld));
                comps.add(new JLabel(""));
                comps.add(new JLabel("Into:"));
            }
            comps.add(GuiUtils.rLabel("Data Range:"));
            rightComps = new ArrayList();
            rightComps.add(this.colorMinFld);
            rightComps.add(this.colorMaxFld);
            rightComps.add(new JLabel("  Unit:"));
            rightComps.add(this.colorUnitFld);
            comps.add(GuiUtils.left(GuiUtils.hbox(rightComps, 5)));
            comps.add(GuiUtils.rLabel("Color Table:"));
            comps.add(GuiUtils.left(GuiUtils.hbox((Component)this.colorPopupBtn, (Component)this.colorBarLbl, (Component)this.colorLbl, 5)));
            GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
            colorTabbedPane.add("Map Value Into Color Table", GuiUtils.topLeft(GuiUtils.doLayout(comps, 2, GuiUtils.WT_N, GuiUtils.WT_N)));
            comps = new ArrayList();
            if (this.colorParamFld == null) {
                this.colorParamFld = new ParamField();
            }
            this.colorParamFld.setToolTipText("<html>Parameter name to color by.<br>Right mouse to use aliases or current fields</html>");
            this.colorParamFld.setText(this.symbol.getColorParam());
            if (!this.doMultiple()) {
                comps.add(GuiUtils.rLabel("Get Color From:"));
                comps.add(GuiUtils.left(this.colorParamFld));
            }
            this.mappingHolder = new JPanel(new BorderLayout());
            this.updateMappings();
            JScrollPane mappingScroller = new JScrollPane(this.mappingHolder);
            mappingScroller.setPreferredSize(new Dimension(400, 250));
            JViewport vp = mappingScroller.getViewport();
            vp.setViewSize(new Dimension(400, 250));
            comps.add(GuiUtils.top(GuiUtils.rLabel("Color Mapping:")));
            comps.add(mappingScroller);
            if (!this.doMultiple()) {
                GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
                colorTabbedPane.add("Color From Parameter", GuiUtils.topLeft(GuiUtils.doLayout(comps, 2, GuiUtils.WT_N, GuiUtils.WT_N)));
            }
        }
        if (this.symbol.shouldShowScaleGui()) {
            comps = new ArrayList();
            PropertiesDialog propertiesDialog = this;
            this.scaleUnitFld = GuiUtils.getEditableBox(propertiesDialog.canvas.getDefaultUnitList(), this.symbol.getScaleUnitName());
            if (this.scaleMaxFld == null) {
                this.scaleMaxFld = new JTextField("", 5);
                this.scaleMinFld = new JTextField("", 5);
                this.scaleDataMaxFld = new JTextField("", 5);
                this.scaleDataMinFld = new JTextField("", 5);
                this.scaleParamFld = new ParamField();
                this.scaleParamFld.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        PropertiesDialog.this.scaleParamChanged();
                    }
                });
            }
            this.scaleMinFld.setText(Misc.format(this.symbol.getScaleRange().getMin()));
            this.scaleMaxFld.setText(Misc.format(this.symbol.getScaleRange().getMax()));
            this.scaleDataMinFld.setText(Misc.format(this.symbol.getScaleDataRange().getMin()));
            this.scaleDataMaxFld.setText(Misc.format(this.symbol.getScaleDataRange().getMax()));
            this.scaleParamFld.setText(this.symbol.getScaleParam());
            comps.add(GuiUtils.rLabel("Scale By Parameter:"));
            comps.add(GuiUtils.left(this.scaleParamFld));
            comps.add(GuiUtils.rLabel("Data Range:"));
            rightComps = new ArrayList();
            rightComps.add(this.scaleDataMinFld);
            rightComps.add(this.scaleDataMaxFld);
            rightComps.add(new JLabel("  Unit:"));
            rightComps.add(this.scaleUnitFld);
            comps.add(GuiUtils.left(GuiUtils.hbox(rightComps, 5)));
            comps.add(GuiUtils.rLabel("Scale By Factor:"));
            rightComps = new ArrayList();
            rightComps.add(this.scaleMinFld);
            rightComps.add(this.scaleMaxFld);
            comps.add(GuiUtils.left(GuiUtils.hbox(rightComps, 5)));
            GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
            if (!this.doMultiple()) {
                tabbedPane.add("Scale Size", GuiUtils.topLeft(GuiUtils.doLayout(comps, 2, GuiUtils.WT_N, GuiUtils.WT_N)));
            }
        }
        if (!this.doMultiple() && this.symbol.shouldShowRotateGui()) {
            JTabbedPane rotateTab = new JTabbedPane();
            tabbedPane.add("Rotate", rotateTab);
            this.rotateZGui = new RotateGui(this.symbol.getRotateZInfo());
            rotateTab.add("Rotate About Z Axis", GuiUtils.topLeft(this.rotateZGui.contents));
            this.rotateXGui = new RotateGui(this.symbol.getRotateXInfo());
            rotateTab.add("Rotate About X Axis", GuiUtils.topLeft(this.rotateXGui.contents));
            this.rotateYGui = new RotateGui(this.symbol.getRotateYInfo());
            rotateTab.add("Rotate About Y Axis", GuiUtils.topLeft(this.rotateYGui.contents));
        }
        if (!this.doMultiple()) {
            this.symbol.addPropertyTabs(tabbedPane);
        }
        JPanel buttons = GuiUtils.makeButtons(this, null, new String[]{GuiUtils.CMD_APPLY, GuiUtils.CMD_OK, GuiUtils.CMD_CANCEL}, new String[]{"Apply the changes and save the station model", "Apply the changes and close the window", "Close the window"}, null);
        JPanel contents = GuiUtils.centerBottom(tabbedPane, buttons);
        this.dialog = GuiUtils.createDialog("", false);
        this.dialog.setLocation(new Point(200, 200));
        this.setDialogTitle();
        this.dialog.getContentPane().add(contents);
        this.dialog.pack();
    }

    private void setDialogTitle() {
        StringBuilder title = new StringBuilder(GuiUtils.getApplicationTitle()).append("Layout Model Editor - Properties Dialog - ");
        if (!this.doMultiple()) {
            title.append(this.symbol.getLabel());
        } else {
            title.append("Selected");
        }
        this.dialog.setTitle(title.toString());
    }

    private void updateMappings() {
        if (this.mappingHolder == null) {
            return;
        }
        ArrayList mappings = this.symbol.getColorMappings();
        ArrayList<JComponent> mappingComps = new ArrayList<JComponent>();
        mappingComps.add(new JLabel("Parameter Value"));
        mappingComps.add(new JLabel("Color"));
        if (mappings == null) {
            mappings = new ArrayList();
        }
        this.colorMappings = new ArrayList(mappings);
        this.colorMappings.add(new ColorMap());
        this.colorMappings.add(new ColorMap());
        for (int i = 0; i < this.colorMappings.size(); ++i) {
            ColorMap colorMap = (ColorMap)this.colorMappings.get(i);
            mappingComps.add(colorMap.getPatternWidget());
            mappingComps.add(colorMap.getColorWidget());
        }
        GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
        JPanel mappingPanel = GuiUtils.doLayout(mappingComps, 2, GuiUtils.WT_YN, GuiUtils.WT_N);
        this.mappingHolder.removeAll();
        this.mappingHolder.add("Center", GuiUtils.top(mappingPanel));
        this.mappingHolder.validate();
    }

    private void colorTableParamChanged() {
        String tmp = this.colorTableParamFld.getText().trim();
        Range range = null;
        Unit unit = null;
        try {
            ColorTable colorTable = DisplayConventions.getDisplayConventions().getParamColorTable(tmp);
            if (colorTable != null) {
                this.setTmpColorTable(colorTable);
            }
            range = DisplayConventions.getDisplayConventions().getParamRange(tmp, null);
            unit = DisplayConventions.getDisplayConventions().getDisplayUnit(tmp, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (unit != null) {
            this.colorUnitFld.setSelectedItem(unit.toString());
        } else {
            this.colorUnitFld.setSelectedItem(new TwoFacedObject((Object)"Default", null));
        }
        if (range != null) {
            this.colorMinFld.setText(Misc.format(range.getMin()));
            this.colorMaxFld.setText(Misc.format(range.getMax()));
        } else {
            this.colorMinFld.setText(Misc.format(0.0));
            this.colorMaxFld.setText(Misc.format(100.0));
        }
    }

    private void scaleParamChanged() {
        String tmp = this.scaleParamFld.getText().trim();
        Range range = null;
        Unit unit = null;
        try {
            range = DisplayConventions.getDisplayConventions().getParamRange(tmp, null);
            unit = DisplayConventions.getDisplayConventions().getDisplayUnit(tmp, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (unit != null) {
            this.scaleUnitFld.setSelectedItem(unit.toString());
        } else {
            this.scaleUnitFld.setSelectedItem(new TwoFacedObject((Object)"Default", null));
        }
        if (range != null) {
            this.scaleDataMinFld.setText(Misc.format(range.getMin()));
            this.scaleDataMaxFld.setText(Misc.format(range.getMax()));
        } else {
            this.scaleDataMinFld.setText(Misc.format(0.0));
            this.scaleDataMaxFld.setText(Misc.format(100.0));
        }
    }

    private void setSelected(String param, List params, JComboBox box) {
        GuiUtils.setListData(box, params);
        if (param == null) {
            return;
        }
        TwoFacedObject current = new TwoFacedObject(param);
        int index = params.indexOf(current);
        if (index >= 0) {
            box.setSelectedIndex(index);
        } else {
            box.setSelectedItem(current);
        }
    }

    private String convertItem(Object paramObject) {
        if (paramObject instanceof TwoFacedObject) {
            Object tmp = ((TwoFacedObject)paramObject).getId();
            if (tmp == null) {
                return null;
            }
            return tmp.toString();
        }
        Object tmp = this.paramMap.get(paramObject);
        if (tmp != null && tmp instanceof TwoFacedObject) {
            return ((TwoFacedObject)tmp).getId().toString();
        }
        return paramObject.toString().trim();
    }

    private void setTmpColorTable(ColorTable ct) {
        this.tmpColorTable = ct;
        if (this.tmpColorTable == null) {
            this.colorLbl.setText("-none-");
            this.colorBarLbl.setIcon(null);
        } else {
            this.colorLbl.setText(this.tmpColorTable.getName());
            this.colorBarLbl.setIcon(ColorTableCanvas.getIcon(this.tmpColorTable));
        }
    }

    private void showColorTableMenu(JComponent comp) {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        JMenuItem noneItem = new JMenuItem("-none-");
        noneItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PropertiesDialog.this.setTmpColorTable(null);
            }
        });
        items.add(noneItem);
        ColorTableManager.getManager().makeColorTableMenu(new ObjectListener(null){

            @Override
            public void actionPerformed(ActionEvent ae, Object data) {
                PropertiesDialog.this.tmpColorTable = (ColorTable)data;
                PropertiesDialog.this.colorLbl.setText(PropertiesDialog.this.tmpColorTable.getName());
                PropertiesDialog.this.colorBarLbl.setIcon(ColorTableCanvas.getIcon(PropertiesDialog.this.tmpColorTable));
            }
        }, items);
        JPopupMenu popup = GuiUtils.makePopupMenu(items);
        Dimension d = comp.getSize();
        popup.show(comp, 0, d.height);
    }

    private TwoFacedObject makeFontTFO(Font font) {
        return new TwoFacedObject((Object)(font == null ? "Default" : font.getName()), font);
    }

    private class RotateGui {
        RotateInfo info;
        private ParamField paramFld;
        private JTextField minFld;
        private JTextField maxFld;
        private JTextField dataMinFld;
        private JTextField dataMaxFld;
        private JComboBox unitFld = null;
        JPanel contents;

        public RotateGui(RotateInfo info) {
            this.info = info;
            ArrayList<JComponent> comps = new ArrayList<JComponent>();
            PropertiesDialog.this.canvas;
            this.unitFld = GuiUtils.getEditableBox(StationModelCanvas.getDefaultUnitList(), info.getUnitName());
            if (this.maxFld == null) {
                this.maxFld = new JTextField("", 5);
                this.minFld = new JTextField("", 5);
                this.dataMaxFld = new JTextField("", 5);
                this.dataMinFld = new JTextField("", 5);
                this.paramFld = new ParamField();
                this.paramFld.setToolTipText("<html>Enter a parameter name to rotate by or \"angle:some_angle\" for a fixed rotation<br>Right mouse to add aliases or current fields</html>");
                this.paramFld.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        RotateGui.this.paramChanged();
                    }
                });
            }
            this.minFld.setText(Misc.format(info.getRange().getMin()));
            this.maxFld.setText(Misc.format(info.getRange().getMax()));
            this.dataMinFld.setText(Misc.format(info.getDataRange().getMin()));
            this.dataMaxFld.setText(Misc.format(info.getDataRange().getMax()));
            this.paramFld.setText(info.getParam());
            comps.add(GuiUtils.rLabel("Rotate By Parameter:"));
            comps.add(GuiUtils.left(this.paramFld));
            comps.add(GuiUtils.rLabel("Data Range:"));
            ArrayList<JComponent> rightComps = new ArrayList<JComponent>();
            rightComps.add(this.dataMinFld);
            rightComps.add(this.dataMaxFld);
            rightComps.add(this.unitFld);
            comps.add(GuiUtils.left(GuiUtils.hbox(rightComps, 5)));
            comps.add(GuiUtils.rLabel("Degrees:"));
            rightComps = new ArrayList();
            rightComps.add(this.minFld);
            rightComps.add(this.maxFld);
            comps.add(GuiUtils.left(GuiUtils.hbox(rightComps, 5)));
            GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
            this.contents = GuiUtils.doLayout(comps, 2, GuiUtils.WT_N, GuiUtils.WT_N);
        }

        private void paramChanged() {
            String tmp = this.paramFld.getText().trim();
            Range range = null;
            Unit unit = null;
            try {
                range = DisplayConventions.getDisplayConventions().getParamRange(tmp, null);
                unit = DisplayConventions.getDisplayConventions().getDisplayUnit(tmp, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (unit != null) {
                this.unitFld.setSelectedItem(unit.toString());
            } else {
                this.unitFld.setSelectedItem(new TwoFacedObject((Object)"Default", null));
            }
            if (range != null) {
                this.dataMinFld.setText(Misc.format(range.getMin()));
                this.dataMaxFld.setText(Misc.format(range.getMax()));
            } else {
                this.dataMinFld.setText(Misc.format(0.0));
                this.dataMaxFld.setText(Misc.format(360.0));
            }
        }

        public void apply() throws Exception {
            this.info.setParam(this.paramFld.getText().trim());
            String tmpUnitName = TwoFacedObject.getIdString(this.unitFld.getSelectedItem());
            PropertiesDialog.this.what = "rotate";
            this.info.getRange().setMin(Misc.parseNumber(this.minFld.getText()));
            this.info.getRange().setMax(Misc.parseNumber(this.maxFld.getText()));
            this.info.getDataRange().setMin(Misc.parseNumber(this.dataMinFld.getText()));
            this.info.getDataRange().setMax(Misc.parseNumber(this.dataMaxFld.getText()));
            if (tmpUnitName != null) {
                Unit unit = Util.parseUnit(tmpUnitName);
            }
            this.info.setUnitName(tmpUnitName);
        }
    }
}

