/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui.symbol;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.List;
import javax.swing.JTabbedPane;
import org.w3c.dom.Element;
import ucar.unidata.data.point.PointOb;
import ucar.unidata.ui.drawing.DisplayCanvas;
import ucar.unidata.ui.drawing.RectangleGlyph;
import ucar.unidata.ui.symbol.PropertiesDialog;
import ucar.unidata.ui.symbol.RotateInfo;
import ucar.unidata.ui.symbol.StationModelCanvas;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.Range;
import ucar.unidata.util.StringUtil;
import ucar.visad.Util;
import visad.Data;
import visad.Unit;
import visad.VisADGeometryArray;

public abstract class MetSymbol
extends RectangleGlyph {
    public static final String ATTR_PARAMID = "paramid";
    private RotateInfo rotateXInfo;
    private RotateInfo rotateYInfo;
    private RotateInfo rotateZInfo;
    protected StationModelCanvas canvas;
    protected PropertiesDialog propertiesDialog;
    private ColorTable colorTable;
    private Unit colorTableUnit = null;
    private String colorTableUnitName = null;
    private String colorTableParam;
    Range colorTableRange = new Range(0.0, 100.0);
    private String colorParam;
    private List colorMappings;
    private Unit rotateUnit = null;
    private String rotateUnitName = null;
    private String rotateParam;
    Range rotateRange = new Range(0.0, 360.0);
    Range rotateDataRange = new Range(0.0, 360.0);
    private Unit displayUnit = null;
    private String displayUnitName = null;
    private double scale = 1.0;
    private String scaleParam;
    private Range scaleDataRange = new Range(0.0, 100.0);
    private Range scaleRange = new Range(1.0, 1.0);
    private Unit scaleUnit = null;
    private String scaleUnitName = null;
    private boolean active = true;
    private boolean missing = false;
    private String[] paramIds;
    private String[] paramDescs;
    Point offset;
    private String rectPoint = "MM";

    protected MetSymbol() {
    }

    public MetSymbol(int x, int y) {
        super(x, y);
    }

    protected MetSymbol(DisplayCanvas canvas, int x, int y, String[] paramIds, String[] paramDescs) {
        super(x, y);
        if (canvas == null) {
            this.offset = new Point(x, y);
        }
        this.setForeground(Color.magenta);
        this.setFilled(true);
        this.paramIds = paramIds;
        this.paramDescs = paramDescs;
    }

    public void initialize(Element symbolNode) {
    }

    public void showPropertiesDialog(StationModelCanvas canvas) {
        this.canvas = canvas;
        if (this.propertiesDialog == null) {
            this.propertiesDialog = new PropertiesDialog(this, canvas);
        }
        this.propertiesDialog.show();
    }

    public void closePropertiesDialog() {
        if (this.propertiesDialog != null) {
            this.propertiesDialog.close();
        }
    }

    protected void initPropertyComponents(List comps) {
    }

    protected void applyProperties() {
        this.canvas.setHaveChanged(true);
    }

    public void addPropertyTabs(JTabbedPane tabbedPane) {
    }

    protected boolean shouldShowColorTableGui() {
        return true;
    }

    protected boolean shouldShowRotateGui() {
        return true;
    }

    protected boolean shouldShowScaleGui() {
        return true;
    }

    public boolean shouldScaleShape() {
        return true;
    }

    public boolean shouldBeColored() {
        return true;
    }

    public boolean shouldOffsetShape() {
        return true;
    }

    public boolean doAllObs() {
        return false;
    }

    public VisADGeometryArray[] makeShapes(PointOb ob) throws Exception {
        return null;
    }

    public VisADGeometryArray[] makeShapes(Data[] dataArray, PointOb ob) throws Exception {
        return null;
    }

    public boolean doAlignmentMenu() {
        return true;
    }

    public void setParamIds(String[] value) {
        this.paramIds = value;
    }

    public String[] getParamIds() {
        return this.paramIds;
    }

    public void setParamDescs(String[] value) {
        this.paramDescs = value;
    }

    public String[] getParamDescs() {
        return this.paramDescs;
    }

    public void setOffset(int x, int y) {
        if (this.offset != null) {
            this.offset.x = x;
            this.offset.y = y;
        }
        this.bounds.x = x;
        this.bounds.y = y;
    }

    public int getXOffset() {
        if (this.offset != null) {
            return this.offset.x;
        }
        return this.bounds.x + this.bounds.width / 2;
    }

    public String getRectPoint() {
        return this.rectPoint;
    }

    public void setRectPoint(String rp) {
        this.rectPoint = rp;
    }

    public int getYOffset() {
        if (this.offset != null) {
            return this.offset.y;
        }
        return -(this.bounds.y + this.bounds.height / 2);
    }

    public void incrSize() {
    }

    public void decrSize() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        for (String s : this.paramIds) {
            sb.append(" param:" + s);
        }
        return sb.toString();
    }

    public String getLabel() {
        String className = this.getClass().getName();
        int idx = className.lastIndexOf(".");
        if (idx >= 0) {
            className = className.substring(idx + 1);
        }
        if (className.endsWith("Symbol")) {
            className = StringUtil.replace(className, "Symbol", " Symbol");
        }
        return className;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        MetSymbol theClone = (MetSymbol)super.clone();
        theClone.propertiesDialog = null;
        if (theClone.paramIds != null) {
            theClone.paramIds = (String[])theClone.paramIds.clone();
        }
        if (theClone.paramDescs != null) {
            theClone.paramDescs = (String[])theClone.paramDescs.clone();
        }
        if (theClone.rotateXInfo != null) {
            theClone.rotateXInfo = theClone.rotateXInfo.doClone();
        }
        if (theClone.rotateYInfo != null) {
            theClone.rotateYInfo = theClone.rotateYInfo.doClone();
        }
        if (theClone.rotateZInfo != null) {
            theClone.rotateZInfo = theClone.rotateZInfo.doClone();
        }
        return theClone;
    }

    public Object cloneMe() {
        try {
            Object cl = super.clone();
            return cl;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String getName() {
        if (this.paramIds != null && this.paramIds.length > 0) {
            return this.paramIds[0];
        }
        return this.getClass().getName();
    }

    public String getDesc() {
        if (this.paramDescs != null && this.paramDescs.length > 0) {
            return this.paramDescs[0];
        }
        return this.getClass().getName();
    }

    public Object getParamValue(int index) {
        return null;
    }

    public void setParamValue(int index, Object v) {
    }

    public String getParam(int index) {
        if (index < this.paramIds.length) {
            return this.paramIds[index];
        }
        throw new IllegalArgumentException("Out of bounds parameter index: " + index);
    }

    @Override
    public void paint(Graphics g, DisplayCanvas c) {
        Rectangle nb = this.transformOutput(c, this.getBounds());
        if (!this.getActive()) {
            Rectangle r = this.getBounds();
            g.setColor(Color.lightGray);
            g.fillRect(r.x, r.y, r.width, r.height);
        }
        this.draw((Graphics2D)g, nb.x, nb.y, nb.width, nb.height);
        if (c instanceof StationModelCanvas && ((StationModelCanvas)c).getShowParams()) {
            int xoff = 0;
            FontMetrics fm = g.getFontMetrics();
            g.setColor(Color.black);
            for (int i = 0; i < this.paramIds.length; ++i) {
                String s = this.paramIds[i];
                if (i > 0) {
                    s = ", " + s;
                }
                g.drawString(s, nb.x + xoff, nb.y + nb.height + fm.getMaxDescent() + fm.getMaxAscent() + 4);
                xoff += fm.stringWidth(s);
            }
        }
        if (c instanceof StationModelCanvas && ((StationModelCanvas)c).shouldShowAlignmentPoints()) {
            this.paintRectPoint(g, c);
        }
    }

    @Override
    public void paintSelection(Graphics g, DisplayCanvas c) {
        super.paintSelection(g, c);
        this.paintRectPoint(g, c);
    }

    private void paintRectPoint(Graphics g, DisplayCanvas c) {
        Rectangle nb = this.transformOutput(c, this.getBounds());
        g.setColor(Color.red);
        Point2D rp = MetSymbol.getPointOnRect(this.rectPoint, nb);
        g.fillRect((int)rp.getX() - 3, (int)rp.getY() - 3, 6, 6);
    }

    public Rectangle getBounds(Point2D loc) {
        if (this.offset != null) {
            this.bounds.x = this.offset.x + (int)loc.getX() - this.bounds.width / 2;
            this.bounds.y = this.offset.y + (int)loc.getY() - this.bounds.height / 2;
        } else {
            this.bounds.x = (int)loc.getX();
            this.bounds.y = (int)loc.getY();
        }
        return this.bounds;
    }

    public void draw(Graphics2D g, Point2D loc) {
        this.getBounds(loc);
        this.draw(g, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
    }

    public abstract void draw(Graphics2D var1, int var2, int var3, int var4, int var5);

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean getActive() {
        return this.active;
    }

    public void setMissing(boolean missing) {
        this.missing = missing;
    }

    public boolean getMissing() {
        return this.missing;
    }

    @Override
    public void setAttr(String name, String value) {
        if (name.equals(ATTR_PARAMID)) {
            if (this.paramIds == null) {
                this.paramIds = new String[1];
            }
            this.paramIds[0] = value;
        } else {
            super.setAttr(name, value);
        }
    }

    public void setColorTable(ColorTable value) {
        this.colorTable = value;
    }

    public ColorTable getColorTable() {
        return this.colorTable;
    }

    public void setColorTableParam(String value) {
        this.colorTableParam = value;
    }

    public String getColorTableParam() {
        return this.colorTableParam;
    }

    public void setColorTableUnitName(String name) {
        this.colorTableUnitName = name;
        this.colorTableUnit = null;
    }

    public String getColorTableUnitName() {
        return this.colorTableUnitName;
    }

    public Unit getColorTableUnit() {
        if (this.colorTableUnit == null && this.colorTableUnitName != null) {
            try {
                this.colorTableUnit = Util.parseUnit(this.colorTableUnitName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.colorTableUnit;
    }

    public void setColorTableRange(Range value) {
        this.colorTableRange = value != null ? new Range(value) : value;
    }

    public Range getColorTableRange() {
        return this.colorTableRange;
    }

    public void setScaleUnitName(String name) {
        this.scaleUnitName = name;
        this.scaleUnit = null;
    }

    public String getScaleUnitName() {
        return this.scaleUnitName;
    }

    public Unit getScaleUnit() {
        if (this.scaleUnit == null && this.scaleUnitName != null) {
            try {
                this.scaleUnit = Util.parseUnit(this.scaleUnitName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.scaleUnit;
    }

    public void setScaleRange(Range value) {
        this.scaleRange = value;
    }

    public Range getScaleRange() {
        return this.scaleRange;
    }

    public void setScaleDataRange(Range value) {
        this.scaleDataRange = value;
    }

    public Range getScaleDataRange() {
        return this.scaleDataRange;
    }

    public void setScaleParam(String value) {
        this.scaleParam = value;
    }

    public String getScaleParam() {
        return this.scaleParam;
    }

    public void setScale(double value) {
        this.scale = value;
    }

    public double getScale() {
        return this.scale;
    }

    public void setRotateParam(String value) {
        this.getRotateZInfo().setParam(value);
    }

    public void setRotateUnitName(String name) {
        this.getRotateZInfo().setUnitName(name);
    }

    public void setRotateRange(Range value) {
        this.getRotateZInfo().setRange(value);
    }

    public void setRotateDataRange(Range value) {
        this.getRotateZInfo().setDataRange(value);
    }

    public void setRotateXInfo(RotateInfo value) {
        this.rotateXInfo = value;
    }

    public RotateInfo getRotateXInfo() {
        if (this.rotateXInfo == null) {
            this.rotateXInfo = new RotateInfo(0);
        }
        return this.rotateXInfo;
    }

    public void setRotateYInfo(RotateInfo value) {
        this.rotateYInfo = value;
    }

    public RotateInfo getRotateYInfo() {
        if (this.rotateYInfo == null) {
            this.rotateYInfo = new RotateInfo(1);
        }
        return this.rotateYInfo;
    }

    public void setRotateZInfo(RotateInfo value) {
        this.rotateZInfo = value;
    }

    public RotateInfo getRotateZInfo() {
        if (this.rotateZInfo == null) {
            this.rotateZInfo = new RotateInfo(2);
        }
        return this.rotateZInfo;
    }

    public RotateInfo getRotateInfo(int type) {
        if (type == 0) {
            return this.getRotateXInfo();
        }
        if (type == 1) {
            return this.getRotateYInfo();
        }
        return this.getRotateZInfo();
    }

    public void setColorParam(String value) {
        this.colorParam = value;
    }

    public String getColorParam() {
        return this.colorParam;
    }

    public void setColorMappings(List value) {
        this.colorMappings = value;
    }

    public List getColorMappings() {
        return this.colorMappings;
    }

    public void setDisplayUnitName(String name) {
        this.displayUnitName = name;
        this.displayUnit = null;
    }

    protected boolean showDisplayUnitInProperties() {
        return false;
    }

    public String getDisplayUnitName() {
        return this.displayUnitName;
    }

    public void setTheDisplayUnit(Unit u) {
        this.displayUnit = u;
        this.displayUnitName = u == null ? null : u.toString();
    }

    public Unit getDisplayUnit() {
        if (this.displayUnit == null && this.displayUnitName != null) {
            try {
                this.displayUnit = Util.parseUnit(this.displayUnitName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.displayUnit;
    }

    public boolean rotateOnEarth() {
        return true;
    }
}

