/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui.symbol;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import ucar.unidata.data.point.PointOb;
import ucar.unidata.ui.drawing.DisplayCanvas;
import ucar.unidata.ui.symbol.ColorMap;
import ucar.unidata.ui.symbol.ShapeMap;
import ucar.unidata.ui.symbol.ShapeSymbol;
import ucar.unidata.util.GuiUtils;
import ucar.visad.ShapeUtility;
import visad.Data;
import visad.Real;
import visad.Unit;
import visad.VisADGeometryArray;

public class MappedShapeSymbol
extends ShapeSymbol {
    private List shapeMappings = new ArrayList();
    private List mappingFields;
    private JPanel mappingHolder;

    public MappedShapeSymbol() {
    }

    public MappedShapeSymbol(int x, int y) {
        this(null, x, y);
    }

    public MappedShapeSymbol(DisplayCanvas canvas, int x, int y) {
        super(canvas, x, y);
        this.setParamIds(new String[]{"param"});
        this.setParamDescs(new String[]{"Parameter"});
        this.shapeMappings = new ArrayList();
    }

    @Override
    public String getLabel() {
        return "Mapped Shape Symbol ";
    }

    @Override
    protected void initPropertyComponents(List comps) {
        super.initPropertyComponents(comps);
        this.mappingHolder = new JPanel(new BorderLayout());
        this.updateShapeMappings();
        JScrollPane sp = new JScrollPane(this.mappingHolder);
        sp.setPreferredSize(new Dimension(300, 200));
        JViewport vp = sp.getViewport();
        vp.setViewSize(new Dimension(300, 200));
        comps.add(GuiUtils.top(GuiUtils.rLabel("Shape Mappings:")));
        comps.add(sp);
    }

    private void updateShapeMappings() {
        if (this.mappingHolder == null) {
            return;
        }
        this.mappingFields = new ArrayList(this.shapeMappings);
        this.mappingFields.add(new ShapeMap());
        this.mappingFields.add(new ShapeMap());
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        comps.add(GuiUtils.cLabel("Value"));
        comps.add(GuiUtils.cLabel("Shape"));
        for (int i = 0; i < this.mappingFields.size(); ++i) {
            ShapeMap shapeMap = (ShapeMap)this.mappingFields.get(i);
            JTextField patternField = shapeMap.getPatternWidget();
            patternField.setToolTipText("<html>Enter a string pattern to match or, for numeric values<br>enter a range of the form:<br><i>min,max</i></html>");
            comps.add(patternField);
            comps.add(shapeMap.getShapeWidget());
        }
        GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
        JPanel mappingPanel = GuiUtils.doLayout(comps, 2, GuiUtils.WT_YN, GuiUtils.WT_N);
        this.mappingHolder.removeAll();
        this.mappingHolder.add("Center", GuiUtils.top(mappingPanel));
        this.mappingHolder.validate();
    }

    @Override
    protected void applyProperties() {
        super.applyProperties();
        this.shapeMappings = ColorMap.applyProperties(this.mappingFields);
        this.updateShapeMappings();
    }

    @Override
    public boolean doAllObs() {
        return false;
    }

    @Override
    public VisADGeometryArray[] makeShapes(Data[] dataArray, PointOb ob) throws Exception {
        if (dataArray.length == 0 || dataArray[0] == null) {
            return null;
        }
        if (this.shapeMappings != null && this.shapeMappings.size() > 0) {
            ShapeMap shapeMap = (ShapeMap)this.shapeMappings.get(0);
            if (shapeMap.isNumericRange()) {
                Unit unit = this.getDisplayUnit();
                Real r = (Real)dataArray[0];
                double value = unit != null ? r.getValue(unit) : r.getValue();
                for (int i = 0; i < this.shapeMappings.size(); ++i) {
                    shapeMap = (ShapeMap)this.shapeMappings.get(i);
                    Real[] range = shapeMap.getNumericRange();
                    if (!(value >= range[0].getValue()) || !(value <= range[1].getValue())) continue;
                    return ShapeUtility.createShape(shapeMap.getShape());
                }
                return null;
            }
            for (int i = 0; i < this.shapeMappings.size(); ++i) {
                shapeMap = (ShapeMap)this.shapeMappings.get(i);
                if (!shapeMap.match(dataArray[0])) continue;
                return ShapeUtility.createShape(shapeMap.getShape());
            }
        }
        return super.makeShapes(ob);
    }

    @Override
    protected boolean showDisplayUnitInProperties() {
        return true;
    }

    public void setShapeMappings(List value) {
        this.shapeMappings = value;
    }

    public List getShapeMappings() {
        return this.shapeMappings;
    }
}

