/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui.symbol;

import java.awt.Font;
import java.util.List;
import javax.swing.JTextField;
import ucar.unidata.data.point.PointOb;
import ucar.unidata.ui.drawing.DisplayCanvas;
import ucar.unidata.ui.symbol.TextSymbol;
import ucar.unidata.util.GuiUtils;
import ucar.visad.ShapeUtility;
import visad.VisADGeometryArray;

public class LabelSymbol
extends TextSymbol {
    private JTextField labelField;
    boolean stretchy = true;

    public LabelSymbol() {
    }

    public LabelSymbol(int x, int y) {
        this(null, x, y);
    }

    public LabelSymbol(DisplayCanvas canvas, int x, int y) {
        super(canvas, x, y, "Label", "label");
        this.setSize(20, 20);
    }

    @Override
    protected void initPropertyComponents(List comps) {
        super.initPropertyComponents(comps);
        this.labelField = new JTextField(this.getValueString(), 20);
        comps.add(GuiUtils.rLabel("Label:"));
        comps.add(GuiUtils.left(this.labelField));
    }

    @Override
    protected void applyProperties() {
        if (this.labelField != null) {
            this.setValue(this.labelField.getText());
            this.setParamIds(this.getParamIds());
        }
        super.applyProperties();
    }

    @Override
    public String[] getParamIds() {
        return new String[]{this.getValue()};
    }

    @Override
    public boolean getStretchy() {
        return this.stretchy;
    }

    @Override
    public void setStretchy(boolean s) {
        this.stretchy = s;
    }

    @Override
    public Object getParamValue(int index) {
        return this.getValue();
    }

    @Override
    protected String getValueString() {
        return this.getValue();
    }

    @Override
    public boolean getEqualSides() {
        return true;
    }

    public boolean xxxdoAllObs() {
        return true;
    }

    public VisADGeometryArray[] xxxmakeShapes(PointOb ob) {
        String label = this.getValueString();
        if (label == null) {
            return null;
        }
        Font f = this.getFont();
        if (f == null) {
            f = this.makeDefaultFont();
        }
        return new VisADGeometryArray[]{ShapeUtility.shapeFont(label, f, true)};
    }

    public String getText() {
        return this.getValueString();
    }

    @Override
    public String getLabel() {
        return "Label Symbol: " + this.getValueString();
    }

    @Override
    public String toString() {
        return "LabelSymbol " + this.getValueString();
    }
}

