/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui.symbol;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.StringUtil;
import ucar.visad.Util;
import visad.Data;
import visad.Real;

public class ColorMap {
    private String pattern;
    private Color color;
    private JComponent[] swatchComps;
    private JTextField patternFld;
    private Real[] range;

    public ColorMap() {
        this.pattern = "";
    }

    public ColorMap(String pattern, Color c) {
        this.pattern = pattern;
        if (this.pattern == null) {
            this.pattern = "";
        }
        this.color = this.color;
    }

    public static List applyProperties(List mappings) {
        ArrayList<ColorMap> goodMappings = new ArrayList<ColorMap>();
        for (int i = 0; i < mappings.size(); ++i) {
            ColorMap colorMap = (ColorMap)mappings.get(i);
            colorMap.applyProperties();
            if (!colorMap.hasPattern()) continue;
            goodMappings.add(colorMap);
        }
        return goodMappings;
    }

    public void applyProperties() {
        this.range = null;
        this.pattern = this.patternFld.getText().trim();
        GuiUtils.ColorSwatch colorSwatch = (GuiUtils.ColorSwatch)this.getSwatchComps()[0];
        this.color = colorSwatch.getSwatchColor();
    }

    public JComponent[] getSwatchComps() {
        if (this.swatchComps == null) {
            this.swatchComps = GuiUtils.makeColorSwatchWidget(this.color, "");
        }
        return this.swatchComps;
    }

    public JComponent getColorWidget() {
        this.getSwatchComps();
        return GuiUtils.hbox(this.swatchComps[0], this.swatchComps[2]);
    }

    public JTextField getPatternWidget() {
        if (this.patternFld == null) {
            this.patternFld = new JTextField(this.pattern, 20);
            this.patternFld.setToolTipText("<html>A string pattern to match or a comma separated numeric range:<br><i>e.g., -5.0,0</i></html>");
        }
        return this.patternFld;
    }

    public boolean hasPattern() {
        return this.pattern != null && this.pattern.length() > 0;
    }

    public boolean isNumericRange() {
        return this.pattern.indexOf(",") >= 0;
    }

    public Real[] getNumericRange() throws Exception {
        if (this.range == null) {
            this.range = new Real[]{null, null};
            List<String> toks = StringUtil.split(this.pattern, ",");
            if (toks.size() == 0) {
                throw new IllegalStateException("Bad format for numeric range:" + this.pattern);
            }
            String tok1 = toks.get(0).toString();
            String tok2 = toks.size() == 1 ? tok1 : toks.get(1).toString();
            this.range[0] = Util.toReal(tok1);
            this.range[1] = Util.toReal(tok2);
        }
        return this.range;
    }

    public boolean match(Data value) throws Exception {
        if (value instanceof Real && this.isNumericRange()) {
            Real r = (Real)value;
            Real[] range = this.getNumericRange();
            if (r.__ge__(range[0]) == 0) {
                return false;
            }
            return r.__le__(range[1]) != 0;
        }
        String stringValue = value.toString();
        return StringUtil.stringMatch(stringValue, this.pattern, true, true);
    }

    public void setPattern(String value) {
        this.pattern = value;
        this.range = null;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setColor(Color value) {
        this.color = value;
    }

    public Color getColor() {
        return this.color;
    }
}

