/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui.symbol;

import java.awt.Graphics2D;
import ucar.unidata.ui.drawing.DisplayCanvas;
import ucar.unidata.ui.symbol.MetSymbol;

public class CloudCoverageSymbol
extends MetSymbol {
    private double coverage = 0.0;

    public CloudCoverageSymbol() {
    }

    public CloudCoverageSymbol(int x, int y) {
        this(null, x, y);
    }

    public CloudCoverageSymbol(DisplayCanvas canvas, int x, int y) {
        this(canvas, x, y, "CC", "Coverage parameter");
    }

    public CloudCoverageSymbol(int x, int y, String param, String paramDesc) {
        this(null, x, y, param, paramDesc);
    }

    public CloudCoverageSymbol(DisplayCanvas canvas, int x, int y, String param, String paramDesc) {
        super(canvas, x, y, new String[]{param}, new String[]{paramDesc});
        this.coverage = 0.0;
        this.setSize(20, 20);
    }

    @Override
    public boolean getStretchy() {
        return !this.getBeingCreated();
    }

    @Override
    public boolean getEqualSides() {
        return true;
    }

    @Override
    public boolean getSymetricReshape() {
        return true;
    }

    public double getCoverage() {
        return this.coverage;
    }

    public void setCoverage(double coverage) {
        this.coverage = coverage;
    }

    @Override
    public Object getParamValue(int index) {
        return new Double(this.coverage);
    }

    @Override
    public void setParamValue(int index, Object v) {
        this.setCoverage(new Double(v.toString()));
    }

    @Override
    public void draw(Graphics2D g, int x, int y, int width, int height) {
        int cx = x + width / 2;
        int cy = y + height / 2;
        g.setColor(this.getForeground());
        g.drawOval(x, y, width, height);
        if (this.coverage == 0.0) {
            return;
        }
        int arcAngle = 0;
        int icover = (int)(this.coverage / 10.0);
        switch (icover) {
            case 0: 
            case 1: {
                g.drawLine(cx, y, cx, y + height);
                break;
            }
            case 2: 
            case 3: {
                arcAngle = -90;
                break;
            }
            case 4: {
                g.drawLine(cx, cy, cx, y + height);
                arcAngle = -90;
                break;
            }
            case 5: {
                arcAngle = -180;
                break;
            }
            case 6: {
                g.drawLine(x, cy, x + width, cy);
                arcAngle = -180;
                break;
            }
            case 7: 
            case 8: {
                arcAngle = -270;
                break;
            }
            case 9: {
                g.fillArc(x, y, width, height, 0, 360);
                g.setColor(this.getForeground());
                g.drawLine(cx, y - 1, cx, y + height + 1);
                break;
            }
            case 10: {
                arcAngle = -360;
                break;
            }
            default: {
                int ux = (int)((double)cx + 0.4 * (double)width) - 1;
                int lx = (int)((double)cx - 0.4 * (double)width) + 1;
                int uy = (int)((double)cy + 0.4 * (double)height) - 1;
                int ly = (int)((double)cy - 0.4 * (double)height) + 1;
                g.drawLine(ux, uy, lx, ly);
                g.drawLine(ux, ly, lx, uy);
            }
        }
        if (arcAngle != 0) {
            g.fillArc(x, y, width, height, 90, arcAngle);
        }
    }
}

