/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui.drawing;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import ucar.unidata.ui.drawing.DisplayCanvas;
import ucar.unidata.ui.drawing.Glyph;
import ucar.unidata.util.Misc;

public class RectangleGlyph
extends Glyph {
    public static final String RECTANGLE = "RECTANGLE";
    public static final String FRECTANGLE = "FRECTANGLE";
    public static final String ROUNDRECT = "ROUNDRECT";
    public static final String FROUNDRECT = "FROUNDRECT";
    public static final String CIRCLE = "CIRCLE";
    public static final String FCIRCLE = "FCIRCLE";
    public static final String ATTR_RECTTYPE = "recttype";
    public Rectangle bounds;
    public static final int TYPE_RECT = 0;
    public static final int TYPE_RRECT = 1;
    public static final int TYPE_CIRCLE = 2;
    String typeName;
    int type;

    public RectangleGlyph() {
        this.bounds = new Rectangle(0, 0, 0, 0);
    }

    public RectangleGlyph(int x, int y) {
        this(RECTANGLE, x, y, 1, 1);
    }

    public RectangleGlyph(String typeName, int x, int y, int w, int h) {
        this.bounds = new Rectangle(x, y, w, h);
        this.setType(typeName);
    }

    public boolean getEqualSides() {
        return false;
    }

    public boolean getSymetricReshape() {
        return false;
    }

    protected void setType(String typeName) {
        this.typeName = typeName;
        if (typeName.equals(RECTANGLE)) {
            this.type = 0;
        } else if (typeName.equals(CIRCLE)) {
            this.type = 2;
        } else if (typeName.equals(ROUNDRECT)) {
            this.type = 1;
        } else if (typeName.equals(FRECTANGLE)) {
            this.type = 0;
            this.setFilled(true);
        } else if (typeName.equals(FCIRCLE)) {
            this.type = 2;
            this.setFilled(true);
        } else if (typeName.equals(FROUNDRECT)) {
            this.type = 1;
            this.setFilled(true);
        }
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        RectangleGlyph clonedObject = (RectangleGlyph)super.clone();
        clonedObject.bounds = new Rectangle(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        clonedObject.typeName = this.typeName;
        clonedObject.type = this.type;
        return clonedObject;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public int getBottom() {
        return this.bounds.y + this.bounds.height;
    }

    public int getTop() {
        return this.bounds.y;
    }

    public int getLeft() {
        return this.bounds.x;
    }

    @Override
    public void paint(Graphics g, DisplayCanvas c) {
        super.paint(g, c);
        Rectangle r = this.transformOutput(c, this.bounds);
        g.setColor(this.getForeground());
        switch (this.type) {
            case 0: {
                if (this.getFilled()) {
                    g.setColor(this.getBackground(this.getForeground()));
                    g.fillRect(r.x, r.y, r.width + 1, r.height + 1);
                    g.setColor(this.getForeground());
                }
                g.drawRect(r.x, r.y, r.width, r.height);
                break;
            }
            case 1: {
                int radius = 10;
                if (this.getFilled()) {
                    g.setColor(this.getBackground(this.getForeground()));
                    g.fillRoundRect(r.x, r.y, r.width + 1, r.height + 1, radius, radius);
                    g.setColor(this.getForeground());
                }
                g.drawRoundRect(r.x, r.y, r.width, r.height, radius, radius);
                break;
            }
            case 2: {
                if (this.getFilled()) {
                    g.setColor(this.getBackground(this.getForeground()));
                    g.fillArc(r.x, r.y, r.width + 1, r.height + 1, 0, 360);
                    g.setColor(this.getForeground());
                }
                g.drawArc(r.x, r.y, r.width, r.height, 0, 360);
            }
        }
    }

    @Override
    public double distance(int x, int y) {
        boolean iny;
        boolean inx = x > this.bounds.x && x < this.bounds.x + this.bounds.width;
        boolean bl = iny = y > this.bounds.y && y < this.bounds.y + this.bounds.height;
        if (inx && iny) {
            if (this.getFilled()) {
                return 0.0;
            }
            double d1 = x - this.bounds.x;
            double d2 = this.bounds.x + this.bounds.width - x;
            double d3 = y - this.bounds.y;
            double d4 = this.bounds.y + this.bounds.height - y;
            return Math.min(d1, Math.min(d2, Math.min(d3, d4)));
        }
        if (inx) {
            if (y < this.bounds.y) {
                return this.bounds.y - y;
            }
            return y - (this.bounds.y + this.bounds.height);
        }
        if (iny) {
            if (x < this.bounds.x) {
                return this.bounds.x - x;
            }
            return x - (this.bounds.x + this.bounds.width);
        }
        int cx = 0;
        int cy = 0;
        cx = x < this.bounds.x ? this.bounds.x : (x > this.bounds.x + this.bounds.width ? this.bounds.x + this.bounds.width : this.bounds.x + this.bounds.width / 2);
        cy = y < this.bounds.y ? this.bounds.y : (y > this.bounds.y + this.bounds.height ? this.bounds.y + this.bounds.height : this.bounds.y + this.bounds.height / 2);
        return Math.sqrt((cx - x) * (cx - x) + (cy - y) * (cy - y));
    }

    @Override
    public String stretchTo(int x, int y, String pt, boolean correct) {
        if (!this.getStretchy()) {
            pt = "MM";
        }
        if ("MM".equals(pt)) {
            this.bounds.x += x;
            this.bounds.y += y;
            this.boundsChanged();
            return pt;
        }
        String vs = pt.substring(0, 1);
        String hs = pt.substring(1, 2);
        boolean es = this.getEqualSides();
        boolean sym = this.getSymetricReshape();
        int vdelta = 0;
        int hdelta = 0;
        boolean didOV = false;
        boolean didOH = false;
        boolean didV = false;
        boolean didH = false;
        int ox = this.bounds.x;
        int oy = this.bounds.y;
        int cx = this.bounds.x + this.bounds.width / 2;
        int cy = this.bounds.y + this.bounds.height / 2;
        if (vs.equals("U")) {
            didOV = true;
            vdelta = this.bounds.y - y;
            didV = true;
            this.bounds.height += vdelta;
            this.bounds.y = y;
            if (sym) {
                this.bounds.height += vdelta;
            }
        } else if (vs.equals("L")) {
            vdelta = y - this.bounds.y - this.bounds.height;
            didV = true;
            this.bounds.height += vdelta;
            if (sym) {
                this.bounds.y -= vdelta;
                this.bounds.height += vdelta;
            }
        }
        if (hs.equals("L")) {
            didOH = true;
            hdelta = this.bounds.x - x;
            didH = true;
            this.bounds.width += hdelta;
            this.bounds.x = x;
            if (sym) {
                this.bounds.width += hdelta;
            }
        } else if (hs.equals("R")) {
            hdelta = x - this.bounds.x - this.bounds.width;
            didH = true;
            this.bounds.width += hdelta;
            if (sym) {
                this.bounds.x -= hdelta;
                this.bounds.width += hdelta;
            }
        }
        if (es && (didV || didH)) {
            if (!didH) {
                this.bounds.width = this.bounds.height;
            } else if (!didV) {
                this.bounds.height = this.bounds.width;
            } else if (this.bounds.width < this.bounds.height) {
                if (didOH) {
                    this.bounds.x += this.bounds.width - this.bounds.height;
                }
                this.bounds.width = this.bounds.height;
            } else {
                if (didOV) {
                    this.bounds.y += this.bounds.height - this.bounds.width;
                }
                this.bounds.height = this.bounds.width;
            }
        }
        if (sym) {
            this.bounds.x += cx - (this.bounds.x + this.bounds.width / 2);
            this.bounds.y += cy - (this.bounds.y + this.bounds.height / 2);
        }
        if (correct) {
            if (this.bounds.width <= 0) {
                hs = "L".equals(hs) ? "R" : "L";
                this.bounds.x += this.bounds.width;
                this.bounds.width = -this.bounds.width;
            }
            if (this.bounds.height <= 0) {
                vs = "U".equals(vs) ? "L" : "U";
                this.bounds.y += this.bounds.height;
                this.bounds.height = -this.bounds.height;
            }
        }
        this.boundsChanged();
        return vs + hs;
    }

    public static Point getPoint(String pt, Rectangle b) {
        Point p = new Point(b.x, b.y);
        String vs = pt.substring(0, 1);
        String hs = pt.substring(1, 2);
        if (vs.equals("U")) {
            p.y = b.y;
        } else if (vs.equals("M")) {
            p.y = b.y + b.height / 2;
        } else if (vs.equals("L")) {
            p.y = b.y + b.height;
        }
        if (hs.equals("L")) {
            p.x = b.x;
        } else if (hs.equals("M")) {
            p.x = b.x + b.width / 2;
        } else if (hs.equals("R")) {
            p.x = b.x + b.width;
        }
        return p;
    }

    @Override
    public String getStretchPoint(int x, int y) {
        if (!this.getStretchy()) {
            return "MM";
        }
        return RectangleGlyph.getStretchPoint(this.bounds, x, y);
    }

    @Override
    public void moveBy(int x, int y) {
        this.moveTo(x + this.bounds.x, y + this.bounds.y);
    }

    @Override
    public void moveTo(int x, int y) {
        this.bounds.x = x;
        this.bounds.y = y;
    }

    @Override
    public void setPoints(int[] p, int cnt) {
        this.moveBy(p[0] - this.bounds.x, p[1] - this.bounds.y);
        this.bounds.width = p[2];
        this.bounds.height = p[3];
    }

    @Override
    public String getPositionAttr() {
        return this.makeAttr("pts", this.bounds.x + "," + this.bounds.y + "," + this.bounds.width + "," + this.bounds.height);
    }

    @Override
    public void setAttr(String name, String value) {
        if (ATTR_RECTTYPE.equals(name)) {
            this.setType(value);
        } else if ("width".equals(name)) {
            this.bounds.width = Misc.getInt(value, this.bounds.width);
        } else if ("height".equals(name)) {
            this.bounds.height = Misc.getInt(value, this.bounds.height);
        } else {
            super.setAttr(name, value);
        }
    }

    public void setSize(int w, int h) {
        this.bounds.width = w;
        this.bounds.height = h;
    }
}

