/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui.drawing;

import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import ucar.unidata.ui.drawing.CanvasCommand;
import ucar.unidata.ui.drawing.DisplayCanvas;
import ucar.unidata.ui.drawing.Glyph;

class GlyphStretcher
extends CanvasCommand {
    Glyph theGlyph;
    Point lastPoint;
    String ptKey = "";
    List selection;

    public GlyphStretcher(DisplayCanvas canvas, AWTEvent firstEvent, Glyph theGlyph, List selection, int x, int y) {
        super(canvas, firstEvent, x, y);
        this.theGlyph = theGlyph;
        this.selection = selection;
        this.ptKey = selection != null && selection.size() > 1 ? "MM" : theGlyph.getStretchPoint(x, y);
        this.lastPoint = new Point(x, y);
        this.doMouseDragged(null, x, y);
    }

    @Override
    public Cursor getCursor() {
        return DisplayCanvas.MOVE_CURSOR;
    }

    @Override
    public String getDescription() {
        return "Resize a glyph";
    }

    @Override
    public CanvasCommand doMouseDragged(MouseEvent e, int x, int y) {
        x = this.canvas.snap(x);
        y = this.canvas.snap(y);
        if (this.theGlyph == null) {
            return null;
        }
        this.canvas.repaint(this.theGlyph);
        int destx = x;
        int desty = y;
        boolean absolute = true;
        if (this.ptKey.equals("MM")) {
            destx = x - this.lastPoint.x;
            desty = y - this.lastPoint.y;
            absolute = false;
        }
        if (this.selection != null) {
            for (int i = 0; i < this.selection.size(); ++i) {
                Glyph g = (Glyph)this.selection.get(i);
                if (g == this.theGlyph) continue;
                this.canvas.repaint(g);
                if (g.canStretch()) {
                    g.stretchTo(destx, desty, this.ptKey, true);
                }
                this.canvas.repaint(g);
            }
        }
        if (this.theGlyph.canStretch()) {
            this.ptKey = this.theGlyph.stretchTo(destx, desty, this.ptKey, true);
        } else if (absolute) {
            this.theGlyph.moveTo(destx, desty);
        } else {
            this.theGlyph.moveBy(destx, desty);
        }
        this.canvas.repaint(this.theGlyph);
        this.lastPoint.x = x;
        this.lastPoint.y = y;
        this.canvas.notifyGlyphMoved(this.theGlyph);
        return this;
    }

    @Override
    protected void doComplete() {
        super.doComplete();
        this.canvas.notifyGlyphMoveComplete(this.theGlyph);
    }
}

