/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui.drawing;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import ucar.unidata.ui.drawing.CanvasCommand;
import ucar.unidata.ui.drawing.CompositeGlyph;
import ucar.unidata.ui.drawing.DisplayCanvas;
import ucar.unidata.ui.drawing.GlyphCreator;
import ucar.unidata.ui.drawing.GlyphStretcher;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.xml.XmlUtil;

public abstract class Glyph
implements Cloneable {
    public static final String TAG_GLYPH = "glyph";
    public static final String ATTR_CLASS = "class";
    public static final String PT_CENTER = "MM";
    public static final String PT_V_UPPER = "U";
    public static final String PT_V_MIDDLE = "M";
    public static final String PT_V_LOWER = "L";
    public static final String PT_H_LEFT = "L";
    public static final String PT_H_MIDDLE = "M";
    public static final String PT_H_RIGHT = "R";
    public static final String PT_UL = "UL";
    public static final String PT_UM = "UM";
    public static final String PT_UR = "UR";
    public static final String PT_ML = "ML";
    public static final String PT_MM = "MM";
    public static final String PT_MR = "MR";
    public static final String PT_LL = "LL";
    public static final String PT_LM = "LM";
    public static final String PT_LR = "LR";
    public static final String[] RECTPOINTS = new String[]{"UL", "UM", "UR", "ML", "MM", "MR", "LL", "LM", "LR"};
    public static final String[] RECTPOINTNAMES = new String[]{"NW", "N", "NE", "W", "Middle", "E", "SW", "S", "SE"};
    public static final String PT_PREFIX = "P";
    public static final String PT_P1 = "P1";
    public static final String PT_P2 = "P2";
    public static final String ATTR_CHILDREN = "children";
    public static final String ATTR_COLOR = "color";
    public static final String ATTR_BGCOLOR = "bgcolor";
    public static final String ATTR_FILL = "fill";
    public static final String ATTR_HEIGHT = "height";
    public static final String ATTR_IMAGE = "image";
    public static final String ATTR_LINEWIDTH = "linewidth";
    public static final String ATTR_PARENT = "parent";
    public static final String ATTR_PTS = "pts";
    public static final String ATTR_STRETCHY = "stretchy";
    public static final String ATTR_TEXT = "text";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_WIDTH = "width";
    public static Hashtable idToGlyph = new Hashtable();
    public static final int MIN_DISTANCE_TO_STRETCH = 4;
    public static final int SEL_WIDTH = 6;
    public static final int H_SEL_WIDTH = 3;
    public static final Color highlightColor = Color.yellow;
    private boolean stretchy = true;
    private CompositeGlyph parent;
    String type;
    private boolean filled = false;
    private int lineWidth = 1;
    private Color foregroundColor = Color.black;
    private Color backgroundColor = null;
    public boolean underline = false;
    public String url;
    public int baseline;
    private String id = "";
    boolean beingCreated = true;

    public static Cursor getCursor(String rectPoint) {
        if (rectPoint == null) {
            return Cursor.getPredefinedCursor(0);
        }
        if (rectPoint.equals(PT_UL)) {
            return Cursor.getPredefinedCursor(6);
        }
        if (rectPoint.equals(PT_UM)) {
            return Cursor.getPredefinedCursor(8);
        }
        if (rectPoint.equals(PT_UR)) {
            return Cursor.getPredefinedCursor(7);
        }
        if (rectPoint.equals(PT_ML)) {
            return Cursor.getPredefinedCursor(10);
        }
        if (rectPoint.equals(PT_MR)) {
            return Cursor.getPredefinedCursor(11);
        }
        if (rectPoint.equals(PT_LL)) {
            return Cursor.getPredefinedCursor(4);
        }
        if (rectPoint.equals(PT_LM)) {
            return Cursor.getPredefinedCursor(9);
        }
        if (rectPoint.equals(PT_LR)) {
            return Cursor.getPredefinedCursor(5);
        }
        return Cursor.getPredefinedCursor(13);
    }

    public static String getRectPointName(String rectPoint) {
        for (int i = 0; i < RECTPOINTS.length; ++i) {
            if (!RECTPOINTS[i].equals(rectPoint)) continue;
            return RECTPOINTNAMES[i];
        }
        return rectPoint;
    }

    public static void paintSelectionPoints(Graphics g, RectangularShape r, int size) {
        int halfSize = size / 2;
        int L = (int)(r.getX() - (double)halfSize);
        int T = (int)(r.getY() - (double)halfSize);
        int R = (int)(r.getX() + r.getWidth() - (double)halfSize + 1.0);
        int B = (int)(r.getY() + r.getHeight() - (double)halfSize + 1.0);
        int MY = (int)((double)T + r.getHeight() / 2.0);
        int MX = (int)((double)L + r.getWidth() / 2.0);
        g.fillRect(L, T, size, size);
        g.fillRect(L, B, size, size);
        g.fillRect(R, T, size, size);
        g.fillRect(R, B, size, size);
        g.fillRect(L, MY, size, size);
        g.fillRect(R, MY, size, size);
        g.fillRect(MX, T, size, size);
        g.fillRect(MX, B, size, size);
    }

    public static String flipY(String pt) {
        String vs = pt.substring(0, 1);
        String hs = pt.substring(1, 2);
        if (vs.equals(PT_V_UPPER)) {
            vs = "L";
        } else if (vs.equals("L")) {
            vs = PT_V_UPPER;
        }
        return vs + hs;
    }

    public static Point2D getPointOnRect(String pt, Rectangle2D r) {
        return Glyph.getPointOnRect(pt, r, new Point2D.Double());
    }

    public static Rectangle toRect(RectangularShape r) {
        return new Rectangle((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
    }

    public static String getStretchPoint(RectangularShape r, int x, int y) {
        Rectangle bounds = Glyph.toRect(r);
        String vS = PT_V_UPPER;
        int vMin = Math.abs(bounds.y - y);
        int tmp = Math.abs(y - (bounds.y + bounds.height / 2));
        if (tmp < vMin) {
            vMin = tmp;
            vS = "M";
        }
        if ((tmp = Math.abs(y - (bounds.y + bounds.height))) < vMin) {
            vMin = tmp;
            vS = "L";
        }
        String hS = "L";
        int hMin = Math.abs(bounds.x - x);
        tmp = Math.abs(x - (bounds.x + bounds.width / 2));
        if (tmp < hMin) {
            hMin = tmp;
            hS = "M";
        }
        if ((tmp = Math.abs(x - (bounds.x + bounds.width))) < hMin) {
            hMin = tmp;
            hS = PT_H_RIGHT;
        }
        if (!(vS.equals("M") && hS.equals("M") || vMin > 4 || hMin > 4)) {
            return vS + hS;
        }
        return "MM";
    }

    public static Point2D getPointOnRect(String pt, Rectangle2D r, Point2D point) {
        pt = pt.toUpperCase();
        String vs = pt.substring(0, 1);
        String hs = pt.substring(1, 2);
        double x = 0.0;
        double y = 0.0;
        y = vs.equals(PT_V_UPPER) ? Math.min(r.getY(), r.getY() + r.getHeight()) : (vs.equals("L") ? Math.max(r.getY(), r.getY() + r.getHeight()) : r.getY() + r.getHeight() / 2.0);
        x = hs.equals("L") ? Math.min(r.getX(), r.getX() + r.getWidth()) : (hs.equals(PT_H_RIGHT) ? Math.max(r.getX(), r.getX() + r.getWidth()) : r.getX() + r.getWidth() / 2.0);
        point.setLocation(x, y);
        return point;
    }

    public static String stretchTo(Rectangle bounds, int x, int y, String pt) {
        return Glyph.stretchTo(bounds, x, y, pt, true, false, false);
    }

    public static String stretchTo(Rectangle bounds, int x, int y, String pt, boolean correct, boolean symetric, boolean equalSides) {
        if ("MM".equals(pt)) {
            bounds.x += x;
            bounds.y += y;
            return pt;
        }
        String vs = pt.substring(0, 1);
        String hs = pt.substring(1, 2);
        boolean es = equalSides;
        boolean sym = symetric;
        int vdelta = 0;
        int hdelta = 0;
        boolean didOV = false;
        boolean didOH = false;
        boolean didV = false;
        boolean didH = false;
        int ox = bounds.x;
        int oy = bounds.y;
        int cx = bounds.x + bounds.width / 2;
        int cy = bounds.y + bounds.height / 2;
        if (vs.equals(PT_V_UPPER)) {
            didOV = true;
            vdelta = bounds.y - y;
            didV = true;
            bounds.height += vdelta;
            bounds.y = y;
            if (sym) {
                bounds.height += vdelta;
            }
        } else if (vs.equals("L")) {
            vdelta = y - bounds.y - bounds.height;
            didV = true;
            bounds.height += vdelta;
            if (sym) {
                bounds.y -= vdelta;
                bounds.height += vdelta;
            }
        }
        if (hs.equals("L")) {
            didOH = true;
            hdelta = bounds.x - x;
            didH = true;
            bounds.width += hdelta;
            bounds.x = x;
            if (sym) {
                bounds.width += hdelta;
            }
        } else if (hs.equals(PT_H_RIGHT)) {
            hdelta = x - bounds.x - bounds.width;
            didH = true;
            bounds.width += hdelta;
            if (sym) {
                bounds.x -= hdelta;
                bounds.width += hdelta;
            }
        }
        if (es && (didV || didH)) {
            if (!didH) {
                bounds.width = bounds.height;
            } else if (!didV) {
                bounds.height = bounds.width;
            } else if (bounds.width < bounds.height) {
                if (didOH) {
                    bounds.x += bounds.width - bounds.height;
                }
                bounds.width = bounds.height;
            } else {
                if (didOV) {
                    bounds.y += bounds.height - bounds.width;
                }
                bounds.height = bounds.width;
            }
        }
        if (sym) {
            bounds.x += cx - (bounds.x + bounds.width / 2);
            bounds.y += cy - (bounds.y + bounds.height / 2);
        }
        if (correct) {
            if (bounds.width <= 0) {
                hs = "L".equals(hs) ? PT_H_RIGHT : "L";
                bounds.x += bounds.width;
                bounds.width = -bounds.width;
            }
            if (bounds.height <= 0) {
                vs = PT_V_UPPER.equals(vs) ? "L" : PT_V_UPPER;
                bounds.y += bounds.height;
                bounds.height = -bounds.height;
            }
        }
        return vs + hs;
    }

    public boolean getStretchy() {
        return this.stretchy;
    }

    public void setStretchy(boolean b) {
        this.stretchy = b;
    }

    public void setBeingCreated(boolean b) {
        this.beingCreated = b;
    }

    public boolean getBeingCreated() {
        return this.beingCreated;
    }

    public void initDone() {
    }

    public void setId(String newId) {
        if (!this.id.equals("")) {
            idToGlyph.remove(this.id);
        }
        this.id = newId;
        if (!this.id.equals("")) {
            idToGlyph.put(this.id, this);
        }
    }

    public String getId() {
        return this.id;
    }

    public void doRemove() {
        if (!this.id.equals("")) {
            idToGlyph.remove(this.id);
        }
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
    }

    public void setParent(CompositeGlyph newParent) {
        this.parent = newParent;
    }

    public boolean pickable() {
        return this.parent == null;
    }

    public void notifyChange() {
        if (this.parent != null) {
            this.parent.calculateBounds();
        }
    }

    public CanvasCommand getCreateCommand(DisplayCanvas canvas, AWTEvent event, int x, int y) {
        return new GlyphCreator(canvas, event, this, x, y);
    }

    public CanvasCommand getMoveCommand(DisplayCanvas canvas, AWTEvent event, int x, int y) {
        return new GlyphStretcher(canvas, event, this, canvas.getSelection(), x, y);
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean getPersistent() {
        return true;
    }

    public boolean canStretch() {
        return true;
    }

    public void boundsChanged() {
    }

    public void setPoints(int[] p, int cnt) {
    }

    public void setForeground(Color c) {
        this.foregroundColor = c;
    }

    public Color getForeground() {
        return this.foregroundColor;
    }

    public void setBackground(Color c) {
        this.backgroundColor = c;
    }

    public Color getBackground() {
        return this.backgroundColor;
    }

    public Color getBackground(Color dflt) {
        return this.backgroundColor != null ? this.backgroundColor : dflt;
    }

    public void setLineWidth(int value) {
        this.lineWidth = value;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setFilled(boolean c) {
        this.filled = c;
    }

    public boolean getFilled() {
        return this.filled;
    }

    public void processAttrs(String s) {
        if (s == null) {
            return;
        }
        Properties p = Misc.parseProperties(s);
        Enumeration<Object> keys = p.keys();
        while (keys.hasMoreElements()) {
            String attr = (String)keys.nextElement();
            String value = (String)p.get(attr);
            this.setAttr(attr.trim(), value);
        }
    }

    public void setAttr(String name, String value) {
        if (ATTR_FILL.equals(name)) {
            this.setFilled("true".equals(value));
        } else if (ATTR_TYPE.equals(name)) {
            this.type = value;
        } else if (ATTR_STRETCHY.equals(name)) {
            this.stretchy = Misc.getBoolean(value, this.stretchy);
        } else if (ATTR_LINEWIDTH.equals(name)) {
            this.setLineWidth(Misc.getInt(value, this.lineWidth));
        } else if (ATTR_BGCOLOR.equals(name)) {
            this.setBackground(GuiUtils.decodeColor(value, Color.black));
        } else if (ATTR_COLOR.equals(name)) {
            this.setForeground(GuiUtils.decodeColor(value, Color.black));
        } else if (ATTR_PTS.equals(name)) {
            StringTokenizer st = new StringTokenizer(value, ",");
            int[] pts = new int[1000];
            int i = 0;
            try {
                while (st.hasMoreTokens() && i < pts.length) {
                    pts[i++] = Integer.decode(st.nextToken());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setPoints(pts, i);
        }
    }

    public String getXml() {
        return XmlUtil.tag(TAG_GLYPH, XmlUtil.attr(ATTR_CLASS, this.getClass().getName()) + " " + this.getPositionAttr() + " " + this.getAttrs()) + "\n";
    }

    public String makeAttr(String name, String value) {
        return XmlUtil.attr(name, value);
    }

    public String getAttrs() {
        return this.makeAttr(ATTR_STRETCHY, "" + this.stretchy) + this.makeAttr(ATTR_TYPE, this.type) + this.makeAttr(ATTR_FILL, "" + this.filled) + this.makeAttr(ATTR_LINEWIDTH, "" + this.lineWidth) + this.makeAttr(ATTR_BGCOLOR, this.backgroundColor != null ? this.backgroundColor.getRed() + "," + this.backgroundColor.getGreen() + "," + this.backgroundColor.getBlue() : "null") + this.makeAttr(ATTR_COLOR, this.foregroundColor.getRed() + "," + this.foregroundColor.getGreen() + "," + this.foregroundColor.getBlue());
    }

    public void paint(Graphics g, DisplayCanvas c) {
    }

    public void paintSelection(Graphics g, DisplayCanvas c) {
        Rectangle r = this.transformOutput(c, this.getBounds());
        if (c.canvasBg == Color.black) {
            g.setColor(Color.white);
        } else {
            g.setColor(Color.black);
        }
        Glyph.paintSelectionPoints(g, r, 6);
    }

    public void paintHighlight(Graphics g, DisplayCanvas c) {
        Rectangle r = this.transformOutput(c, this.getBounds());
        g.setColor(highlightColor);
        g.drawRect(r.x - 1, r.y - 1, r.width + 2, r.height + 2);
        g.drawRect(r.x - 2, r.y - 2, r.width + 4, r.height + 4);
    }

    abstract String getPositionAttr();

    public abstract double distance(int var1, int var2);

    public abstract void moveBy(int var1, int var2);

    public abstract void moveTo(int var1, int var2);

    public abstract Rectangle getBounds();

    public Rectangle getRepaintBounds() {
        return this.getBounds();
    }

    public String getStretchPoint(int x, int y) {
        return "MM";
    }

    public String stretchTo(int x, int y, String pt, boolean correct) {
        this.moveBy(x, y);
        return "MM";
    }

    public static double distance(int x1, int y1, int x2, int y2) {
        return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    public int transformOutputX(DisplayCanvas canvas, int x) {
        return canvas.transformOutputX(x);
    }

    public int transformOutputY(DisplayCanvas canvas, int x) {
        return canvas.transformOutputY(x);
    }

    public Rectangle transformOutput(DisplayCanvas canvas, Rectangle r) {
        return canvas.transformOutput(r);
    }

    public Point transformOutput(DisplayCanvas canvas, Point r) {
        return canvas.transformOutput(r);
    }
}

