/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui.drawing;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.w3c.dom.Element;
import ucar.unidata.ui.drawing.CanvasCommand;
import ucar.unidata.ui.drawing.DisplayCanvas;
import ucar.unidata.ui.drawing.DragRectCommand;
import ucar.unidata.ui.drawing.Glyph;
import ucar.unidata.ui.drawing.GroupGlyph;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.ObjectListener;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.xml.XmlNodeList;
import ucar.unidata.xml.XmlUtil;

public class EditCanvas
extends DisplayCanvas
implements MouseListener,
MouseMotionListener,
ActionListener,
FocusListener,
KeyListener {
    public static final String CMD_ZOOMIN = "cmd.zoom.in";
    public static final String CMD_ZOOMOUT = "cmd.zoom.out";
    public static final String CMD_ZOOMRESET = "cmd.zoom.reset";
    public static final String CMD_EDIT_CUT = "edit.cut";
    public static final String CMD_EDIT_COPY = "edit.copy";
    public static final String CMD_EDIT_PASTE = "edit.paste";
    public static final String CMD_EDIT_SELECTALL = "edit.selectall";
    public static final String CMD_EDIT_GROUP = "edit.group";
    public static final String CMD_EDIT_UNGROUP = "edit.ungroup";
    public static final String CMD_EDIT_TOFRONT = "edit.tofront";
    public static final String CMD_EDIT_TOBACK = "edit.toback";
    public static final String CMD_ALIGN_PREFIX = "align.";
    public static final String CMD_ALIGN_TOP = "align.top";
    public static final String CMD_ALIGN_CENTER = "align.center";
    public static final String CMD_ALIGN_BOTTOM = "align.bottom";
    public static final String CMD_ALIGN_LEFT = "align.left";
    public static final String CMD_ALIGN_MIDDLE = "align.middle";
    public static final String CMD_ALIGN_RIGHT = "align.right";
    public static final String CMD_SPACE_H = "align.spaceh";
    public static final String CMD_SPACE_V = "align.spacev";
    public static final String CMD_SNAP = "cmd.snap";
    private boolean selectionSticky = false;
    private List selectionMenuItems = new ArrayList();
    private List shapeGroup = new ArrayList();
    private List colorList;
    int lastx;
    int lasty;
    int mousex;
    int mousey;
    boolean mouseWasPressed = false;
    String currentUrl;
    CanvasCommand currentCommand;
    String uniqueifier = null;
    boolean haveChanged = false;
    CanvasCommand dragCommand;
    JToggleButton selectButton;
    private JMenuBar menuBar;

    public EditCanvas() {
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
    }

    public void setDefaultCursor() {
        this.setCursor(DEFAULT_CURSOR);
    }

    String getGlyphId() {
        if (this.uniqueifier == null) {
            this.uniqueifier = "" + System.currentTimeMillis();
        }
        return "ID-" + this.uniqueifier + "-" + this.glyphCnt++;
    }

    public boolean okToPaintHighlight() {
        return true;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(Color.black);
        if (this.highlightedGlyph != null && this.okToPaintHighlight()) {
            this.highlightedGlyph.paintHighlight(g, this);
        }
        if (this.currentCommand != null) {
            this.currentCommand.doPaint(g);
        }
    }

    public boolean haveCommand() {
        return this.currentCommand != null;
    }

    public boolean getHaveChanged() {
        return this.haveChanged;
    }

    public void setHaveChanged(boolean v) {
        this.haveChanged = v;
    }

    public void setCommand(CanvasCommand newCommand) {
        if (newCommand != null && newCommand.doesChangeGlyphs()) {
            this.setHaveChanged(true);
        }
        if (this.currentCommand != null && this.currentCommand != newCommand) {
            CanvasCommand tmpCommand = this.currentCommand;
            this.currentCommand = null;
            tmpCommand.doComplete();
            this.setDefaultCursor();
        }
        this.currentCommand = newCommand;
        if (newCommand != null) {
            Cursor cursor = newCommand.getCursor();
            if (cursor != null) {
                this.setCursor(cursor);
            }
            if (newCommand.isAtomic()) {
                this.setCommand(null);
            }
        }
    }

    @Override
    public void notifyGlyphMoved(Glyph theGlyph) {
    }

    @Override
    public void notifyGlyphMoveComplete(Glyph theGlyph) {
    }

    public void notifyGlyphChanged(Glyph theGlyph, String attr) {
    }

    public void notifyGlyphChangeDone(Glyph theGlyph, String attr) {
    }

    @Override
    public void notifyGlyphCreateComplete(Glyph g, boolean diddleSelection, boolean fromPaste) {
        super.notifyGlyphCreateComplete(g, diddleSelection, fromPaste);
        if (diddleSelection) {
            this.clearSelection();
            this.addSelection(g);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.currentCommand != null) {
            return;
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.currentCommand != null) {
            this.setCommand(this.currentCommand.doFocusLost(e));
            return;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.currentCommand != null) {
            this.setCommand(this.currentCommand.doKeyReleased(e));
            return;
        }
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        if (this.currentCommand != null) {
            this.setCommand(this.currentCommand.doKeyPress(evt));
            return;
        }
        char key = evt.getKeyChar();
        int keyCode = evt.getKeyCode();
        if (GuiUtils.isDeleteEvent(evt)) {
            this.doCut();
        }
        if (evt.isControlDown()) {
            if ((key = (char)(key + 97 - 1)) == 'x') {
                this.doCut();
            } else if (key == 'c') {
                this.doCopy();
            } else if (key == 'v') {
                this.doPaste();
            } else if (key == 'a') {
                this.selectAll();
            } else if (key == 'g') {
                this.group();
            } else if (key == 'u') {
                this.unGroup();
            } else if (key == 'z') {
                // empty if block
            }
            return;
        }
        if (key == 'f' || key == 'b') {
            for (int i = 0; i < this.selectionSet.size(); ++i) {
                Glyph g = (Glyph)this.selectionSet.get(i);
                if (key == 'f') {
                    this.moveToFront(g);
                    continue;
                }
                this.moveToBack(g);
            }
        }
    }

    protected JMenuItem makeSelectionMenuItem(String label, char mnem, String command, boolean enabled) {
        JMenuItem mi = this.makeMenuItem(label, mnem, command);
        this.selectionMenuItems.add(mi);
        if (!enabled) {
            mi.setEnabled(false);
        }
        return mi;
    }

    protected JMenuItem makeMenuItem(String label, char mnem, String command) {
        JMenuItem mi = this.makeMenuItem(label, command);
        return mi;
    }

    protected JMenuItem makeMenuItem(String label, String command) {
        JMenuItem mi = new JMenuItem(label);
        mi.setActionCommand(command);
        mi.addActionListener(this);
        return mi;
    }

    public JMenu makeEditMenu() {
        JMenu editMenu = new JMenu("Edit");
        return this.makeEditMenu(editMenu);
    }

    public JMenu makeViewMenu() {
        JMenu viewMenu = new JMenu("View");
        return this.makeViewMenu(viewMenu);
    }

    @Override
    public void selectionChanged() {
        super.selectionChanged();
        boolean hasSelection = this.hasSelection();
        for (int i = 0; i < this.selectionMenuItems.size(); ++i) {
            ((JMenuItem)this.selectionMenuItems.get(i)).setEnabled(hasSelection);
        }
    }

    public JMenu makeEditMenu(JMenu editMenu) {
        boolean hasSelection = this.hasSelection();
        boolean hasBuffer = this.cutBuffer != null && this.cutBuffer.size() > 0;
        editMenu.add(this.makeSelectionMenuItem("Cut", 'x', CMD_EDIT_CUT, hasSelection));
        editMenu.add(this.makeSelectionMenuItem("Copy", 'c', CMD_EDIT_COPY, hasSelection));
        editMenu.add(this.makeSelectionMenuItem("Paste", 'v', CMD_EDIT_PASTE, hasBuffer));
        editMenu.addSeparator();
        editMenu.add(this.makeMenuItem("Select All", 'a', CMD_EDIT_SELECTALL));
        editMenu.addSeparator();
        editMenu.add(this.makeSelectionMenuItem("To Front", 'f', CMD_EDIT_TOFRONT, hasSelection));
        editMenu.add(this.makeSelectionMenuItem("To Back", 'b', CMD_EDIT_TOBACK, hasSelection));
        if (this.doGroup()) {
            editMenu.addSeparator();
            editMenu.add(this.makeSelectionMenuItem("Group", 'g', CMD_EDIT_GROUP, hasSelection));
            editMenu.add(this.makeSelectionMenuItem("Ungroup", 'u', CMD_EDIT_UNGROUP, hasSelection));
        }
        return editMenu;
    }

    private KeyStroke getKeyStroke(char c) {
        int keyCode = GuiUtils.charToKeyCode(c);
        if (keyCode < 0) {
            return KeyStroke.getKeyStroke((int)c, 2);
        }
        return KeyStroke.getKeyStroke(keyCode, 2);
    }

    public JMenu makeViewMenu(JMenu viewMenu) {
        JMenuItem mi = this.makeMenuItem("Zoom in", '=', CMD_ZOOMIN);
        viewMenu.add(mi);
        mi = this.makeMenuItem("Zoom out", '-', CMD_ZOOMOUT);
        viewMenu.add(mi);
        mi = this.makeMenuItem("Zoom reset", '0', CMD_ZOOMRESET);
        viewMenu.add(mi);
        JMenu gridMenu = new JMenu("Grid");
        viewMenu.add(gridMenu);
        gridMenu.add(GuiUtils.makeCheckboxMenuItem("Show", this, "showGrid", null));
        gridMenu.add(GuiUtils.makeMenuItem("Increase", this, "increaseGridSpacing"));
        gridMenu.add(GuiUtils.makeMenuItem("Decrease", this, "decreaseGridSpacing"));
        return viewMenu;
    }

    public boolean doGroup() {
        return true;
    }

    protected void doZoomIn() {
        this.scaleFactor += 0.1;
        this.repaint();
    }

    protected void doZoomOut() {
        this.scaleFactor -= 0.1;
        if (this.scaleFactor < 0.1) {
            this.scaleFactor = 0.1;
        }
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String action = event.getActionCommand();
        if (action.equals(CMD_ZOOMOUT)) {
            this.doZoomOut();
        } else if (action.equals(CMD_ZOOMIN)) {
            this.doZoomIn();
        }
        if (action.equals(CMD_ZOOMRESET)) {
            this.scaleFactor = 1.0;
            this.repaint();
        } else if (action.equals(CMD_EDIT_CUT)) {
            this.doCut();
        } else if (action.equals(CMD_EDIT_COPY)) {
            this.doCopy();
        } else if (action.equals(CMD_EDIT_TOFRONT)) {
            this.doToFront();
        } else if (action.equals(CMD_EDIT_TOBACK)) {
            this.doToBack();
        } else if (action.equals(CMD_EDIT_PASTE)) {
            this.doPaste();
        } else if (action.equals(CMD_EDIT_SELECTALL)) {
            this.selectAll();
        } else if (action.equals(CMD_EDIT_GROUP)) {
            this.group();
        } else if (action.equals(CMD_EDIT_UNGROUP)) {
            this.unGroup();
        } else if (action.equals(CMD_SNAP)) {
            this.snapToGrid();
        } else if (action.startsWith(CMD_ALIGN_PREFIX)) {
            this.doAlign(action);
        }
    }

    public void group() {
        if (!this.doGroup()) {
            return;
        }
        if (!this.hasSelection()) {
            return;
        }
        if (this.selectionSet.size() == 1 && this.selectionSet.get(0) instanceof GroupGlyph) {
            return;
        }
        GroupGlyph glyph = new GroupGlyph(this.selectionSet);
        glyph.setId(this.getGlyphId());
        this.addGlyph(glyph);
        this.notifyGlyphCreateComplete(glyph, true, false);
    }

    public void unGroup() {
        if (!this.doGroup()) {
            return;
        }
        for (int i = 0; i < this.selectionSet.size(); ++i) {
            Glyph g = (Glyph)this.selectionSet.get(i);
            if (!(g instanceof GroupGlyph)) continue;
            ((GroupGlyph)g).unGroup();
            this.notifyGlyphChangeDone(g, "children");
            this.removeGlyph(g);
        }
        this.repaint();
    }

    public void doPaste(List l, int x, int y) {
        Glyph g;
        int i;
        if (l == null) {
            return;
        }
        this.clearSelection();
        int ox = Integer.MAX_VALUE;
        int oy = Integer.MAX_VALUE;
        for (i = 0; i < l.size(); ++i) {
            g = (Glyph)l.get(i);
            Rectangle b = g.getBounds();
            if (b.x < ox) {
                ox = b.x;
            }
            if (b.y >= oy) continue;
            oy = b.y;
        }
        for (i = 0; i < l.size(); ++i) {
            g = (Glyph)l.get(i);
            g.setId(this.getGlyphId());
            g.moveBy(x - ox, y - oy);
            this.addGlyph(g);
            this.addSelection(g);
            this.notifyGlyphCreateComplete(g, false, true);
        }
    }

    public void doPaste() {
        this.doPaste(this.cloneGlyphs(this.cutBuffer), this.mousex, this.mousey);
    }

    public List cloneGlyphs(List from) {
        ArrayList<Object> to = new ArrayList<Object>();
        if (from == null) {
            return to;
        }
        for (int i = 0; i < from.size(); ++i) {
            Glyph o = (Glyph)from.get(i);
            try {
                to.add(o.clone());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return to;
    }

    public void doToFront() {
        if (this.selectionSet == null || this.selectionSet.size() == 0) {
            return;
        }
        for (int i = 0; i < this.selectionSet.size(); ++i) {
            Glyph glyph = (Glyph)this.selectionSet.get(i);
            this.glyphs.remove(glyph);
            this.glyphs.add(glyph);
        }
        this.repaint();
    }

    public void doToBack() {
        if (this.selectionSet == null || this.selectionSet.size() == 0) {
            return;
        }
        for (int i = 0; i < this.selectionSet.size(); ++i) {
            Glyph glyph = (Glyph)this.selectionSet.get(i);
            this.glyphs.remove(glyph);
            this.glyphs.add(0, glyph);
        }
        this.repaint();
    }

    public void doCopy() {
        this.cutBuffer = this.cloneGlyphs(this.selectionSet);
    }

    public void doCut() {
        this.cutBuffer = this.selectionSet;
        this.selectionSet = new ArrayList();
        this.selectionChanged();
        for (int i = 0; i < this.cutBuffer.size(); ++i) {
            Glyph g = (Glyph)this.cutBuffer.get(i);
            if (!g.getPersistent()) continue;
            this.removeGlyph(g);
        }
    }

    public void selectAll() {
        this.selectionSet.clear();
        for (int i = 0; i < this.glyphs.size(); ++i) {
            Glyph glyph = (Glyph)this.glyphs.get(i);
            if (!glyph.pickable()) continue;
            this.selectionSet.add(glyph);
        }
        this.selectionChanged();
        this.repaint();
    }

    public void spaceH() {
        this.doAlign(CMD_SPACE_H);
    }

    public void spaceV() {
        this.doAlign(CMD_SPACE_V);
    }

    public void doAlign(String cmd) {
        int top = Integer.MAX_VALUE;
        int vmid = Integer.MIN_VALUE;
        int bottom = Integer.MIN_VALUE;
        int left = Integer.MAX_VALUE;
        int hmid = Integer.MIN_VALUE;
        int right = Integer.MIN_VALUE;
        ArrayList<Glyph> glyphs = new ArrayList<Glyph>();
        for (int i = 0; i < this.selectionSet.size(); ++i) {
            Rectangle ob;
            Glyph other;
            int j;
            Glyph g = (Glyph)this.selectionSet.get(i);
            Rectangle b = g.getBounds();
            top = Math.min(b.y, top);
            left = Math.min(b.x, left);
            bottom = Math.max(b.y + b.height, bottom);
            right = Math.max(b.x + b.width, right);
            vmid = Math.max(b.y + b.height / 2, vmid);
            hmid = Math.max(b.x + b.width / 2, hmid);
            int size = glyphs.size();
            if (cmd.equals(CMD_SPACE_H)) {
                for (j = 0; j < glyphs.size(); ++j) {
                    other = (Glyph)glyphs.get(j);
                    ob = other.getBounds();
                    if (b.x >= ob.x) continue;
                    glyphs.add(j, g);
                    break;
                }
                if (glyphs.size() != size) continue;
                glyphs.add(g);
                continue;
            }
            if (cmd.equals(CMD_SPACE_V)) {
                for (j = 0; j < glyphs.size(); ++j) {
                    other = (Glyph)glyphs.get(j);
                    ob = other.getBounds();
                    if (b.y >= ob.y) continue;
                    glyphs.add(j, g);
                    break;
                }
                if (glyphs.size() != size) continue;
                glyphs.add(g);
                continue;
            }
            glyphs.add(g);
        }
        if (glyphs.size() == 0) {
            return;
        }
        int cnt = 0;
        for (Glyph g : glyphs) {
            Rectangle b = g.getBounds();
            if (cmd.equals(CMD_ALIGN_TOP)) {
                g.moveBy(0, top - b.y);
            } else if (cmd.equals(CMD_ALIGN_CENTER)) {
                g.moveBy(0, vmid - (b.y + b.height / 2));
            } else if (cmd.equals(CMD_ALIGN_BOTTOM)) {
                g.moveBy(0, bottom - (b.y + b.height));
            } else if (cmd.equals(CMD_ALIGN_LEFT)) {
                g.moveBy(left - b.x, 0);
            } else if (cmd.equals(CMD_ALIGN_MIDDLE)) {
                g.moveBy(hmid - (b.x + b.width / 2), 0);
            } else if (cmd.equals(CMD_ALIGN_RIGHT)) {
                g.moveBy(right - (b.x + b.width), 0);
            } else if (cmd.equals(CMD_SPACE_H)) {
                int dx = (right - left) / glyphs.size();
                int newX = left + dx * cnt;
                g.moveBy(newX - b.x, 0);
            } else if (cmd.equals(CMD_SPACE_V)) {
                int dy = (bottom - top) / glyphs.size();
                int newY = top + dy * cnt;
                g.moveBy(0, newY - b.y);
            }
            ++cnt;
            this.notifyGlyphMoveComplete(g);
        }
        this.repaint();
    }

    public void snapToGrid() {
        for (int i = 0; i < this.selectionSet.size(); ++i) {
            Glyph g = (Glyph)this.selectionSet.get(i);
            Rectangle b = g.getBounds();
            int dx = b.x % this.gridSpacing;
            int dy = b.y % this.gridSpacing;
            g.moveBy(-dx, -dy);
        }
        this.repaint();
    }

    public List doMakeMenuItems(final Glyph g, List l) {
        JMenuItem mi;
        l = new ArrayList<Object>();
        JMenu colorMenu = new JMenu("Set Color");
        l.add(colorMenu);
        if (this.colorList == null) {
            this.initColors();
        }
        for (int i = 0; i < this.colorList.size(); ++i) {
            TwoFacedObject colorTFO = (TwoFacedObject)this.colorList.get(i);
            mi = new JMenuItem(colorTFO.toString());
            colorMenu.add(mi);
            mi.addActionListener(new ObjectListener(colorTFO.getId()){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    EditCanvas.this.setColor(g, true, (Color)this.theObject);
                }
            });
        }
        mi = new JMenuItem("Custom...");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                EditCanvas.this.setColor(g, true);
            }
        });
        colorMenu.add(mi);
        l.add("separator");
        l.add(GuiUtils.makeMenuItem("To Front", this, "moveToFront", g));
        l.add(GuiUtils.makeMenuItem("To Back", this, "moveToBack", g));
        l.add("separator");
        l.add(GuiUtils.makeMenuItem("Delete", this, "removeGlyph", g));
        l.add("separator");
        return l;
    }

    public void setColor(Glyph g, boolean foreground) {
        this.setColor(g, foreground, null);
    }

    public void setColor(Glyph g, boolean foreground, Color newColor) {
        if (newColor == null) {
            newColor = JColorChooser.showDialog(this, "Choose " + (foreground ? "foreground" : "background") + " color", foreground ? g.getForeground() : g.getBackground());
        }
        if (newColor != null) {
            if (foreground) {
                g.setForeground(newColor);
            } else {
                g.setBackground(newColor);
            }
            this.repaint(g);
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        int y;
        if (event.getClickCount() > 1) {
            return;
        }
        this.requestFocus();
        if (!SwingUtilities.isRightMouseButton(event)) {
            return;
        }
        int x = this.transformInputX(event.getX());
        Glyph closest = EditCanvas.findGlyph(this.glyphs, x, y = this.transformInputY(event.getY()), 10.0);
        if (closest == null) {
            return;
        }
        List menuItems = this.doMakeMenuItems(closest, new ArrayList());
        if (menuItems == null || menuItems.size() == 0) {
            return;
        }
        JPopupMenu popup = new JPopupMenu();
        for (int i = 0; i < menuItems.size(); ++i) {
            Object item = menuItems.get(i);
            if (item instanceof String) {
                popup.addSeparator();
                continue;
            }
            if (!(item instanceof Component)) continue;
            popup.add((Component)item);
        }
        popup.show(this, event.getX(), event.getY());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int x = this.transformInputX(e.getX());
        int y = this.transformInputY(e.getY());
        this.mousex = x;
        this.mousey = y;
        if (this.currentCommand != null) {
            return;
        }
        Glyph closestGlyph = EditCanvas.findGlyph(this.glyphs, x, y, 10.0);
        Glyph lastHighlight = this.highlightedGlyph;
        boolean hadUrl = this.currentUrl != null;
        this.currentUrl = null;
        if (hadUrl && this.currentUrl == null) {
            this.setCursor(DisplayCanvas.DEFAULT_CURSOR);
        } else if (!hadUrl && this.currentUrl != null) {
            this.setCursor(DisplayCanvas.HAND_CURSOR);
        }
        if (closestGlyph != lastHighlight) {
            if (this.highlightedGlyph != null) {
                this.repaint(this.highlightedGlyph);
            }
            this.setHighlight(closestGlyph);
            if (this.highlightedGlyph != null) {
                this.repaint(this.highlightedGlyph);
            }
        }
    }

    public List getShapeDescriptors() {
        return null;
    }

    public JMenuBar getMenuBar() {
        if (this.menuBar == null) {
            this.menuBar = new JMenuBar();
            this.initMenuBar(this.menuBar);
        }
        return this.menuBar;
    }

    @Override
    protected Component doMakeContents() {
        JPanel labelComp = GuiUtils.inset((Component)this.getLabelComponent(), new Insets(5, 5, 5, 5));
        JPanel toolbarPanel = GuiUtils.leftCenterRight(GuiUtils.left(this.doMakeToolbar(null)), new JLabel("            "), labelComp);
        return GuiUtils.topCenter(toolbarPanel, GuiUtils.leftCenter(GuiUtils.inset(this.doMakePalette(), 2), this));
    }

    protected JComponent getLabelComponent() {
        return new JPanel();
    }

    public void initMenuBar(JMenuBar menuBar) {
        menuBar.add(this.makeEditMenu());
        menuBar.add(this.makeViewMenu());
    }

    public void togglePressed(JToggleButton pressed) {
        for (int i = 0; i < this.shapeGroup.size(); ++i) {
            JToggleButton tb = (JToggleButton)this.shapeGroup.get(i);
            if (tb == pressed) continue;
            tb.setSelected(false);
        }
    }

    public JToolBar doMakeToolbar(JToolBar toolbar) {
        if (toolbar == null) {
            toolbar = new JToolBar();
        }
        String[] cmds = new String[]{CMD_ALIGN_TOP, CMD_ALIGN_CENTER, CMD_ALIGN_BOTTOM, null, CMD_ALIGN_LEFT, CMD_ALIGN_MIDDLE, CMD_ALIGN_RIGHT, CMD_SPACE_H, CMD_SPACE_V, CMD_SNAP};
        String[] icons = new String[]{"aligntop.gif", "aligncenter.gif", "alignbottom.gif", "", "alignleft.gif", "alignmiddle.gif", "alignright.gif", "spaceh.gif", "spacev.gif", "snaptogrid.gif"};
        String[] tips = new String[]{"Align top", "Align center", "Align bottom", "", "Align left", "Align middle", "Align right", "Space Horizontally", "Space Vertically", "Snap to Grid"};
        String ip = "/auxdata/ui/icons/";
        for (int i = 0; i < cmds.length; ++i) {
            if (cmds[i] == null) {
                toolbar.add(new JLabel("  "));
                continue;
            }
            JButton b = GuiUtils.getImageButton(GuiUtils.getImageIcon(ip + icons[i], this.getClass()), 3);
            b.setActionCommand(cmds[i]);
            b.addActionListener(this);
            b.setToolTipText(tips[i]);
            toolbar.add(b);
        }
        return toolbar;
    }

    public Component doMakePalette() {
        List shapeDescriptors = this.getShapeDescriptors();
        if (shapeDescriptors == null) {
            return null;
        }
        ArrayList<JToggleButton> shapeButtons = new ArrayList<JToggleButton>();
        Border bborder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        if (this.showTextInPalette()) {
            ImageIcon image = GuiUtils.getImageIcon("/ucar/unidata/ui/drawing/images/pointer.gif");
            this.selectButton = new JToggleButton("Select", image);
            if (!GuiUtils.isMac()) {
                this.selectButton.setBorder(bborder);
            }
        } else {
            this.selectButton = GuiUtils.getToggleButton("/ucar/unidata/ui/drawing/images/pointer.gif", 4, 4);
        }
        Font nf = this.selectButton.getFont().deriveFont(10.0f);
        this.selectButton.setFont(nf);
        this.selectButton.setToolTipText("Select");
        this.selectButton.setHorizontalAlignment(2);
        this.shapeGroup.add(this.selectButton);
        shapeButtons.add(this.selectButton);
        for (int i = 0; i < shapeDescriptors.size(); ++i) {
            JToggleButton tb;
            ShapeDescriptor sd = (ShapeDescriptor)shapeDescriptors.get(i);
            if (this.showTextInPalette()) {
                ImageIcon image = GuiUtils.getImageIcon(sd.iconName);
                tb = new JToggleButton(sd.name, image);
                if (!GuiUtils.isMac()) {
                    tb.setBorder(bborder);
                }
            } else {
                tb = GuiUtils.getToggleButton(sd.iconName, 4, 4);
            }
            tb.setHorizontalAlignment(2);
            tb.setToolTipText(sd.name);
            tb.setFont(nf);
            this.shapeGroup.add(tb);
            shapeButtons.add(tb);
            tb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    EditCanvas.this.togglePressed((JToggleButton)ae.getSource());
                }
            });
        }
        JPanel buttons = GuiUtils.vbox(shapeButtons);
        JScrollPane sp = GuiUtils.makeScrollPane(GuiUtils.top(buttons), 175, 300);
        sp.setPreferredSize(new Dimension(175, 300));
        return sp;
    }

    public boolean showTextInPalette() {
        return false;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        boolean shouldClearSelection;
        Glyph nearestGlyph;
        this.requestFocus();
        this.dragCommand = null;
        int x = this.transformInputX(e.getX());
        int y = this.transformInputY(e.getY());
        if (this.currentCommand != null) {
            this.setCommand(this.currentCommand.doMousePressed(e, x, y));
            this.repaint();
            return;
        }
        if (e.isMetaDown()) {
            return;
        }
        if (this.mousePressedInner(e)) {
            return;
        }
        Glyph glyph = nearestGlyph = this.highlightedGlyph != null ? this.highlightedGlyph : this.findGlyph(x, y);
        if (nearestGlyph == null) {
            this.clearSelection();
            this.setCommand(new DragRectCommand(this, (AWTEvent)e, x, y));
            return;
        }
        boolean alreadySelected = this.isSelected(nearestGlyph);
        boolean bl = shouldClearSelection = !e.isShiftDown() && !e.isControlDown();
        if (!alreadySelected) {
            if (shouldClearSelection) {
                this.clearSelection();
            }
            this.addSelection(nearestGlyph);
        } else if (e.isShiftDown()) {
            this.removeSelection(nearestGlyph);
        }
        if (e.getClickCount() > 1) {
            this.doDoubleClick(nearestGlyph);
            return;
        }
        this.dragCommand = nearestGlyph.getMoveCommand(this, e, x, y);
    }

    protected void doDoubleClick(Glyph nearestGlyph) {
    }

    public boolean mousePressedInner(MouseEvent e) {
        int x = this.transformInputX(e.getX());
        int y = this.transformInputY(e.getY());
        int idx = -1;
        for (int i = 0; idx < 0 && i < this.shapeGroup.size(); ++i) {
            JToggleButton tb = (JToggleButton)this.shapeGroup.get(i);
            if (!tb.isSelected()) continue;
            idx = i;
        }
        if (idx <= 0) {
            return false;
        }
        --idx;
        if (!this.selectionSticky) {
            this.selectButton.setSelected(true);
            this.togglePressed(this.selectButton);
        }
        List shapeDescriptors = this.getShapeDescriptors();
        ShapeDescriptor sd = (ShapeDescriptor)shapeDescriptors.get(idx);
        Glyph glyph = this.createGlyph(sd.className, this.snap(x), this.snap(y));
        if (glyph != null) {
            sd.initializeGlyph(glyph);
            glyph.initDone();
            glyph.setId(this.getGlyphId());
            this.addGlyph(glyph);
            this.clearSelection();
            this.setCommand(glyph.getCreateCommand(this, e, x, y));
        }
        return true;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.setHighlight(null);
        if (this.dragCommand != null) {
            this.setCommand(this.dragCommand);
            this.dragCommand = null;
        }
        int x = this.transformInputX(e.getX());
        int y = this.transformInputY(e.getY());
        if (this.currentCommand != null) {
            this.mouseWasPressed = false;
            this.setCommand(this.currentCommand.doMouseDragged(e, x, y));
            return;
        }
    }

    public void loadXml(Element root) {
        XmlNodeList glyphs = XmlUtil.getElements(root, "glyph");
        for (int i = 0; i < glyphs.getLength(); ++i) {
            Element element = (Element)glyphs.item(i);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getClickCount() > 1) {
            return;
        }
        int x = this.transformInputX(e.getX());
        int y = this.transformInputY(e.getY());
        this.mouseWasPressed = false;
        if (this.currentCommand != null) {
            this.setCommand(this.currentCommand.doMouseReleased(e, x, y));
        }
    }

    private void initColors() {
        this.colorList = new Vector();
        this.colorList.add(new TwoFacedObject((Object)"black", Color.black));
        this.colorList.add(new TwoFacedObject((Object)"blue", Color.blue));
        this.colorList.add(new TwoFacedObject((Object)"cyan", Color.cyan));
        this.colorList.add(new TwoFacedObject((Object)"dark gray", Color.darkGray));
        this.colorList.add(new TwoFacedObject((Object)"gray", Color.gray));
        this.colorList.add(new TwoFacedObject((Object)"green", Color.green));
        this.colorList.add(new TwoFacedObject((Object)"light gray", Color.lightGray));
        this.colorList.add(new TwoFacedObject((Object)"magenta", Color.magenta));
        this.colorList.add(new TwoFacedObject((Object)"orange", Color.orange));
        this.colorList.add(new TwoFacedObject((Object)"pink", Color.pink));
        this.colorList.add(new TwoFacedObject((Object)"red", Color.red));
        this.colorList.add(new TwoFacedObject((Object)"yellow", Color.yellow));
        this.colorList.add(new TwoFacedObject((Object)"white", Color.white));
    }

    public ShapeDescriptor makeDescriptor(String className, String name, String iconName, String attrs) {
        return new ShapeDescriptor(className, name, iconName, attrs);
    }

    public static class ShapeDescriptor {
        String className;
        String name;
        String iconName;
        String attrs;

        public ShapeDescriptor(String className, String name, String iconName, String attrs) {
            this.className = className;
            this.name = name;
            this.iconName = iconName;
            this.attrs = attrs;
        }

        public void initializeGlyph(Glyph g) {
            g.processAttrs(this.attrs);
        }
    }
}

