/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui.drawing;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import ucar.unidata.ui.drawing.CanvasCommand;
import ucar.unidata.ui.drawing.EditCanvas;

class DragRectCommand
extends CanvasCommand {
    int anchorX;
    int anchorY;
    int currentX;
    int currentY;

    public DragRectCommand(EditCanvas canvas, AWTEvent firstEvent, int x, int y) {
        super(canvas, firstEvent, x, y);
        this.anchorX = x;
        this.anchorY = y;
        this.currentX = x;
        this.currentY = y;
    }

    @Override
    public boolean doesChangeGlyphs() {
        return false;
    }

    @Override
    public void doPaint(Graphics g) {
        g.setColor(Color.lightGray);
        Rectangle r = this.canvas.transformOutput(this.getRect());
        g.drawRect(r.x, r.y, r.width, r.height);
    }

    Rectangle getRect() {
        return new Rectangle(this.anchorX < this.currentX ? this.anchorX : this.currentX, this.anchorY < this.currentY ? this.anchorY : this.currentY, Math.abs(this.anchorX - this.currentX), Math.abs(this.anchorY - this.currentY));
    }

    @Override
    public CanvasCommand doMouseDragged(MouseEvent e, int x, int y) {
        this.currentX = x;
        this.currentY = y;
        this.canvas.repaint();
        return this;
    }

    @Override
    public CanvasCommand doMouseReleased(MouseEvent e, int x, int y) {
        this.canvas.select(this.getRect());
        this.canvas.repaint();
        return null;
    }

    @Override
    protected void doComplete() {
    }
}

