/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui.drawing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import ucar.unidata.ui.drawing.Glyph;
import ucar.unidata.ui.drawing.GroupGlyph;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;

public class DisplayCanvas
extends JPanel {
    public static final String CMD_CREATE = "create";
    public static final String CMD_TOFRONT = "tofront";
    public static final String CMD_TOBACK = "toback";
    public static final String CMD_CHANGE = "change";
    public static final String CMD_REMOVE = "remove";
    public static final String CMD_MOVE = "move";
    public static final Cursor DEFAULT_CURSOR = new Cursor(0);
    public static final Cursor HAND_CURSOR = new Cursor(12);
    public static final Cursor MOVE_CURSOR = new Cursor(13);
    public static final Cursor TEXT_CURSOR = new Cursor(2);
    public static final Cursor NW_CURSOR = new Cursor(6);
    public int gridSpacing = 20;
    public boolean showGrid = false;
    protected double scaleFactor = 1.0;
    protected Color canvasBg = Color.white;
    protected List glyphs = new ArrayList();
    List selectionSet = new ArrayList();
    List cutBuffer;
    protected Glyph highlightedGlyph = null;
    int glyphCnt = 0;
    private Component contents;

    public void setCanvasBackground(Color c) {
        this.canvasBg = c;
        this.repaint();
    }

    protected List getGlyphs() {
        return this.glyphs;
    }

    protected void setGlyphs(List newGlyphs) {
        this.glyphs = newGlyphs;
        this.clearSelection();
        this.repaint();
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    public Component getContents() {
        if (this.contents == null) {
            this.contents = this.doMakeContents();
        }
        return this.contents;
    }

    public int snap(int p) {
        if (this.getShowGrid()) {
            int dx = p % this.gridSpacing;
            p -= dx;
        }
        return p;
    }

    public void setShowGrid(boolean value) {
        this.showGrid = value;
        this.repaint();
    }

    public boolean getShowGrid() {
        return this.showGrid;
    }

    public void increaseGridSpacing() {
        this.gridSpacing += 2;
        this.repaint();
    }

    public void decreaseGridSpacing() {
        this.gridSpacing -= 2;
        if (this.gridSpacing < 2) {
            this.gridSpacing = 2;
        }
        this.repaint();
    }

    protected Component doMakeContents() {
        return this;
    }

    public void paintGrid(Graphics g) {
        int i;
        if (!this.showGrid) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform at = g2d.getTransform();
        double tx = at.getTranslateX();
        double ty = at.getTranslateY();
        Rectangle b = this.getBounds();
        Stroke oldStroke = g2d.getStroke();
        BasicStroke stroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{4.0f, 4.0f}, 0.0f);
        g2d.setStroke(stroke);
        g2d.setColor(Color.lightGray);
        for (i = 0; i < b.width; i += this.gridSpacing) {
            g.drawLine(i, 0, i, b.height);
        }
        for (i = 0; i < b.height; i += this.gridSpacing) {
            g.drawLine(0, i, b.width, i);
        }
        g2d.setStroke(oldStroke);
    }

    @Override
    public void paint(Graphics g) {
        Rectangle gb;
        Glyph glyph;
        int i;
        Rectangle clip = g.getClipBounds();
        if (clip != null) {
            clip.x -= 2;
            clip.y -= 2;
            clip.width += 4;
            clip.height += 4;
        }
        if (clip != null) {
            clip = this.transformInput(clip);
        }
        clip = null;
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).scale(this.scaleFactor, this.scaleFactor);
        }
        for (i = 0; i < this.glyphs.size(); ++i) {
            glyph = (Glyph)this.glyphs.get(i);
            gb = glyph.getBounds();
            if (clip != null && !clip.intersects(gb)) continue;
            glyph.paint(g, this);
        }
        for (i = 0; i < this.selectionSet.size(); ++i) {
            glyph = (Glyph)this.selectionSet.get(i);
            gb = glyph.getBounds();
            if (clip != null && !clip.intersects(gb)) continue;
            glyph.paintSelection(g, this);
        }
    }

    public Glyph createGlyph(String glyphClass, int x, int y) {
        Constructor ctor;
        Class c = null;
        try {
            c = Misc.findClass(glyphClass);
        }
        catch (Exception exc) {
            LogUtil.logException("Creating glyph:" + glyphClass, exc);
            return null;
        }
        Glyph g = null;
        if (g == null) {
            try {
                ctor = c.getConstructor(DisplayCanvas.class, Integer.TYPE, Integer.TYPE);
                if (ctor != null) {
                    g = (Glyph)ctor.newInstance(this, new Integer(x), new Integer(y));
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception exc) {
                LogUtil.logException("Creating: " + glyphClass, exc);
                return null;
            }
        }
        if (g == null) {
            try {
                ctor = c.getConstructor(Integer.TYPE, Integer.TYPE);
                if (ctor != null) {
                    g = (Glyph)ctor.newInstance(new Integer(x), new Integer(y));
                }
            }
            catch (NoSuchMethodException exc) {
            }
            catch (Exception exc) {
                LogUtil.logException("Creating: " + glyphClass, exc);
                return null;
            }
        }
        if (g == null) {
            try {
                ctor = c.getConstructor(new Class[0]);
                if (ctor != null) {
                    g = (Glyph)ctor.newInstance(new Object[0]);
                }
            }
            catch (NoSuchMethodException exc) {
            }
            catch (Exception exc) {
                LogUtil.logException("Creating: " + glyphClass, exc);
                return null;
            }
        }
        if (g == null) {
            throw new IllegalArgumentException("Unable to create glyph:" + glyphClass);
        }
        return g;
    }

    public void repaint(Glyph g) {
        super.repaint();
    }

    public void addGlyph(Glyph g) {
        this.glyphs.add(g);
        this.repaint(g);
    }

    public void select(Rectangle r) {
        for (int i = 0; i < this.glyphs.size(); ++i) {
            Glyph glyph = (Glyph)this.glyphs.get(i);
            Rectangle gb = glyph.getBounds();
            if (!r.contains(gb.x, gb.y) || !r.contains(gb.x + gb.width, gb.y + gb.height)) continue;
            this.addSelection(glyph);
        }
    }

    public void selectionChanged() {
    }

    public boolean hasSelection() {
        return this.selectionSet.size() > 0;
    }

    public void addSelection(Glyph g) {
        if (!this.isSelected(g)) {
            this.selectionSet.add(g);
            this.selectionChanged();
            this.repaint(g);
        }
    }

    public boolean isSelected(Glyph g) {
        return this.selectionSet.contains(g);
    }

    public List getSelection() {
        return this.selectionSet;
    }

    public void clearSelection() {
        this.selectionSet.clear();
        this.selectionChanged();
        this.repaint();
    }

    public void clearAll() {
        this.glyphs.clear();
        this.highlightedGlyph = null;
        this.clearSelection();
    }

    public void notifyGlyphMoved(Glyph theGlyph) {
    }

    public void notifyGlyphMoveComplete(Glyph theGlyph) {
    }

    public void notifyGlyphCreateComplete(Glyph g, boolean diddleSelection, boolean fromPaste) {
    }

    public void notifyGlyphCreateComplete(Glyph g) {
        this.notifyGlyphCreateComplete(g, true, false);
    }

    public void removeSelection(Glyph g) {
        this.selectionSet.remove(g);
        this.selectionChanged();
        this.repaint(g);
    }

    public void justRemoveGlyph(Glyph g) {
        this.doRemove(g);
    }

    public void removeGlyph(Glyph g) {
        this.doRemove(g);
    }

    public void doRemove(Glyph g) {
        if (this.highlightedGlyph == g) {
            this.repaint(this.highlightedGlyph);
            this.setHighlight(null);
        }
        this.removeSelection(g);
        this.glyphs.remove(g);
        if (g instanceof GroupGlyph) {
            ArrayList children = new ArrayList(((GroupGlyph)g).getChildren());
            for (int i = 0; i < children.size(); ++i) {
                this.doRemove((Glyph)children.get(i));
            }
        }
        g.doRemove();
        this.repaint(g);
    }

    public void setHighlight(Glyph g) {
        this.highlightedGlyph = g;
    }

    public void glyphChanged(Glyph g) {
    }

    public Image getImage(String path) {
        return GuiUtils.getImage(path, this.getClass());
    }

    public Glyph findGlyph(String id) {
        int num = this.glyphs.size();
        for (int i = 0; i < num; ++i) {
            Glyph g = (Glyph)this.glyphs.get(i);
            if (!g.getId().equals(id)) continue;
            return g;
        }
        return null;
    }

    public Glyph findGlyph(int x, int y) {
        return DisplayCanvas.findGlyph(this.glyphs, x, y, 10.0);
    }

    public static Glyph findGlyph(List glyphs, int x, int y, double threshold) {
        int num = glyphs.size();
        double minDistance = Double.MAX_VALUE;
        Glyph minGlyph = null;
        for (int i = 0; i < num; ++i) {
            double distance;
            Glyph g = (Glyph)glyphs.get(i);
            if (!g.pickable() || !((distance = g.distance(x, y)) < threshold) || !(distance <= minDistance)) continue;
            minDistance = distance;
            minGlyph = g;
        }
        return minGlyph;
    }

    public void moveToFront(Glyph theGlyph) {
        this.glyphs.remove(theGlyph);
        this.glyphs.add(theGlyph);
        this.repaint(theGlyph);
    }

    public void moveToBack(Glyph theGlyph) {
        this.glyphs.remove(theGlyph);
        this.glyphs.add(0, theGlyph);
        this.repaint(theGlyph);
    }

    public int transformInputX(int x) {
        return x;
    }

    public int transformInputY(int x) {
        return x;
    }

    public int transformOutputX(int x) {
        return x;
    }

    public int transformOutputY(int x) {
        return x;
    }

    public Rectangle transformOutput(Rectangle r) {
        return r;
    }

    public Rectangle transformInput(Rectangle r) {
        return r;
    }

    public Point transformOutput(Point r) {
        return r;
    }

    public Point transformInput(Point r) {
        return r;
    }
}

