/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui.drawing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import ucar.unidata.ui.drawing.DisplayCanvas;
import ucar.unidata.ui.drawing.Glyph;
import ucar.unidata.ui.drawing.RectangleGlyph;

public abstract class CompositeGlyph
extends RectangleGlyph {
    List children = new ArrayList();
    boolean paintBorder = true;
    boolean strongOwnership = false;

    protected CompositeGlyph(String type, List newChildren) {
        this(type, 0, 0, newChildren);
    }

    protected CompositeGlyph(String type, int x, int y) {
        this(type, x, y, null);
    }

    protected CompositeGlyph(String type) {
        this(type, 0, 0, null);
    }

    protected CompositeGlyph(String type, int x, int y, List newChildren) {
        super(type, x, y, 1, 1);
        if (newChildren != null) {
            for (int i = 0; i < newChildren.size(); ++i) {
                this.addChild((Glyph)newChildren.get(i));
            }
        }
    }

    public void childChanged(Glyph g) {
        this.calculateBounds();
    }

    public void removeChild(Glyph g) {
        this.children.remove(g);
        this.calculateBounds();
    }

    public List getChildren() {
        return this.children;
    }

    public void unGroup() {
        for (int i = 0; i < this.children.size(); ++i) {
            Glyph child = (Glyph)this.children.get(i);
            if (this.strongOwnership) {
                child.doRemove();
            }
            child.setParent(null);
        }
        this.children.clear();
    }

    @Override
    public double distance(int x, int y) {
        if (!this.getBoundsFromChildren() || this.children.size() == 0) {
            return super.distance(x, y);
        }
        double min = this.paintBorder ? super.distance(x, y) : Double.MAX_VALUE;
        for (int i = 0; i < this.children.size(); ++i) {
            Glyph child = (Glyph)this.children.get(i);
            min = Math.min(child.distance(x, y), min);
        }
        return min;
    }

    public void addChild(Glyph g) {
        this.addChild(g, true);
    }

    public void addChild(Glyph g, boolean calculateBounds) {
        this.children.add(g);
        g.setParent(this);
        if (calculateBounds) {
            this.calculateBounds();
        }
    }

    public boolean getBoundsFromChildren() {
        return true;
    }

    public void calculateBounds() {
        if (!this.getBoundsFromChildren() || this.children.size() == 0) {
            return;
        }
        this.bounds = null;
        for (int i = 0; i < this.children.size(); ++i) {
            Glyph child = (Glyph)this.children.get(i);
            Rectangle cb = child.getBounds();
            if (this.bounds == null) {
                this.bounds = new Rectangle(cb);
                continue;
            }
            this.bounds.add(cb);
        }
        if (this.bounds == null) {
            this.bounds = new Rectangle(0, 0, 0, 0);
        } else {
            this.bounds.x -= 2;
            this.bounds.y -= 2;
            this.bounds.width += 4;
            this.bounds.height += 4;
        }
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        CompositeGlyph clonedObject = (CompositeGlyph)super.clone();
        return clonedObject;
    }

    @Override
    public void paint(Graphics g, DisplayCanvas c) {
        this.paintChildren(g, c);
    }

    protected void paintChildren(Graphics g, DisplayCanvas c) {
        if (this.strongOwnership) {
            for (int i = 0; i < this.children.size(); ++i) {
                Glyph child = (Glyph)this.children.get(i);
                child.paint(g, c);
            }
        }
        if (this.paintBorder) {
            g.setColor(Color.lightGray);
            Rectangle r = this.bounds;
            g.drawRect(r.x - 1, r.y - 1, r.width + 2, r.height + 2);
        }
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        for (int i = 0; i < this.children.size(); ++i) {
            Glyph child = (Glyph)this.children.get(i);
            child.setForeground(c);
        }
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        for (int i = 0; i < this.children.size(); ++i) {
            Glyph child = (Glyph)this.children.get(i);
            child.setBackground(c);
        }
    }

    @Override
    public void setLineWidth(int c) {
        super.setLineWidth(c);
        for (int i = 0; i < this.children.size(); ++i) {
            Glyph child = (Glyph)this.children.get(i);
            child.setLineWidth(c);
        }
        this.calculateBounds();
    }

    @Override
    public void setFilled(boolean c) {
        super.setFilled(c);
        for (int i = 0; i < this.children.size(); ++i) {
            Glyph child = (Glyph)this.children.get(i);
            child.setFilled(c);
        }
    }

    @Override
    public String getStretchPoint(int x, int y) {
        return "MM";
    }

    @Override
    public String stretchTo(int x, int y, String pt, boolean correct) {
        super.stretchTo(x, y, pt, correct);
        for (int i = 0; i < this.children.size(); ++i) {
            Glyph child = (Glyph)this.children.get(i);
            child.stretchTo(x, y, pt, correct);
        }
        this.calculateBounds();
        return pt;
    }

    @Override
    public void moveTo(int x, int y) {
        Point delta = new Point(x - this.bounds.x, y - this.bounds.y);
        this.bounds.x = x;
        this.bounds.y = y;
        for (int i = 0; i < this.children.size(); ++i) {
            Glyph child = (Glyph)this.children.get(i);
            child.moveBy(delta.x, delta.y);
        }
        this.calculateBounds();
    }

    @Override
    public String getAttrs() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.children.size(); ++i) {
            Glyph child = (Glyph)this.children.get(i);
            if (i > 0) {
                sb.append(",");
            }
            sb.append(child.getId());
        }
        return this.makeAttr("children", sb.toString()) + super.getAttrs();
    }

    @Override
    public void setAttr(String name, String value) {
        if ("children".equals(name)) {
            Glyph child;
            StringTokenizer st = new StringTokenizer(value, ",");
            for (int i = 0; i < this.children.size(); ++i) {
                child = (Glyph)this.children.get(i);
                child.setParent(null);
            }
            this.children.clear();
            while (st.hasMoreTokens()) {
                String cId = st.nextToken();
                child = (Glyph)idToGlyph.get(cId);
                if (child == null) continue;
                this.addChild(child, false);
            }
            this.calculateBounds();
        } else {
            super.setAttr(name, value);
        }
    }
}

