/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui.colortable;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import ucar.unidata.ui.ImageUtils;
import ucar.unidata.ui.colortable.ColorTableCanvas;
import ucar.unidata.ui.colortable.ColorTableDefaults;
import ucar.unidata.ui.colortable.ColorTableEditor;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.NamedObject;
import ucar.unidata.util.ObjectListener;
import ucar.unidata.util.PatternFileFilter;
import ucar.unidata.util.ResourceCollection;
import ucar.unidata.util.ResourceManager;
import ucar.unidata.util.StringUtil;
import ucar.unidata.xml.XmlEncoder;

public class ColorTableManager
extends ResourceManager {
    private static ColorTableManager manager;
    public static final String NAME_DEFAULT = "default";
    public static final String PROP_COLORTABLE = "prop.colortable";
    public static final String PROP_RANGE = "prop.range";
    public static final String PROP_CANCEL = "prop.cancel";
    public static final String PROP_CLOSE = "prop.close";
    public String TAG_COLORTABLES = "colortables";
    public String TAG_COLORTABLE = "colortable";
    public String TAG_NAME = "name";
    private XmlEncoder encoder;
    public static final PatternFileFilter FILTER_IDV;
    public static final PatternFileFilter FILTER_GEM;
    public static final PatternFileFilter FILTER_MCI;
    public static final PatternFileFilter FILTER_PAL;
    public static final PatternFileFilter FILTER_ACT;
    public static final PatternFileFilter FILTER_AWIPS2;
    boolean didit = false;

    @Override
    public void doExport(NamedObject object, String file) {
        if (!ImageUtils.isImage(file)) {
            super.doExport(object, file);
            return;
        }
        try {
            Image image = ColorTableCanvas.getImage((ColorTable)object, 200, 30);
            ImageUtils.writeImageToFile(image, new File(file));
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    public static void setManager(ColorTableManager theManager) {
        manager = theManager;
    }

    public static ColorTableManager getManager() {
        return manager;
    }

    @Override
    public List getWriteFileFilters() {
        return Misc.newList(FILTER_IDV, FILTER_GEM);
    }

    @Override
    public List getReadFileFilters() {
        List filters = Misc.newList(FILTER_IDV, FILTER_GEM, FILTER_MCI);
        filters.addAll(Misc.newList(FILTER_PAL, FILTER_ACT, FILTER_AWIPS2));
        return filters;
    }

    @Override
    public String getTitle() {
        return "Color table";
    }

    public List getColorTables() {
        return this.getResources();
    }

    public List getCategories() {
        Hashtable<String, String> map = new Hashtable<String, String>();
        List colorTables = this.getColorTables();
        for (int i = 0; i < colorTables.size(); ++i) {
            ColorTable ct = (ColorTable)colorTables.get(i);
            if (ct.getCategory() == null) continue;
            map.put(ct.getCategory(), "");
        }
        ArrayList categories = new ArrayList();
        Enumeration e = map.keys();
        while (e.hasMoreElements()) {
            categories.add(e.nextElement());
        }
        return categories;
    }

    public ColorTable getDefaultColorTable() {
        return this.getColorTable(NAME_DEFAULT);
    }

    public ColorTable getColorTable(String name) {
        return (ColorTable)this.getObject(name);
    }

    public ColorTableEditor edit(ColorTable colorTable, PropertyChangeListener listener) {
        ColorTableEditor cte = new ColorTableEditor(this, new ColorTable(colorTable), listener);
        cte.show();
        return cte;
    }

    public void makeColorTableMenu(ObjectListener listener, List l) {
        this.makeColorTableMenu(listener, l, false);
    }

    public JLabel getLabel(String colorTableName) {
        ColorTable ct = this.getColorTable(colorTableName);
        if (ct == null) {
            return null;
        }
        Icon icon = ColorTableCanvas.getIcon(ct);
        return new JLabel(icon);
    }

    private void doit() {
        this.didit = true;
        List tables = this.getColorTables();
        try {
            for (int i = 0; i < tables.size(); ++i) {
                ColorTable ct = (ColorTable)tables.get(i);
                Image image = ColorTableCanvas.getImage(ct, 100, 20);
                String name = IOUtil.cleanFileName(ct.getName());
                name = name.replace(" ", "_");
                ImageUtils.writeImageToFile(image, name + ".png");
                System.out.println("colortable." + ct.getName() + ".icon" + "=" + name + ".png");
                System.out.println("colortable." + ct.getName() + ".category" + "=" + ct.getCategory());
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void makeColorTableMenu(final ObjectListener listener, List l, boolean showLocal) {
        int listIndex = l.size();
        Hashtable<String, JMenu> categories = new Hashtable<String, JMenu>();
        List tables = this.getColorTables();
        ArrayList<JMenuItem> items = null;
        for (int i = 0; i < tables.size(); ++i) {
            ColorTable ct = (ColorTable)tables.get(i);
            Icon icon = ColorTableCanvas.getIcon(ct);
            String name = GuiUtils.getLocalName(ct.getName(), this.isUsers(ct) && showLocal);
            JMenuItem item = icon != null ? new JMenuItem(name, icon) : new JMenuItem(name);
            item.addActionListener(new ObjectListener(ct){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    listener.actionPerformed(ae, (ColorTable)this.theObject);
                }
            });
            String category = ct.getCategory();
            if (category == null || category.trim().length() == 0) {
                if (items == null) {
                    items = new ArrayList<JMenuItem>();
                }
                items.add(item);
                continue;
            }
            List<String> cats = StringUtil.split(category, ">", true, true);
            JMenu categoryMenu = null;
            String catSoFar = "";
            String menuCategory = "";
            for (int catIdx = 0; catIdx < cats.size(); ++catIdx) {
                String subCat = cats.get(catIdx);
                JMenu m = (JMenu)categories.get(catSoFar = catSoFar + "/" + subCat);
                if (m == null) {
                    m = new JMenu(subCat);
                    menuCategory = catSoFar;
                    categories.put(catSoFar, m);
                    if (categoryMenu != null) {
                        categoryMenu.add((Component)m, 0);
                    } else {
                        l.add(m);
                    }
                }
                categoryMenu = m;
            }
            if (categoryMenu == null) {
                categoryMenu = new JMenu("");
                categories.put(ct.getCategory(), categoryMenu);
                l.add(categoryMenu);
                menuCategory = ct.getCategory();
            }
            categoryMenu.add(item);
        }
        if (items != null) {
            l.addAll(listIndex, items);
        }
        GuiUtils.limitMenuSize(l, "Group", 20);
    }

    public static void main(String[] args) {
        ArrayList<Object> theList = new ArrayList<Object>();
        int startIdx = 0;
        if (args.length == 0 || !args[0].equals("-merge")) {
            theList.addAll(ColorTableDefaults.createColorTables());
        } else {
            startIdx = 1;
        }
        for (int i = startIdx; i < args.length; ++i) {
            try {
                System.err.println("Processing:" + args[i]);
                String contents = IOUtil.readContents(args[i], ColorTableManager.class);
                if (contents == null) {
                    System.err.println("Failed to read:" + args[i]);
                    continue;
                }
                Object o = new XmlEncoder().toObject(contents);
                if (o == null) {
                    System.err.println("Failed to process:" + args[i]);
                    continue;
                }
                if (o instanceof Collection) {
                    theList.addAll((Collection)o);
                    continue;
                }
                if (o instanceof ColorTable) {
                    theList.add(o);
                    continue;
                }
                System.err.println("Unknown object:" + o.getClass().getName());
                continue;
            }
            catch (Exception exc) {
                System.err.println("Error processing:" + args[i]);
                exc.printStackTrace();
            }
        }
        String xml = new XmlEncoder().toXml(theList);
        System.out.println(xml);
    }

    private boolean isGempakFile(String file) {
        return file.toLowerCase().endsWith(".tbl");
    }

    @Override
    protected String getExportContents(NamedObject object, String file) {
        if (!this.isGempakFile(file)) {
            return super.getExportContents(object, file);
        }
        StringBuffer c = new StringBuffer("!\n!This table was created from the IDV's " + object + " color table\n");
        ColorTable ct = (ColorTable)object;
        float[][] table = ct.getColorTable();
        String template = "                       red    green    blue ";
        c.append("!");
        c.append("                       red    green  blue ");
        c.append("\n!\n");
        String[] names = new String[]{"red", "green", "blue"};
        for (int i = 0; i < table[0].length; ++i) {
            String line = template;
            for (int ci = 0; ci < 3; ++ci) {
                float v = table[ci][i] * 255.0f;
                line = StringUtil.replace(line, names[ci], StringUtil.padLeft("" + (int)v, 3));
            }
            c.append(line);
            c.append("\n");
        }
        return c.toString();
    }

    @Override
    protected Object initResource(ResourceCollection resources, int index) {
        String file = (String)resources.get(index);
        try {
            List cts = this.processSpecial(file, resources.getProperty("name", index), resources.getProperty("category", index));
            if (cts != null) {
                return cts;
            }
        }
        catch (IOException ioe) {
            return null;
        }
        return super.initResource(resources, index);
    }

    private List processSpecial(String file, String name, String category) throws IOException {
        String cat = category;
        if (name == null) {
            name = IOUtil.stripExtension(IOUtil.getFileTail(file));
        }
        if (cat == null) {
            cat = "Basic";
        }
        String suffix = file.toLowerCase();
        ArrayList<ColorTable> cts = new ArrayList<ColorTable>();
        if (suffix.endsWith(".et")) {
            if (category == null) {
                cat = "Satellite";
            }
            cts.add(ColorTableDefaults.createColorTable(name, cat, ColorTableDefaults.makeTableFromET(file, false)));
        } else if (suffix.endsWith(".pa1")) {
            cts.add(ColorTableDefaults.createColorTable(name, cat, ColorTableDefaults.makeTableFromPal1(file)));
        } else if (suffix.endsWith(".pa2")) {
            cts.add(ColorTableDefaults.createColorTable(name, cat, ColorTableDefaults.makeTableFromPal2(file)));
        } else if (suffix.endsWith(".pal")) {
            cts.add(ColorTableDefaults.createColorTable(name, cat, ColorTableDefaults.makeTableFromPal(file)));
        } else if (suffix.endsWith(".act")) {
            cts.add(ColorTableDefaults.createColorTable(name, cat, ColorTableDefaults.makeTableFromAct(file)));
        } else if (suffix.endsWith(".ncmap")) {
            cts.addAll(ColorTableDefaults.makeGempakColorTables(name, cat, file));
        } else if (suffix.endsWith(".gp")) {
            cts.addAll(ColorTableDefaults.makeNclRgbColorTables(name, cat, file, null));
        } else if (this.isGempakFile(file)) {
            cts.addAll(ColorTableDefaults.makeGempakColorTables(name, cat, file));
        } else if (suffix.endsWith(".rgb")) {
            cts.addAll(ColorTableDefaults.makeRgbColorTables(name, cat, file));
        } else if (suffix.endsWith(".cmap")) {
            cts.addAll(ColorTableDefaults.makeAwips2ColorTables(name, cat, file));
        } else {
            return null;
        }
        if (cts.size() == 0) {
            return null;
        }
        return cts;
    }

    @Override
    public NamedObject doImport(boolean makeUnique) {
        String file = FileManager.getReadFile(this.getTitle() + " import", this.getReadFileFilters());
        if (file == null) {
            return null;
        }
        try {
            List cts = this.processSpecial(file, null, null);
            if (cts != null) {
                return this.doImport(cts, makeUnique);
            }
        }
        catch (IOException ioe) {
            LogUtil.printException(log_, "Error reading file: " + file, ioe);
            return null;
        }
        try {
            String xml = IOUtil.readContents(file, ResourceManager.class);
            if (xml == null) {
                return null;
            }
            Object o = new XmlEncoder().toObject(xml);
            return this.doImport(o, makeUnique);
        }
        catch (Exception exc) {
            LogUtil.printException(log_, "Error reading file: " + file, exc);
            return null;
        }
    }

    static {
        FILTER_IDV = new PatternFileFilter(".+\\.xml", "IDV color table (*.xml)", ".xml");
        FILTER_GEM = new PatternFileFilter(".+\\.tbl", "GEMPAK color table (*.tbl)", ".tbl");
        FILTER_MCI = new PatternFileFilter(".+\\.et", "McIDAS color table (*.et)", ".et");
        FILTER_PAL = new PatternFileFilter("(.+\\.pal|.+\\.pa1|.+\\.pa2)", "PAL color table (*.pal,*.pa1,*.pa2)");
        FILTER_ACT = new PatternFileFilter(".+\\.act", "ACT color table (*.act)");
        FILTER_AWIPS2 = new PatternFileFilter(".+\\.cmap", "AWIPS II color table (*.cmap)", ".cmap");
    }
}

