/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui.colortable;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import ucar.unidata.ui.Help;
import ucar.unidata.ui.WindowHolder;
import ucar.unidata.ui.colortable.ColorTableCanvas;
import ucar.unidata.ui.colortable.ColorTableDefaults;
import ucar.unidata.ui.colortable.ColorTableManager;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Msg;
import ucar.unidata.util.ObjectListener;
import ucar.unidata.util.Range;

public class ColorTableEditor
extends WindowHolder {
    public static LogUtil.LogCategory log_ = LogUtil.getLogInstance(ColorTableEditor.class.getName());
    private String originalName;
    private ColorTableCanvas canvas;
    private boolean ok = false;
    private ColorTable theColorTable;
    private boolean standalone = false;
    private JMenuItem deleteMenuItem;
    private JMenu viewMenu;
    private int colorTableListVersion = 0;
    private ColorTableManager ctm;
    private boolean haveInited = false;
    private PropertyChangeListener listener;
    private static String HELP_TOP_DIR = "/auxdata/docs/userguide";

    public ColorTableEditor(ColorTableManager colorTableManager) {
        this(colorTableManager, null);
        this.standalone = true;
    }

    public ColorTableEditor(ColorTableManager colorTableManager, ColorTable table) {
        this(colorTableManager, table, null);
    }

    public ColorTableEditor(ColorTableManager colorTableManager, ColorTable table, PropertyChangeListener listener) {
        this.ctm = colorTableManager;
        this.theColorTable = table;
        this.listener = listener;
    }

    @Override
    public void show() {
        if (!this.haveInited) {
            this.init(this.theColorTable, this.listener);
        }
        super.show();
    }

    public ColorTableManager getColorTableManager() {
        return this.ctm;
    }

    public String getColorTableName() {
        ColorTable current;
        if (this.canvas != null && (current = this.canvas.getCurrentColorTable()) != null) {
            return current.getName().trim();
        }
        return this.theColorTable != null ? this.theColorTable.getName().trim() : "";
    }

    private void init(ColorTable table, PropertyChangeListener listener) {
        this.haveInited = true;
        this.theColorTable = table;
        if (this.theColorTable == null) {
            this.theColorTable = this.ctm.getDefaultColorTable();
        }
        if (this.theColorTable == null) {
            this.theColorTable = ColorTableDefaults.createColorTable(new ArrayList(), "Default", "Basic", ColorTableDefaults.grayTable(256, true));
        }
        this.canvas = new ColorTableCanvas(this, this.theColorTable);
        this.originalName = this.getColorTableName();
        if (listener != null) {
            this.canvas.addPropertyChangeListener(listener);
        }
        JPanel buttons = this.standalone ? GuiUtils.makeButtons(this, new String[]{GuiUtils.CMD_CLOSE}) : GuiUtils.makeButtons(this, new String[]{GuiUtils.CMD_APPLY, GuiUtils.CMD_OK, GuiUtils.CMD_CANCEL});
        final JCheckBox propagateChanges = new JCheckBox("Auto update", true);
        propagateChanges.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                ColorTableEditor.this.canvas.setPropagateChanges(propagateChanges.isSelected());
            }
        });
        JPanel bottom = GuiUtils.hbox((Component)buttons, listener != null ? propagateChanges : new JLabel(""));
        JMenuBar menuBar = this.doMakeMenuBar();
        this.contents = GuiUtils.topCenterBottom(menuBar, this.canvas.getContents(), bottom);
        this.setMenuBar(menuBar);
        this.setDialogTitle();
        this.show();
    }

    @Override
    public String getWindowTitle() {
        return GuiUtils.getApplicationTitle() + "Color Table Editor";
    }

    public void updateViewMenu(JMenu m) {
        if (this.colorTableListVersion != this.ctm.getResourceTimestamp()) {
            this.doMakeViewMenu();
        }
    }

    protected JMenuBar doMakeMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        this.doMakeFileMenu(fileMenu);
        this.viewMenu = GuiUtils.makeDynamicMenu("Color Tables", this, "updateViewMenu", false);
        this.doMakeViewMenu();
        Msg.addDontRecurseComponent(this.viewMenu);
        menuBar.add(fileMenu);
        menuBar.add(this.viewMenu);
        JMenu helpMenu = new JMenu("Help");
        JMenuItem helpMenuItem = new JMenuItem("User's Guide");
        helpMenu.add(helpMenuItem);
        helpMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ColorTableEditor.this.showHelp();
            }
        });
        menuBar.add(helpMenu);
        return menuBar;
    }

    public ColorTableCanvas getCanvas() {
        return this.canvas;
    }

    protected void doMakeFileMenu(JMenu fileMenu) {
        JMenuItem mi = new JMenuItem("New");
        fileMenu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorTableEditor.this.doNew();
            }
        });
        fileMenu.addSeparator();
        mi = new JMenuItem("Save");
        fileMenu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorTableEditor.this.doSave();
            }
        });
        mi = new JMenuItem("Save As...");
        fileMenu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorTableEditor.this.doSaveAs();
            }
        });
        this.deleteMenuItem = new JMenuItem("Remove");
        this.deleteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String originalName = ColorTableEditor.this.getColorTableName();
                if (!GuiUtils.showYesNoDialog(ColorTableEditor.this.dialog, "Are you sure you want to remove the " + originalName + " color table?", "Confirm")) {
                    return;
                }
                ColorTableEditor.this.ctm.removeUsers(ColorTableEditor.this.theColorTable);
                ColorTable newTable = ColorTableEditor.this.ctm.getColorTable(originalName);
                if (newTable == null) {
                    newTable = ColorTableEditor.this.getColorTableManager().getDefaultColorTable();
                }
                ColorTableEditor.this.setColorTable(newTable);
                ColorTableEditor.this.doMakeViewMenu();
            }
        });
        fileMenu.addSeparator();
        fileMenu.add(this.deleteMenuItem);
        fileMenu.addSeparator();
        mi = new JMenuItem("Import...");
        fileMenu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorTableEditor.this.doImport();
            }
        });
        mi = new JMenuItem("Export...");
        fileMenu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorTableEditor.this.doExport();
            }
        });
        fileMenu.addSeparator();
        mi = new JMenuItem("Close");
        fileMenu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorTableEditor.this.doClose();
            }
        });
    }

    public void doMakeViewMenu() {
        this.colorTableListVersion = this.ctm.getResourceTimestamp();
        this.checkDeleteMenu();
        this.viewMenu.removeAll();
        ArrayList menus = new ArrayList();
        this.ctm.makeColorTableMenu(new ObjectListener(null){

            @Override
            public void actionPerformed(ActionEvent ae, Object data) {
                ColorTableEditor.this.setColorTable((ColorTable)data);
            }
        }, menus, true);
        for (int i = 0; i < menus.size(); ++i) {
            this.viewMenu.add((JMenuItem)menus.get(i));
        }
    }

    private void doImport() {
        ColorTable ct = (ColorTable)this.ctm.doImport();
        if (ct == null) {
            return;
        }
        this.doMakeViewMenu();
        this.setColorTable(ct);
    }

    private void doExport() {
        this.ctm.doExport(this.canvas.getCurrentColorTable());
    }

    public void setColorTable(String ctName) {
        try {
            ColorTable ct;
            if (!this.haveInited) {
                this.init(this.theColorTable, this.listener);
            }
            if ((ct = this.ctm.getColorTable(ctName)) != null) {
                this.setColorTable(ct);
            }
        }
        catch (Exception exc) {
            LogUtil.printException(log_, "Setting color table", exc);
        }
    }

    public void setColorTable(ColorTable ct) {
        try {
            if (!this.haveInited) {
                this.init(this.theColorTable, this.listener);
            }
            this.theColorTable = ct;
            this.originalName = this.getColorTableName();
            this.canvas.setColorTable(ct);
            this.checkDeleteMenu();
        }
        catch (Exception exc) {
            LogUtil.printException(log_, "Setting color table", exc);
        }
    }

    public void setRange(Range range) {
        this.canvas.setRange(range.getMin(), range.getMax());
    }

    private void checkDeleteMenu() {
        if (this.deleteMenuItem != null) {
            if (this.theColorTable != null) {
                this.deleteMenuItem.setEnabled(this.ctm.isUsers(this.theColorTable));
            } else {
                this.deleteMenuItem.setEnabled(false);
            }
        }
    }

    private void doApply() {
        this.canvas.doApply();
        this.canvas.setMinMax();
    }

    private void doSaveAs() {
        this.theColorTable = this.canvas.getCurrentColorTable();
        String newName = this.ctm.doSaveAs(this.theColorTable, this.canvas);
        if (newName == null) {
            return;
        }
        this.originalName = newName;
        this.canvas.setName(newName);
        this.doSave();
    }

    private void doSave() {
        this.theColorTable = this.canvas.getCurrentColorTable();
        this.ctm.addUsers(this.theColorTable);
        this.doMakeViewMenu();
    }

    private void doNew() {
        String newName = this.ctm.doNew(this.canvas);
        if (newName == null) {
            return;
        }
        float[][] table = ColorTableDefaults.grayTable1(32);
        ColorTable newCt = new ColorTable(newName, "Basic", table);
        this.ctm.addUsers(newCt);
        this.setColorTable(newCt);
        this.doMakeViewMenu();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.canvas.addPropertyChangeListener(listener);
    }

    public void setVisible(boolean v) {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
        }
    }

    protected void setDialogTitle() {
        this.setWindowTitle(GuiUtils.getApplicationTitle() + "Color Table Editor -- " + this.getColorTableName());
    }

    public void doClose() {
        this.ok = true;
        super.close();
        this.canvas.doClose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(GuiUtils.CMD_CLOSE)) {
            this.doClose();
        } else if (cmd.equals(GuiUtils.CMD_APPLY)) {
            this.doApply();
        } else if (cmd.equals(GuiUtils.CMD_CANCEL)) {
            this.ok = false;
            super.close();
            this.canvas.doCancel();
        } else if (cmd.equals(GuiUtils.CMD_OK)) {
            this.ok = true;
            this.doApply();
            this.canvas.doClose();
            super.close();
        } else if (cmd.equals(GuiUtils.CMD_SAVEAS)) {
            this.doSaveAs();
        } else if (cmd.equals(GuiUtils.CMD_SAVE)) {
            this.doSave();
        } else if (cmd.equals(GuiUtils.CMD_HELP)) {
            this.showHelp();
        }
    }

    public static void setHelpTopDir(String topDir) {
        HELP_TOP_DIR = topDir;
    }

    private void showHelp() {
        Help.setTopDir(HELP_TOP_DIR);
        Help.getDefaultHelp().gotoTarget("idv.tools.colortableeditor");
    }

    public boolean getOk() {
        return this.ok;
    }

    public static void main(String[] args) {
    }
}

