/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui.colortable;

import edu.wisc.ssec.mcidas.EnhancementTable;
import java.awt.Color;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import ucar.unidata.util.Resource;
import ucar.unidata.util.StringUtil;
import ucar.unidata.xml.XmlUtil;

public class ColorTableDefaults {
    public static final String NAME_DEFAULT = "default";
    private static final String NAME_BLACK = "Black";
    private static final String NAME_BLUE = "Blue";
    private static final String NAME_BLUES = "Blues";
    private static final String NAME_BREF = "Base Reflectivity";
    private static final String NAME_BREF24 = "Base Reflectivity (24)";
    private static final String NAME_BRIGHT38 = "Bright38";
    private static final String NAME_CREF = "Composite Reflectivity";
    private static final String NAME_CYAN = "Cyan";
    private static final String NAME_DBZ = "DbZ";
    private static final String NAME_DBZNWS = "DbZ(NWS)";
    private static final String NAME_GRAY = "Gray";
    private static final String NAME_GRAY_SCALE_SAT = "Light Gray scale";
    private static final String NAME_GRAY_SCALE = "Gray scale";
    private static final String NAME_INVERSE_GRAY_SCALE = "Inverse Gray shade";
    private static final String NAME_GREEN = "Green";
    private static final String NAME_H2O = "Water Vapor (Gray)";
    private static final String NAME_INVRAINBOW = "Inverse rainbow";
    private static final String NAME_INVVISAD = "Inverse VisAD";
    private static final String NAME_MAGENTA = "Magenta";
    private static final String NAME_MDR = "MDR Radar";
    private static final String NAME_ORANGE = "Orange";
    private static final String NAME_PINK = "Pink";
    private static final String NAME_PRECIP = "Precip";
    private static final String NAME_RADAR_PRECIP = "Radar Precip";
    private static final String NAME_RAINBOW = "Rainbow";
    private static final String NAME_RED = "Red";
    private static final String NAME_RH = "Relative humidity";
    private static final String NAME_RVEL = "Radial Velocity";
    private static final String NAME_TEMPERATURE = "Temperature";
    private static final String NAME_TOPO = "Topographic";
    private static final String NAME_TOPOBATHY = "Topography/Bathymetry";
    private static final String NAME_TOPOMDR = "TOPO/MDR Composite";
    private static final String NAME_TOPOSAT = "TOPO/Sat Composite";
    private static final String NAME_TOPS = "Echo Tops";
    private static final String NAME_VIL = "VIL";
    private static final String NAME_VISAD = "VisAD";
    private static final String NAME_VIS_FOG = "Visible/Fog";
    private static final String NAME_WHITE = "White";
    private static final String NAME_WINDCOMPS = "Wind comps";
    private static final String NAME_WINDSPEED = "Windspeed";
    private static final String NAME_YELLOW = "Yellow";
    private static float[][] ATD_Scook = new float[][]{{0.926f, 0.012f, 0.938f}, {0.898f, 0.035f, 0.941f}, {0.875f, 0.055f, 0.941f}, {0.836f, 0.074f, 0.938f}, {0.801f, 0.094f, 0.934f}, {0.762f, 0.113f, 0.93f}, {0.727f, 0.133f, 0.93f}, {0.688f, 0.152f, 0.926f}, {0.652f, 0.172f, 0.922f}, {0.613f, 0.195f, 0.918f}, {0.578f, 0.215f, 0.914f}, {0.543f, 0.234f, 0.91f}, {0.504f, 0.254f, 0.906f}, {0.469f, 0.277f, 0.902f}, {0.434f, 0.297f, 0.898f}, {0.398f, 0.32f, 0.895f}, {0.363f, 0.34f, 0.891f}, {0.328f, 0.363f, 0.887f}, {0.293f, 0.387f, 0.883f}, {0.258f, 0.41f, 0.879f}, {0.223f, 0.43f, 0.871f}, {0.188f, 0.453f, 0.867f}, {0.156f, 0.477f, 0.863f}, {0.121f, 0.5f, 0.859f}, {0.086f, 0.523f, 0.855f}, {0.055f, 0.547f, 0.848f}, {0.02f, 0.57f, 0.844f}, {0.016f, 0.605f, 0.816f}, {0.012f, 0.637f, 0.781f}, {0.012f, 0.66f, 0.742f}, {0.008f, 0.688f, 0.699f}, {0.008f, 0.711f, 0.656f}, {0.008f, 0.73f, 0.613f}, {0.008f, 0.754f, 0.57f}, {0.004f, 0.777f, 0.523f}, {0.004f, 0.797f, 0.48f}, {0.004f, 0.82f, 0.434f}, {0.004f, 0.84f, 0.391f}, {0.0f, 0.855f, 0.348f}, {0.0f, 0.867f, 0.301f}, {0.0f, 0.875f, 0.258f}, {0.0f, 0.871f, 0.215f}, {0.0f, 0.863f, 0.176f}, {0.0f, 0.852f, 0.141f}, {0.0f, 0.832f, 0.109f}, {0.0f, 0.812f, 0.086f}, {0.0f, 0.789f, 0.062f}, {0.0f, 0.766f, 0.047f}, {0.0f, 0.742f, 0.031f}, {0.0f, 0.719f, 0.023f}, {0.0f, 0.695f, 0.016f}, {0.0f, 0.676f, 0.012f}, {0.004f, 0.652f, 0.012f}, {0.016f, 0.637f, 0.02f}, {0.031f, 0.621f, 0.035f}, {0.062f, 0.613f, 0.062f}, {0.105f, 0.609f, 0.109f}, {0.168f, 0.613f, 0.168f}, {0.242f, 0.617f, 0.242f}, {0.324f, 0.629f, 0.324f}, {0.414f, 0.641f, 0.414f}, {0.504f, 0.652f, 0.504f}, {0.598f, 0.664f, 0.598f}, {0.781f, 0.781f, 0.781f}, {0.691f, 0.645f, 0.598f}, {0.695f, 0.621f, 0.551f}, {0.699f, 0.602f, 0.5f}, {0.703f, 0.582f, 0.453f}, {0.711f, 0.562f, 0.414f}, {0.715f, 0.551f, 0.379f}, {0.723f, 0.543f, 0.355f}, {0.73f, 0.539f, 0.34f}, {0.738f, 0.539f, 0.328f}, {0.746f, 0.539f, 0.32f}, {0.754f, 0.543f, 0.312f}, {0.77f, 0.547f, 0.309f}, {0.781f, 0.551f, 0.301f}, {0.797f, 0.555f, 0.289f}, {0.812f, 0.555f, 0.273f}, {0.828f, 0.559f, 0.258f}, {0.844f, 0.559f, 0.238f}, {0.859f, 0.559f, 0.215f}, {0.875f, 0.562f, 0.191f}, {0.895f, 0.562f, 0.168f}, {0.91f, 0.566f, 0.145f}, {0.922f, 0.57f, 0.125f}, {0.934f, 0.574f, 0.105f}, {0.945f, 0.582f, 0.086f}, {0.953f, 0.59f, 0.07f}, {0.961f, 0.602f, 0.059f}, {0.965f, 0.613f, 0.047f}, {0.969f, 0.625f, 0.043f}, {0.973f, 0.637f, 0.039f}, {0.973f, 0.648f, 0.039f}, {0.973f, 0.66f, 0.043f}, {0.973f, 0.672f, 0.055f}, {0.973f, 0.684f, 0.066f}, {0.973f, 0.691f, 0.082f}, {0.969f, 0.695f, 0.102f}, {0.969f, 0.699f, 0.121f}, {0.969f, 0.699f, 0.148f}, {0.969f, 0.695f, 0.176f}, {0.969f, 0.691f, 0.207f}, {0.973f, 0.68f, 0.238f}, {0.973f, 0.668f, 0.27f}, {0.977f, 0.652f, 0.301f}, {0.977f, 0.637f, 0.324f}, {0.98f, 0.613f, 0.352f}, {0.98f, 0.59f, 0.367f}, {0.984f, 0.566f, 0.383f}, {0.988f, 0.539f, 0.391f}, {0.988f, 0.512f, 0.395f}, {0.992f, 0.48f, 0.391f}, {0.992f, 0.449f, 0.379f}, {0.992f, 0.418f, 0.363f}, {0.996f, 0.383f, 0.344f}, {0.996f, 0.348f, 0.32f}, {0.996f, 0.312f, 0.293f}, {0.996f, 0.277f, 0.266f}, {0.996f, 0.242f, 0.234f}, {0.996f, 0.207f, 0.203f}, {0.996f, 0.172f, 0.168f}, {0.996f, 0.141f, 0.137f}, {0.996f, 0.105f, 0.105f}, {0.996f, 0.074f, 0.074f}, {0.996f, 0.047f, 0.047f}, {0.996f, 0.016f, 0.016f}};
    private static float[][] ATD_Reflectivity = new float[][]{{0.0f, 0.0f, 0.0f}, {0.23529412f, 0.23529412f, 0.23529412f}, {0.23529412f, 0.23529412f, 0.23529412f}, {0.0f, 0.27058825f, 0.0f}, {0.0f, 0.27058825f, 0.0f}, {0.0f, 0.39607844f, 0.039215688f}, {0.0f, 0.39607844f, 0.039215688f}, {0.0f, 0.61960787f, 0.11764706f}, {0.0f, 0.61960787f, 0.11764706f}, {0.0f, 0.69411767f, 0.23137255f}, {0.0f, 0.69411767f, 0.23137255f}, {0.0f, 0.8039216f, 0.45490196f}, {0.0f, 0.8039216f, 0.45490196f}, {0.0f, 0.7490196f, 0.5882353f}, {0.0f, 0.7490196f, 0.5882353f}, {0.0f, 0.62352943f, 0.80784315f}, {0.0f, 0.62352943f, 0.80784315f}, {0.03137255f, 0.49803922f, 0.85882354f}, {0.03137255f, 0.49803922f, 0.85882354f}, {0.10980392f, 0.2784314f, 0.9098039f}, {0.10980392f, 0.2784314f, 0.9098039f}, {0.21960784f, 0.1882353f, 0.87058824f}, {0.21960784f, 0.1882353f, 0.87058824f}, {0.43137255f, 0.050980393f, 0.7764706f}, {0.43137255f, 0.050980393f, 0.7764706f}, {0.5647059f, 0.047058824f, 0.68235296f}, {0.5647059f, 0.047058824f, 0.68235296f}, {0.78431374f, 0.05882353f, 0.5254902f}, {0.78431374f, 0.05882353f, 0.5254902f}, {0.76862746f, 0.2627451f, 0.5254902f}, {0.76862746f, 0.2627451f, 0.5254902f}, {0.7529412f, 0.39215687f, 0.5294118f}, {0.7529412f, 0.39215687f, 0.5294118f}, {0.7490196f, 0.40784314f, 0.39607844f}, {0.7490196f, 0.40784314f, 0.39607844f}, {0.74509805f, 0.42352942f, 0.26666668f}, {0.74509805f, 0.42352942f, 0.26666668f}, {0.8235294f, 0.53333336f, 0.23137255f}, {0.8235294f, 0.53333336f, 0.23137255f}, {0.98039216f, 0.76862746f, 0.19215687f}, {0.98039216f, 0.76862746f, 0.19215687f}, {0.99607843f, 0.8509804f, 0.12941177f}, {0.99607843f, 0.8509804f, 0.12941177f}, {0.99607843f, 0.98039216f, 0.011764706f}, {0.99607843f, 0.98039216f, 0.011764706f}, {0.99607843f, 0.8666667f, 0.10980392f}, {0.99607843f, 0.8666667f, 0.10980392f}, {0.99607843f, 0.6039216f, 0.34509805f}, {0.99607843f, 0.6039216f, 0.34509805f}, {0.99607843f, 0.50980395f, 0.2509804f}, {0.99607843f, 0.50980395f, 0.2509804f}, {0.99607843f, 0.37254903f, 0.019607844f}, {0.99607843f, 0.37254903f, 0.019607844f}, {0.9764706f, 0.30980393f, 0.03137255f}, {0.9764706f, 0.30980393f, 0.03137255f}, {0.99215686f, 0.20392157f, 0.10980392f}, {0.99215686f, 0.20392157f, 0.10980392f}, {0.78431374f, 0.45882353f, 0.40784314f}, {0.78431374f, 0.45882353f, 0.40784314f}, {0.84313726f, 0.7176471f, 0.70980394f}, {0.84313726f, 0.7176471f, 0.70980394f}, {0.8235294f, 0.8235294f, 0.8235294f}, {0.8235294f, 0.8235294f, 0.8235294f}, {0.0f, 0.0f, 0.0f}};
    private static float[][] ATD_Velocity = new float[][]{{0.0f, 0.0f, 0.0f}, {0.99607843f, 0.0f, 0.99607843f}, {0.99607843f, 0.0f, 0.99607843f}, {0.99215686f, 0.0f, 0.99607843f}, {0.99215686f, 0.0f, 0.99607843f}, {0.972549f, 0.0f, 0.99607843f}, {0.972549f, 0.0f, 0.99607843f}, {0.87058824f, 0.0f, 0.99607843f}, {0.87058824f, 0.0f, 0.99607843f}, {0.7294118f, 0.0f, 0.99607843f}, {0.7294118f, 0.0f, 0.99607843f}, {0.6862745f, 0.0f, 0.99215686f}, {0.6862745f, 0.0f, 0.99215686f}, {0.64705884f, 0.0f, 0.9882353f}, {0.64705884f, 0.0f, 0.9882353f}, {0.54509807f, 0.0f, 0.972549f}, {0.54509807f, 0.0f, 0.972549f}, {0.44313726f, 0.003921569f, 0.9490196f}, {0.44313726f, 0.003921569f, 0.9490196f}, {0.2784314f, 0.07450981f, 0.9254902f}, {0.2784314f, 0.07450981f, 0.9254902f}, {0.07450981f, 0.21568628f, 0.8980392f}, {0.07450981f, 0.21568628f, 0.8980392f}, {0.0f, 0.43137255f, 0.8980392f}, {0.0f, 0.43137255f, 0.8980392f}, {0.0f, 0.7137255f, 0.89411765f}, {0.0f, 0.7137255f, 0.89411765f}, {0.015686275f, 0.9098039f, 0.59607846f}, {0.015686275f, 0.9098039f, 0.59607846f}, {0.007843138f, 0.45490196f, 0.29803923f}, {0.007843138f, 0.45490196f, 0.29803923f}, {0.49019608f, 0.49019608f, 0.49019608f}, {0.49019608f, 0.49019608f, 0.49019608f}, {0.8862745f, 0.75686276f, 0.52156866f}, {0.8862745f, 0.75686276f, 0.52156866f}, {0.8509804f, 0.58431375f, 0.19215687f}, {0.8509804f, 0.58431375f, 0.19215687f}, {0.93333334f, 0.72156864f, 0.12156863f}, {0.93333334f, 0.72156864f, 0.12156863f}, {0.9882353f, 0.85490197f, 0.07058824f}, {0.9882353f, 0.85490197f, 0.07058824f}, {0.99607843f, 0.85490197f, 0.12941177f}, {0.99607843f, 0.85490197f, 0.12941177f}, {0.99607843f, 0.69411767f, 0.39215687f}, {0.99607843f, 0.69411767f, 0.39215687f}, {0.99607843f, 0.5686275f, 0.5882353f}, {0.99607843f, 0.5686275f, 0.5882353f}, {0.99607843f, 0.5137255f, 0.5137255f}, {0.99607843f, 0.5137255f, 0.5137255f}, {0.99607843f, 0.42352942f, 0.22745098f}, {0.99607843f, 0.42352942f, 0.22745098f}, {0.99607843f, 0.3647059f, 0.02745098f}, {0.99607843f, 0.3647059f, 0.02745098f}, {0.99607843f, 0.3372549f, 0.0f}, {0.99607843f, 0.3372549f, 0.0f}, {0.99607843f, 0.21568628f, 0.0f}, {0.99607843f, 0.21568628f, 0.0f}, {0.99607843f, 0.050980393f, 0.0f}, {0.99607843f, 0.050980393f, 0.0f}, {0.99607843f, 0.0f, 0.0f}, {0.99607843f, 0.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}};
    private static float[][] ATD_Wild = new float[][]{{0.43137255f, 0.43137255f, 0.43137255f}, {0.33333334f, 0.33333334f, 0.49019608f}, {0.5411765f, 0.5411765f, 0.69411767f}, {0.003921569f, 0.003921569f, 0.49019608f}, {0.003921569f, 0.09019608f, 0.6666667f}, {0.003921569f, 0.003921569f, 0.8235294f}, {0.015686275f, 0.5019608f, 1.0f}, {0.015686275f, 0.75686276f, 1.0f}, {0.015686275f, 0.9882353f, 0.06666667f}, {0.015686275f, 0.6627451f, 0.06666667f}, {0.015686275f, 0.5176471f, 0.06666667f}, {0.015686275f, 0.3254902f, 0.06666667f}, {0.78431374f, 0.78431374f, 0.78431374f}, {0.654902f, 0.28235295f, 0.011764706f}, {0.8509804f, 0.58431375f, 0.3764706f}, {1.0f, 0.72156864f, 0.12156863f}, {1.0f, 1.0f, 0.011764706f}, {0.99607843f, 0.74509805f, 0.74509805f}, {0.99607843f, 0.53333336f, 0.53333336f}, {0.99607843f, 0.34117648f, 0.34117648f}, {0.99607843f, 0.46666667f, 0.0f}, {0.8745098f, 0.3137255f, 0.0f}, {0.5411765f, 0.0f, 0.0f}, {0.8235294f, 0.0f, 0.0f}, {1.0f, 0.0f, 0.0f}};
    private static float[][][] ATD_Data = new float[][][]{ATD_Scook, ATD_Reflectivity, ATD_Velocity, ATD_Wild};
    private static String[] ATD_Names = new String[]{"ATD-Scook", "ATD-Reflectivity", "ATD-Velocity", "ATD-Wild"};

    public static ColorTable createColorTable(String name, String category, float[][] table) {
        return ColorTableDefaults.createColorTable(new ArrayList(), name, category, table);
    }

    public static ColorTable createColorTable(ArrayList l, String name, String category, float[][] table) {
        return ColorTableDefaults.createColorTable(l, name, category, table, false);
    }

    public static ColorTable createColorTable(ArrayList l, String name, String category, float[][] table, boolean tableFlipped) {
        return ColorTableDefaults.createColorTable(l, name, category, table, tableFlipped, null);
    }

    public static ColorTable createColorTable(ArrayList l, String name, String category, float[][] table, boolean tableFlipped, Range range) {
        for (int i = 0; i < table.length; ++i) {
            for (int j = 0; j < table[i].length; ++j) {
                if ((double)table[i][j] < 0.0) {
                    table[i][j] = 0.0f;
                    continue;
                }
                if (!((double)table[i][j] > 1.0)) continue;
                table[i][j] = 1.0f;
            }
        }
        ColorTable colorTable = new ColorTable(name.toUpperCase(), name, category, table, tableFlipped);
        if (range != null) {
            colorTable.setRange(range);
        }
        l.add(colorTable);
        return colorTable;
    }

    public static ArrayList createColorTables() {
        int i;
        ArrayList l = new ArrayList();
        ColorTableDefaults.createColorTable(l, NAME_DEFAULT, "Basic", ColorTableDefaults.temperatureCT4());
        ColorTableDefaults.createColorTable(l, NAME_BLUES, "Basic", ColorTableDefaults.percentBlue(30));
        ColorTableDefaults.createColorTable(l, NAME_BRIGHT38, "Basic", ColorTableDefaults.bright38());
        ColorTableDefaults.createColorTable(l, NAME_PRECIP, "Basic", ColorTableDefaults.precipCT1());
        ColorTableDefaults.createColorTable(l, NAME_RH, "Basic", ColorTableDefaults.percentYelGrnBlue(20));
        ColorTableDefaults.createColorTable(l, NAME_TEMPERATURE, "Basic", ColorTableDefaults.temperatureCT4());
        ColorTableDefaults.createColorTable(l, NAME_VISAD, "Basic", ColorTableDefaults.rainbow(30));
        ColorTableDefaults.createColorTable(l, NAME_INVVISAD, "Basic", ColorTableDefaults.invRainbow(30));
        ColorTableDefaults.createColorTable(l, NAME_WINDCOMPS, "Basic", ColorTableDefaults.windSpeed(20));
        ColorTableDefaults.createColorTable(l, NAME_WINDSPEED, "Basic", ColorTableDefaults.windspeed());
        ColorTableDefaults.createColorTable(l, NAME_GRAY_SCALE, "Basic", ColorTableDefaults.grayTable(256, false));
        ColorTableDefaults.createColorTable(l, NAME_INVERSE_GRAY_SCALE, "Basic", ColorTableDefaults.grayTable(256, true));
        ColorTableDefaults.createColorTable(l, NAME_DBZ, "Radar", ColorTableDefaults.DZ2());
        ColorTableDefaults.createColorTable(l, NAME_DBZNWS, "Radar", ColorTableDefaults.DZ1());
        ColorTableDefaults.createColorTable(l, NAME_GRAY_SCALE_SAT, "Satellite", ColorTableDefaults.grayTable1(30));
        ColorTableDefaults.createColorTable(l, NAME_TOPOSAT, "Satellite", ColorTableDefaults.makeTableFromET("TOPOSAT.ET"));
        ColorTableDefaults.createColorTable(l, NAME_H2O, "Satellite", ColorTableDefaults.makeTableFromET("H2O.ET"));
        ColorTableDefaults.createColorTable(l, NAME_TOPOBATHY, "Misc.", ColorTableDefaults.makeTableFromET("TOPO.ET"), false, new Range(-12458.0, 8791.0));
        ColorTableDefaults.createColorTable(l, NAME_RADAR_PRECIP, "Radar", ColorTableDefaults.makeTableFromET("PRET.ET"));
        ColorTableDefaults.createColorTable(l, NAME_VIS_FOG, "Satellite", ColorTableDefaults.makeTableFromET("VISFOG.ET"));
        ColorTableDefaults.createColorTable(l, NAME_TOPO, "Misc.", ColorTableDefaults.topographyCT());
        Color[] colors = new Color[]{Color.black, Color.white, Color.yellow, Color.cyan, Color.red, Color.blue, Color.gray, Color.green, Color.magenta, Color.orange, Color.pink};
        String[] cNames = new String[]{NAME_BLACK, NAME_WHITE, NAME_YELLOW, NAME_CYAN, NAME_RED, NAME_BLUE, NAME_GRAY, NAME_GREEN, NAME_MAGENTA, NAME_ORANGE, NAME_PINK};
        for (int i2 = 0; i2 < colors.length; ++i2) {
            ColorTableDefaults.createColorTable(l, cNames[i2], "Solid", ColorTableDefaults.allOneColor(colors[i2]));
        }
        String[] radarLabels = new String[]{NAME_BREF, NAME_BREF24, NAME_CREF, NAME_RVEL, NAME_TOPS, NAME_VIL, NAME_TOPOMDR, NAME_MDR};
        String[] radarNames = new String[]{"BREF.ET", "BREF24.ET", "CREF.ET", "RVEL.ET", "TOPS.ET", "VIL.ET", "TOPOMDR.ET", "MDR.ET"};
        for (i = 0; i < radarLabels.length; ++i) {
            ColorTableDefaults.createColorTable(l, radarLabels[i], "Radar", ColorTableDefaults.makeTableFromET(radarNames[i]));
        }
        for (i = 0; i < ATD_Data.length; ++i) {
            ColorTableDefaults.createColorTable(l, ATD_Names[i], "Radar>ATD", ATD_Data[i], true);
        }
        return l;
    }

    public static final float[][] rainbow(int len) throws IllegalArgumentException {
        if (len <= 0) {
            throw new IllegalArgumentException(" Table length must be greater than 0");
        }
        float[][] table = new float[3][len];
        for (int i = 0; i < len; ++i) {
            float a;
            table[0][i] = a = (float)i / (float)(len - 1);
            table[1][i] = (float)i <= (float)(len - 1) / 2.0f ? 2.0f * a : 2.0f - 2.0f * a;
            table[2][i] = 1.0f - a;
        }
        return table;
    }

    public static final float[][] temperatureCT1() throws IllegalArgumentException {
        float a;
        int i;
        int len = 27;
        float[][] table = new float[3][len];
        for (i = 0; i < 14; ++i) {
            a = (float)i / 15.0f;
            table[0][i] = a * 0.6f;
            table[1][i] = a * 0.6f;
            table[2][i] = 1.0f;
        }
        table[0][14] = 0.85f;
        table[1][14] = 0.85f;
        table[2][14] = 0.95f;
        for (i = 15; i < len; ++i) {
            a = (float)(i - 17) / 9.0f;
            table[0][i] = 1.0f;
            table[1][i] = 1.0f - 1.0f * a;
            table[2][i] = 0.0f;
            if ((double)table[1][i] < 0.0) {
                table[1][i] = 0.0f;
            }
            if (!((double)table[2][i] < 0.0)) continue;
            table[2][i] = 0.0f;
        }
        return table;
    }

    public static final float[][] temperatureCT4() throws IllegalArgumentException {
        float a;
        int i;
        int temp;
        int len = 135;
        float[][] table = new float[3][len];
        for (temp = -89; temp < 0; ++temp) {
            i = temp + 89;
            a = (float)(temp + 89) / 89.0f;
            table[0][i] = 0.0f;
            table[1][i] = 0.0f + a * 250.0f;
            table[2][i] = 250.0f;
        }
        for (temp = 0; temp < 5; ++temp) {
            i = temp + 89;
            a = (float)temp / 4.0f;
            table[0][i] = 0.0f;
            table[1][i] = 255.0f;
            table[2][i] = 255.0f - 205.0f * a;
        }
        for (temp = 5; temp < 15; ++temp) {
            i = temp + 89;
            a = (float)(temp - 5) / 9.0f;
            table[0][i] = 0.0f + 205.0f * a;
            table[1][i] = 255.0f;
            table[2][i] = 0.0f;
        }
        for (temp = 15; temp < 46; ++temp) {
            i = temp + 89;
            a = (float)(temp - 15) / 30.0f;
            table[0][i] = 255.0f;
            table[1][i] = 255.0f - 225.0f * a;
            table[2][i] = 0.0f;
        }
        for (int n = 0; n < 3; ++n) {
            int m = 0;
            while (m < len) {
                float[] fArray = table[n];
                int n2 = m++;
                fArray[n2] = fArray[n2] / 255.0f;
            }
        }
        return table;
    }

    public static final float[][] temperatureCT2() {
        int len = 21;
        float[][] table = new float[3][len];
        table[0][0] = 0.0f;
        table[1][0] = 0.0f;
        table[2][0] = 255.0f;
        table[0][1] = 0.0f;
        table[1][1] = 0.0f;
        table[2][1] = 255.0f;
        table[0][2] = 0.0f;
        table[1][2] = 0.0f;
        table[2][2] = 255.0f;
        table[0][3] = 0.0f;
        table[1][3] = 0.0f;
        table[2][3] = 255.0f;
        table[0][4] = 0.0f;
        table[1][4] = 0.0f;
        table[2][4] = 255.0f;
        table[0][5] = 51.0f;
        table[1][5] = 51.0f;
        table[2][5] = 255.0f;
        table[0][6] = 51.0f;
        table[1][6] = 51.0f;
        table[2][6] = 255.0f;
        table[0][7] = 90.0f;
        table[1][7] = 90.0f;
        table[2][7] = 255.0f;
        table[0][8] = 111.0f;
        table[1][9] = 111.0f;
        table[2][9] = 255.0f;
        table[0][9] = 132.0f;
        table[1][9] = 132.0f;
        table[2][9] = 255.0f;
        table[0][10] = 153.0f;
        table[1][10] = 153.0f;
        table[2][10] = 255.0f;
        table[0][11] = 153.0f;
        table[1][11] = 153.0f;
        table[2][11] = 255.0f;
        table[0][12] = 153.0f;
        table[1][12] = 255.0f;
        table[2][12] = 255.0f;
        table[0][13] = 127.0f;
        table[1][13] = 255.0f;
        table[2][13] = 177.0f;
        table[0][14] = 102.0f;
        table[1][14] = 255.0f;
        table[2][14] = 102.0f;
        table[0][15] = 177.0f;
        table[1][15] = 255.0f;
        table[2][15] = 51.0f;
        table[0][16] = 255.0f;
        table[1][16] = 255.0f;
        table[2][16] = 102.0f;
        table[0][17] = 255.0f;
        table[1][17] = 201.0f;
        table[2][17] = 51.0f;
        table[0][18] = 255.0f;
        table[1][18] = 153.0f;
        table[2][18] = 0.0f;
        table[0][19] = 255.0f;
        table[1][19] = 140.0f;
        table[2][19] = 0.0f;
        table[0][20] = 255.0f;
        table[1][20] = 102.0f;
        table[2][20] = 0.0f;
        for (int n = 0; n < 3; ++n) {
            int m = 0;
            while (m < len) {
                float[] fArray = table[n];
                int n2 = m++;
                fArray[n2] = fArray[n2] / 256.0f;
            }
        }
        return table;
    }

    public static final float[][] temperatureCT3() {
        int len = 21;
        float[][] table = new float[3][len];
        table[0][0] = 0.0f;
        table[1][0] = 0.0f;
        table[2][0] = 245.0f;
        table[0][1] = 0.0f;
        table[1][1] = 70.0f;
        table[2][1] = 220.0f;
        table[0][2] = 0.0f;
        table[1][2] = 110.0f;
        table[2][2] = 195.0f;
        table[0][3] = 0.0f;
        table[1][3] = 135.0f;
        table[2][3] = 170.0f;
        table[0][4] = 0.0f;
        table[1][4] = 175.0f;
        table[2][4] = 145.0f;
        table[0][5] = 145.0f;
        table[1][5] = 215.0f;
        table[2][5] = 0.0f;
        table[0][6] = 150.0f;
        table[1][6] = 255.0f;
        table[2][6] = 0.0f;
        table[0][7] = 170.0f;
        table[1][7] = 255.0f;
        table[2][7] = 0.0f;
        table[0][9] = 190.0f;
        table[1][9] = 255.0f;
        table[2][9] = 0.0f;
        table[0][10] = 215.0f;
        table[1][10] = 255.0f;
        table[2][10] = 0.0f;
        table[0][11] = 235.0f;
        table[1][11] = 255.0f;
        table[2][11] = 0.0f;
        table[0][12] = 255.0f;
        table[1][12] = 255.0f;
        table[2][12] = 0.0f;
        table[0][13] = 255.0f;
        table[1][13] = 230.0f;
        table[2][13] = 0.0f;
        table[0][14] = 255.0f;
        table[1][14] = 205.0f;
        table[2][14] = 0.0f;
        table[0][15] = 255.0f;
        table[1][15] = 180.0f;
        table[2][15] = 0.0f;
        table[0][16] = 255.0f;
        table[1][16] = 155.0f;
        table[2][16] = 0.0f;
        table[0][17] = 255.0f;
        table[1][17] = 130.0f;
        table[2][17] = 0.0f;
        table[0][18] = 255.0f;
        table[1][18] = 105.0f;
        table[2][18] = 0.0f;
        table[0][19] = 255.0f;
        table[1][19] = 80.0f;
        table[2][19] = 0.0f;
        table[0][20] = 255.0f;
        table[1][20] = 55.0f;
        table[2][20] = 0.0f;
        for (int n = 0; n < 3; ++n) {
            int m = 0;
            while (m < len) {
                float[] fArray = table[n];
                int n2 = m++;
                fArray[n2] = fArray[n2] / 256.0f;
            }
        }
        return table;
    }

    public static final float[][] precipCT1() throws IllegalArgumentException {
        float a;
        int i;
        int len = 100;
        float[][] table = new float[3][len];
        table[0][0] = 1.0f;
        table[1][0] = 1.0f;
        table[2][0] = 1.0f;
        for (i = 1; i < 20; ++i) {
            a = (float)i / 19.0f;
            table[0][i] = a * 0.5f;
            table[1][i] = a * 1.0f;
            table[2][i] = 1.0f;
        }
        for (i = 20; i < len; ++i) {
            a = (float)(i - 20) / 79.0f;
            table[0][i] = 0.5f + a * 0.5f;
            table[1][i] = 1.0f - 0.6f * a;
            table[2][i] = 0.9f - 2.0f * a;
            if (!((double)table[2][i] < 0.0)) continue;
            table[2][i] = 0.0f;
        }
        return table;
    }

    public static final float[][] invRainbow(int len) throws IllegalArgumentException {
        if (len <= 0) {
            throw new IllegalArgumentException(" Table length must be greater than 0");
        }
        float[][] table = new float[3][len];
        for (int i = 0; i < len; ++i) {
            float a;
            table[2][i] = a = (float)i / (float)(len - 1);
            table[1][i] = (float)i <= (float)(len - 1) / 2.0f ? 2.0f * a : 2.0f - 2.0f * a;
            table[0][i] = 1.0f - a;
        }
        return table;
    }

    public static final float[][] percentBlue(int len) throws IllegalArgumentException {
        if (len <= 0) {
            throw new IllegalArgumentException(" Table length must be greater than 0");
        }
        float[][] table = new float[3][len];
        for (int i = 0; i < len; ++i) {
            float a = (float)i / (float)(len - 1);
            table[0][i] = 1.0f - a;
            table[1][i] = 1.0f - a;
            table[2][i] = 1.0f;
        }
        return table;
    }

    public static final float[][] grayTable(int numColors, boolean inverse) throws IllegalArgumentException {
        float[][] table = new float[3][numColors];
        float scale = 1.0f / (float)(numColors - 1);
        for (int i = 0; i < numColors; ++i) {
            float a = inverse ? (float)numColors - (float)i : (float)i;
            table[0][i] = a * scale;
            table[1][i] = a * scale;
            table[2][i] = a * scale;
        }
        return table;
    }

    public static final float[][] grayTable1(int len) throws IllegalArgumentException {
        if (len <= 0) {
            throw new IllegalArgumentException(" Table length must be greater than 0");
        }
        float[][] table = new float[3][len];
        for (int i = 0; i < len; ++i) {
            float a;
            table[0][i] = a = (float)(0.245 + (double)((float)i / (1.33f * (float)(len - 1))));
            table[1][i] = a;
            table[2][i] = a;
        }
        return table;
    }

    public static final float[][] percentYellowBlue(int len) throws IllegalArgumentException {
        if (len <= 0) {
            throw new IllegalArgumentException(" Table length must be greater than 0");
        }
        float[][] table = new float[3][len];
        for (int i = 0; i < len; ++i) {
            float a = (float)i / (float)(len - 1);
            table[0][i] = 1.0f - a;
            table[1][i] = 1.0f - a;
            table[2][i] = a;
        }
        return table;
    }

    public static final float[][] percentYelGrnBlue(int len) throws IllegalArgumentException {
        if (len <= 0) {
            throw new IllegalArgumentException(" Table length must be greater than 0");
        }
        float[][] table = new float[3][len];
        for (int i = 0; i < len; ++i) {
            float a = (float)i / (float)(len - 1);
            table[0][i] = 1.0f - 2.0f * a;
            if ((double)table[0][i] < 0.0) {
                table[0][i] = 0.0f;
            }
            table[1][i] = 1.0f;
            if ((double)a >= 0.5) {
                table[1][i] = 1.5f - a;
            }
            table[2][i] = -1.0f + 2.0f * a;
            if (!((double)table[2][i] < 0.0)) continue;
            table[2][i] = 0.0f;
        }
        return table;
    }

    public static final float[][] windSpeed(int len) throws IllegalArgumentException {
        float frac;
        int i;
        if (len <= 0) {
            len = 30;
        }
        float[][] table = new float[3][len];
        for (i = 0; i < len / 2; ++i) {
            frac = 1.75f * ((float)i / (float)(len / 2));
            table[0][i] = frac * 60.0f;
            table[1][i] = frac * 140.0f;
            table[2][i] = 180.0f + frac * 45.0f;
        }
        for (i = len / 2; i < len; ++i) {
            frac = 2.0f * (-0.5f + (float)i / (float)(len - 1));
            table[0][i] = 65.0f;
            table[1][i] = 206.0f + 49.0f * frac;
            table[2][i] = 255.0f - 200.0f * frac;
        }
        for (int n = 0; n < 3; ++n) {
            for (int m = 0; m < len; ++m) {
                table[n][m] = table[n][m] / 256.0f;
            }
        }
        return table;
    }

    public static final float[][] bright38() {
        int len = 38;
        float[][] table = new float[3][len];
        table[0][0] = 255.0f;
        table[1][0] = 0.0f;
        table[2][0] = 226.0f;
        table[0][1] = 189.0f;
        table[1][1] = 1.0f;
        table[2][1] = 255.0f;
        table[0][2] = 166.0f;
        table[1][2] = 1.0f;
        table[2][2] = 255.0f;
        table[0][3] = 135.0f;
        table[1][3] = 1.0f;
        table[2][3] = 255.0f;
        table[0][4] = 112.0f;
        table[1][4] = 1.0f;
        table[2][4] = 255.0f;
        table[0][5] = 82.0f;
        table[1][5] = 1.0f;
        table[2][5] = 255.0f;
        table[0][6] = 59.0f;
        table[1][6] = 1.0f;
        table[2][6] = 255.0f;
        table[0][7] = 29.0f;
        table[1][7] = 1.0f;
        table[2][7] = 255.0f;
        table[0][8] = 1.0f;
        table[1][8] = 3.0f;
        table[2][8] = 255.0f;
        table[0][9] = 1.0f;
        table[1][9] = 34.0f;
        table[2][9] = 255.0f;
        table[0][10] = 1.0f;
        table[1][10] = 57.0f;
        table[2][10] = 255.0f;
        table[0][11] = 1.0f;
        table[1][11] = 79.0f;
        table[2][11] = 255.0f;
        table[0][12] = 1.0f;
        table[1][12] = 140.0f;
        table[2][12] = 255.0f;
        table[0][13] = 0.0f;
        table[1][13] = 170.0f;
        table[2][13] = 255.0f;
        table[0][14] = 0.0f;
        table[1][14] = 209.0f;
        table[2][14] = 255.0f;
        table[0][15] = 0.0f;
        table[1][15] = 232.0f;
        table[2][15] = 255.0f;
        table[0][16] = 1.0f;
        table[1][16] = 255.0f;
        table[2][16] = 232.0f;
        table[0][17] = 0.0f;
        table[1][17] = 255.0f;
        table[2][17] = 201.0f;
        table[0][18] = 0.0f;
        table[1][18] = 255.0f;
        table[2][18] = 170.0f;
        table[0][19] = 0.0f;
        table[1][19] = 255.0f;
        table[2][19] = 140.0f;
        table[0][20] = 0.0f;
        table[1][20] = 255.0f;
        table[2][20] = 110.0f;
        table[0][21] = 0.0f;
        table[1][21] = 255.0f;
        table[2][21] = 80.0f;
        table[0][22] = 0.0f;
        table[1][22] = 255.0f;
        table[2][22] = 40.0f;
        table[0][23] = 0.0f;
        table[1][23] = 255.0f;
        table[2][23] = 0.0f;
        table[0][24] = 43.0f;
        table[1][24] = 255.0f;
        table[2][24] = 0.0f;
        table[0][25] = 89.0f;
        table[1][25] = 255.0f;
        table[2][25] = 0.0f;
        table[0][26] = 127.0f;
        table[1][26] = 255.0f;
        table[2][26] = 0.0f;
        table[0][27] = 165.0f;
        table[1][27] = 255.0f;
        table[2][27] = 0.0f;
        table[0][28] = 196.0f;
        table[1][28] = 255.0f;
        table[2][28] = 1.0f;
        table[0][29] = 227.0f;
        table[1][29] = 255.0f;
        table[2][29] = 1.0f;
        table[0][30] = 255.0f;
        table[1][30] = 244.0f;
        table[2][30] = 0.0f;
        table[0][31] = 255.0f;
        table[1][31] = 200.0f;
        table[2][31] = 0.0f;
        table[0][32] = 255.0f;
        table[1][32] = 168.0f;
        table[2][32] = 0.0f;
        table[0][33] = 255.0f;
        table[1][33] = 138.0f;
        table[2][33] = 0.0f;
        table[0][34] = 255.0f;
        table[1][34] = 107.0f;
        table[2][34] = 0.0f;
        table[0][35] = 255.0f;
        table[1][35] = 69.0f;
        table[2][35] = 0.0f;
        table[0][36] = 255.0f;
        table[1][36] = 31.0f;
        table[2][36] = 0.0f;
        table[0][37] = 255.0f;
        table[1][37] = 0.0f;
        table[2][37] = 0.0f;
        for (int n = 0; n < 3; ++n) {
            int m = 0;
            while (m < len) {
                float[] fArray = table[n];
                int n2 = m++;
                fArray[n2] = fArray[n2] / 256.0f;
            }
        }
        return table;
    }

    public static final float[][] bright16() {
        int len = 16;
        float[][] table = new float[3][len];
        table[0][0] = 0.0f;
        table[1][0] = 0.0f;
        table[2][0] = 255.0f;
        table[0][1] = 51.0f;
        table[1][1] = 51.0f;
        table[2][1] = 255.0f;
        table[0][2] = 102.0f;
        table[1][2] = 102.0f;
        table[2][2] = 255.0f;
        table[0][3] = 153.0f;
        table[1][3] = 153.0f;
        table[2][3] = 255.0f;
        table[0][4] = 153.0f;
        table[1][4] = 255.0f;
        table[2][4] = 255.0f;
        table[0][5] = 102.0f;
        table[1][5] = 255.0f;
        table[2][5] = 255.0f;
        table[0][6] = 51.0f;
        table[1][6] = 255.0f;
        table[2][6] = 255.0f;
        table[0][7] = 102.0f;
        table[1][7] = 255.0f;
        table[2][7] = 102.0f;
        table[0][8] = 51.0f;
        table[1][8] = 255.0f;
        table[2][8] = 51.0f;
        table[0][9] = 255.0f;
        table[1][9] = 255.0f;
        table[2][9] = 102.0f;
        table[0][10] = 255.0f;
        table[1][10] = 255.0f;
        table[2][10] = 51.0f;
        table[0][11] = 255.0f;
        table[1][11] = 255.0f;
        table[2][11] = 0.0f;
        table[0][12] = 255.0f;
        table[1][12] = 204.0f;
        table[2][12] = 102.0f;
        table[0][13] = 255.0f;
        table[1][13] = 153.0f;
        table[2][13] = 0.0f;
        table[0][14] = 255.0f;
        table[1][14] = 102.0f;
        table[2][14] = 102.0f;
        table[0][15] = 255.0f;
        table[1][15] = 51.0f;
        table[2][15] = 51.0f;
        for (int n = 0; n < 3; ++n) {
            int m = 0;
            while (m < len) {
                float[] fArray = table[n];
                int n2 = m++;
                fArray[n2] = fArray[n2] / 256.0f;
            }
        }
        return table;
    }

    public static final float[][] bright14() {
        int len = 14;
        float[][] table = new float[3][len];
        table[0][0] = 0.0f;
        table[1][0] = 0.0f;
        table[2][0] = 255.0f;
        table[0][1] = 51.0f;
        table[1][1] = 51.0f;
        table[2][1] = 255.0f;
        table[0][2] = 102.0f;
        table[1][2] = 102.0f;
        table[2][2] = 255.0f;
        table[0][3] = 153.0f;
        table[1][3] = 153.0f;
        table[2][3] = 255.0f;
        table[0][4] = 153.0f;
        table[1][4] = 255.0f;
        table[2][4] = 255.0f;
        table[0][5] = 102.0f;
        table[1][5] = 255.0f;
        table[2][5] = 255.0f;
        table[0][6] = 51.0f;
        table[1][6] = 255.0f;
        table[2][6] = 255.0f;
        table[0][7] = 102.0f;
        table[1][7] = 255.0f;
        table[2][7] = 102.0f;
        table[0][8] = 51.0f;
        table[1][8] = 255.0f;
        table[2][8] = 51.0f;
        table[0][9] = 255.0f;
        table[1][9] = 255.0f;
        table[2][9] = 102.0f;
        table[0][10] = 255.0f;
        table[1][10] = 255.0f;
        table[2][10] = 51.0f;
        table[0][11] = 255.0f;
        table[1][11] = 255.0f;
        table[2][11] = 0.0f;
        table[0][12] = 255.0f;
        table[1][12] = 204.0f;
        table[2][12] = 102.0f;
        table[0][13] = 255.0f;
        table[1][13] = 153.0f;
        table[2][13] = 0.0f;
        for (int n = 0; n < 3; ++n) {
            int m = 0;
            while (m < len) {
                float[] fArray = table[n];
                int n2 = m++;
                fArray[n2] = fArray[n2] / 256.0f;
            }
        }
        return table;
    }

    public static final float[][] bright12() {
        int len = 12;
        float[][] table = new float[3][len];
        table[0][0] = 1.0f;
        table[1][0] = 57.0f;
        table[2][0] = 255.0f;
        table[0][1] = 1.0f;
        table[1][1] = 140.0f;
        table[2][1] = 255.0f;
        table[0][2] = 1.0f;
        table[1][2] = 209.0f;
        table[2][2] = 255.0f;
        table[0][3] = 1.0f;
        table[1][3] = 255.0f;
        table[2][3] = 232.0f;
        table[0][4] = 0.0f;
        table[1][4] = 255.0f;
        table[2][4] = 201.0f;
        table[0][5] = 0.0f;
        table[1][5] = 255.0f;
        table[2][5] = 80.0f;
        table[0][6] = 43.0f;
        table[1][6] = 255.0f;
        table[2][6] = 0.0f;
        table[0][7] = 165.0f;
        table[1][7] = 255.0f;
        table[2][7] = 0.0f;
        table[0][8] = 227.0f;
        table[1][8] = 255.0f;
        table[2][8] = 1.0f;
        table[0][9] = 255.0f;
        table[1][9] = 199.0f;
        table[2][9] = 0.0f;
        table[0][10] = 255.0f;
        table[1][10] = 138.0f;
        table[2][10] = 0.0f;
        table[0][11] = 255.0f;
        table[1][11] = 69.0f;
        table[2][11] = 0.0f;
        for (int n = 0; n < 3; ++n) {
            for (int m = 0; m < len; ++m) {
                table[n][m] = table[n][m] / 256.0f;
            }
        }
        return table;
    }

    public static final float[][] topographyCT() {
        int len = 256;
        float[][] table = new float[3][len];
        float[] red = new float[]{25.0f, 25.0f, 20.0f, 20.0f, 70.0f, 165.0f, 200.0f};
        float[] green = new float[]{25.0f, 25.0f, 170.0f, 170.0f, 200.0f, 165.0f, 200.0f};
        float[] blue = new float[]{255.0f, 255.0f, 42.0f, 42.0f, 0.0f, 42.0f, 200.0f};
        float[] range = new float[]{0.0f, 0.01f, 0.015f, 0.03f, 0.1f, 1.0f, 2.8f};
        float minhgt = range[0];
        float maxhgt = range[range.length - 1];
        for (int i = 0; i < 6; ++i) {
            float x0 = (range[i] - minhgt) / (maxhgt - minhgt) * (float)(len - 1);
            float x1 = (range[i + 1] - minhgt) / (maxhgt - minhgt) * (float)(len - 1);
            float dr = (red[i + 1] - red[i]) / (x1 - x0);
            float dg = (green[i + 1] - green[i]) / (x1 - x0);
            float db = (blue[i + 1] - blue[i]) / (x1 - x0);
            float r = red[i];
            float g = green[i];
            float b = blue[i];
            for (int j = (int)x0; j < (int)x1; ++j) {
                if (j >= 0 && j < len - 1) {
                    table[0][j] = r / 255.0f;
                    table[1][j] = g / 255.0f;
                    table[2][j] = b / 255.0f;
                }
                r += dr;
                g += dg;
                b += db;
            }
        }
        table[0][len - 1] = 1.0f;
        table[1][len - 1] = 1.0f;
        table[2][len - 1] = 1.0f;
        return table;
    }

    public static final float[][] allOneColor(Color color) {
        return ColorTableDefaults.allOneColor(color, false);
    }

    public static final float[][] allOneColor(Color color, boolean addAlpha) {
        int len = 5;
        float[][] table = new float[addAlpha ? 4 : 3][len];
        for (int m = 0; m < len; ++m) {
            table[0][m] = (float)color.getRed() / 255.0f;
            table[1][m] = (float)color.getGreen() / 255.0f;
            table[2][m] = (float)color.getBlue() / 255.0f;
            if (!addAlpha) continue;
            table[3][m] = 1.0f;
        }
        return table;
    }

    public static final float[][] DZ1() {
        int len = 16;
        float[][] table = new float[3][len];
        table[0][0] = 0.0f;
        table[1][0] = 0.0f;
        table[2][0] = 0.0f;
        table[0][1] = 0.0f;
        table[1][1] = 255.0f;
        table[2][1] = 255.0f;
        table[0][2] = 135.0f;
        table[1][2] = 206.0f;
        table[2][2] = 235.0f;
        table[0][3] = 0.0f;
        table[1][3] = 0.0f;
        table[2][3] = 255.0f;
        table[0][4] = 0.0f;
        table[1][4] = 255.0f;
        table[2][4] = 0.0f;
        table[0][5] = 50.0f;
        table[1][5] = 205.0f;
        table[2][5] = 50.0f;
        table[0][6] = 34.0f;
        table[1][6] = 139.0f;
        table[2][6] = 34.0f;
        table[0][7] = 238.0f;
        table[1][7] = 238.0f;
        table[2][7] = 0.0f;
        table[0][8] = 238.0f;
        table[1][8] = 220.0f;
        table[2][8] = 130.0f;
        table[0][9] = 238.0f;
        table[1][9] = 118.0f;
        table[2][9] = 33.0f;
        table[0][10] = 255.0f;
        table[1][10] = 48.0f;
        table[2][10] = 48.0f;
        table[0][11] = 176.0f;
        table[1][11] = 48.0f;
        table[2][11] = 96.0f;
        table[0][12] = 176.0f;
        table[1][12] = 48.0f;
        table[2][12] = 96.0f;
        table[0][13] = 186.0f;
        table[1][13] = 85.0f;
        table[2][13] = 211.0f;
        table[0][14] = 255.0f;
        table[1][14] = 0.0f;
        table[2][14] = 255.0f;
        table[0][15] = 255.0f;
        table[1][15] = 255.0f;
        table[2][15] = 255.0f;
        for (int n = 0; n < 3; ++n) {
            int m = 0;
            while (m < len) {
                float[] fArray = table[n];
                int n2 = m++;
                fArray[n2] = fArray[n2] / 255.0f;
            }
        }
        return table;
    }

    public static final float[][] DZ2() {
        int len = 16;
        float[][] table = new float[3][len];
        table[0][0] = 1.0f;
        table[1][0] = 57.0f;
        table[2][0] = 255.0f;
        table[0][1] = 0.0f;
        table[1][1] = 140.0f;
        table[2][1] = 255.0f;
        table[0][2] = 1.0f;
        table[1][2] = 209.0f;
        table[2][2] = 255.0f;
        table[0][3] = 1.0f;
        table[1][3] = 255.0f;
        table[2][3] = 232.0f;
        table[0][4] = 1.0f;
        table[1][4] = 255.0f;
        table[2][4] = 171.0f;
        table[0][5] = 1.0f;
        table[1][5] = 255.0f;
        table[2][5] = 79.0f;
        table[0][6] = 43.0f;
        table[1][6] = 255.0f;
        table[2][6] = 0.0f;
        table[0][7] = 166.0f;
        table[1][7] = 255.0f;
        table[2][7] = 2.0f;
        table[0][8] = 227.0f;
        table[1][8] = 255.0f;
        table[2][8] = 1.0f;
        table[0][9] = 255.0f;
        table[1][9] = 198.0f;
        table[2][9] = 0.0f;
        table[0][10] = 255.0f;
        table[1][10] = 168.0f;
        table[2][10] = 1.0f;
        table[0][11] = 255.0f;
        table[1][11] = 145.0f;
        table[2][11] = 1.0f;
        table[0][12] = 255.0f;
        table[1][12] = 130.0f;
        table[2][12] = 1.0f;
        table[0][13] = 255.0f;
        table[1][13] = 107.0f;
        table[2][13] = 0.0f;
        table[0][14] = 255.0f;
        table[1][14] = 84.0f;
        table[2][14] = 0.0f;
        table[0][15] = 255.0f;
        table[1][15] = 7.0f;
        table[2][15] = 0.0f;
        for (int n = 0; n < 3; ++n) {
            int m = 0;
            while (m < len) {
                float[] fArray = table[n];
                int n2 = m++;
                fArray[n2] = fArray[n2] / 255.0f;
            }
        }
        return table;
    }

    public static final float[][] windspeed() throws IllegalArgumentException {
        float a;
        int i;
        int temp;
        int len = 70;
        float[][] table = new float[3][len];
        for (temp = 0; temp < 20; ++temp) {
            i = temp;
            a = (float)temp / 20.0f;
            table[0][i] = 0.0f;
            table[1][i] = 0.0f + a * 250.0f;
            table[2][i] = 250.0f;
        }
        for (temp = 20; temp < 30; ++temp) {
            i = temp;
            a = (float)(temp - 20) / 10.0f;
            table[0][i] = 0.0f;
            table[1][i] = 255.0f;
            table[2][i] = 255.0f - 205.0f * a;
        }
        for (temp = 30; temp < 40; ++temp) {
            i = temp;
            a = (float)(temp - 30) / 10.0f;
            table[0][i] = 0.0f + 205.0f * a;
            table[1][i] = 255.0f;
            table[2][i] = 0.0f;
        }
        for (temp = 40; temp < 70; ++temp) {
            i = temp;
            a = (float)(temp - 40) / 30.0f;
            table[0][i] = 255.0f;
            table[1][i] = 255.0f - 225.0f * a;
            table[2][i] = 0.0f;
        }
        for (int n = 0; n < 3; ++n) {
            int m = 0;
            while (m < len) {
                float[] fArray = table[n];
                int n2 = m++;
                fArray[n2] = fArray[n2] / 255.0f;
            }
        }
        return table;
    }

    public static final float[][] makeTableFromET(String name) throws IllegalArgumentException {
        return ColorTableDefaults.makeTableFromET(name, true);
    }

    public static final float[][] makeTableFromET(String name, boolean fromAuxdata) throws IllegalArgumentException {
        float[][] colorTable = new float[3][256];
        try {
            EnhancementTable et;
            if (fromAuxdata) {
                URL enhancement = Resource.getURL("/auxdata/ui/colortables/" + name);
                et = new EnhancementTable(enhancement);
            } else {
                URL url = IOUtil.getURL(name, ColorTableDefaults.class);
                et = new EnhancementTable(url);
            }
            int[][] rgbVals = et.getRGBValues();
            for (int j = 0; j < 256; ++j) {
                colorTable[0][j] = (float)rgbVals[0][j] / 255.0f;
                colorTable[1][j] = (float)rgbVals[1][j] / 255.0f;
                colorTable[2][j] = (float)rgbVals[2][j] / 255.0f;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.toString());
        }
        return colorTable;
    }

    private static float[][] toArray(List colors) {
        float[][] colorTable = new float[3][colors.size()];
        for (int i = 0; i < colors.size(); ++i) {
            Color c = (Color)colors.get(i);
            colorTable[0][i] = (float)c.getRed() / 255.0f;
            colorTable[1][i] = (float)c.getGreen() / 255.0f;
            colorTable[2][i] = (float)c.getBlue() / 255.0f;
        }
        return colorTable;
    }

    public static final float[][] makeTableFromPal1(String name) throws IOException {
        byte[] b = IOUtil.readBytes(IOUtil.getInputStream(name));
        if (b.length < 768) {
            throw new IOException("Not a valid PAL-1 color table");
        }
        ArrayList<Color> colors = new ArrayList<Color>();
        int minBin = 1;
        int maxBin = 254;
        for (int i = minBin; i <= maxBin; ++i) {
            colors.add(new Color(0xFF & b[i], 0xFF & b[i + 256], 0xFF & b[i + 512]));
        }
        return ColorTableDefaults.toArray(colors);
    }

    public static final float[][] makeTableFromPal2(String name) throws IOException {
        byte[] b = IOUtil.readBytes(IOUtil.getInputStream(name));
        if (b.length < 768) {
            throw new IOException("Not a valid PAL-2 color table");
        }
        ArrayList<Color> colors = new ArrayList<Color>();
        int minBin = 2;
        int maxBin = 253;
        for (int i = minBin; i <= maxBin; ++i) {
            colors.add(new Color(0xFF & b[i], 0xFF & b[i + 256], 0xFF & b[i + 512]));
        }
        return ColorTableDefaults.toArray(colors);
    }

    public static List makeGempakColorTables(String name, String category, String file) {
        try {
            List<String> lines = StringUtil.split(IOUtil.readContents(file), "\n", true, true);
            ArrayList<int[]> colors = new ArrayList<int[]>();
            for (int lineIdx = 0; lineIdx < lines.size(); ++lineIdx) {
                List<String> symbols = StringUtil.split(lines.get(lineIdx), " ", true, true);
                int colorCnt = 0;
                int[] colorArray = new int[]{0, 0, 0};
                for (int symbolIdx = 0; colorCnt < 3 && symbolIdx < symbols.size(); ++symbolIdx) {
                    String symbol = symbols.get(symbolIdx);
                    if (symbolIdx == 0 && (symbol.startsWith("!") || symbol.startsWith("#"))) continue;
                    try {
                        int value = ColorTableDefaults.toInt(symbol);
                        if (value < 0 || value > 255) continue;
                        colorArray[colorCnt++] = value;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (colorCnt != 3) continue;
                colors.add(colorArray);
            }
            float[][] table = new float[3][colors.size()];
            for (int colorIdx = 0; colorIdx < colors.size(); ++colorIdx) {
                int[] ca = (int[])colors.get(colorIdx);
                for (int i = 0; i < 3; ++i) {
                    table[i][colorIdx] = (float)ca[i] / 255.0f;
                }
            }
            ColorTable ct = new ColorTable(name, category, table);
            ct.getColorList();
            return Misc.newList(ct);
        }
        catch (Exception exc) {
            LogUtil.logException("Error reading color table file: " + file, exc);
            return new ArrayList();
        }
    }

    public static void main(String[] args) throws Exception {
        String line = args[0];
    }

    public static List makeNclRgbColorTables(String name, String cat, String file, String contents) throws IOException {
        if (contents == null) {
            contents = IOUtil.readContents(file);
        }
        List<String> lines = StringUtil.split(contents, "\n", true, true);
        ArrayList<Color> colors = new ArrayList<Color>();
        for (int lineIdx = 0; lineIdx < lines.size(); ++lineIdx) {
            String line = lines.get(lineIdx);
            if ((line = line.trim()).length() == 0 || line.startsWith("#") || line.startsWith("ncolors") || line.startsWith("ntsc")) continue;
            List<String> rgb = StringUtil.split(line, " ", true, true);
            if (rgb.size() != 3) {
                throw new IllegalStateException("Bad rgb values in:" + line);
            }
            try {
                colors.add(new Color(ColorTableDefaults.toInt(rgb.get(0)), ColorTableDefaults.toInt(rgb.get(1)), ColorTableDefaults.toInt(rgb.get(2).toString())));
                continue;
            }
            catch (NumberFormatException nfe) {
                throw new IllegalStateException("Bad number format on:" + line + " in file:" + file);
            }
        }
        if (colors != null && colors.size() > 0) {
            return Misc.newList(ColorTableDefaults.makeColorTable(name, cat, colors));
        }
        return null;
    }

    public static List makeRgbColorTables(String name, String cat, String file, List lines, String delimiter) {
        ArrayList<Color> colors = new ArrayList<Color>();
        for (int lineIdx = 0; lineIdx < lines.size(); ++lineIdx) {
            String line = (String)lines.get(lineIdx);
            if ((line = ColorTableDefaults.stripComments(line)).startsWith("ncolors") || line.startsWith("ntsc") || line.length() == 0 || line.startsWith("#")) continue;
            List<String> toks = StringUtil.split(line, delimiter, true, true);
            try {
                colors.add(new Color(ColorTableDefaults.toInt(toks.get(0)), ColorTableDefaults.toInt(toks.get(1)), ColorTableDefaults.toInt(toks.get(2))));
                continue;
            }
            catch (NumberFormatException nfe) {
                throw new IllegalStateException("Bad number format in line:" + line + " from file:" + file);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalStateException("Bad color value in line:" + line + " from file:" + file);
            }
        }
        if (colors != null && colors.size() > 0) {
            return Misc.newList(ColorTableDefaults.makeColorTable(name, cat, colors));
        }
        return null;
    }

    private static int toInt(Object o) {
        String s = o.toString().trim();
        return (int)new Double(s).doubleValue();
    }

    private static String stripComments(String line) {
        int commentIdx = line.indexOf("/*");
        if (commentIdx >= 0) {
            int end = line.indexOf("*/");
            if (end < 0) {
                return "";
            }
            line = line.substring(0, commentIdx) + line.substring(end + 2, line.length());
        }
        if ((line = line.trim()).startsWith("#")) {
            return "";
        }
        return line;
    }

    public static List makeRgbColorTables(String name, String cat, String file) throws IOException {
        ArrayList<ColorTable> tables = new ArrayList<ColorTable>();
        String contents = IOUtil.readContents(file);
        if (contents.indexOf("ncolors=") >= 0) {
            return ColorTableDefaults.makeNclRgbColorTables(name, cat, file, contents);
        }
        List<String> lines = StringUtil.split(contents, "\n", true, true);
        ArrayList<Color> colors = null;
        String delimiter = null;
        for (int lineIdx = 0; lineIdx < lines.size(); ++lineIdx) {
            List<String> toks;
            String line = lines.get(lineIdx);
            if ((line = ColorTableDefaults.stripComments(line)).length() == 0 || line.startsWith("#")) continue;
            if (line.startsWith("*")) {
                if (colors != null) {
                    tables.add(ColorTableDefaults.makeColorTable(name, cat, colors));
                }
                colors = new ArrayList<Color>();
                name = line.substring(1);
                int index = name.indexOf("#");
                if (index < 0) continue;
                name = name.substring(0, index).trim();
                continue;
            }
            if (delimiter == null) {
                delimiter = line.indexOf(",") >= 0 ? "," : " ";
            }
            if ((toks = StringUtil.split(line, delimiter, true, true)).size() == 3) {
                return ColorTableDefaults.makeRgbColorTables(name, cat, file, lines, delimiter);
            }
            if (toks.size() != 8) {
                throw new IllegalArgumentException("Incorrect number of tokens in:" + file + " Read:" + line);
            }
            int idx = 0;
            try {
                int from = ColorTableDefaults.toInt(toks.get(idx++));
                int to = ColorTableDefaults.toInt(toks.get(idx++));
                int fromRed = ColorTableDefaults.toInt(toks.get(idx++));
                int toRed = ColorTableDefaults.toInt(toks.get(idx++));
                int redWidth = toRed - fromRed + 1;
                int fromGreen = ColorTableDefaults.toInt(toks.get(idx++));
                int toGreen = ColorTableDefaults.toInt(toks.get(idx++));
                int greenWidth = toGreen - fromGreen + 1;
                int fromBlue = ColorTableDefaults.toInt(toks.get(idx++));
                int toBlue = ColorTableDefaults.toInt(toks.get(idx));
                int blueWidth = toBlue - fromBlue + 1;
                int width = to - from + 1;
                for (int i = 0; i < width; ++i) {
                    double percent = (double)i / (double)width;
                    Color c = new Color((int)((double)fromRed + (double)redWidth * percent), (int)((double)fromGreen + (double)greenWidth * percent), (int)((double)fromBlue + (double)blueWidth * percent));
                    colors.add(c);
                }
                continue;
            }
            catch (NumberFormatException nfe) {
                throw new IllegalStateException("Bad number format in line:" + line + " from file:" + file);
            }
        }
        if (colors != null && colors.size() > 0) {
            tables.add(ColorTableDefaults.makeColorTable(name, cat, colors));
        }
        return tables;
    }

    private static ColorTable makeColorTable(String name, String cat, ArrayList colors) {
        ColorTable ct = new ColorTable(name, cat, null);
        ct.setTable(colors);
        return ct;
    }

    public static final float[][] makeTableFromAct(String name) throws IOException {
        byte[] b = IOUtil.readBytes(IOUtil.getInputStream(name));
        if (b.length < 768) {
            throw new IOException("Not a valid ACT color table");
        }
        int colorCount = 256;
        if (b.length == 772) {
            colorCount = b[769] > 0 ? b[769] : 256 + b[769];
        }
        ArrayList<Color> colors = new ArrayList<Color>();
        for (int i = 0; i < colorCount; ++i) {
            colors.add(new Color(0xFF & b[i * 3], 0xFF & b[i * 3 + 1], 0xFF & b[i * 3 + 2]));
        }
        return ColorTableDefaults.toArray(colors);
    }

    public static final float[][] makeTableFromPal(String name) throws IOException {
        byte[] b = IOUtil.readBytes(IOUtil.getInputStream(name));
        if (b.length < 768) {
            throw new IOException("Not a valid ACT color table");
        }
        ArrayList<Color> colors = new ArrayList<Color>();
        for (int i = 0; i < 256; ++i) {
            colors.add(new Color(0xFF & b[i], 0xFF & b[i + 256], 0xFF & b[i + 512]));
        }
        return ColorTableDefaults.toArray(colors);
    }

    public static List makeAwips2ColorTables(String name, String category, String file) {
        String xpath = "//color";
        ArrayList<Color> colors = new ArrayList<Color>(512);
        for (Element e : XmlUtil.elements(file, xpath)) {
            float r = Float.valueOf(e.getAttribute("r")).floatValue();
            float g = Float.valueOf(e.getAttribute("g")).floatValue();
            float b = Float.valueOf(e.getAttribute("b")).floatValue();
            float a = Float.valueOf(e.getAttribute("a")).floatValue();
            if ((double)a > 1.0) {
                a = 1.0f;
            }
            colors.add(new Color(r, g, b, a));
        }
        ArrayList<ColorTable> newColorTable = null;
        if (!colors.isEmpty()) {
            newColorTable = new ArrayList<ColorTable>(1);
            newColorTable.add(ColorTableDefaults.makeColorTable(name, category, colors));
        }
        return newColorTable;
    }
}

