/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui.colortable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ucar.unidata.ui.Command;
import ucar.unidata.ui.CommandManager;
import ucar.unidata.ui.colortable.ColorTableEditor;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Msg;
import ucar.unidata.util.ObjectListener;
import ucar.unidata.util.Range;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;

public class ColorTableCanvas
extends JPanel
implements MouseMotionListener,
MouseListener,
KeyListener {
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(ColorTableCanvas.class.getName());
    private static final int BREAKPOINT_NONE = -1;
    public static final String PROP_COLORTABLE = "prop.colortable";
    public static final String PROP_RANGE = "prop.range";
    public static final String PROP_CANCEL = "prop.cancel";
    public static final String PROP_CLOSE = "prop.close";
    private static final int MARGIN_V = 30;
    private static final int MARGIN_H = 40;
    private static final int ARROW_HEIGHT = 8;
    private static final int ARROW_WIDTH = 8;
    private static final int MODE_NONE = 0;
    private static final int MODE_FILL = 2;
    private static final int MODE_INTERPOLATE = 1;
    private static final int MODE_TRANSPARENCY = 3;
    private static final int MODE_BRIGHTNESS = 4;
    private static final int[] modes = new int[]{2, 1, 4, 3};
    private int DFLT_COLOR_SPACE = -999;
    private static final String[] modeNames = new String[]{"Fill", "Interpolate", "Brightness:", "Transparency:"};
    private Image lockImage;
    private ColorTableEditor editor;
    private Font labelFont = new Font("Dialog", 0, 12);
    private Font boldFont = new Font("Dialog", 1, 12);
    private boolean needToPropagateChanges = false;
    private Color selectedColor;
    private boolean cursorOver = false;
    private int cursorPosition = 0;
    private boolean okToPropagateChangesNow = true;
    private boolean propagateChanges = true;
    private JCheckBox setColorFromChooserCbx = new JCheckBox("Actively set color", true);
    private JComboBox colorSpaceCbx;
    private JColorChooser colorChooser;
    private JLabel colorCntLabel = GuiUtils.cLabel("     ");
    private JTextField minField = new JTextField(4);
    private JTextField maxField = new JTextField(4);
    private JComboBox categoryField;
    private JComboBox transBox;
    private boolean ignoreTransBoxEvents = false;
    private JComboBox brightnessBox;
    private int lastAlpha;
    private Range myRange;
    private ArrayList colorList = new ArrayList();
    private ArrayList scales = new ArrayList();
    private ColorTable originalColorTable;
    private ColorTable currentColorTable;
    private int lastChangeIdx = -1;
    private int lastControlKey = -1;
    private ArrayList listeners;
    private ArrayList breakpoints;
    private ColorTable.Breakpoint currentBP = null;
    private JLabel nameLabel;
    private JPanel wrapper;
    private int currentMode = 2;
    private boolean mouseInBox = false;
    private double activePercent;
    private JRadioButton modeTransparencyBtn;
    private JComponent colorSwatch;
    private JRadioButton modeBrightnessBtn;
    private ButtonGroup modeGroup;
    private int activeColorIndex;
    private Color activeColor;
    private ArrayList priorColors;
    private CommandManager commands = new CommandManager(5000);
    public static final Cursor normalCursor = Cursor.getPredefinedCursor(0);
    public static Cursor paintCursor;
    private boolean inPaint = false;

    public ColorTableCanvas() {
        this(null, null);
    }

    public ColorTableCanvas(ColorTableEditor editor, ColorTable table) {
        this.editor = editor;
        this.init(table);
    }

    public void init(ColorTable newTable) {
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setPreferredSize(new Dimension(250, 100));
        this.setMinimumSize(new Dimension(250, 100));
        this.setColorTableInner(newTable, false);
    }

    public void setColorTable(ColorTable newTable) {
        this.commands.add(new ColorTableCommand(this, newTable));
    }

    private void setColorTableInner(ColorTable newTable, boolean notifyChange) {
        this.currentBP = null;
        if (newTable == null) {
            newTable = this.editor.getColorTableManager().getDefaultColorTable();
        }
        if (this.isStandAlone() || !notifyChange || this.myRange == null) {
            Range tableRange = newTable.getRange();
            if (tableRange != null) {
                this.myRange = new Range(tableRange);
            } else {
                this.myRange = new Range(0.0, 100.0);
                newTable.setRange(this.myRange);
            }
        }
        if (this.originalColorTable == null) {
            this.originalColorTable = newTable;
        }
        this.currentColorTable = new ColorTable(newTable);
        this.setColorList(this.currentColorTable.getColorList(), null);
        this.breakpoints = ColorTableCanvas.cloneList(this.currentColorTable.getBreakpoints());
        if (this.breakpoints.size() == 0) {
            this.addToBreakpoints(0.0);
            this.addToBreakpoints(1.0);
        }
        if (this.categoryField != null) {
            this.categoryField.setSelectedItem(this.currentColorTable.getCategory());
            this.minField.setText(this.myRange.formatMin());
            this.maxField.setText(this.myRange.formatMax());
            this.repaint();
        }
        if (this.nameLabel != null) {
            this.nameLabel.setText(this.currentColorTable.getName());
            this.nameLabel.repaint();
        }
        if (this.editor != null) {
            this.editor.setWindowTitle(GuiUtils.getApplicationTitle() + "Color Table Editor -- " + this.currentColorTable.getName());
        }
        if (notifyChange) {
            this.tableChanged();
        }
    }

    public JPanel getContents() {
        this.colorChooser = new JColorChooser();
        this.colorChooser.setPreviewPanel(new JPanel());
        this.colorChooser.getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ColorTableCanvas.this.selectedColor = ColorTableCanvas.this.colorChooser.getColor();
                ColorTableCanvas.this.colorSwatch.setBackground(ColorTableCanvas.this.selectedColor);
                if (ColorTableCanvas.this.inPaint) {
                    return;
                }
                if (ColorTableCanvas.this.setColorFromChooserCbx.isSelected()) {
                    ColorTableCanvas.this.setColor(ColorTableCanvas.this.selectedColor);
                }
            }
        });
        this.colorChooser.removeChooserPanel(this.colorChooser.getChooserPanels()[0]);
        JPanel leftBtn = this.getAddRemoveButton(true);
        JPanel rightBtn = this.getAddRemoveButton(false);
        JPanel colorPanel = GuiUtils.leftCenterRight(leftBtn, this.colorCntLabel, rightBtn);
        this.minField.setText(this.myRange.formatMin());
        this.maxField.setText(this.myRange.formatMax());
        ActionListener minMaxListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorTableCanvas.this.setMinMax();
            }
        };
        this.minField.addActionListener(minMaxListener);
        this.maxField.addActionListener(minMaxListener);
        this.brightnessBox = new JComboBox(new Vector(this.getBrightnessList()));
        this.brightnessBox.setSelectedIndex(6);
        this.brightnessBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ColorTableCanvas.this.modeBrightnessBtn.setSelected(true);
                if (ColorTableCanvas.this.setColorFromChooserCbx.isSelected() && ColorTableCanvas.this.currentBP != null) {
                    ColorTableCanvas.this.setBrightness(ColorTableCanvas.this.currentBP, ColorTableCanvas.this.currentBP);
                }
            }
        });
        this.transBox = new JComboBox(new Vector(this.getTransparencyList()));
        Dimension preferred = this.transBox.getPreferredSize();
        this.transBox.setEditable(true);
        if (GuiUtils.checkHeight(preferred.height)) {
            this.transBox.setPreferredSize(preferred);
        }
        this.transBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (ColorTableCanvas.this.ignoreTransBoxEvents) {
                    return;
                }
                ColorTableCanvas.this.modeTransparencyBtn.setSelected(true);
                if (ColorTableCanvas.this.setColorFromChooserCbx.isSelected() && ColorTableCanvas.this.currentBP != null) {
                    ColorTableCanvas.this.ignoreTransBoxEvents = true;
                    ColorTableCanvas.this.setTransparency(ColorTableCanvas.this.currentBP, ColorTableCanvas.this.currentBP);
                    ColorTableCanvas.this.ignoreTransBoxEvents = false;
                }
            }
        });
        ButtonGroup modeGroup = new ButtonGroup();
        List modeBtns = Misc.newList(new JLabel("Paint Mode: "));
        this.colorSwatch = GuiUtils.filler(30, 15);
        this.colorSwatch.setSize(new Dimension(30, 15));
        this.colorSwatch.setBorder(BorderFactory.createLineBorder(Color.black));
        for (int i = 0; i < modes.length; ++i) {
            JRadioButton rb = new JRadioButton(modeNames[i], i == 0);
            modeGroup.add(rb);
            modeBtns.add(rb);
            rb.addItemListener(new ObjectListener(new Integer(modes[i])){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (((JRadioButton)e.getSource()).isSelected()) {
                        ColorTableCanvas.this.currentMode = (Integer)this.theObject;
                    }
                }
            });
            if (modes[i] == 2) {
                // empty if block
            }
            if (modes[i] == 3) {
                modeBtns.add(GuiUtils.left(GuiUtils.wrap(this.transBox)));
                this.modeTransparencyBtn = rb;
            }
            if (modes[i] != 4) continue;
            modeBtns.add(GuiUtils.left(GuiUtils.wrap(this.brightnessBox)));
            this.modeBrightnessBtn = rb;
        }
        JButton rangeBtn = new JButton("Range:");
        rangeBtn.addActionListener(minMaxListener);
        GuiUtils.setNoFill();
        GuiUtils.tmpInsets = new Insets(0, 2, 0, 2);
        JPanel valuePanel = GuiUtils.inset((Component)GuiUtils.doLayout(new Component[]{rangeBtn, this.minField, new JLabel("-"), this.maxField}, 4, GuiUtils.WT_N, GuiUtils.WT_N), 4);
        Msg.SkipPanel bottom = new Msg.SkipPanel(GuiUtils.leftCenterRight(leftBtn, this.colorCntLabel, rightBtn));
        JPanel thisComponent = GuiUtils.center(this);
        thisComponent.setBorder(BorderFactory.createEtchedBorder());
        JPanel modePanel = GuiUtils.hbox(modeBtns, 7);
        JPanel topPanel = GuiUtils.leftCenterRight(this.commands.getContents(), null, valuePanel);
        topPanel = GuiUtils.vbox((Component)topPanel, bottom);
        this.wrapper = GuiUtils.topCenterBottom(topPanel, thisComponent, GuiUtils.left(modePanel));
        JPanel wrapperWrapper = GuiUtils.inset((Component)this.wrapper, 5);
        this.nameLabel = new JLabel(this.currentColorTable.getName());
        Font font = this.nameLabel.getFont();
        this.nameLabel.setFont(font.deriveFont(3));
        this.categoryField = new JComboBox<Object>(this.editor.getColorTableManager().getCategories().toArray());
        this.categoryField.setToolTipText("Use \">\" to define sub-categories");
        this.categoryField.setEditable(true);
        this.categoryField.setSelectedItem(this.currentColorTable.getCategory());
        JPanel fieldPanel = GuiUtils.leftRight(GuiUtils.hbox(new JLabel("Color table: ", 4), this.nameLabel), GuiUtils.hbox(new JLabel("Category: ", 4), GuiUtils.wrap(this.categoryField)));
        this.setColorFromChooserCbx.setToolTipText("Automatically change the color of the selected breakpoint");
        Vector<TwoFacedObject> colorSpaces = new Vector<TwoFacedObject>();
        colorSpaces.add(new TwoFacedObject((Object)"Default", this.DFLT_COLOR_SPACE));
        colorSpaces.add(new TwoFacedObject((Object)"RGB", 1004));
        colorSpaces.add(new TwoFacedObject((Object)"SRGB", 1000));
        colorSpaces.add(new TwoFacedObject((Object)"CIE", 1001));
        colorSpaces.add(new TwoFacedObject((Object)"GRAY", 1003));
        colorSpaces.add(new TwoFacedObject((Object)"PYCC", 1002));
        this.colorSpaceCbx = new JComboBox(colorSpaces);
        JPanel colorChooserPanel = GuiUtils.topCenter(GuiUtils.leftRight(GuiUtils.hbox(this.setColorFromChooserCbx, GuiUtils.wrap(this.colorSwatch)), GuiUtils.label("Color Space:", this.colorSpaceCbx)), this.colorChooser);
        JPanel contents = GuiUtils.inset((Component)GuiUtils.topCenterBottom(GuiUtils.inset((Component)fieldPanel, 4), wrapperWrapper, colorChooserPanel), 4);
        return contents;
    }

    private List getTransparencyList() {
        ArrayList<TwoFacedObject> l = new ArrayList<TwoFacedObject>();
        int[] values = new int[]{0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100};
        for (int i = 0; i < values.length; ++i) {
            l.add(new TwoFacedObject((Object)(values[i] + "%"), new Integer(values[i])));
        }
        return l;
    }

    private List getBrightnessList() {
        ArrayList<TwoFacedObject> l = new ArrayList<TwoFacedObject>();
        float[] values = new float[]{1.6f, 1.5f, 1.4f, 1.3f, 1.2f, 1.1f, 1.0f, 0.9f, 0.8f, 0.7f, 0.6f, 0.5f, 0.4f};
        for (int i = 0; i < values.length; ++i) {
            float v = values[i];
            String name = (int)(v * 100.0f) + "%";
            l.add(new TwoFacedObject((Object)name, new Float(v)));
        }
        return l;
    }

    public void setTransparency() {
        if (this.haveBreakpointSelected()) {
            int index = this.percentToColorIndex(this.getPercent(this.currentBP));
            Color c = (Color)this.colorList.get(index);
            this.colorList.set(index, new Color(c.getRed(), c.getGreen(), c.getBlue(), this.getAlphaInt()));
            this.repaint();
        }
    }

    private int getAlphaInt() {
        return (int)(255.0f * this.getTransparency());
    }

    private float getBrightness() {
        TwoFacedObject selected = (TwoFacedObject)this.brightnessBox.getSelectedItem();
        Float f = (Float)selected.getId();
        return f.floatValue();
    }

    private float getTransparency() {
        Object selected = this.transBox.getSelectedItem();
        int value = 0;
        if (selected instanceof TwoFacedObject) {
            TwoFacedObject tfo = (TwoFacedObject)selected;
            value = (Integer)tfo.getId();
        } else {
            String text = selected.toString();
            try {
                text = StringUtil.replace(text, "%", "").trim();
                value = (int)new Float(text).floatValue();
            }
            catch (Exception e) {
                return 1.0f;
            }
        }
        value = 100 - value;
        if (value < 0) {
            value = 0;
        }
        if (value > 100) {
            value = 100;
        }
        return (float)value / 100.0f;
    }

    private boolean isShift(ActionEvent e) {
        return (e.getModifiers() & 1) != 0;
    }

    private JPanel getAddRemoveButton(final boolean start) {
        JButton addColorBtn = GuiUtils.getImageButton(GuiUtils.getImageIcon("plus.gif", this.getClass()));
        addColorBtn.setToolTipText("Add color ('+')");
        addColorBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ColorTableCanvas.this.addColor(start, ColorTableCanvas.this.isShift(event) ? 10 : 1);
            }
        });
        JButton remColorBtn = GuiUtils.getImageButton(GuiUtils.getImageIcon("minus.gif", this.getClass()));
        remColorBtn.setToolTipText("Remove color ('-')");
        remColorBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ColorTableCanvas.this.removeColor(start, ColorTableCanvas.this.isShift(event) ? 10 : 1);
            }
        });
        remColorBtn.setBorder(BorderFactory.createEmptyBorder());
        addColorBtn.setBorder(BorderFactory.createEmptyBorder());
        return GuiUtils.hbox(remColorBtn, addColorBtn);
    }

    @Override
    public void setName(String name) {
        ColorTable newColorTable = new ColorTable(this.currentColorTable);
        newColorTable.setName(name);
        this.currentColorTable = newColorTable;
        this.commands.add(new ColorTableCommand(this, newColorTable));
    }

    protected void setMinMax() {
        double max;
        double min;
        try {
            min = Misc.parseNumber(this.minField.getText());
        }
        catch (NumberFormatException pe) {
            LogUtil.userMessage(log_, "Incorrect value:" + this.minField.getText());
            return;
        }
        try {
            max = Misc.parseNumber(this.maxField.getText());
        }
        catch (NumberFormatException pe) {
            LogUtil.userMessage(log_, "Incorrect value:" + this.maxField.getText());
            return;
        }
        this.myRange.setMin(min);
        this.myRange.setMax(max);
        this.rangeChanged();
        this.repaint();
    }

    protected void setRange(double min, double max) {
        this.minField.setText(Misc.format(min));
        this.maxField.setText(Misc.format(max));
        this.myRange.setMin(min);
        this.myRange.setMax(max);
        this.repaint();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public boolean isStandAlone() {
        return this.listeners == null || this.listeners.size() == 0;
    }

    private static Color applyBrightness(Color c, float b) {
        if ((double)b != 1.0) {
            c = new Color(Math.min(255, (int)(b * (float)c.getRed())), Math.min(255, (int)(b * (float)c.getGreen())), Math.min(255, (int)(b * (float)c.getBlue())), c.getAlpha());
        }
        return c;
    }

    public ColorTable getCurrentColorTable() {
        if (this.categoryField != null) {
            String currentCategory = (String)this.categoryField.getSelectedItem();
            ArrayList<Color> actualColors = new ArrayList<Color>();
            for (int i = 0; i < this.colorList.size(); ++i) {
                float bright = ((Float)this.scales.get(i)).floatValue();
                Color c = ColorTableCanvas.applyBrightness((Color)this.colorList.get(i), bright);
                actualColors.add(c);
            }
            if (currentCategory != null) {
                currentCategory = currentCategory.trim();
                return this.currentColorTable.init(this.currentColorTable.getName(), currentCategory, actualColors, this.scales, this.breakpoints, this.myRange);
            }
        }
        return this.currentColorTable;
    }

    public void doClose() {
        this.propagateEvent(PROP_CLOSE, null);
    }

    public void doApply() {
        this.tableChanged(true);
        this.rangeChanged(true);
    }

    public void doCancel() {
        this.setColorTableInner(this.originalColorTable, false);
        this.propagateEvent(PROP_CANCEL, this.originalColorTable);
    }

    public void tableChanged() {
        this.tableChanged(false);
    }

    public void tableChanged(boolean force) {
        if (!this.okToPropagateChangesNow) {
            this.needToPropagateChanges = true;
            return;
        }
        if (force || this.propagateChanges) {
            this.propagateEvent(PROP_COLORTABLE, this.getCurrentColorTable());
        }
    }

    public void rangeChanged() {
        this.rangeChanged(false);
    }

    private void rangeChanged(boolean force) {
        if (force || this.propagateChanges) {
            this.propagateEvent(PROP_RANGE, this.myRange);
        }
        if (this.isStandAlone()) {
            this.currentColorTable.setRange(this.myRange);
        }
    }

    public void setPropagateChanges(boolean v) {
        this.propagateChanges = v;
    }

    private void propagateEvent(String event, Object data) {
        this.propagateEvent(new PropertyChangeEvent(this, event, null, data));
    }

    private void propagateEvent(PropertyChangeEvent event) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((PropertyChangeListener)this.listeners.get(i)).propertyChange(event);
        }
    }

    private void setColorList(ArrayList colors, ArrayList brightnessList) {
        this.colorList = new ArrayList(colors);
        this.scales = brightnessList;
        if (this.scales == null) {
            this.scales = new ArrayList();
            for (int i = 0; i < this.colorList.size(); ++i) {
                this.scales.add(new Float(1.0f));
            }
        }
        this.colorsChanged();
    }

    public void colorsChanged() {
        this.repaint();
        this.colorCntLabel.setText(this.colorList.size() + " colors");
    }

    public void addColor(boolean start, int cnt) {
        this.prepColorChange();
        while (cnt-- > 0) {
            if (start) {
                this.colorList.add(0, this.colorList.get(0));
                this.scales.add(0, new Float(1.0f));
                continue;
            }
            this.colorList.add(this.colorList.get(this.colorList.size() - 1));
            this.scales.add(new Float(1.0f));
        }
        this.colorsChanged();
        this.tableChanged();
    }

    public void removeColor(boolean start, int cnt) {
        while (cnt-- > 0 && this.colorList.size() > 5) {
            this.prepColorChange();
            if (start) {
                this.colorList.remove(0);
                this.scales.remove(0);
            } else {
                this.colorList.remove(this.colorList.size() - 1);
                this.scales.remove(this.scales.size() - 1);
            }
            this.colorsChanged();
            this.tableChanged();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        boolean moveRight = code == 227 || code == 39;
        boolean moveLeft = code == 226 || code == 37;
        char c = e.getKeyChar();
        if (e.isControlDown()) {
            if (code == 67) {
                if (this.currentBP != null) {
                    this.addBreakpointAtData(this.currentBP);
                }
                this.lastControlKey = -1;
                return;
            }
            if (code == 76) {
                if (this.currentBP != null) {
                    this.saveCurrentBreakpoints();
                    this.currentBP.setLocked(true);
                    this.repaint();
                }
                this.lastControlKey = -1;
                return;
            }
            if (code == 85) {
                if (this.currentBP != null) {
                    this.saveCurrentBreakpoints();
                    this.currentBP.setLocked(false);
                    this.repaint();
                }
                this.lastControlKey = -1;
                return;
            }
            if (code == 90) {
                this.commands.undo();
                this.lastControlKey = -1;
                return;
            }
            if (code == 89) {
                this.commands.redo();
                this.lastControlKey = -1;
                return;
            }
            String type = null;
            String dir = null;
            if (moveRight) {
                dir = "Right";
            } else if (moveLeft) {
                dir = "Left";
            } else if (code == 65) {
                dir = "All";
            } else {
                if (code != 17) {
                    this.lastControlKey = code;
                    return;
                }
                return;
            }
            if (this.lastControlKey == 70) {
                type = "fill";
            } else if (this.lastControlKey == 73) {
                type = "interpolate";
            } else if (this.lastControlKey == 84) {
                type = "trans";
            } else if (this.lastControlKey == 66) {
                type = "bright";
            } else if (code != 17) {
                this.lastControlKey = code;
            }
            if (type != null && dir != null) {
                this.lastControlKey = -1;
                Misc.run(this, type + dir);
            }
            return;
        }
        this.lastControlKey = -1;
        if (code == 32) {
            if (this.breakpoints.size() == 0) {
                return;
            }
            if (this.currentBP != null) {
                this.currentBP = this.getNext(this.currentBP);
            }
            if (this.currentBP == null) {
                this.currentBP = this.getMin();
            }
            this.repaint();
        } else if (code == 521) {
            this.addColor(false, 1);
        } else if (code == 45) {
            this.removeColor(false, 1);
        } else if (GuiUtils.isDeleteEvent(e)) {
            this.removeBreakpoint();
        } else if (this.currentBP != null && !this.currentBP.getLocked() && (moveRight || moveLeft)) {
            int idx = this.percentToColorIndex(this.currentBP.getValue());
            if (moveLeft && idx == 0) {
                return;
            }
            if (moveRight && idx == this.colorList.size() - 1) {
                return;
            }
            int nextIdx = moveRight ? idx + 1 : idx - 1;
            this.lastChangeIdx = -1;
            if (this.currentMode == 3) {
                this.prepColorChange();
                this.setTransparencyFromTo(nextIdx, nextIdx);
            } else if (this.currentMode == 2) {
                this.prepColorChange();
                this.fillFromTo(this.activeColor, nextIdx, nextIdx);
            } else if (this.currentMode == 4) {
                this.prepColorChange();
                this.setBrightnessFromTo(nextIdx, nextIdx);
            } else {
                this.saveCurrentBreakpoints();
            }
            double perc = (double)nextIdx / (double)(this.colorList.size() - 1);
            this.currentBP.setValue(perc);
            this.repaint();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.checkCursor(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.requestFocus();
        this.checkCursor(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public Cursor getPaintCursor() {
        if (paintCursor == null) {
            Image image = GuiUtils.getImage("/auxdata/ui/icons/paintbrush.png", this.getClass(), true);
            paintCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), "paintcursor");
        }
        return paintCursor;
    }

    public void checkCursor(MouseEvent e) {
        if (this.cursorOver == this.reallyInBox(e)) {
            if (this.cursorPosition != e.getX()) {
                this.cursorPosition = e.getX();
                this.repaint();
            }
            return;
        }
        this.cursorOver = !this.cursorOver;
        this.cursorPosition = e.getX();
        if (this.cursorOver) {
            this.setCursor(this.getPaintCursor());
        } else {
            this.setCursor(normalCursor);
        }
        this.repaint();
    }

    public boolean isInBox(MouseEvent event) {
        Rectangle box = this.getColorBox();
        int ex = event.getX();
        int ey = event.getY();
        if (ey < box.y) {
            return false;
        }
        return ey <= box.y + box.height;
    }

    public boolean reallyInBox(MouseEvent event) {
        Rectangle box = this.getColorBox();
        return box.contains(new Point(event.getX(), event.getY()));
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (!SwingUtilities.isLeftMouseButton(event)) {
            return;
        }
        this.mouseInBox = this.isInBox(event);
        if (!this.mouseInBox && !this.selectBreakpoint(event)) {
            return;
        }
        switch (this.currentMode) {
            case 0: {
                this.saveCurrentBreakpoints();
                break;
            }
            default: {
                this.activePercent = this.xToPercent(event.getX());
                this.prepColorChange();
                this.activeColor = this.mouseInBox ? this.colorChooser.getColor() : this.getBreakpointColor(this.currentBP);
                this.activeColorIndex = this.percentToColorIndex(this.xToPercent(event.getX()));
                if (this.currentMode == 1) {
                    this.activeColor = (Color)this.colorList.get(this.activeColorIndex);
                }
                this.priorColors = (ArrayList)this.colorList.clone();
                if (!this.mouseInBox || this.activeColorIndex < 0) break;
                if (this.currentMode == 4) {
                    this.setBrightnessFromTo(this.activeColorIndex, this.activeColorIndex);
                } else if (this.currentMode == 2 && this.selectedColor != null) {
                    this.colorList.set(this.activeColorIndex, this.selectedColor);
                } else if (this.currentMode == 3) {
                    this.setTransparencyFromTo(this.activeColorIndex, this.activeColorIndex);
                }
                this.tableChanged();
                this.repaint();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        this.checkCursor(event);
        int x = 0;
        if (!this.mouseInBox) {
            if (!this.haveBreakpointSelected()) {
                return;
            }
            if (this.currentBP != null && this.currentBP.getLocked()) {
                return;
            }
            this.currentBP.setValue(this.xToPercent(event.getX()));
            x = this.getBreakpointX(this.currentBP);
            this.repaint();
            return;
        }
        x = event.getX();
        if (this.currentMode != 0) {
            boolean ok;
            this.colorList = (ArrayList)this.priorColors.clone();
            int startColorIndex = this.activeColorIndex;
            Color startColor = this.activeColor;
            int endColorIndex = this.percentToColorIndex(this.xToPercent(x));
            Color endColor = (Color)this.priorColors.get(endColorIndex);
            if (endColorIndex <= startColorIndex) {
                int tmp = endColorIndex;
                endColorIndex = startColorIndex;
                startColorIndex = tmp;
                Color tmpc = endColor;
                endColor = startColor;
                startColor = tmpc;
            }
            this.okToPropagateChangesNow = false;
            if (this.currentMode == 1) {
                this.interpolate(startColorIndex, endColorIndex, startColor, endColor);
            } else if (this.currentMode == 2) {
                this.fillFromTo(this.activeColor, startColorIndex, endColorIndex);
            } else if (this.currentMode == 4) {
                ok = true;
                if (startColorIndex == endColorIndex && Math.abs(this.percentToX(this.activePercent) - this.percentToX(this.xToPercent(event.getX()))) < 3) {
                    ok = false;
                }
                if (ok) {
                    this.setBrightnessFromTo(startColorIndex, endColorIndex);
                }
            } else if (this.currentMode == 3) {
                ok = true;
                if (startColorIndex == endColorIndex && Math.abs(this.percentToX(this.activePercent) - this.percentToX(this.xToPercent(event.getX()))) < 3) {
                    ok = false;
                }
                if (ok) {
                    this.setTransparencyFromTo(startColorIndex, endColorIndex);
                }
            }
            this.okToPropagateChangesNow = true;
        }
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (!SwingUtilities.isLeftMouseButton(event)) {
            return;
        }
        this.currentBP = null;
        if (this.needToPropagateChanges) {
            this.needToPropagateChanges = false;
            this.tableChanged();
        }
        this.selectBreakpoint(event);
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        JMenuItem mi;
        final double xPercent = this.xToPercent(event.getX());
        if (!SwingUtilities.isRightMouseButton(event)) {
            if (event.getClickCount() > 1) {
                this.insertBreakpoint(xPercent);
            }
            return;
        }
        if (!this.selectBreakpoint(event)) {
            this.currentBP = null;
            this.repaint();
        }
        JPopupMenu popup = new JPopupMenu();
        if (this.currentBP != null) {
            mi = GuiUtils.makeMenuItem("Remove Breakpoint", this, "removeBreakpoint");
            popup.add(mi);
            mi.setToolTipText("Delete");
            mi = GuiUtils.makeMenuItem(this.currentBP.getLocked() ? "Unlock Breakpoint" : "Lock Breakpoint", this, "lockUnlockBreakpoint", this.currentBP);
            popup.add(mi);
            mi.setToolTipText("Control-l;Control-u");
            mi = GuiUtils.makeMenuItem("Change Breakpoint", this, "addBreakpointAtData", this.currentBP);
            popup.add(mi);
            mi.setToolTipText("Control-c");
            popup.addSeparator();
        }
        JMenu addMenu = new JMenu("Add Breakpoint");
        popup.add(addMenu);
        mi = new JMenuItem("Here");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorTableCanvas.this.insertBreakpoint(xPercent);
            }
        });
        addMenu.add(mi);
        addMenu.add(GuiUtils.makeMenuItem("At Data Point", this, "addBreakpointAtData"));
        addMenu.add(GuiUtils.makeMenuItem("At Beginning", this, "addBreakpointBeginning"));
        addMenu.add(GuiUtils.makeMenuItem("At End", this, "addBreakpointEnd"));
        JMenu colorsMenu = new JMenu("Edit Colors");
        popup.add(colorsMenu);
        JMenu interpMenu = new JMenu("Interpolate");
        colorsMenu.add(interpMenu);
        mi = GuiUtils.makeMenuItem("All", this, "interpolateAll");
        interpMenu.add(mi);
        mi.setToolTipText("Control-i;Control-a");
        if (this.currentBP != null) {
            mi = GuiUtils.makeMenuItem("Left", this, "interpolateLeft");
            interpMenu.add(mi);
            mi.setToolTipText("Control-i;Control-left arrow");
            mi = GuiUtils.makeMenuItem("Right", this, "interpolateRight");
            interpMenu.add(mi);
            mi.setToolTipText("Control-i;Control-right arrow");
        }
        JMenu fillMenu = new JMenu("Fill");
        colorsMenu.add(fillMenu);
        mi = GuiUtils.makeMenuItem("All", this, "fillAll");
        fillMenu.add(mi);
        mi.setToolTipText("Control-f;Control-a");
        if (this.currentBP != null) {
            mi = GuiUtils.makeMenuItem("Left", this, "fillLeft");
            fillMenu.add(mi);
            mi.setToolTipText("Control-f;Control-left arrow");
            mi = GuiUtils.makeMenuItem("Right", this, "fillRight");
            fillMenu.add(mi);
            mi.setToolTipText("Control-f;Control-right arrow");
        }
        String transLbl = this.transBox.getSelectedItem().toString();
        JMenu transMenu = new JMenu("Transparency (" + transLbl + ")");
        colorsMenu.add(transMenu);
        mi = GuiUtils.makeMenuItem("All", this, "transAll");
        transMenu.add(mi);
        mi.setToolTipText("Control-t;Control-a");
        if (this.currentBP != null) {
            mi = GuiUtils.makeMenuItem("Left", this, "transLeft");
            transMenu.add(mi);
            mi.setToolTipText("Control-t;Control-left arrow");
            mi = GuiUtils.makeMenuItem("Right", this, "transRight");
            transMenu.add(mi);
            mi.setToolTipText("Control-t;Control-right arrow");
            mi = GuiUtils.makeMenuItem("Set", this, "setTransparency");
            transMenu.add(mi);
            JMenu interpTrans = new JMenu("Interpolate");
            transMenu.add(interpTrans);
            mi = GuiUtils.makeMenuItem("All", this, "interpolateTransAll");
            interpTrans.add(mi);
            mi = GuiUtils.makeMenuItem("Left", this, "interpolateTransLeft");
            interpTrans.add(mi);
            mi = GuiUtils.makeMenuItem("Right", this, "interpolateTransRight");
            interpTrans.add(mi);
        }
        String brightLbl = this.brightnessBox.getSelectedItem().toString();
        JMenu scaleMenu = new JMenu("Brightness (" + brightLbl + ")");
        colorsMenu.add(scaleMenu);
        mi = GuiUtils.makeMenuItem("All", this, "brightAll");
        scaleMenu.add(mi);
        mi.setToolTipText("Control-b;Control-a");
        if (this.currentBP != null) {
            mi = GuiUtils.makeMenuItem("Left", this, "brightLeft");
            scaleMenu.add(mi);
            mi.setToolTipText("Control-b;Control-left arrow");
            mi = GuiUtils.makeMenuItem("Right", this, "brightRight");
            scaleMenu.add(mi);
            mi.setToolTipText("Control-b;Control-right arrow");
            JMenu interpBrightness = new JMenu("Interpolate");
            scaleMenu.add(interpBrightness);
            mi = GuiUtils.makeMenuItem("All", this, "interpolateBrightnessAll");
            interpBrightness.add(mi);
            mi = GuiUtils.makeMenuItem("Left", this, "interpolateBrightnessLeft");
            interpBrightness.add(mi);
            mi = GuiUtils.makeMenuItem("Right", this, "interpolateBrightnessRight");
            interpBrightness.add(mi);
        }
        popup.add(GuiUtils.makeMenuItem("Replicate Color Table", this, "replicate"));
        popup.add(GuiUtils.makeMenuItem("Invert Color Table", this, "invert"));
        popup.show(this, event.getX(), event.getY());
    }

    private boolean selectBreakpoint(MouseEvent e) {
        int minDistance = Integer.MAX_VALUE;
        ColorTable.Breakpoint minBreakpoint = null;
        for (int i = 0; i < this.breakpoints.size(); ++i) {
            ColorTable.Breakpoint bp = (ColorTable.Breakpoint)this.breakpoints.get(i);
            int distance = Math.abs(e.getX() - this.getBreakpointX(bp));
            if (distance >= minDistance || distance >= 10) continue;
            minDistance = distance;
            minBreakpoint = bp;
        }
        this.repaint();
        this.currentBP = minBreakpoint;
        return minBreakpoint != null;
    }

    public void addBreakpointAtData() {
        this.addBreakpointAtData(null);
    }

    public void addBreakpointAtData(ColorTable.Breakpoint bp) {
        String initString = "";
        if (bp != null) {
            initString = Misc.format(this.percentToValue(this.getPercent(bp)));
        } else {
            bp = new ColorTable.Breakpoint();
            this.breakpoints.add(bp);
        }
        String inputValue;
        while ((inputValue = GuiUtils.getInput("Please enter a data value between " + this.myRange.formatMin() + " and " + this.myRange.formatMax(), "Value: ", initString, null, null, "Breakpoint Value", 5)) != null) {
            try {
                double d = Misc.parseNumber(inputValue);
                double percent = Math.max(Math.min(this.myRange.getPercent(d), 1.0), 0.0);
                this.saveCurrentBreakpoints();
                bp.setValue(percent);
                this.currentBP = bp;
                this.repaint();
                return;
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(null, "Incorrect number format:" + inputValue, "Error", 0);
                continue;
            }
            break;
        }
        return;
    }

    public void insertBreakpoint(double percent) {
        this.saveCurrentBreakpoints();
        this.currentBP = new ColorTable.Breakpoint(percent);
        this.breakpoints.add(this.currentBP);
        this.repaint();
    }

    private ColorTable.Breakpoint getNext(ColorTable.Breakpoint bp) {
        if (bp == null) {
            return null;
        }
        ColorTable.Breakpoint next = null;
        double minDiff = 0.0;
        for (int i = 0; i < this.breakpoints.size(); ++i) {
            ColorTable.Breakpoint tmp = (ColorTable.Breakpoint)this.breakpoints.get(i);
            if (tmp == bp || tmp.getValue() <= bp.getValue() || next != null && !(tmp.getValue() - bp.getValue() < minDiff)) continue;
            minDiff = tmp.getValue() - bp.getValue();
            next = tmp;
        }
        return next;
    }

    private ColorTable.Breakpoint getMin() {
        ColorTable.Breakpoint min = null;
        double minValue = 0.0;
        for (int i = 0; i < this.breakpoints.size(); ++i) {
            ColorTable.Breakpoint tmp = (ColorTable.Breakpoint)this.breakpoints.get(i);
            if (min != null && !(tmp.getValue() < minValue)) continue;
            min = tmp;
            minValue = tmp.getValue();
        }
        return min;
    }

    private ColorTable.Breakpoint getPrevious(ColorTable.Breakpoint bp) {
        if (bp == null) {
            return null;
        }
        ColorTable.Breakpoint prev = null;
        double minDiff = 0.0;
        for (int i = 0; i < this.breakpoints.size(); ++i) {
            ColorTable.Breakpoint tmp = (ColorTable.Breakpoint)this.breakpoints.get(i);
            if (tmp == bp || tmp.getValue() >= bp.getValue() || prev != null && !(bp.getValue() - tmp.getValue() < minDiff)) continue;
            minDiff = bp.getValue() - tmp.getValue();
            prev = tmp;
        }
        return prev;
    }

    private boolean haveBreakpointSelected() {
        return this.currentBP != null;
    }

    private void saveCurrentBreakpoints() {
        this.lastChangeIdx = -1;
        this.commands.add(new CanvasCommand(this));
    }

    private void prepColorChange() {
        this.prepColorChange(-1);
    }

    private void prepColorChange(int idx) {
        if (idx == -1 || idx != this.lastChangeIdx) {
            this.commands.add(new ColorListCommand(this));
            this.lastChangeIdx = idx;
        }
    }

    public void debug() {
        System.err.println("" + this.commands);
    }

    public void removeBreakpoint() {
        if (this.currentBP != null) {
            this.saveCurrentBreakpoints();
            this.breakpoints.remove(this.currentBP);
            this.currentBP = null;
            this.repaint();
        }
    }

    public void lockUnlockBreakpoint(ColorTable.Breakpoint bp) {
        this.saveCurrentBreakpoints();
        bp.setLocked(!bp.getLocked());
        this.repaint();
    }

    public void addBreakpointBeginning() {
        this.saveCurrentBreakpoints();
        this.currentBP = this.addToBreakpoints(0.0);
        this.repaint();
    }

    public void addBreakpointEnd() {
        this.saveCurrentBreakpoints();
        this.currentBP = this.addToBreakpoints(1.0);
        this.repaint();
    }

    private ColorTable.Breakpoint addToBreakpoints(double d) {
        ColorTable.Breakpoint bp = new ColorTable.Breakpoint(d);
        this.breakpoints.add(bp);
        this.currentBP = bp;
        return bp;
    }

    public void setColor(Color c) {
        if (this.currentBP == null) {
            return;
        }
        double percent = this.currentBP.getValue();
        int index = this.percentToColorIndex(percent);
        Color current = (Color)this.colorList.get(index);
        if (current == c) {
            return;
        }
        this.prepColorChange(index);
        this.colorList.set(index, new Color(c.getRed(), c.getGreen(), c.getBlue(), current.getAlpha()));
        this.repaint();
    }

    private String getBreakpointLabel(ColorTable.Breakpoint bp) {
        return Misc.format(this.percentToValue(bp.getValue()));
    }

    private int getBreakpointX(ColorTable.Breakpoint bp) {
        return this.percentToX(this.getPercent(bp));
    }

    private double getPercent(ColorTable.Breakpoint bp) {
        return this.getPercent(bp, 0.0);
    }

    private double getPercent(ColorTable.Breakpoint bp, double dflt) {
        if (bp == null) {
            return dflt;
        }
        return bp.getValue();
    }

    private Color getBreakpointColor(ColorTable.Breakpoint bp) {
        if (bp == null) {
            return null;
        }
        return this.percentToColor(bp.getValue());
    }

    public int boxWidth() {
        return this.getColorBox().width;
    }

    public double xToPercent(int x) {
        return Math.max(Math.min(1.0, (double)(x - 40) / (double)this.boxWidth()), 0.0);
    }

    public int percentToX(double percent) {
        return 40 + (int)(percent * (double)this.boxWidth());
    }

    public double percentToValue(double percent) {
        return this.myRange.getValueOfPercent(percent);
    }

    public void interpolateAll() {
        this.prepColorChange();
        this.interpolate(0, this.colorList.size() - 1, (Color)this.colorList.get(0), (Color)this.colorList.get(this.colorList.size() - 1));
    }

    public void interpolateLeft() {
        this.interpolate(this.getPrevious(this.currentBP), this.currentBP);
    }

    public void interpolateRight() {
        this.interpolate(this.currentBP, this.getNext(this.currentBP));
    }

    public void interpolateTransAll() {
        this.prepColorChange();
        this.interpolateTrans(0, this.colorList.size() - 1, (Color)this.colorList.get(0), (Color)this.colorList.get(this.colorList.size() - 1));
    }

    public void interpolateTransLeft() {
        this.interpolateTrans(this.getPrevious(this.currentBP), this.currentBP);
    }

    public void interpolateTransRight() {
        this.interpolateTrans(this.currentBP, this.getNext(this.currentBP));
    }

    public void interpolateBrightnessAll() {
        this.prepColorChange();
        this.interpolateBrightness(0, this.colorList.size() - 1, (Color)this.colorList.get(0), (Color)this.colorList.get(this.colorList.size() - 1));
    }

    public void interpolateBrightnessLeft() {
        this.interpolateBrightness(this.getPrevious(this.currentBP), this.currentBP);
    }

    public void interpolateBrightnessRight() {
        this.interpolateBrightness(this.currentBP, this.getNext(this.currentBP));
    }

    public void replicate() {
        String inputValue = "1";
        while ((inputValue = GuiUtils.getInput("How many times do you want to replicate the color table?", "Value: ", inputValue, null, null, "Replicate Color Table", 5)) != null) {
            try {
                int count = new Integer(inputValue.trim());
                this.prepColorChange();
                if (count > 100) {
                    count = 100;
                }
                ArrayList tmp = new ArrayList(this.colorList);
                for (int i = 0; i < count; ++i) {
                    for (int j = 0; j < tmp.size(); ++j) {
                        this.colorList.add(tmp.get(j));
                        this.scales.add(new Float(1.0f));
                    }
                }
                this.colorsChanged();
                this.repaint();
                return;
            }
            catch (NumberFormatException nfe) {
                LogUtil.userErrorMessage("Bad input value:" + inputValue);
                continue;
            }
            break;
        }
        return;
    }

    public void invert() {
        int i;
        this.prepColorChange();
        ArrayList tmpColors = new ArrayList(this.colorList);
        ArrayList tmpScales = new ArrayList(this.scales);
        this.colorList = new ArrayList();
        this.scales = new ArrayList();
        for (i = 0; i < tmpColors.size(); ++i) {
            this.colorList.add(0, tmpColors.get(i));
        }
        for (i = 0; i < tmpScales.size(); ++i) {
            this.scales.add(0, tmpScales.get(i));
        }
        this.colorsChanged();
        this.repaint();
    }

    public void interpolate(ColorTable.Breakpoint from, ColorTable.Breakpoint to) {
        int lowerColorIndex = this.percentToColorIndex(from != null ? from.getValue() : 0.0);
        int upperColorIndex = this.percentToColorIndex(to != null ? to.getValue() : 1.0);
        this.prepColorChange();
        this.interpolate(lowerColorIndex, upperColorIndex, (Color)this.colorList.get(lowerColorIndex), (Color)this.colorList.get(upperColorIndex));
    }

    public void interpolate(int lowerColorIndex, int upperColorIndex, Color lowerColor, Color upperColor) {
        int colorSpace = (Integer)((TwoFacedObject)this.colorSpaceCbx.getSelectedItem()).getId();
        if (colorSpace == this.DFLT_COLOR_SPACE) {
            this.oldInterpolate(lowerColorIndex, upperColorIndex, lowerColor, upperColor);
        } else {
            this.newInterpolate(colorSpace, lowerColorIndex, upperColorIndex, lowerColor, upperColor);
        }
        this.tableChanged();
        this.repaint();
    }

    public void newInterpolate(int colorSpace, int lowerColorIndex, int upperColorIndex, Color lowerColor, Color upperColor) {
        float steps = upperColorIndex - lowerColorIndex + 1;
        ColorSpace rgb = ColorSpace.getInstance(1004);
        rgb = lowerColor.getColorSpace();
        ColorSpace other = ColorSpace.getInstance(colorSpace);
        float[] comps1 = rgb.toCIEXYZ(lowerColor.getColorComponents(rgb, null));
        float[] comps2 = rgb.toCIEXYZ(upperColor.getColorComponents(rgb, null));
        comps1 = other.fromCIEXYZ(comps1);
        comps2 = other.fromCIEXYZ(comps2);
        float[] stepArray = new float[comps1.length];
        for (int j = 0; j < comps1.length; ++j) {
            stepArray[j] = (comps2[j] - comps1[j]) / steps;
        }
        int cnt = 0;
        float[] tmp = new float[comps1.length];
        int i = lowerColorIndex;
        while (i <= upperColorIndex) {
            try {
                Color current = (Color)this.colorList.get(i);
                for (int j = 0; j < comps1.length; ++j) {
                    tmp[j] = comps1[j] + stepArray[j] * (float)i;
                    if (tmp[j] < 1.0E-4f) {
                        tmp[j] = 0.0f;
                        continue;
                    }
                    if (!(tmp[j] > 1.0f)) continue;
                    tmp[j] = 1.0f;
                }
                Color c = new Color(other, tmp, (float)current.getAlpha() / 255.0f);
                this.colorList.set(i, c);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++i;
            ++cnt;
        }
    }

    public void oldInterpolate(int lowerColorIndex, int upperColorIndex, Color lowerColor, Color upperColor) {
        float steps = upperColorIndex - lowerColorIndex + 1;
        double redStep = (float)(upperColor.getRed() - lowerColor.getRed()) / steps;
        double greenStep = (float)(upperColor.getGreen() - lowerColor.getGreen()) / steps;
        double blueStep = (float)(upperColor.getBlue() - lowerColor.getBlue()) / steps;
        int cnt = 0;
        int i = lowerColorIndex;
        while (i <= upperColorIndex) {
            Color current = (Color)this.colorList.get(i);
            int newRed = lowerColor.getRed() + (int)(redStep * (double)cnt);
            int newGreen = lowerColor.getGreen() + (int)(greenStep * (double)cnt);
            int newBlue = lowerColor.getBlue() + (int)(blueStep * (double)cnt);
            this.colorList.set(i, new Color(newRed, newGreen, newBlue, current.getAlpha()));
            ++i;
            ++cnt;
        }
    }

    public void interpolateTrans(ColorTable.Breakpoint from, ColorTable.Breakpoint to) {
        int lowerColorIndex = this.percentToColorIndex(from != null ? from.getValue() : 0.0);
        int upperColorIndex = this.percentToColorIndex(to != null ? to.getValue() : 1.0);
        this.prepColorChange();
        this.interpolateTrans(lowerColorIndex, upperColorIndex, (Color)this.colorList.get(lowerColorIndex), (Color)this.colorList.get(upperColorIndex));
    }

    public void interpolateTrans(int lowerColorIndex, int upperColorIndex, Color lowerColor, Color upperColor) {
        double steps = upperColorIndex - lowerColorIndex + 1;
        double alphaStep = (double)(upperColor.getAlpha() - lowerColor.getAlpha()) / steps;
        int cnt = 0;
        int i = lowerColorIndex;
        while (i <= upperColorIndex) {
            int newAlpha = lowerColor.getAlpha() + (int)(alphaStep * (double)cnt);
            Color current = (Color)this.colorList.get(i);
            this.colorList.set(i, new Color(current.getRed(), current.getGreen(), current.getBlue(), newAlpha));
            ++i;
            ++cnt;
        }
        this.tableChanged();
        this.repaint();
    }

    public void interpolateBrightness(ColorTable.Breakpoint from, ColorTable.Breakpoint to) {
        int lowerColorIndex = this.percentToColorIndex(from != null ? from.getValue() : 0.0);
        int upperColorIndex = this.percentToColorIndex(to != null ? to.getValue() : 1.0);
        this.prepColorChange();
        this.interpolateBrightness(lowerColorIndex, upperColorIndex, (Color)this.colorList.get(lowerColorIndex), (Color)this.colorList.get(upperColorIndex));
    }

    public void interpolateBrightness(int lowerColorIndex, int upperColorIndex, Color lowerColor, Color upperColor) {
        float steps = upperColorIndex - lowerColorIndex + 1;
        float f1 = ((Float)this.scales.get(lowerColorIndex)).floatValue();
        float f2 = ((Float)this.scales.get(upperColorIndex)).floatValue();
        float brightnessStep = (f2 - f1) / steps;
        int cnt = 0;
        int i = lowerColorIndex;
        while (i <= upperColorIndex) {
            float newBrightness = f1 + brightnessStep * (float)cnt;
            this.scales.set(i, new Float(newBrightness));
            ++i;
            ++cnt;
        }
        this.tableChanged();
        this.repaint();
    }

    public void fillLeft() {
        this.fill(this.percentToColor(this.getPercent(this.currentBP)), this.getPrevious(this.currentBP), this.currentBP);
    }

    public void fillRight() {
        this.fill(this.percentToColor(this.getPercent(this.currentBP)), this.currentBP, this.getNext(this.currentBP));
    }

    public void fill(Color color, ColorTable.Breakpoint from, ColorTable.Breakpoint to) {
        int lowerIndex = this.percentToColorIndex(from != null ? from.getValue() : 0.0);
        int upperIndex = this.percentToColorIndex(to != null ? to.getValue() : 1.0);
        this.prepColorChange();
        this.fillFromTo(color, lowerIndex, upperIndex);
    }

    public void fillAll() {
        this.prepColorChange();
        this.fillFromTo((Color)this.colorList.get(0), 0, this.colorList.size() - 1);
    }

    public void fillFromTo(Color color, int lowerIndex, int upperIndex) {
        for (int i = lowerIndex; i <= upperIndex; ++i) {
            Color current = (Color)this.colorList.get(i);
            this.colorList.set(i, new Color(color.getRed(), color.getGreen(), color.getBlue(), current.getAlpha()));
        }
        this.tableChanged();
        this.repaint();
    }

    public void transLeft() {
        this.setTransparency(this.getPrevious(this.currentBP), this.currentBP);
    }

    public void transRight() {
        this.setTransparency(this.currentBP, this.getNext(this.currentBP));
    }

    public void transAll() {
        this.prepColorChange();
        this.setTransparencyFromTo(0, this.colorList.size() - 1);
    }

    public void setTransparency(ColorTable.Breakpoint from, ColorTable.Breakpoint to) {
        int lowerIndex = this.percentToColorIndex(from != null ? from.getValue() : 0.0);
        int upperIndex = this.percentToColorIndex(to != null ? to.getValue() : 1.0);
        this.prepColorChange();
        this.setTransparencyFromTo(lowerIndex, upperIndex);
    }

    public void setTransparencyFromTo(int lowerIndex, int upperIndex) {
        int alpha = this.getAlphaInt();
        for (int i = lowerIndex; i <= upperIndex; ++i) {
            Color c = (Color)this.colorList.get(i);
            this.colorList.set(i, new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha));
        }
        this.tableChanged();
        this.repaint();
    }

    public void brightLeft() {
        this.setBrightness(this.getPrevious(this.currentBP), this.currentBP);
    }

    public void brightRight() {
        this.setBrightness(this.currentBP, this.getNext(this.currentBP));
    }

    public void setBrightness(ColorTable.Breakpoint from, ColorTable.Breakpoint to) {
        int lowerIndex = this.percentToColorIndex(from != null ? from.getValue() : 0.0);
        int upperIndex = this.percentToColorIndex(to != null ? to.getValue() : 1.0);
        this.prepColorChange();
        this.setBrightnessFromTo(lowerIndex, upperIndex);
    }

    public void brightAll() {
        this.prepColorChange();
        this.setBrightnessFromTo(0, this.colorList.size() - 1);
    }

    public void setBrightnessFromTo(int lowerIndex, int upperIndex) {
        float b = this.getBrightness();
        for (int i = lowerIndex; i <= upperIndex; ++i) {
            this.scales.set(i, new Float(b));
        }
        this.tableChanged();
        this.repaint();
    }

    public Rectangle getColorBox() {
        return this.getColorBox(this.getBounds());
    }

    public Rectangle getColorBox(Rectangle bounds) {
        return new Rectangle(40, 30, bounds.width - 80, bounds.height - 60);
    }

    public int percentToColorIndex(double percent) {
        double index = percent * (double)this.colorList.size();
        return Math.min(Math.max(0, (int)index), this.colorList.size() - 1);
    }

    public Color percentToColor(double percent) {
        return (Color)this.colorList.get(this.percentToColorIndex(percent));
    }

    public void paintColors(Graphics g) {
        Rectangle box = this.getColorBox();
        ColorTableCanvas.paintColors(g, box, this.colorList, true, true, this.scales);
    }

    public static void paintColors(Graphics g, Rectangle box, List<Color> colorList, boolean doLines, boolean doCheckerboard, List<Float> scales) {
        ColorTableCanvas.paintColors(g, box, colorList, doLines, doCheckerboard, false, scales);
    }

    public static void paintColors(Graphics g, Rectangle box, List<Color> colorList, boolean doLines, boolean doCheckerboard, boolean doTransparency, List<Float> scales) {
        int length;
        if (!doTransparency) {
            g.setColor(Color.white);
            g.fillRect(box.x, box.y, box.width, box.height);
        }
        if (doCheckerboard) {
            g.setColor(Color.black);
            boolean top = true;
            int patternHeight = box.height / 2;
            if (patternHeight > 0) {
                for (int patternX = box.x; patternX < box.x + box.width; patternX += patternHeight) {
                    int patternWidth = patternHeight;
                    if (patternX + patternWidth > box.x + box.width) {
                        patternWidth = box.x + box.width - patternX;
                    }
                    g.fillRect(patternX, top ? box.y : box.y + patternHeight, patternWidth, patternHeight);
                    top = !top;
                }
            }
        }
        if ((length = colorList.size()) > 50) {
            doLines = false;
        }
        double dWidth = (double)box.width / (double)length;
        int width = (int)dWidth;
        double extraPerBox = dWidth - (double)width;
        int x = box.x;
        double remainderWidth = 0.0;
        for (int i = 0; i < length; ++i) {
            Color c = colorList.get(i);
            if (scales != null) {
                float bright = scales.get(i).floatValue();
                c = ColorTableCanvas.applyBrightness(c, bright);
            }
            if (!doCheckerboard && !doTransparency) {
                c = new Color(c.getRed(), c.getGreen(), c.getBlue());
            }
            g.setColor(c);
            int extraWidth = 0;
            remainderWidth += extraPerBox;
            if (remainderWidth > 1.0) {
                extraWidth = (int)remainderWidth;
                remainderWidth -= (double)extraWidth;
            }
            if (i == length - 1) {
                extraWidth = box.width - (x - box.x) - width + 1;
            }
            g.fillRect(x, box.y, width + extraWidth, box.height);
            if (doLines) {
                g.setColor(g.getColor().darker());
                if (i > 0) {
                    g.drawLine(x, box.y, x, box.y + box.height - 1);
                }
            }
            x += width + extraWidth;
        }
    }

    @Override
    public void repaint() {
        super.repaint();
    }

    @Override
    public void paint(Graphics g) {
        if (this.inPaint) {
            return;
        }
        this.inPaint = true;
        this.paintInner(g);
        this.inPaint = false;
    }

    public void paintInner(Graphics g) {
        super.paint(g);
        Rectangle bounds = this.getBounds();
        Rectangle box = this.getColorBox(bounds);
        g.setColor(this.wrapper.getBackground());
        g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        this.paintColors(g);
        g.setColor(Color.black);
        g.drawRect(box.x - 1, box.y, box.width + 2, box.height - 1);
        for (int i = 0; i < this.breakpoints.size(); ++i) {
            ColorTable.Breakpoint bp = (ColorTable.Breakpoint)this.breakpoints.get(i);
            if (bp == this.currentBP) continue;
            this.paintBreakpoint(g, bp, false);
        }
        if (this.currentBP != null) {
            this.paintBreakpoint(g, this.currentBP, true);
        }
        g.setFont(this.labelFont);
        FontMetrics fm = g.getFontMetrics();
        String minLabel = this.myRange.formatMin();
        String midLabel = this.myRange.formatMid();
        String maxLabel = this.myRange.formatMax();
        int lineHeight = fm.getAscent() + fm.getDescent();
        g.setColor(Color.black);
        g.drawString(minLabel, 40 - fm.stringWidth(minLabel) / 2, lineHeight + 30 + box.height);
        g.drawString(midLabel, 40 + box.width / 2 - fm.stringWidth(midLabel) / 2, lineHeight + 30 + box.height);
        g.drawString(maxLabel, 40 + box.width - fm.stringWidth(maxLabel) / 2, lineHeight + 30 + box.height);
        if (this.cursorOver) {
            double percent = this.xToPercent(this.cursorPosition);
            int index = this.percentToColorIndex(percent);
            String value = Misc.format(this.percentToValue(percent));
            g.setColor(Color.gray);
            int lineX = this.cursorPosition;
            g.drawLine(lineX, box.y, lineX, box.y + box.height);
            g.drawString(value, lineX, lineHeight + 30 + box.height);
        }
    }

    @Override
    public boolean imageUpdate(Image img, int flags, int x, int y, int width, int height) {
        this.repaint();
        return true;
    }

    private void paintBreakpoint(Graphics g, ColorTable.Breakpoint bp, boolean isCurrent) {
        if (this.lockImage == null) {
            this.lockImage = GuiUtils.getImage("/auxdata/ui/icons/lock.gif");
            this.lockImage.getWidth(this);
        }
        int arrowTop = 21;
        int arrowBottom = 29;
        int x = this.getBreakpointX(bp);
        g.setColor(this.getBreakpointColor(bp));
        if (isCurrent) {
            int alpha;
            if (this.colorChooser != null) {
                Color cColor = this.colorChooser.getColor();
                Color gColor = g.getColor();
                if (cColor.getRed() != gColor.getRed() || cColor.getGreen() != gColor.getGreen() || cColor.getBlue() != gColor.getBlue()) {
                    this.colorChooser.setColor(g.getColor());
                }
            }
            if (this.lastAlpha != (alpha = g.getColor().getAlpha())) {
                this.ignoreTransBoxEvents = true;
                double percent = 1.0 - (double)alpha / 255.0;
                int intPercent = (int)(percent * 100.0 + 0.5);
                TwoFacedObject tfo = new TwoFacedObject((Object)(intPercent + "%"), new Integer(intPercent));
                this.transBox.setSelectedItem(tfo);
                this.ignoreTransBoxEvents = false;
                this.lastAlpha = alpha;
            }
        }
        if (bp.getLocked()) {
            g.drawImage(this.lockImage, x - this.lockImage.getWidth(null) / 2, arrowTop, null);
        } else {
            int[] lxp = new int[]{x, x - 8, x + 8, x};
            int[] lyp = new int[]{arrowBottom, arrowTop, arrowTop, arrowBottom};
            g.fillPolygon(lxp, lyp, lxp.length);
            g.setColor(Color.black);
            if (isCurrent) {
                g.setColor(Color.yellow);
            }
            g.drawPolygon(lxp, lyp, lxp.length);
        }
        String label = this.getBreakpointLabel(bp);
        if (isCurrent) {
            g.setFont(this.boldFont);
        } else {
            g.setFont(this.labelFont);
        }
        int labelWidth = g.getFontMetrics().stringWidth(label);
        int labelHeight = g.getFontMetrics().getHeight();
        if (!isCurrent) {
            // empty if block
        }
        g.setColor(this.getBackground());
        g.fillRect(x - labelWidth / 2 - 1, arrowTop - labelHeight - 3, labelWidth + 2, labelHeight);
        g.setColor(Color.black);
        g.drawString(label, x - labelWidth / 2, arrowTop - 3);
    }

    private static ArrayList cloneList(List l) {
        return ColorTable.Breakpoint.cloneList(l);
    }

    public static Icon getIcon(ColorTable ct) {
        return ColorTableCanvas.getIcon(ct, 100, 15);
    }

    public static Icon getIcon(ColorTable ct, int width, int height) {
        try {
            if (ct == null) {
                JLabel tmp = new JLabel(" ");
                tmp.setSize(new Dimension(width, height));
                return new ImageIcon(GuiUtils.getImage(tmp));
            }
            final ArrayList<Color> colors = ct.getColorList();
            final Rectangle box = new Rectangle(0, 0, width, height);
            JPanel preview = new JPanel(){

                @Override
                public void paint(Graphics g) {
                    ColorTableCanvas.paintColors(g, box, colors, false, true, null);
                }
            };
            preview.setSize(new Dimension(width, height));
            return new ImageIcon(GuiUtils.getImage(preview));
        }
        catch (Exception exc) {
            return null;
        }
    }

    public static Image getImage(ColorTable ct, int width, int height) {
        return ColorTableCanvas.getImage(ct, width, height, true);
    }

    public static Image getImage(ColorTable ct, int width, int height, boolean includeAlpha) {
        try {
            ArrayList<Color> colors = ct.getColorList(includeAlpha);
            Rectangle box = new Rectangle(0, 0, width, height);
            BufferedImage image = new BufferedImage(width, height, 2);
            Graphics2D g = (Graphics2D)image.getGraphics();
            ColorTableCanvas.paintColors(g, box, colors, false, false, true, null);
            return image;
        }
        catch (Exception exc) {
            return null;
        }
    }

    public static class CanvasCommand
    extends Command {
        ArrayList newBreakpoints;
        ArrayList oldBreakpoints;
        ColorTable.Breakpoint newBP;
        ColorTable.Breakpoint oldBP;
        ColorTableCanvas canvas;

        public CanvasCommand(ColorTableCanvas canvas) {
            this.canvas = canvas;
            this.newBreakpoints = canvas.breakpoints;
            this.newBP = canvas.currentBP;
        }

        @Override
        public void doCommand() {
            this.oldBreakpoints = ColorTableCanvas.cloneList(this.canvas.breakpoints);
            this.oldBP = this.find(this.canvas.currentBP, this.oldBreakpoints);
            this.canvas.breakpoints = this.newBreakpoints;
            this.canvas.currentBP = this.newBP;
            this.canvas.repaint();
        }

        @Override
        public void undoCommand() {
            this.newBreakpoints = ColorTableCanvas.cloneList(this.canvas.breakpoints);
            this.newBP = this.find(this.canvas.currentBP, this.newBreakpoints);
            this.canvas.breakpoints = ColorTableCanvas.cloneList(this.oldBreakpoints);
            this.canvas.currentBP = this.find(this.oldBP, this.canvas.breakpoints);
            this.canvas.repaint();
        }

        private ColorTable.Breakpoint find(ColorTable.Breakpoint bp, List l) {
            if (bp == null || l == null) {
                return null;
            }
            for (int i = 0; i < l.size(); ++i) {
                ColorTable.Breakpoint tmp = (ColorTable.Breakpoint)l.get(i);
                if (tmp.getValue() != bp.getValue() || tmp.getLocked() != bp.getLocked()) continue;
                return tmp;
            }
            return null;
        }
    }

    public static class ColorListCommand
    extends CanvasCommand {
        ArrayList oldColorList;
        ArrayList newColorList;
        ArrayList oldScalesList;
        ArrayList newScalesList;

        public ColorListCommand(ColorTableCanvas canvas) {
            super(canvas);
            this.oldColorList = canvas.colorList;
            this.newColorList = (ArrayList)this.oldColorList.clone();
            this.oldScalesList = canvas.scales;
            this.newScalesList = (ArrayList)this.oldScalesList.clone();
        }

        @Override
        public void doCommand() {
            super.doCommand();
            this.canvas.setColorList(this.newColorList, this.newScalesList);
            this.canvas.tableChanged();
        }

        @Override
        public void undoCommand() {
            super.undoCommand();
            this.canvas.setColorList(this.oldColorList, this.oldScalesList);
            this.canvas.tableChanged();
        }
    }

    public static class ColorTableCommand
    extends CanvasCommand {
        ColorTable oldColorTable;
        ColorTable newColorTable;

        public ColorTableCommand(ColorTableCanvas canvas, ColorTable newCt) {
            super(canvas);
            this.oldColorTable = new ColorTable(canvas.getCurrentColorTable());
            this.newColorTable = new ColorTable(newCt);
        }

        @Override
        public void doCommand() {
            super.doCommand();
            this.canvas.setColorTableInner(this.newColorTable, true);
        }

        @Override
        public void undoCommand() {
            super.undoCommand();
            this.canvas.setColorTableInner(this.oldColorTable, true);
        }
    }
}

