/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.JTextComponent;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ucar.unidata.ui.ButtonTabbedPane;
import ucar.unidata.ui.GraphPaperLayout;
import ucar.unidata.ui.TreePanel;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.xml.XmlNodeList;
import ucar.unidata.xml.XmlUtil;

public class XmlUi
implements ActionListener,
ItemListener {
    public static final String NULLSTRING = null;
    public static final String ACTION_UI_FLIP = "ui.flip";
    public static final String ACTION_UI_FOCUS = "ui.focus";
    public static final String ACTION_MENUPOPUP = "menu.popup";
    public static final String ACTION_SETTEXT = "ui.setText";
    public static final String ACTION_SETBORDER = "ui.setBorder";
    public static final String ACTION_UI_GROUP_NEXT = "ui.group.next";
    public static final String ACTION_UI_GROUP_PREV = "ui.group.prev";
    public static final String TAG_SKIN = "skin";
    public static final String TAG_STYLES = "styles";
    public static final String TAG_STYLE = "style";
    public static final String TAG_UI = "ui";
    public static final String TAG_CARDPANEL = "cardpanel";
    public static final String TAG_COMBOBOX = "combobox";
    public static final String TAG_COMPONENTS = "components";
    public static final String TAG_COMPONENT = "component";
    public static final String TAG_BUTTON = "button";
    public static final String TAG_RADIO = "radio";
    public static final String TAG_CHECKBOX = "checkbox";
    public static final String TAG_FILLER = "filler";
    public static final String TAG_HTML = "html";
    public static final String TAG_IMAGE = "image";
    public static final String TAG_IMPORT = "import";
    public static final String TAG_ITEM = "item";
    public static final String TAG_LABEL = "label";
    public static final String TAG_MENU = "menu";
    public static final String TAG_MENUPOPUP = "menupopup";
    public static final String TAG_MENUBAR = "menubar";
    public static final String TAG_MENUITEM = "menuitem";
    public static final String TAG_PANEL = "panel";
    public static final String TAG_PROPERTIES = "properties";
    public static final String TAG_PROPERTY = "property";
    public static final String TAG_SCROLLER = "scroller";
    public static final String TAG_SEPARATOR = "separator";
    public static final String TAG_SPLITPANE = "splitpane";
    public static final String TAG_TABBEDPANE = "tabbedpane";
    public static final String TAG_BUTTONTABBEDPANE = "buttontabbedpane";
    public static final String TAG_TREEPANEL = "treepanel";
    public static final String TAG_TEXTINPUT = "textinput";
    public static final String TAG_TOGGLEBUTTON = "togglebutton";
    public static final String TAG_TOOLBAR = "toolbar";
    public static final String ATTR_ACTION = "action";
    public static final String ATTR_CATEGORY = "category";
    public static final String ATTR_CATEGORYCOMPONENT = "categorycomponent";
    public static final String ATTR_ACTIONTEMPLATE = "actiontemplate";
    public static final String ATTR_ALIGN = "align";
    public static final String ATTR_HPOSITION = "hposition";
    public static final String ATTR_VPOSITION = "vposition";
    public static final String ATTR_ANCHOR = "anchor";
    public static final String ATTR_BGCOLOR = "bgcolor";
    public static final String ATTR_BORDER = "border";
    public static final String ATTR_BORDER_TITLE = "border_title";
    public static final String ATTR_BORDER_COLOR = "border_color";
    public static final String ATTR_BORDER_THICKNESS = "border_thickness";
    public static final String ATTR_BORDER_INSET = "border_inset";
    public static final String ATTR_BORDER_HINSET = "border_hinset";
    public static final String ATTR_BORDER_VINSET = "border_vinset";
    public static final String ATTR_BORDER_TOP = "border_top";
    public static final String ATTR_BORDER_LEFT = "border_left";
    public static final String ATTR_BORDER_BOTTOM = "border_bottom";
    public static final String ATTR_BORDER_RIGHT = "border_right";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_TAGCLASS = "tagclass";
    public static final String ATTR_COLS = "cols";
    public static final String ATTR_COLWIDTHS = "colwidths";
    public static final String ATTR_CONTINUOUS = "continuous";
    public static final String ATTR_ONETOUCHEXPANDABLE = "onetouchexpandable";
    public static final String ATTR_DEFAULT = "default";
    public static final String ATTR_DIVIDER = "divider";
    public static final String ATTR_DOWNIMAGE = "downimage";
    public static final String ATTR_EDITABLE = "editable";
    public static final String ATTR_EVENT = "event";
    public static final String ATTR_FLOAT = "float";
    public static final String ATTR_FGCOLOR = "fgcolor";
    public static final String ATTR_FILL = "fill";
    public static final String ATTR_FONTSIZE = "fontsize";
    public static final String ATTR_FONTFACE = "fontface";
    public static final String ATTR_FONTSTYLE = "fontstyle";
    public static final String ATTR_GROUP = "group";
    public static final String ATTR_HEIGHT = "height";
    public static final String ATTR_HSCROLL = "hscroll";
    public static final String ATTR_IMAGEWIDTH = "imagewidth";
    public static final String ATTR_IMAGEHEIGHT = "imageheight";
    public static final String ATTR_KEYPRESS = "keypress";
    public static final String ATTR_MOUSE_ENTER = "mouse_enter";
    public static final String ATTR_MOUSE_EXIT = "mouse_exit";
    public static final String ATTR_MOUSE_CLICK = "mouse_click";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_PREF_HEIGHT = "pref_height";
    public static final String ATTR_TSPACE = "topspace";
    public static final String ATTR_BSPACE = "bottomspace";
    public static final String ATTR_LSPACE = "leftspace";
    public static final String ATTR_RSPACE = "rightspace";
    public static final String ATTR_HSPACE = "hspace";
    public static final String ATTR_ID = "id";
    public static final String ATTR_IDREF = "idref";
    public static final String ATTR_IMAGE = "image";
    public static final String ATTR_LABEL = "label";
    public static final String ATTR_LAYOUT = "layout";
    public static final String ATTR_MARGIN = "margin";
    public static final String ATTR_MNEMONIC = "mnemonic";
    public static final String ATTR_ORIENTATION = "orientation";
    public static final String ATTR_OVERIMAGE = "overimage";
    public static final String ATTR_PLACE = "place";
    public static final String ATTR_PREF_WIDTH = "pref_width";
    public static final String ATTR_RESIZEWEIGHT = "resizeweight";
    public static final String ATTR_ROWHEIGHTS = "rowheights";
    public static final String ATTR_ROWS = "rows";
    public static final String ATTR_SELECTIMAGE = "selectimage";
    public static final String ATTR_SPACE = "space";
    public static final String ATTR_TABNESTED = "tabnested";
    public static final String ATTR_TABPLACE = "tabplace";
    public static final String ATTR_TABPAD = "tabpad";
    public static final String ATTR_TABINSETS = "tabinsets";
    public static final String ATTR_TABBORDERLEFT = "tabborderleft";
    public static final String ATTR_TABBORDERBOTTOM = "tabborderbottom";
    public static final String ATTR_TABBORDERRIGHT = "tabborderright";
    public static final String ATTR_TABBORDERTOP = "tabbordertop";
    public static final String ATTR_ICON = "icon";
    public static final String ATTR_TEMPLATE = "template";
    public static final String ATTR_TEXT = "text";
    public static final String ATTR_TITLE = "title";
    public static final String ATTR_TOOLTIP = "tooltip";
    public static final String ATTR_TABTOOLTIP = "tabtooltip";
    public static final String ATTR_URL = "url";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_VSCROLL = "vscroll";
    public static final String ATTR_VSPACE = "vspace";
    public static final String ATTR_WIDTH = "width";
    public static final String ATTR_TREEWIDTH = "treewidth";
    public static final String ATTR_USESPLITPANE = "usesplitpane";
    public static final String ATTR_X = "x";
    public static final String ATTR_Y = "y";
    private Border buttonBorder;
    public static final String BORDER_BUTTON = "button";
    public static final String BORDER_TITLED = "titled";
    public static final String BORDER_BEVEL = "bevel";
    public static final String BORDER_BEVEL_LOWERED = "bevel_lowered";
    public static final String BORDER_BEVEL_RAISED = "bevel_raised";
    public static final String BORDER_EMPTY = "empty";
    public static final String BORDER_LINE = "line";
    public static final String BORDER_ETCHED = "etched";
    public static final String BORDER_ETCHED_RAISED = "etched_raised";
    public static final String BORDER_ETCHED_LOWERED = "etched_lowered";
    public static final String BORDER_MATTE = "matte";
    public static final String LAYOUT_BORDER = "border";
    public static final String LAYOUT_CARD = "card";
    public static final String LAYOUT_FLOW = "flow";
    public static final String LAYOUT_GRAPHPAPER = "graphpaper";
    public static final String LAYOUT_GRID = "grid";
    public static final String LAYOUT_GRIDBAG = "gridbag";
    public static final String LAYOUT_INSET = "inset";
    public static final String LAYOUT_WRAP = "wrap";
    public static final String[] FLOWLAYOUT_NAMES = new String[]{"left", "center", "leading", "right", "trailing"};
    public static final int[] FLOWLAYOUT_VALUES = new int[]{0, 1, 3, 2, 4};
    public static final String[] FILL_NAMES = new String[]{"h", "v", "both", "none"};
    public static final int[] FILL_VALUES = new int[]{2, 3, 1, 0};
    public static final String[] TABPLACE_NAMES = new String[]{"top", "bottom", "left", "right"};
    public static final int[] TABPLACE_VALUES = new int[]{1, 3, 2, 4};
    public static final String[] TOOLBAR_NAMES = new String[]{"h", "v"};
    public static final int[] TOOLBAR_VALUES = new int[]{0, 1};
    public static final String[] SPLITPANE_NAMES = new String[]{"h", "v"};
    public static final int[] SPLITPANE_VALUES = new int[]{1, 0};
    public static final String[] ANCHOR_NAMES = new String[]{"nw", "w", "sw", "ne", "e", "se", "n", "c", "s"};
    public static final int[] ANCHOR_VALUES = new int[]{18, 17, 16, 12, 13, 14, 11, 10, 15};
    public static final String[] HPOS_NAMES = new String[]{"left", "right", "center", "leading", "trailing"};
    public static final int[] HPOS_VALUES = new int[]{2, 4, 0, 10, 11};
    public static final String[] VPOS_NAMES = new String[]{"center", "top", "bottom"};
    public static final int[] VPOS_VALUES = new int[]{0, 1, 3};
    public static final String[] ALIGN_NAMES = new String[]{"left", "right", "center"};
    public static final int[] ALIGN_VALUES = new int[]{2, 4, 0};
    public static final String[] SCROLL_NAMES = new String[]{"asneeded", "always", "never"};
    public static final int[] VSCROLL_VALUES = new int[]{20, 22, 21};
    public static final int[] HSCROLL_VALUES = new int[]{30, 32, 31};
    private Component myContents;
    private Element root;
    private Element startNode;
    private Element uiNode;
    private ActionListener actionListener;
    private ActionHandler actionHandler;
    private int xmlNodeId = 0;
    private List components = new ArrayList();
    private Hashtable idToElement = new Hashtable();
    private Hashtable buttonGroups = new Hashtable();
    private Hashtable classToStyle = new Hashtable();
    Hashtable idToComponent = new Hashtable();
    protected Hashtable properties = new Hashtable();
    private Hashtable containerToNodeList = new Hashtable();
    private Hashtable compToNode = new Hashtable();
    private Hashtable nodeToComponent = new Hashtable();
    private Hashtable componentToParent = new Hashtable();
    private Hashtable componentToAction = new Hashtable();
    public static final int NOVALUE = -9999999;

    public XmlUi() {
        this(null, new Hashtable(), null, null);
    }

    public XmlUi(String xml, Hashtable idToComponent, ActionListener actionListener) {
        this(null, idToComponent, actionListener, null);
        try {
            this.root = XmlUtil.getRoot(xml);
        }
        catch (Exception exc) {
            LogUtil.logException("XmlUi: creating xml", exc);
        }
        this.initXml();
    }

    public XmlUi(Element root, ActionListener actionListener) {
        this(root, null, actionListener, null);
    }

    public XmlUi(Element root, Hashtable idToComponent, ActionListener actionListener, Hashtable initProperties) {
        this(root, null, idToComponent, actionListener, initProperties);
    }

    public XmlUi(Element root, Element startNode, Hashtable idToComponent, ActionListener actionListener, Hashtable initProperties) {
        this.root = root;
        this.startNode = startNode;
        this.idToComponent = idToComponent == null ? new Hashtable() : idToComponent;
        this.actionListener = actionListener;
        if (initProperties != null) {
            this.properties.putAll(initProperties);
        }
        this.initXml();
    }

    public void setStartNode(Element node) {
        this.startNode = node;
    }

    public void dispose() {
        this.myContents = null;
        this.root = null;
        this.uiNode = null;
        this.actionListener = null;
        this.actionHandler = null;
        this.idToElement = null;
        this.buttonGroups = null;
        this.classToStyle = null;
        this.idToComponent = null;
        this.properties = null;
        this.containerToNodeList = null;
        this.compToNode = null;
        this.nodeToComponent = null;
        this.componentToParent = null;
        this.componentToAction = null;
    }

    private void initXml() {
        if (this.root == null) {
            return;
        }
        String rootTag = this.root.getTagName();
        if (rootTag.equals(TAG_PANEL) || rootTag.equals(TAG_TABBEDPANE) || rootTag.equals(TAG_BUTTONTABBEDPANE) || rootTag.equals(TAG_TREEPANEL) || rootTag.equals(TAG_SPLITPANE) || rootTag.equals(TAG_SCROLLER) || rootTag.equals(TAG_TOOLBAR)) {
            return;
        }
        if (rootTag.equals(TAG_UI)) {
            this.uiNode = this.root;
        }
        if (this.uiNode == null) {
            this.uiNode = XmlUtil.getElement(this.root, TAG_UI);
            List propertiesNodes = XmlUtil.findChildren(this.root, TAG_PROPERTIES);
            for (int i = 0; i < propertiesNodes.size(); ++i) {
                Element propsNode = (Element)propertiesNodes.get(i);
                List children = XmlUtil.findChildren(propsNode, TAG_PROPERTY);
                for (int j = 0; j < children.size(); ++j) {
                    Element propNode = (Element)children.get(j);
                    this.properties.put(XmlUtil.getAttribute(propNode, ATTR_NAME), XmlUtil.getAttribute(propNode, ATTR_VALUE));
                }
            }
            this.initializeComponents(this.root);
            List stylesNodes = XmlUtil.findChildren(this.root, TAG_STYLES);
            for (int stylesNodeIdx = 0; stylesNodeIdx < stylesNodes.size(); ++stylesNodeIdx) {
                Element stylesNode = (Element)stylesNodes.get(stylesNodeIdx);
                List styleNodes = XmlUtil.findChildren(stylesNode, TAG_STYLE);
                for (int styleNodeIdx = 0; styleNodeIdx < styleNodes.size(); ++styleNodeIdx) {
                    Element styleNode = (Element)styleNodes.get(styleNodeIdx);
                    this.classToStyle.put(XmlUtil.getAttribute(styleNode, ATTR_CLASS), styleNode);
                }
            }
        }
    }

    protected void initializeComponents(Element root) {
        List compsNodes = XmlUtil.findChildren(root, TAG_COMPONENTS);
        for (int compNodeIdx = 0; compNodeIdx < compsNodes.size(); ++compNodeIdx) {
            Element componentsNode = (Element)compsNodes.get(compNodeIdx);
            NodeList children = XmlUtil.getElements(componentsNode);
            for (int i = 0; i < children.getLength(); ++i) {
                Element component = (Element)children.item(i);
                String id = this.getAttr(component, ATTR_ID, (String)null);
                if (id == null) continue;
                this.addComponent(id, component);
            }
        }
    }

    public boolean hasComponent(String id) {
        return this.idToComponent.get(id) != null;
    }

    public void addComponent(String id, Element component) {
        this.idToElement.put(id, component);
    }

    private boolean hasComponent(String id, boolean throwException) {
        if (this.hasComponent(id)) {
            if (throwException) {
                throw new IllegalArgumentException("Already have component:" + id);
            }
            return true;
        }
        return false;
    }

    public void addComponent(String id, Component comp) {
        this.idToComponent.put(id, comp);
    }

    public Component getComponent(String id) {
        return (Component)this.idToComponent.get(id);
    }

    public List getComponents() {
        return this.components;
    }

    int getAlign(Element node) {
        return this.getAlign(this.getAttr(node, ATTR_ALIGN, "CENTER"));
    }

    public int getAlign(String align) {
        return this.findValue(align, ALIGN_NAMES, ALIGN_VALUES, 2);
    }

    public String getAttr(Element node, String attr) {
        int idx;
        String v = XmlUtil.getAttribute((Node)node, attr, NULLSTRING);
        if (v == null) {
            Element styleNode;
            String styleClass = XmlUtil.getAttribute((Node)node, ATTR_TAGCLASS, NULLSTRING);
            if (styleClass == null) {
                styleClass = XmlUtil.getAttribute((Node)node, ATTR_CLASS, NULLSTRING);
            }
            if (styleClass != null && (styleNode = (Element)this.classToStyle.get(styleClass)) != null) {
                v = XmlUtil.getAttribute((Node)styleNode, attr, NULLSTRING);
            }
            if (v == null) {
                v = XmlUtil.getAttributeFromTree(node.getParentNode(), XmlUi.inheritNameOldWay(attr));
            }
            if (v == null) {
                v = XmlUtil.getAttributeFromTree(node.getParentNode(), XmlUi.inheritName(attr));
            }
        }
        if (v != null && (v.startsWith("prop:") || v.startsWith("prop_"))) {
            v = this.getProperty(v.substring(5));
        }
        if (v != null && (idx = v.indexOf("%")) >= 0) {
            Enumeration keys = this.properties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = (String)this.properties.get(key);
                if (value == null) continue;
                v = StringUtil.replace(v, "%" + key + "%", value);
            }
        }
        return v;
    }

    public static String inheritNameOldWay(String attr) {
        return "i:" + attr;
    }

    public static String inheritName(String attr) {
        return "i_" + attr;
    }

    public int getAttr(Element node, String attr, int dflt) {
        String v = this.getAttr(node, attr);
        if (v == null) {
            return dflt;
        }
        return Integer.decode(v);
    }

    public double getAttr(Element node, String attr, double dflt) {
        String v = this.getAttr(node, attr);
        if (v == null) {
            return dflt;
        }
        return Double.parseDouble(v);
    }

    public boolean getAttr(Element node, String attr, boolean dflt) {
        String v = this.getAttr(node, attr);
        if (v == null) {
            return dflt;
        }
        return new Boolean(v);
    }

    public String getAttr(Element node, String attr, String dflt) {
        String v = this.getAttr(node, attr);
        if (v == null) {
            return dflt;
        }
        return v;
    }

    public Color getAttr(Element node, String attr, Color dflt) {
        String v = this.getAttr(node, attr);
        if (v == null) {
            return dflt;
        }
        return GuiUtils.decodeColor(v, dflt);
    }

    public ImageIcon getAttr(Element node, String attr, ImageIcon dflt) {
        String v = this.getAttr(node, attr);
        if (v == null) {
            return dflt;
        }
        Image image = XmlUi.getImage(v);
        if (image == null) {
            return null;
        }
        return new ImageIcon(image);
    }

    public Border getBorder(String type, Element node) {
        if (type.equals(BORDER_TITLED)) {
            return BorderFactory.createTitledBorder(this.getAttr(node, ATTR_BORDER_TITLE, "no title"));
        }
        int inset = this.getAttr(node, ATTR_BORDER_INSET, 0);
        int hinset = this.getAttr(node, ATTR_BORDER_HINSET, inset);
        int vinset = this.getAttr(node, ATTR_BORDER_VINSET, inset);
        int top = this.getAttr(node, ATTR_BORDER_TOP, vinset);
        int bottom = this.getAttr(node, ATTR_BORDER_BOTTOM, vinset);
        int left = this.getAttr(node, ATTR_BORDER_LEFT, hinset);
        int right = this.getAttr(node, ATTR_BORDER_RIGHT, hinset);
        if (type.equals("button")) {
            return BorderFactory.createEtchedBorder(1);
        }
        if (type.equals(BORDER_BEVEL_LOWERED) || type.equals(BORDER_BEVEL)) {
            return BorderFactory.createBevelBorder(1);
        }
        if (type.equals(BORDER_BEVEL_RAISED)) {
            return BorderFactory.createBevelBorder(0);
        }
        if (type.equals(BORDER_EMPTY)) {
            return BorderFactory.createEmptyBorder(top, left, bottom, right);
        }
        if (type.equals(BORDER_LINE)) {
            return BorderFactory.createLineBorder(this.getAttr(node, ATTR_BORDER_COLOR, Color.black), this.getAttr(node, ATTR_BORDER_THICKNESS, 1));
        }
        if (type.equals(BORDER_ETCHED_RAISED) || type.equals(BORDER_ETCHED)) {
            return BorderFactory.createEtchedBorder(0);
        }
        if (type.equals(BORDER_ETCHED_LOWERED)) {
            return BorderFactory.createEtchedBorder(1);
        }
        if (type.equals(BORDER_MATTE)) {
            return BorderFactory.createMatteBorder(top, left, bottom, right, this.getAttr(node, ATTR_BORDER_COLOR, Color.gray));
        }
        System.err.println("Unknown border:" + type);
        return BorderFactory.createEmptyBorder();
    }

    void setAttrs(Component comp, Element node) {
        Color fgColor;
        Color bgColor;
        if (comp instanceof JComponent) {
            String border;
            JComponent jcomp = (JComponent)comp;
            String tooltip = this.getAttr(node, ATTR_TOOLTIP, NULLSTRING);
            if (tooltip != null) {
                jcomp.setToolTipText(tooltip);
            }
            if ((border = this.getAttr(node, "border", NULLSTRING)) != null) {
                jcomp.setBorder(this.getBorder(border, node));
            }
            int pw = this.getAttr(node, ATTR_PREF_WIDTH, -1);
            int ph = this.getAttr(node, ATTR_PREF_HEIGHT, -1);
            if (pw != -1 && ph != -1) {
                jcomp.setPreferredSize(new Dimension(pw, ph));
            }
        }
        int w = this.getAttr(node, ATTR_WIDTH, -1);
        int h = this.getAttr(node, ATTR_HEIGHT, -1);
        if (w != -1 && h != -1) {
            comp.setSize(new Dimension(w, h));
        }
        if ((bgColor = this.getAttr(node, ATTR_BGCOLOR, (Color)null)) != null) {
            if (comp instanceof JLabel) {
                ((JLabel)comp).setOpaque(true);
            }
            comp.setBackground(bgColor);
        }
        if ((fgColor = this.getAttr(node, ATTR_FGCOLOR, (Color)null)) != null) {
            comp.setForeground(fgColor);
        }
        String fontSizeStr = this.getAttr(node, ATTR_FONTSIZE, NULLSTRING);
        String fontFace = this.getAttr(node, ATTR_FONTFACE, NULLSTRING);
        String fontStyleStr = this.getAttr(node, ATTR_FONTSTYLE, NULLSTRING);
        if (fontSizeStr != null || fontFace != null || fontStyleStr != null) {
            Font f = comp.getFont();
            int fontSize = f.getSize();
            int style = f.getStyle();
            String face = f.getFamily();
            if (fontSizeStr != null) {
                fontSize = fontSizeStr.startsWith("+") ? (fontSize += new Integer(fontSizeStr.substring(1)).intValue()) : (fontSizeStr.startsWith("-") ? (fontSize -= new Integer(fontSizeStr.substring(1)).intValue()) : new Integer(fontSizeStr));
            }
            if (fontStyleStr != null) {
                if ((fontStyleStr = fontStyleStr.toLowerCase()).equals("bold")) {
                    style = 1;
                } else if (fontStyleStr.equals("italic")) {
                    style = 2;
                } else if (fontStyleStr.equals("plain")) {
                    style = 0;
                }
            }
            f = new Font(fontFace, style, fontSize);
            comp.setFont(f);
        }
    }

    public void setRoot(Element root) {
        this.root = root;
        this.myContents = null;
        this.initXml();
    }

    public Component getContents() {
        if (this.myContents == null) {
            this.myContents = this.doMakeContents();
        }
        return this.myContents;
    }

    private Component doMakeContents() {
        String rootTag = this.root.getTagName();
        if (rootTag.equals(TAG_PANEL) || rootTag.equals(TAG_TABBEDPANE) || rootTag.equals(TAG_BUTTONTABBEDPANE) || rootTag.equals(TAG_TREEPANEL) || rootTag.equals(TAG_SPLITPANE) || rootTag.equals(TAG_SCROLLER) || rootTag.equals(TAG_TOOLBAR)) {
            return this.xmlToUi(this.root);
        }
        Element initialNode = this.startNode;
        if (initialNode == null && this.uiNode != null) {
            NodeList children = XmlUtil.getElements(this.uiNode);
            if (children.getLength() != 1) {
                this.badState("Error: <ui> tag must have only one child");
            }
            initialNode = (Element)children.item(0);
        }
        if (initialNode != null) {
            return this.xmlToUi(initialNode);
        }
        return this.xmlToUi(this.root);
    }

    public String getProperty(String name) {
        return (String)this.properties.get(name);
    }

    private Element getReffedNode(Element node) {
        String idRef = this.getAttr(node, ATTR_IDREF, NULLSTRING);
        if (idRef == null) {
            return node;
        }
        Element reffedNode = (Element)this.idToElement.get(idRef);
        if (reffedNode == null) {
            this.badState("Could not find idref=" + idRef);
        }
        NamedNodeMap map = node.getAttributes();
        for (int i = 0; i < map.getLength(); ++i) {
            Node attrNode = map.item(i);
            if (attrNode.getNodeName().equals(ATTR_IDREF)) continue;
            reffedNode.setAttribute(attrNode.getNodeName(), attrNode.getNodeValue());
        }
        return reffedNode;
    }

    protected Component xmlToUi(Element node) {
        Component comp;
        String id;
        if (node.getTagName().equals(TAG_IMPORT)) {
            try {
                Element root = XmlUtil.getRoot(this.getAttr(node, ATTR_URL), this.getClass());
                if (root.getTagName().equals(TAG_SKIN)) {
                    // empty if block
                }
                Element child = (Element)node.getOwnerDocument().importNode(root, true);
                node.appendChild(child);
                node = child;
            }
            catch (Exception exc) {
                LogUtil.logException("XmlUi: creating xml from import", exc);
            }
        }
        if ((id = this.getAttr(node, ATTR_ID, (String)null)) == null) {
            id = "nodeid" + this.xmlNodeId++;
            node.setAttribute(ATTR_ID, id);
        }
        if ((comp = (Component)this.nodeToComponent.get(node)) != null) {
            return comp;
        }
        JPanel topComp = null;
        comp = (Component)this.idToComponent.get(id);
        if (comp == null && (comp = this.createComponent(node, id)) != null) {
            String margin;
            this.components.add(comp);
            this.compToNode.put(comp, node);
            this.nodeToComponent.put(node, comp);
            this.idToComponent.put(id, comp);
            String keyPress = this.getAttr(node, ATTR_KEYPRESS, NULLSTRING);
            final Component theComp = comp;
            if (keyPress != null) {
                final List<String> commands = StringUtil.split(keyPress, ";", true, true);
                comp.setFocusable(true);
                comp.addKeyListener(new KeyListener(){

                    @Override
                    public void keyPressed(KeyEvent event) {
                        String key = KeyEvent.getKeyText(event.getKeyCode());
                        for (int i = 0; i < commands.size(); ++i) {
                            int idx;
                            String tmp = commands.get(i).toString();
                            if (!tmp.substring(0, idx = tmp.indexOf(":")).equals(key)) continue;
                            XmlUi.this.actionPerformed(new ActionEvent(theComp, 0, tmp.substring(idx + 1)));
                        }
                    }

                    @Override
                    public void keyReleased(KeyEvent event) {
                    }

                    @Override
                    public void keyTyped(KeyEvent event) {
                    }
                });
            }
            final String mouseClick = this.getAttr(node, ATTR_MOUSE_CLICK, NULLSTRING);
            final String mouseEnter = this.getAttr(node, ATTR_MOUSE_ENTER, NULLSTRING);
            final String mouseExit = this.getAttr(node, ATTR_MOUSE_EXIT, NULLSTRING);
            if (mouseClick != null || mouseEnter != null || mouseExit != null) {
                comp.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        if (mouseEnter != null) {
                            XmlUi.this.actionPerformed(new ActionEvent(theComp, 0, mouseEnter));
                        }
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        if (mouseExit != null) {
                            XmlUi.this.actionPerformed(new ActionEvent(theComp, 0, mouseExit));
                        }
                    }

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (mouseClick != null) {
                            XmlUi.this.actionPerformed(new ActionEvent(theComp, 0, mouseClick));
                        }
                    }
                });
            }
            if ((margin = this.getAttr(node, ATTR_MARGIN, NULLSTRING)) != null && comp != null) {
                double[] insets = Misc.parseDoubles(margin);
                if (insets.length == 1) {
                    topComp = GuiUtils.inset(comp, (int)insets[0]);
                } else if (insets.length == 4) {
                    topComp = GuiUtils.inset(comp, new Insets((int)insets[0], (int)insets[1], (int)insets[2], (int)insets[3]));
                }
            }
        }
        if (comp != null) {
            this.setAttrs(comp, node);
        }
        if (topComp != null) {
            return topComp;
        }
        return comp;
    }

    private Insets getInsets(String str) {
        if (str == null) {
            return null;
        }
        double[] insets = Misc.parseDoubles(str);
        if (insets.length == 1) {
            return new Insets((int)insets[0], (int)insets[0], (int)insets[0], (int)insets[0]);
        }
        if (insets.length == 4) {
            return new Insets((int)insets[0], (int)insets[1], (int)insets[2], (int)insets[3]);
        }
        return null;
    }

    private int findValue(String v, String[] names, int[] values) {
        return this.findValue(v, names, values, values[0]);
    }

    private int findValue(String v, String[] names, int[] values, int dflt) {
        if (v == null) {
            return dflt;
        }
        v = v.toLowerCase();
        for (int fidx = 0; fidx < names.length; ++fidx) {
            if (!v.equals(names[fidx])) continue;
            return values[fidx];
        }
        return dflt;
    }

    private Hashtable addInteger(Hashtable ht, String v, Object o, String[] names, int[] values) {
        int value = this.findValue(v, names, values, -9999999);
        if (value == -9999999) {
            return ht;
        }
        if (ht == null) {
            ht = new Hashtable<Object, Integer>();
        }
        ht.put(o, new Integer(value));
        return ht;
    }

    private Container layoutContainer(JPanel panel, Element node, List xmlChildren) {
        panel.removeAll();
        String panelId = this.getAttr(node, ATTR_ID, (String)null);
        String layout = this.getAttr(node, ATTR_LAYOUT, "");
        Hashtable fills = null;
        Hashtable anchors = null;
        ArrayList<Component> children = new ArrayList<Component>();
        ArrayList<Element> nodes = new ArrayList<Element>();
        int space = this.getAttr(node, ATTR_SPACE, 0);
        int hspace = this.getAttr(node, ATTR_HSPACE, space);
        int vspace = this.getAttr(node, ATTR_VSPACE, space);
        int leftSpace = this.getAttr(node, ATTR_LSPACE, hspace);
        int rightSpace = this.getAttr(node, ATTR_RSPACE, hspace);
        int topSpace = this.getAttr(node, ATTR_TSPACE, vspace);
        int bottomSpace = this.getAttr(node, ATTR_BSPACE, vspace);
        int rows = this.getAttr(node, ATTR_ROWS, 0);
        int cols = this.getAttr(node, ATTR_COLS, 1);
        String defaultComp = this.getAttr(node, ATTR_DEFAULT, "nocomp");
        if (panel instanceof CardPanel) {
            panel.setLayout(new BorderLayout());
        } else if (layout.equals("border")) {
            panel.setLayout(new BorderLayout());
        } else if (layout.equals(LAYOUT_CARD)) {
            panel.setLayout(new CardLayout());
        } else if (layout.equals(LAYOUT_FLOW)) {
            int align = this.findValue(this.getAttr(node, ATTR_ALIGN, NULLSTRING), FLOWLAYOUT_NAMES, FLOWLAYOUT_VALUES);
            panel.setLayout(new FlowLayout(align, hspace, vspace));
        } else if (layout.equals(LAYOUT_GRAPHPAPER)) {
            panel.setLayout(new GraphPaperLayout(new Dimension(rows, cols)));
        } else if (layout.equals(LAYOUT_GRID)) {
            panel.setLayout(new GridLayout(rows, cols, hspace, vspace));
        }
        for (int i = 0; i < xmlChildren.size(); ++i) {
            Element childElement = this.getReffedNode((Element)xmlChildren.get(i));
            Component childComponent = this.xmlToUi(childElement);
            if (childComponent == null) continue;
            this.componentToParent.put(childComponent, panel);
            children.add(childComponent);
            nodes.add(childElement);
            if (layout.equals("border")) {
                String place = this.getAttr(childElement, ATTR_PLACE, "Center");
                panel.add(place, childComponent);
                continue;
            }
            if (panel instanceof CardPanel || layout.equals(LAYOUT_CARD)) {
                String childId = this.getAttr(childElement, ATTR_ID, (String)null);
                panel.add(childId, childComponent);
                if (!defaultComp.equals(childId)) continue;
                if (layout.equals(LAYOUT_CARD)) {
                    ((CardLayout)panel.getLayout()).show(panel, childId);
                    continue;
                }
                ((CardPanel)panel).flip(childId);
                continue;
            }
            if (layout.equals(LAYOUT_INSET)) {
                GuiUtils.tmpInsets = new Insets(topSpace, leftSpace, bottomSpace, rightSpace);
                GuiUtils.doLayout(panel, new Component[]{childComponent}, 1, GuiUtils.WT_Y, GuiUtils.WT_Y);
                break;
            }
            if (layout.equals(LAYOUT_WRAP)) {
                GuiUtils.doLayout(panel, new Component[]{childComponent}, 1, GuiUtils.WT_N, GuiUtils.WT_N);
                break;
            }
            if (layout.equals(LAYOUT_GRAPHPAPER)) {
                Rectangle r = new Rectangle(this.getAttr(childElement, ATTR_X, 0), this.getAttr(childElement, ATTR_Y, 0), this.getAttr(childElement, ATTR_COLS, 1), this.getAttr(childElement, ATTR_ROWS, 1));
                panel.add(childComponent, r);
                continue;
            }
            if (layout.equals(LAYOUT_GRIDBAG)) {
                fills = this.addInteger(fills, this.getAttr(childElement, ATTR_FILL, (String)null), childComponent, FILL_NAMES, FILL_VALUES);
                anchors = this.addInteger(anchors, this.getAttr(childElement, ATTR_ANCHOR, (String)null), childComponent, ANCHOR_NAMES, ANCHOR_VALUES);
                continue;
            }
            panel.add(childComponent);
        }
        if (layout.equals(LAYOUT_GRIDBAG)) {
            double[] cw = Misc.parseDoubles(this.getAttr(node, ATTR_COLWIDTHS, (String)null));
            double[] rh = Misc.parseDoubles(this.getAttr(node, ATTR_ROWHEIGHTS, (String)null));
            if (cw == null) {
                cw = GuiUtils.WT_Y;
            }
            if (rh == null) {
                rh = GuiUtils.WT_N;
            }
            GuiUtils.tmpInsets = new Insets(topSpace, leftSpace, bottomSpace, rightSpace);
            GuiUtils.doLayout(panel, GuiUtils.getComponentArray(children), cols, cw, rh, anchors, fills, null);
        }
        this.containerToNodeList.put(panel, nodes);
        return panel;
    }

    public static Image getImage(String path) {
        return GuiUtils.getImage(path);
    }

    public Image getImageAttr(Element node, String attr) {
        String path = this.getAttr(node, attr, NULLSTRING);
        if (path != null) {
            return XmlUi.getImage(path);
        }
        return null;
    }

    private void badState(String msg) {
        throw new IllegalStateException(msg);
    }

    private AbstractButton makeImageButton(String tag, Element node, String imagePath, String action) {
        AbstractButton tb;
        Image image;
        if (imagePath == null) {
            imagePath = this.getAttr(node, "image", "no path");
        }
        if ((image = XmlUi.getImage(imagePath)) == null) {
            this.badState("No image found for:" + imagePath);
        }
        int imageWidth = this.getAttr(node, ATTR_IMAGEWIDTH, -1);
        int imageHeight = this.getAttr(node, ATTR_IMAGEHEIGHT, -1);
        if (imageWidth != -1 || imageHeight != -1) {
            if (imageWidth == -1) {
                imageWidth = imageHeight;
            }
            if (imageHeight == -1) {
                imageHeight = imageWidth;
            }
            image = image.getScaledInstance(imageWidth, imageHeight, 0);
        }
        Image overImage = this.getImageAttr(node, ATTR_OVERIMAGE);
        Image downImage = this.getImageAttr(node, ATTR_DOWNIMAGE);
        Image selectImage = this.getImageAttr(node, ATTR_SELECTIMAGE);
        ImageIcon icon = new ImageIcon(image);
        icon = GuiUtils.scaleImageIcon(icon);
        if (tag.equals(TAG_TOGGLEBUTTON)) {
            tb = new JToggleButton(icon);
        } else {
            tb = new JButton(icon);
            tb.setContentAreaFilled(false);
        }
        int space = this.getAttr(node, ATTR_SPACE, 0);
        int hspace = this.getAttr(node, ATTR_HSPACE, space);
        int vspace = this.getAttr(node, ATTR_VSPACE, space);
        if (overImage != null) {
            tb.setRolloverIcon(new ImageIcon(overImage));
        }
        if (downImage != null) {
            tb.setPressedIcon(new ImageIcon(downImage));
        }
        if (selectImage != null) {
            tb.setSelectedIcon(new ImageIcon(selectImage));
        }
        if (XmlUtil.hasAttribute(node, "label")) {
            String label = this.getAttr(node, "label", "");
            tb.setText(label);
            if (XmlUtil.hasAttribute(node, ATTR_HPOSITION)) {
                tb.setHorizontalTextPosition(this.findValue(this.getAttr(node, ATTR_HPOSITION, ""), HPOS_NAMES, HPOS_VALUES, 11));
            }
            if (XmlUtil.hasAttribute(node, ATTR_VPOSITION)) {
                tb.setVerticalTextPosition(this.findValue(this.getAttr(node, ATTR_VPOSITION, ""), VPOS_NAMES, VPOS_VALUES, 0));
            }
        } else {
            tb.setPreferredSize(new Dimension(icon.getIconWidth() + hspace, icon.getIconHeight() + vspace));
        }
        if (action == null) {
            action = this.getAttr(node, ATTR_ACTION, (String)null);
        }
        if (action != null) {
            tb.setActionCommand(action);
            tb.addActionListener(this);
        }
        return tb;
    }

    public Component createComponent(Element node, String id) {
        JComponent comp = null;
        String tag = node.getTagName();
        if (tag.equals(TAG_PANEL) || tag.equals(TAG_CARDPANEL)) {
            JPanel thePanel = tag.equals(TAG_CARDPANEL) ? new CardPanel() : new JPanel();
            comp = this.layoutContainer(thePanel, node, XmlUtil.getListOfElements(node));
        } else if (tag.equals(TAG_TOOLBAR)) {
            List xmlChildren = XmlUtil.getListOfElements(node);
            int orientation = this.findValue(this.getAttr(node, ATTR_ORIENTATION, NULLSTRING), TOOLBAR_NAMES, TOOLBAR_VALUES);
            JToolBar toolbar = new JToolBar(orientation);
            toolbar.setFloatable(this.getAttr(node, ATTR_FLOAT, true));
            comp = toolbar;
            for (int i = 0; i < xmlChildren.size(); ++i) {
                Element childElement = this.getReffedNode((Element)xmlChildren.get(i));
                Component childComponent = this.xmlToUi(childElement);
                if (childComponent == null) continue;
                toolbar.add(childComponent);
            }
        } else if (tag.equals(TAG_MENUBAR)) {
            List xmlChildren = XmlUtil.getListOfElements(node);
            JMenuBar menuBar = new JMenuBar();
            comp = menuBar;
            for (int i = 0; i < xmlChildren.size(); ++i) {
                Element childElement = this.getReffedNode((Element)xmlChildren.get(i));
                Component childComponent = this.xmlToUi(childElement);
                if (childComponent == null) continue;
                menuBar.add(childComponent);
            }
        } else if (tag.equals(TAG_TABBEDPANE)) {
            List xmlChildren = XmlUtil.getListOfElements(node);
            int orient = this.findValue(this.getAttr(node, ATTR_TABPLACE, NULLSTRING), TABPLACE_NAMES, TABPLACE_VALUES, 1);
            Insets tabInsets = null;
            String insetsString = this.getAttr(node, ATTR_TABINSETS, NULLSTRING);
            if (insetsString != null) {
                double[] insets = Misc.parseDoubles(insetsString);
                if (insets.length == 1) {
                    tabInsets = new Insets((int)insets[0], (int)insets[0], (int)insets[0], (int)insets[0]);
                } else if (insets.length == 4) {
                    tabInsets = new Insets((int)insets[0], (int)insets[1], (int)insets[2], (int)insets[3]);
                }
            }
            Insets labelInsets = this.getInsets(this.getAttr(node, ATTR_TABPAD, NULLSTRING));
            JTabbedPane tab = XmlUtil.hasAttribute(node, ATTR_TABBORDERTOP) || XmlUtil.hasAttribute(node, ATTR_TABBORDERLEFT) || XmlUtil.hasAttribute(node, ATTR_TABBORDERBOTTOM) || XmlUtil.hasAttribute(node, ATTR_TABBORDERRIGHT) ? GuiUtils.getNestedTabbedPane(orient, this.getAttr(node, ATTR_TABBORDERTOP, 0), this.getAttr(node, ATTR_TABBORDERLEFT, 0), this.getAttr(node, ATTR_TABBORDERBOTTOM, 0), this.getAttr(node, ATTR_TABBORDERRIGHT, 0)) : (this.getAttr(node, ATTR_TABNESTED, false) ? GuiUtils.getNestedTabbedPane(orient) : new JTabbedPane(orient));
            comp = tab;
            for (int i = 0; i < xmlChildren.size(); ++i) {
                Image image;
                Component childComponent;
                Element childElement = this.getReffedNode((Element)xmlChildren.get(i));
                if (XmlUtil.getAttribute((Node)childElement, ATTR_CATEGORYCOMPONENT, false) || (childComponent = this.xmlToUi(childElement)) == null) continue;
                String iconName = XmlUtil.getAttribute((Node)childElement, ATTR_ICON, (String)null);
                ImageIcon icon = null;
                if (iconName != null && (image = XmlUi.getImage(iconName)) != null) {
                    icon = new ImageIcon(image);
                }
                String label = this.getAttr(childElement, ATTR_TITLE, "");
                if (labelInsets != null) {
                    label = "<html><div style=\"margin-top:" + labelInsets.top + ";margin-right:" + labelInsets.right + ";margin-bottom:" + labelInsets.bottom + ";margin-left:" + labelInsets.left + "\">" + label + "</div></html>";
                }
                if (tabInsets != null) {
                    childComponent = GuiUtils.inset(childComponent, tabInsets);
                }
                tab.addTab(label, icon, childComponent);
                String mnemonic = XmlUtil.getAttribute((Node)childElement, ATTR_MNEMONIC, (String)null);
                String tabTooltip = XmlUtil.getAttribute((Node)childElement, ATTR_TABTOOLTIP, (String)null);
                if (tabTooltip == null) continue;
                tab.setToolTipTextAt(i, tabTooltip);
            }
        } else if (tag.equals(TAG_TABBEDPANE)) {
            List xmlChildren = XmlUtil.getListOfElements(node);
            int orient = this.findValue(this.getAttr(node, ATTR_TABPLACE, NULLSTRING), TABPLACE_NAMES, TABPLACE_VALUES, 1);
            Insets tabInsets = null;
            String insetsString = this.getAttr(node, ATTR_TABINSETS, NULLSTRING);
            if (insetsString != null) {
                double[] insets = Misc.parseDoubles(insetsString);
                if (insets.length == 1) {
                    tabInsets = new Insets((int)insets[0], (int)insets[0], (int)insets[0], (int)insets[0]);
                } else if (insets.length == 4) {
                    tabInsets = new Insets((int)insets[0], (int)insets[1], (int)insets[2], (int)insets[3]);
                }
            }
            Insets labelInsets = this.getInsets(this.getAttr(node, ATTR_TABPAD, NULLSTRING));
            JTabbedPane tab = XmlUtil.hasAttribute(node, ATTR_TABBORDERTOP) || XmlUtil.hasAttribute(node, ATTR_TABBORDERLEFT) || XmlUtil.hasAttribute(node, ATTR_TABBORDERBOTTOM) || XmlUtil.hasAttribute(node, ATTR_TABBORDERRIGHT) ? GuiUtils.getNestedTabbedPane(orient, this.getAttr(node, ATTR_TABBORDERTOP, 0), this.getAttr(node, ATTR_TABBORDERLEFT, 0), this.getAttr(node, ATTR_TABBORDERBOTTOM, 0), this.getAttr(node, ATTR_TABBORDERRIGHT, 0)) : (this.getAttr(node, ATTR_TABNESTED, false) ? GuiUtils.getNestedTabbedPane(orient) : new JTabbedPane(orient));
            comp = tab;
            for (int i = 0; i < xmlChildren.size(); ++i) {
                Image image;
                Component childComponent;
                Element childElement = this.getReffedNode((Element)xmlChildren.get(i));
                if (XmlUtil.getAttribute((Node)childElement, ATTR_CATEGORYCOMPONENT, false) || (childComponent = this.xmlToUi(childElement)) == null) continue;
                String iconName = XmlUtil.getAttribute((Node)childElement, ATTR_ICON, (String)null);
                ImageIcon icon = null;
                if (iconName != null && (image = XmlUi.getImage(iconName)) != null) {
                    icon = new ImageIcon(image);
                }
                String label = this.getAttr(childElement, ATTR_TITLE, "");
                if (labelInsets != null) {
                    label = "<html><div style=\"margin-top:" + labelInsets.top + ";margin-right:" + labelInsets.right + ";margin-bottom:" + labelInsets.bottom + ";margin-left:" + labelInsets.left + "\">" + label + "</div></html>";
                }
                if (tabInsets != null) {
                    childComponent = GuiUtils.inset(childComponent, tabInsets);
                }
                tab.addTab(label, icon, childComponent);
                String mnemonic = XmlUtil.getAttribute((Node)childElement, ATTR_MNEMONIC, (String)null);
                String tabTooltip = XmlUtil.getAttribute((Node)childElement, ATTR_TABTOOLTIP, (String)null);
                if (tabTooltip == null) continue;
                tab.setToolTipTextAt(i, tabTooltip);
            }
        } else if (tag.equals(TAG_BUTTONTABBEDPANE)) {
            List xmlChildren = XmlUtil.getListOfElements(node);
            ButtonTabbedPane tab = new ButtonTabbedPane(-1);
            comp = tab;
            Component firstComp = null;
            for (int i = 0; i < xmlChildren.size(); ++i) {
                Component childComponent;
                Element childElement = this.getReffedNode((Element)xmlChildren.get(i));
                if (XmlUtil.getAttribute((Node)childElement, ATTR_CATEGORYCOMPONENT, false) || (childComponent = this.xmlToUi(childElement)) == null) continue;
                if (firstComp == null) {
                    firstComp = childComponent;
                }
                String label = this.getAttr(childElement, ATTR_TITLE, "");
                tab.addTab(label, childComponent);
            }
            if (firstComp != null) {
                tab.show(firstComp);
            }
        } else if (tag.equals(TAG_TREEPANEL)) {
            TreePanel treePanel = new TreePanel(this.getAttr(node, ATTR_USESPLITPANE, false), this.getAttr(node, ATTR_TREEWIDTH, -1));
            comp = treePanel;
            List xmlChildren = XmlUtil.getListOfElements(node);
            for (int i = 0; i < xmlChildren.size(); ++i) {
                Element childElement = this.getReffedNode((Element)xmlChildren.get(i));
                Component childComponent = this.xmlToUi(childElement);
                if (childComponent == null) continue;
                String label = this.getAttr(childElement, ATTR_TITLE, "");
                ImageIcon icon = this.getAttr(childElement, ATTR_ICON, (ImageIcon)null);
                String cat = this.getAttr(childElement, ATTR_CATEGORY, (String)null);
                if (XmlUtil.getAttribute((Node)childElement, ATTR_CATEGORYCOMPONENT, false)) {
                    treePanel.addCategoryComponent(cat, (JComponent)childComponent);
                    continue;
                }
                treePanel.addComponent((JComponent)childComponent, cat, label, icon);
            }
            treePanel.openAll();
        } else if (tag.equals(TAG_SPLITPANE)) {
            List xmlChildren = XmlUtil.getListOfElements(node);
            if (xmlChildren.size() != 2) {
                this.badState("splitpane tag needs to  have 2 children");
            }
            Element leftElement = this.getReffedNode((Element)xmlChildren.get(0));
            Component leftComponent = this.xmlToUi(leftElement);
            Element rightElement = this.getReffedNode((Element)xmlChildren.get(1));
            Component rightComponent = this.xmlToUi(rightElement);
            boolean continuous = this.getAttr(node, ATTR_CONTINUOUS, true);
            int orientation = this.findValue(this.getAttr(node, ATTR_ORIENTATION, NULLSTRING), SPLITPANE_NAMES, SPLITPANE_VALUES);
            JSplitPane split = new JSplitPane(orientation, continuous, leftComponent, rightComponent);
            int divider = this.getAttr(node, ATTR_DIVIDER, -1);
            if (divider != -1) {
                split.setDividerLocation(divider);
            }
            split.setOneTouchExpandable(this.getAttr(node, ATTR_ONETOUCHEXPANDABLE, false));
            double resizeweight = this.getAttr(node, ATTR_RESIZEWEIGHT, -1.0);
            if (resizeweight != -1.0) {
                split.setResizeWeight(resizeweight);
            }
            comp = split;
        } else if (tag.equals(TAG_SCROLLER)) {
            List xmlChildren = XmlUtil.getListOfElements(node);
            if (xmlChildren.size() != 1) {
                this.badState("scroller tag needs to  have 1 children");
            }
            Element element = this.getReffedNode((Element)xmlChildren.get(0));
            Component component = this.xmlToUi(element);
            JScrollPane scroller = new JScrollPane(component, this.findValue(this.getAttr(node, ATTR_VSCROLL, "asneeded"), SCROLL_NAMES, VSCROLL_VALUES), this.findValue(this.getAttr(node, ATTR_HSCROLL, "asneeded"), SCROLL_NAMES, HSCROLL_VALUES));
            comp = scroller;
        } else if (tag.equals(TAG_TEXTINPUT)) {
            JTextComponent textComp;
            int cols = this.getAttr(node, ATTR_COLS, -1);
            int rows = this.getAttr(node, ATTR_ROWS, -1);
            String value = this.getAttr(node, ATTR_VALUE, "");
            if (rows > 1) {
                if (cols < 0) {
                    cols = 30;
                }
                textComp = new JTextArea(value, rows, cols);
            } else {
                textComp = cols == -1 ? new JTextField(value) : new JTextField(value, cols);
                ((JTextField)textComp).addActionListener(this);
            }
            comp = textComp;
            String action = this.getAttr(node, ATTR_ACTION, (String)null);
            if (action != null) {
                this.componentToAction.put(textComp, action);
            }
        } else if (tag.equals(TAG_FILLER)) {
            int w = this.getAttr(node, ATTR_WIDTH, 0);
            int h = this.getAttr(node, ATTR_HEIGHT, 0);
            int pw = this.getAttr(node, ATTR_PREF_WIDTH, w);
            int ph = this.getAttr(node, ATTR_PREF_HEIGHT, h);
            comp = GuiUtils.topCenter(null, new Box.Filler(new Dimension(w, h), new Dimension(pw, ph), null));
        } else if (tag.equals("label")) {
            String label = this.getAttr(node, ATTR_TEXT, NULLSTRING);
            String imagePath = this.getAttr(node, "image", NULLSTRING);
            Image image = this.getImageAttr(node, "image");
            String template = this.getAttr(node, ATTR_TEMPLATE, NULLSTRING);
            if (template != null && label != null) {
                label = StringUtil.replace(template, "%text%", label);
            }
            if (label == null && image == null) {
                label = XmlUtil.getChildText(node);
                if (label != null && label.trim().length() == 0) {
                    label = null;
                }
                if (label != null) {
                    label = label.trim();
                }
            }
            if (label == null && image == null) {
                label = "No label";
            }
            comp = label == null ? new JLabel(new ImageIcon(image), this.getAlign(node)) : (image == null ? new JLabel(label, this.getAlign(node)) : new JLabel(label, new ImageIcon(image), this.getAlign(node)));
        } else if (tag.equals(TAG_HTML)) {
            String text = this.getAttr(node, ATTR_TEXT, NULLSTRING);
            if (text == null) {
                String url = this.getAttr(node, ATTR_URL, NULLSTRING);
                if (url != null) {
                    text = IOUtil.readContents(url, (String)null);
                }
                if (text == null) {
                    text = XmlUtil.getChildText(node);
                }
            }
            HyperlinkListener linkListener = new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        String url = e.getURL() == null ? e.getDescription() : e.getURL().toString();
                        XmlUi.this.actionPerformed(new ActionEvent(this, 0, url));
                    }
                }
            };
            Component[] comps = GuiUtils.getHtmlComponent(text, linkListener, this.getAttr(node, ATTR_WIDTH, 200), this.getAttr(node, ATTR_HEIGHT, 200));
            ((JComponent)comps[0]).putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            this.setAttrs(comps[0], node);
            comp = comps[1];
        } else if (tag.equals("image")) {
            Image image = this.getImageAttr(node, "image");
            if (image == null) {
                this.badState("No image found for:" + this.getAttr(node, "image", NULLSTRING));
            }
            comp = new JLabel(new ImageIcon(image));
        } else if (tag.equals(TAG_RADIO)) {
            JRadioButton radio = new JRadioButton(this.getAttr(node, "label", ""), this.getAttr(node, ATTR_DEFAULT, false));
            String group = this.getAttr(node, ATTR_GROUP, (String)null);
            if (group != null) {
                ButtonGroup bg = (ButtonGroup)this.buttonGroups.get(group);
                if (bg == null) {
                    bg = new ButtonGroup();
                    this.buttonGroups.put(group, bg);
                }
                bg.add(radio);
                String action = this.getAttr(node, ATTR_ACTION, (String)null);
                if (action != null) {
                    radio.setActionCommand(action);
                } else {
                    String value;
                    String actionTemplate = this.getAttr(node, ATTR_ACTIONTEMPLATE, (String)null);
                    if (actionTemplate != null && (value = this.getAttr(node, ATTR_VALUE, (String)null)) != null) {
                        radio.setActionCommand(StringUtil.replace(actionTemplate, "%value%", value));
                    }
                }
            }
            radio.addActionListener(this);
            comp = radio;
        } else if (tag.equals("button") || tag.equals(TAG_TOGGLEBUTTON)) {
            comp = this.makeButton(tag, node);
        } else if (tag.equals(TAG_CHECKBOX)) {
            JCheckBox b = new JCheckBox(this.getAttr(node, "label", "No label"), this.getAttr(node, ATTR_VALUE, false));
            String action = this.getAttr(node, ATTR_ACTION, (String)null);
            comp = b;
            if (action != null) {
                this.componentToAction.put(comp, action);
                b.addItemListener(this);
                this.actionPerformed(new ActionEvent(comp, 0, action));
            }
        } else if (tag.equals(TAG_COMBOBOX)) {
            XmlNodeList items = XmlUtil.getElements(node, TAG_ITEM);
            Vector<TwoFacedObject> boxItems = new Vector<TwoFacedObject>();
            for (int i = 0; i < items.size(); ++i) {
                Element child = this.getReffedNode((Element)items.get(i));
                String label = this.getAttr(child, "label");
                String action = this.getAttr(child, ATTR_ACTION, (String)null);
                String value = this.getAttr(child, ATTR_VALUE, (String)null);
                boxItems.add(new TwoFacedObject((Object)label, new String[]{action, value}));
            }
            JComboBox box = new JComboBox(boxItems);
            box.setEditable(this.getAttr(node, ATTR_EDITABLE, false));
            comp = box;
            box.addActionListener(this);
        } else if (tag.equals(TAG_MENUITEM)) {
            comp = this.makeMenuItem(node, null);
        } else if (tag.equals(TAG_MENU)) {
            JMenu menu = new JMenu(this.getAttr(node, "label", "No label"));
            List xmlChildren = XmlUtil.getListOfElements(node);
            for (int i = 0; i < xmlChildren.size(); ++i) {
                Element childElement = this.getReffedNode((Element)xmlChildren.get(i));
                if (childElement.getTagName().equals(TAG_SEPARATOR)) {
                    menu.addSeparator();
                    continue;
                }
                Component childComponent = this.xmlToUi(childElement);
                if (childComponent == null) continue;
                menu.add(childComponent);
            }
            comp = menu;
        } else if (tag.equals(TAG_MENUPOPUP)) {
            String image = this.getAttr(node, "image", (String)null);
            if (image == null) {
                JButton b = new JButton(this.getAttr(node, "label", "No label"));
                b.setActionCommand(ACTION_MENUPOPUP);
                b.addActionListener(this);
                comp = b;
            } else {
                comp = this.makeImageButton(tag, node, image, ACTION_MENUPOPUP);
            }
        } else {
            comp = new JLabel("Unknown tag:" + tag);
        }
        return comp;
    }

    public JComponent makeButton(String tag, Element node) {
        String image = this.getAttr(node, "image", (String)null);
        String action = this.getAttr(node, ATTR_ACTION, "No action");
        if (image == null) {
            AbstractButton b = tag.equals("button") ? new JButton(this.getAttr(node, "label", "No label")) : new JToggleButton(this.getAttr(node, "label", "No label"));
            b.setActionCommand(action);
            b.addActionListener(this);
            return b;
        }
        return this.makeImageButton(tag, node, image, action);
    }

    private void setText(Component comp, String text) {
        if (comp instanceof JTextComponent) {
            ((JTextComponent)comp).setText(text);
        } else if (comp instanceof JLabel) {
            ((JLabel)comp).setText(text);
        } else if (comp instanceof JButton) {
            ((JButton)comp).setText(text);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        String action = (String)this.componentToAction.get(source);
        if (action == null) {
            return;
        }
        this.actionPerformed(new ActionEvent(source, 0, action));
    }

    @Override
    public void actionPerformed(final ActionEvent event) {
        Misc.run(new Runnable(){

            @Override
            public void run() {
                XmlUi.this.actionPerformedInner(event);
            }
        });
    }

    private void actionPerformedInner(ActionEvent event) {
        Object source = event.getSource();
        String cmd = null;
        if (source instanceof JComboBox) {
            TwoFacedObject tfo = (TwoFacedObject)((JComboBox)source).getSelectedItem();
            String[] actionOrValue = (String[])tfo.getId();
            Element boxNode = (Element)this.compToNode.get(source);
            if (actionOrValue[0] != null) {
                cmd = actionOrValue[0];
            } else if (actionOrValue[1] != null) {
                String actionTemplate = this.getAttr(boxNode, ATTR_ACTIONTEMPLATE);
                if (actionTemplate != null) {
                    cmd = StringUtil.replace(actionTemplate, "%value%", actionOrValue[1]);
                }
            } else {
                cmd = this.getAttr(boxNode, ATTR_ACTION);
            }
        }
        if (cmd == null) {
            cmd = event.getActionCommand();
            String otherAction = (String)this.componentToAction.get(source);
            if (otherAction != null) {
                cmd = otherAction;
            }
        }
        if (cmd == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(cmd, ";");
        while (tok.hasMoreTokens()) {
            this.processAction(tok.nextToken(), source);
        }
    }

    public static String extractOneArg(String cmd) {
        int idx1 = cmd.indexOf("(");
        int idx2 = cmd.indexOf(")");
        if (idx1 < 0 || idx2 < 0) {
            return null;
        }
        return cmd.substring(idx1 + 1, idx2);
    }

    public static String[] extractTwoArgs(String cmd) {
        int idx1 = cmd.indexOf("(");
        int idx2 = cmd.indexOf(",");
        int idx3 = cmd.indexOf(")");
        if (idx1 < 0 || idx2 < 0 || idx3 < 0) {
            return null;
        }
        if (idx1 >= idx2 || idx2 >= idx3) {
            return null;
        }
        return new String[]{cmd.substring(idx1 + 1, idx2), cmd.substring(idx2 + 1, idx3)};
    }

    private void processAction(String cmd, Object source) {
        if ((cmd = cmd.trim()).startsWith("ui.toggle")) {
            String compId = XmlUi.extractOneArg(cmd);
            Component comp = (Component)this.idToComponent.get(compId);
            if (comp == null) {
                System.err.println("Unable to find: " + compId);
                return;
            }
            Container parent = (Container)this.componentToParent.get(comp);
            if (parent == null) {
                return;
            }
            Element parentNode = (Element)this.compToNode.get(parent);
            if (parentNode == null) {
                return;
            }
            comp.setVisible(!comp.isVisible());
            this.layoutContainer((JPanel)parent, parentNode, (List)this.containerToNodeList.get(parent));
            this.myContents.invalidate();
            this.myContents.validate();
        } else if (cmd.equals(ACTION_MENUPOPUP)) {
            Element node = (Element)this.compToNode.get(source);
            if (node == null) {
                return;
            }
            JPopupMenu m = new JPopupMenu();
            this.processMenu(null, m, node, this.getAttr(node, ATTR_ACTIONTEMPLATE, (String)null));
            Component mb = (Component)source;
            m.show(mb, 0, mb.getBounds().height);
        } else if (cmd.startsWith(ACTION_SETTEXT)) {
            String[] args = XmlUi.extractTwoArgs(cmd);
            if (args != null) {
                Component comp;
                Component component = comp = args[0].equals("this") ? (Component)source : (Component)this.idToComponent.get(args[0]);
                if (comp != null) {
                    String text = args[1];
                    if (text.startsWith("prop:")) {
                        Element node = (Element)this.compToNode.get(source);
                        if (node == null) {
                            return;
                        }
                        text = this.getAttr(node, text.substring(5), "");
                    }
                    this.setText(comp, text);
                }
            }
        } else if (cmd.startsWith(ACTION_SETBORDER)) {
            String[] args = XmlUi.extractTwoArgs(cmd);
            if (args != null) {
                JComponent comp;
                JComponent jComponent = comp = args[0].equals("this") ? (JComponent)source : (JComponent)this.idToComponent.get(args[0]);
                if (comp != null) {
                    String border = args[1];
                    Element node = (Element)this.compToNode.get(source);
                    comp.setBorder(this.getBorder(border, node));
                }
            }
        } else if (cmd.startsWith(ACTION_UI_FOCUS)) {
            String id = XmlUi.extractOneArg(cmd);
            if (id == null) {
                return;
            }
            Component comp = (Component)(id.equals("this") ? source : this.idToComponent.get(id));
            if (comp == null) {
                return;
            }
            if (comp instanceof JComponent) {
                ((JComponent)comp).requestFocusInWindow();
            }
        } else if (cmd.startsWith(ACTION_UI_GROUP_NEXT)) {
            String groupId = XmlUi.extractOneArg(cmd);
            if (groupId == null) {
                return;
            }
            ButtonGroup bg = (ButtonGroup)this.buttonGroups.get(groupId);
            if (bg == null) {
                return;
            }
            boolean nextOneOn = false;
            List buttons = Misc.toList(bg.getElements());
            for (int i = 0; i < buttons.size(); ++i) {
                JToggleButton btn = (JToggleButton)buttons.get(i);
                if (nextOneOn) {
                    btn.setSelected(true);
                    String action = btn.getActionCommand();
                    if (action != null) {
                        this.actionPerformed(new ActionEvent(btn, 0, action));
                    }
                    break;
                }
                nextOneOn = btn.isSelected();
            }
        } else if (cmd.startsWith(ACTION_UI_GROUP_PREV)) {
            String groupId = XmlUi.extractOneArg(cmd);
            if (groupId == null) {
                return;
            }
            ButtonGroup bg = (ButtonGroup)this.buttonGroups.get(groupId);
            if (bg == null) {
                return;
            }
            boolean nextOneOn = false;
            List buttons = Misc.toList(bg.getElements());
            for (int i = buttons.size() - 1; i >= 0; --i) {
                JToggleButton btn = (JToggleButton)buttons.get(i);
                if (nextOneOn) {
                    btn.setSelected(true);
                    String action = btn.getActionCommand();
                    if (action != null) {
                        this.actionPerformed(new ActionEvent(btn, 0, action));
                    }
                    break;
                }
                nextOneOn = btn.isSelected();
            }
        } else if (cmd.startsWith(ACTION_UI_FLIP)) {
            String[] args = XmlUi.extractTwoArgs(cmd);
            if (args != null) {
                Container panel = (Container)this.idToComponent.get(args[0]);
                Component comp = (Component)this.idToComponent.get(args[1]);
                if (panel == null || comp == null) {
                    System.err.println("Unable to find: " + args[0] + " or " + args[1]);
                    return;
                }
                if (panel instanceof CardPanel) {
                    ((CardPanel)panel).flip(args[1]);
                    panel.invalidate();
                    panel.validate();
                    panel.repaint();
                } else {
                    CardLayout layout = (CardLayout)panel.getLayout();
                    layout.show(panel, args[1]);
                }
            } else {
                String arg = XmlUi.extractOneArg(cmd);
                if (arg == null) {
                    return;
                }
                Container panel = (Container)this.idToComponent.get(arg);
                if (panel == null) {
                    System.err.println("Unable to find: " + arg);
                    return;
                }
                if (panel instanceof CardPanel) {
                    ((CardPanel)panel).next();
                    panel.invalidate();
                    panel.validate();
                    panel.repaint();
                } else {
                    CardLayout layout = (CardLayout)panel.getLayout();
                    layout.next(panel);
                }
            }
        } else if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(source, 0, cmd));
        }
    }

    private JMenuItem makeMenuItem(Element child, String actionTemplate) {
        String tooltip;
        JMenuItem mi = new JMenuItem(this.getAttr(child, "label", "No label"));
        String action = this.getAttr(child, ATTR_ACTION, (String)null);
        String value = this.getAttr(child, ATTR_VALUE, (String)null);
        if (action == null && actionTemplate != null && value != null) {
            action = StringUtil.replace(actionTemplate, "%value%", value);
        }
        if (action != null) {
            mi.setActionCommand(action);
            mi.addActionListener(this);
        }
        if ((tooltip = this.getAttr(child, ATTR_TOOLTIP, (String)null)) != null) {
            mi.setToolTipText(tooltip);
        }
        return mi;
    }

    private void processMenu(JMenu m, JPopupMenu pm, Element node, String actionTemplate) {
        JComponent cont = m != null ? m : pm;
        NodeList children = XmlUtil.getElements(node);
        for (int i = 0; i < children.getLength(); ++i) {
            Element child = this.getReffedNode((Element)children.item(i));
            if (child.getTagName().equals(TAG_SEPARATOR)) {
                if (m != null) {
                    m.addSeparator();
                    continue;
                }
                pm.addSeparator();
                continue;
            }
            if (child.getTagName().equals(TAG_MENUITEM)) {
                cont.add(this.makeMenuItem(child, actionTemplate));
                continue;
            }
            if (!child.getTagName().equals(TAG_MENU)) continue;
            JMenu childMenu = new JMenu(this.getAttr(child, "label", "No label"));
            m.add(childMenu);
            this.processMenu(childMenu, null, child, actionTemplate);
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Provide an xml file");
            return;
        }
        try {
            XmlUi xmlUi = new XmlUi(XmlUtil.getRoot(args[0], XmlUi.class), null, null, null);
            JFrame f = new JFrame();
            f.getContentPane().add(xmlUi.getContents());
            f.pack();
            f.setLocation(300, 300);
            f.setVisible(true);
        }
        catch (Exception exc) {
            System.err.println("Error:");
            exc.printStackTrace();
        }
    }

    public static class CardPanel
    extends JPanel {
        List members = new ArrayList();
        Hashtable idToMember = new Hashtable();
        int currentIdx = 0;

        @Override
        public Component add(Component comp) {
            this.addCardComponent(null, comp);
            return comp;
        }

        @Override
        public Component add(String id, Component comp) {
            this.addCardComponent(id, comp);
            return comp;
        }

        public void addCardComponent(String id, Component comp) {
            this.members.add(comp);
            if (id != null) {
                this.idToMember.put(id, comp);
            }
            if (this.members.size() == 1) {
                super.add(comp, "Center");
            } else {
                comp.setVisible(false);
            }
        }

        private void checkVisible() {
            for (int i = 0; i < this.members.size(); ++i) {
                ((Component)this.members.get(i)).setVisible(i == this.currentIdx);
            }
        }

        public void next() {
            ++this.currentIdx;
            if (this.currentIdx >= this.members.size()) {
                this.currentIdx = 0;
            }
            Component next = (Component)this.members.get(this.currentIdx);
            this.checkVisible();
            super.removeAll();
            super.add(next, "Center");
        }

        public void flip(String id) {
            if (id == null) {
                return;
            }
            Component next = (Component)this.idToMember.get(id);
            if (next == null) {
                return;
            }
            int idx = this.members.indexOf(next);
            if (idx < 0 || idx == this.currentIdx) {
                return;
            }
            this.currentIdx = idx;
            this.checkVisible();
            super.removeAll();
            super.add(next, "Center");
        }
    }

    public static interface ActionHandler {
        public void handleAction(ActionEvent var1, XmlUi var2);
    }
}

