/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.xml.XmlNodeList;
import ucar.unidata.xml.XmlUtil;

public class XmlTree
extends JTree {
    public static final String ATTR_NAME = "name";
    public static final String ATTR_LABEL = "label";
    public static final String ATTR_XLINKHREF = "xlink:href";
    public static final String NULL_STRING = null;
    static ImageIcon leafIcon;
    private Element xmlRoot;
    private XmlTreeNode treeRoot;
    private DefaultTreeModel treeModel;
    private Hashtable elementToNode = new Hashtable();
    private Hashtable tagsToNotProcessButRecurse = null;
    private Hashtable tagToIcons = new Hashtable();
    private boolean includeAttributes = false;
    private Hashtable tagsToRecurse = null;
    private Hashtable tagsToProcess = null;
    private Hashtable tagsToNotRecurse = null;
    private Hashtable tagsToNotProcess = null;
    private Hashtable tagNameToLabelAttr = null;
    private Hashtable tagNameToLabelChild = null;
    private Hashtable tagNameToTooltipChild = null;
    private Hashtable xlinkTags = null;
    private boolean useTagNameAsLabel;
    private JScrollPane scroller;
    private boolean openFirstLevel = false;
    private boolean haveInitialized = false;
    private String baseUrlPath;

    public XmlTree(Element xmlRoot) {
        this(xmlRoot, false);
    }

    public XmlTree(Element xmlRoot, boolean openFirstLevel) {
        this(xmlRoot, openFirstLevel, null);
    }

    public XmlTree(Element xmlRoot, boolean openFirstLevel, String basePath) {
        this.setToolTipText(" ");
        this.baseUrlPath = basePath;
        this.xmlRoot = xmlRoot;
        this.openFirstLevel = openFirstLevel;
        this.setMultipleSelect(false);
        this.setShowsRootHandles(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                XmlTree.this.treeClick(event);
            }
        });
        this.setCellRenderer(new MyRenderer(this));
    }

    public ImageIcon getIconForNode(Element node) {
        return null;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Element child;
        String childTag;
        Element n = this.getXmlNodeAt(event.getX(), event.getY());
        if (n == null) {
            return null;
        }
        if (this.tagNameToTooltipChild != null && (childTag = (String)this.tagNameToTooltipChild.get(XmlUtil.getLocalName(n))) != null && (child = XmlUtil.getElement(n, childTag)) != null) {
            String text = XmlUtil.getChildText(child);
            if (text != null && text.length() > 50) {
                text = "<html>" + StringUtil.breakText(text, "<br>", 50) + "</html>";
            }
            return text;
        }
        return this.getToolTipText(n);
    }

    public String getToolTipText(Element n) {
        return null;
    }

    private void init() {
        this.haveInitialized = true;
        this.treeRoot = new XmlTreeNode(null, "", this.baseUrlPath);
        this.treeModel = new DefaultTreeModel(this.treeRoot);
        this.setModel(this.treeModel);
        this.setRootVisible(false);
        this.loadTree();
    }

    public void loadTree() {
        if (!this.haveInitialized) {
            this.init();
        }
        if (this.xmlRoot != null) {
            this.treeRoot.removeAllChildren();
            this.process(this.treeRoot, this.xmlRoot);
            this.treeModel.nodeStructureChanged(this.treeRoot);
            if (this.openFirstLevel) {
                Enumeration<TreeNode> children = this.treeRoot.children();
                while (children.hasMoreElements()) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                    this.expandPath(new TreePath(new Object[]{this.treeRoot, child}));
                }
            }
        }
    }

    public void setUseTagNameAsLabel(boolean value) {
        this.useTagNameAsLabel = value;
    }

    public boolean getUseTagNameAsLabel() {
        return this.useTagNameAsLabel;
    }

    public void setIncludeAttributes(boolean value) {
        this.includeAttributes = value;
    }

    public boolean getIncludeAttributes() {
        return this.includeAttributes;
    }

    public List getSelectedElements() {
        ArrayList<Element> l = new ArrayList<Element>();
        TreePath[] paths = this.getSelectionModel().getSelectionPaths();
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                l.add(this.getXmlNodeAtPath(paths[i]));
            }
        }
        return l;
    }

    public void selectElement(Element element) {
        TreeNode node = (TreeNode)this.elementToNode.get(element);
        if (node == null) {
            return;
        }
        TreePath treePath = new TreePath(this.treeModel.getPathToRoot(node));
        this.addSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
    }

    public Element getSelectedElement() {
        TreePath[] paths = this.getSelectionModel().getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return null;
        }
        return this.getXmlNodeAtPath(paths[0]);
    }

    public Element getXmlRoot() {
        return this.xmlRoot;
    }

    public void setXmlRoot(Element newRoot) {
        this.xmlRoot = newRoot;
        this.init();
    }

    protected void treeClick(MouseEvent event) {
        XmlTreeNode node = this.getXmlTreeNodeAt(event.getX(), event.getY());
        if (node == null) {
            return;
        }
        Element element = node.getXmlNode();
        if (element == null) {
            return;
        }
        if (SwingUtilities.isRightMouseButton(event)) {
            this.doRightClick(this, node, element, event);
        } else if (event.getClickCount() > 1) {
            this.doDoubleClick(this, node, element);
        } else {
            this.doClick(this, node, element);
        }
    }

    public void doDoubleClick(XmlTree tree, XmlTreeNode node, Element element) {
        this.doDoubleClick(tree, element);
    }

    public void doDoubleClick(XmlTree tree, Element element) {
    }

    public void doClick(XmlTree tree, XmlTreeNode node, Element element) {
        this.doClick(tree, element);
    }

    public void doClick(XmlTree tree, Element element) {
    }

    public void doRightClick(XmlTree tree, XmlTreeNode node, Element element, MouseEvent event) {
        this.doRightClick(tree, element, event);
    }

    public void doRightClick(XmlTree tree, Element element, MouseEvent event) {
    }

    public Component getContents() {
        if (!this.haveInitialized) {
            this.init();
        }
        return this;
    }

    public JScrollPane getScroller() {
        if (this.scroller == null) {
            this.scroller = GuiUtils.makeScrollPane(this.getContents(), 200, 300);
        }
        return this.scroller;
    }

    private Hashtable addToTable(Hashtable ht, List tags) {
        if (ht == null) {
            ht = new Hashtable();
        }
        for (int i = 0; i < tags.size(); ++i) {
            ht.put(tags.get(i), tags.get(i));
        }
        return ht;
    }

    public void defineLabelAttr(String tagName, String attrName) {
        if (this.tagNameToLabelAttr == null) {
            this.tagNameToLabelAttr = new Hashtable();
        }
        this.tagNameToLabelAttr.put(tagName, attrName);
    }

    public void defineLabelChild(String tagName, String childTag) {
        if (this.tagNameToLabelChild == null) {
            this.tagNameToLabelChild = new Hashtable();
        }
        this.tagNameToLabelChild.put(tagName, childTag);
    }

    public void defineTooltipChild(String tagName, String childTag) {
        if (this.tagNameToTooltipChild == null) {
            this.tagNameToTooltipChild = new Hashtable();
        }
        this.tagNameToTooltipChild.put(tagName, childTag);
    }

    public void addXlinkTag(String tagName) {
        if (this.xlinkTags == null) {
            this.xlinkTags = new Hashtable();
        }
        this.xlinkTags.put(tagName, tagName);
    }

    private boolean isXlinkTag(String tag) {
        if (this.xlinkTags == null) {
            return false;
        }
        return this.xlinkTags.get(tag) != null;
    }

    public void addTagsToRecurse(List tags) {
        this.tagsToRecurse = this.addToTable(this.tagsToRecurse, tags);
    }

    public void setIconForTag(ImageIcon icon, String tagName) {
        this.tagToIcons.put(tagName, icon);
    }

    public void addTagToRecurse(String tag) {
        this.addTagsToRecurse(Misc.newList(tag));
    }

    public void addTagsToProcess(List tags) {
        this.tagsToProcess = this.addToTable(this.tagsToProcess, tags);
    }

    public void addTagToProcess(String tag) {
        this.addTagsToProcess(Misc.newList(tag));
    }

    public void addTagsToNotProcessButRecurse(List tags) {
        this.tagsToNotProcessButRecurse = this.addToTable(this.tagsToNotProcessButRecurse, tags);
    }

    public void addTagsToNotRecurse(List tags) {
        this.tagsToNotRecurse = this.addToTable(this.tagsToNotRecurse, tags);
    }

    public void addTagToNotRecurse(String tag) {
        this.addTagsToNotRecurse(Misc.newList(tag));
    }

    public void addTagsToNotProcess(List tags) {
        this.tagsToNotProcess = this.addToTable(this.tagsToNotProcess, tags);
    }

    public void addTagToNotProcess(String tag) {
        this.addTagsToNotProcess(Misc.newList(tag));
    }

    @Override
    public void fireTreeWillExpand(TreePath treePath) throws ExpandVetoException {
        Object[] path = treePath.getPath();
        if (path.length > 0 && path[path.length - 1] instanceof XlinkTreeNode) {
            ((XlinkTreeNode)path[path.length - 1]).checkExpansion();
        }
        super.fireTreeWillExpand(treePath);
    }

    public String expandRelativeUrl(XmlTreeNode node, String href) {
        String base = node.getBaseLocation();
        if (base != null) {
            return XmlTree.expandRelativeUrl(href, base);
        }
        return this.expandRelativeUrl(href);
    }

    public String expandRelativeUrl(String href) {
        return XmlTree.expandRelativeUrl(href, this.baseUrlPath);
    }

    public static String expandRelativeUrl(String href, String baseUrlPath) {
        if (href == null) {
            return baseUrlPath;
        }
        if (baseUrlPath == null) {
            return href;
        }
        try {
            URL url = new URL(href);
            return href;
        }
        catch (Exception badHrefException) {
            if (href.startsWith("/")) {
                try {
                    URL url = new URL(baseUrlPath);
                    int port = url.getPort();
                    String portString = "";
                    if (port != -1) {
                        portString = ":" + port;
                    }
                    return url.getProtocol() + "://" + url.getHost() + portString + href;
                }
                catch (Exception exc) {
                    return href;
                }
            }
            int idx = baseUrlPath.lastIndexOf("/");
            if (idx >= 0) {
                String base = baseUrlPath.substring(0, idx);
                if (base.lastIndexOf("/") != base.length() - 1) {
                    base = base + "/";
                }
                href = base + href;
            }
            return href;
        }
    }

    protected Document readXlinkXml(String href) throws Exception {
        String xml = IOUtil.readContents(href, this.getClass());
        if (xml == null) {
            return null;
        }
        return XmlUtil.getDocument(xml);
    }

    protected int getXlinkImportLevel() {
        return 0;
    }

    protected void expandXlink(final XlinkTreeNode node, String href) {
        try {
            href = this.expandRelativeUrl(href);
            Document document = this.readXlinkXml(href);
            node.removeAllChildren();
            if (document == null) {
                this.treeModel.nodeStructureChanged(node);
                return;
            }
            Element newRoot = document.getDocumentElement();
            if (!this.initXlinkRoot(newRoot, document, href)) {
                return;
            }
            NodeList importElements = this.getXlinkImportElements(newRoot);
            for (int i = 0; i < importElements.getLength(); ++i) {
                Element child = (Element)importElements.item(i);
                this.process(node, child);
            }
            final TreePath path = new TreePath(this.treeModel.getPathToRoot(node));
            GuiUtils.invokeInSwingThread(new Runnable(){

                @Override
                public void run() {
                    XmlTree.this.expandPath(path);
                    XmlTree.this.treeModel.nodeStructureChanged(node);
                    XmlTree.this.repaint();
                }
            });
        }
        catch (Throwable exc) {
            LogUtil.logException("Expanding xlink node:" + href, exc);
        }
    }

    public NodeList getXlinkImportElements(Element root) {
        NodeList importElements = null;
        int importLevel = this.getXlinkImportLevel();
        if (importLevel == 1) {
            importElements = XmlUtil.getElements(root);
        } else if (importLevel == 2) {
            importElements = XmlUtil.getGrandChildren(root);
            if (importElements.getLength() == 0) {
                importElements = XmlUtil.getElements(root);
            }
            if (importElements.getLength() == 0) {
                ((XmlNodeList)importElements).add(root);
            }
        } else {
            importElements = new XmlNodeList();
            ((XmlNodeList)importElements).add(root);
        }
        return importElements;
    }

    protected boolean initXlinkRoot(Element root, Document doc, String url) {
        return true;
    }

    protected boolean shouldProcess(Element xmlNode) {
        String tagName = XmlUtil.getLocalName(xmlNode);
        if (this.tagsToProcess != null && this.tagsToProcess.get(tagName) == null) {
            return false;
        }
        if (this.tagsToNotProcess != null) {
            return this.tagsToNotProcess.get(XmlUtil.getLocalName(xmlNode)) == null;
        }
        return true;
    }

    protected ImageIcon getIcon(Element xmlNode, boolean isLeaf) {
        String tagName = XmlUtil.getLocalName(xmlNode);
        ImageIcon icon = (ImageIcon)this.tagToIcons.get(tagName);
        if (icon != null) {
            return icon;
        }
        if (leafIcon == null) {
            leafIcon = GuiUtils.getImageIcon("/ucar/unidata/ui/images/bullet.gif", this.getClass());
        }
        return isLeaf ? leafIcon : null;
    }

    protected void process(XmlTreeNode parentTreeNode, Element xmlNode) {
        XmlTreeNode childTreeNode = null;
        if (this.shouldProcess(xmlNode)) {
            String xlinkHref = XmlUtil.getAttribute((Node)xmlNode, ATTR_XLINKHREF, NULL_STRING);
            String label = this.getLabel(xmlNode);
            if (this.isXlinkTag(XmlUtil.getLocalName(xmlNode)) && xlinkHref != null) {
                childTreeNode = new XlinkTreeNode(xmlNode, this, label, xlinkHref);
                childTreeNode.add(new DefaultMutableTreeNode("Please wait"));
            } else {
                childTreeNode = new XmlTreeNode(xmlNode, label);
                this.elementToNode.put(xmlNode, childTreeNode);
            }
            parentTreeNode.add(childTreeNode);
            if (this.includeAttributes) {
                NamedNodeMap attrs = xmlNode.getAttributes();
                DefaultMutableTreeNode attrsNode = null;
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Attr attr = (Attr)attrs.item(i);
                    if (i == 0) {
                        attrsNode = new DefaultMutableTreeNode("Attributes");
                        childTreeNode.add(attrsNode);
                    }
                    attrsNode.add(new DefaultMutableTreeNode(attr.getNodeName() + "=" + attr.getNodeValue()));
                }
            }
        }
        if (this.shouldRecurse(xmlNode)) {
            NodeList children = XmlUtil.getElements(xmlNode);
            if (childTreeNode == null) {
                childTreeNode = parentTreeNode;
            }
            for (int i = 0; i < children.getLength(); ++i) {
                Element childXmlNode = (Element)children.item(i);
                this.process(childTreeNode, childXmlNode);
            }
        }
    }

    protected boolean shouldRecurse(Element xmlNode) {
        String tagName = XmlUtil.getLocalName(xmlNode);
        if (this.tagsToNotProcessButRecurse != null && this.tagsToNotProcessButRecurse.get(tagName) != null) {
            return true;
        }
        if (this.tagsToRecurse != null && this.tagsToRecurse.get(tagName) == null) {
            return false;
        }
        if (this.tagsToNotRecurse != null) {
            return this.tagsToNotRecurse.get(XmlUtil.getLocalName(xmlNode)) == null;
        }
        return true;
    }

    public String getLabel(Element n) {
        Element child;
        String childTag;
        String attrName;
        String label = null;
        if (this.useTagNameAsLabel) {
            return XmlUtil.getLocalName(n);
        }
        if (this.tagNameToLabelAttr != null && (attrName = (String)this.tagNameToLabelAttr.get(XmlUtil.getLocalName(n))) != null) {
            label = XmlUtil.getAttribute((Node)n, attrName, NULL_STRING);
        }
        if (this.tagNameToLabelChild != null && (childTag = (String)this.tagNameToLabelChild.get(XmlUtil.getLocalName(n))) != null && (child = XmlUtil.getElement(n, childTag)) != null) {
            label = XmlUtil.getChildText(child);
        }
        if (label == null) {
            label = XmlUtil.getAttribute((Node)n, ATTR_LABEL, NULL_STRING);
        }
        if (label == null) {
            label = XmlUtil.getAttribute((Node)n, ATTR_NAME, NULL_STRING);
        }
        if (label == null) {
            label = XmlUtil.getLocalName(n);
        }
        return label;
    }

    public Element getXmlNodeAt(int x, int y) {
        return this.getXmlNodeAtPath(this.getPathForLocation(x, y));
    }

    protected Element getXmlNodeAtPath(TreePath path) {
        if (path == null) {
            return null;
        }
        Object last = path.getLastPathComponent();
        if (last == null) {
            return null;
        }
        if (!(last instanceof XmlTreeNode)) {
            return null;
        }
        return ((XmlTreeNode)last).getXmlNode();
    }

    public XmlTreeNode getXmlTreeNodeAt(int x, int y) {
        return this.getXmlTreeNodeAtPath(this.getPathForLocation(x, y));
    }

    protected XmlTreeNode getXmlTreeNodeAtPath(TreePath path) {
        if (path == null) {
            return null;
        }
        Object last = path.getLastPathComponent();
        if (last == null) {
            return null;
        }
        if (!(last instanceof XmlTreeNode)) {
            return null;
        }
        return (XmlTreeNode)last;
    }

    public Element getXmlElement(TreeNode treeNode) {
        if (!(treeNode instanceof XmlTreeNode)) {
            return null;
        }
        return ((XmlTreeNode)treeNode).getXmlNode();
    }

    public void setMultipleSelect(boolean v) {
        this.getSelectionModel().setSelectionMode(v ? 4 : 1);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Provide a  xml file");
            System.exit(0);
        }
        try {
            XmlTree t = new XmlTree(XmlUtil.getRoot(IOUtil.readContents(new File(args[0]))));
            t.addTagToProcess("catalog");
            t.addTagToProcess("collection");
            t.addTagToProcess("dataset");
            JFrame f = new JFrame();
            f.getContentPane().add(GuiUtils.makeScrollPane(t.getContents(), 200, 300));
            f.pack();
            f.setVisible(true);
        }
        catch (Exception exc) {
            System.err.println("Error:" + exc);
        }
    }

    public static class XlinkTreeNode
    extends XmlTreeNode {
        private boolean haveLoaded = false;
        XmlTree tree;
        String href;

        public XlinkTreeNode(Element node, XmlTree tree, String name, String href) {
            super(node, name, href);
            this.href = href;
            this.tree = tree;
        }

        public void checkExpansion() {
            if (this.haveLoaded) {
                return;
            }
            this.haveLoaded = true;
            Misc.run(this, "checkExpansionInner");
        }

        public void checkExpansionInner() {
            this.tree.expandXlink(this, this.getXlinkHref());
        }

        public boolean getHaveLoaded() {
            return this.haveLoaded;
        }

        public String getXlinkHref() {
            String baseLocation = null;
            XmlTreeNode parent = (XmlTreeNode)this.getParent();
            if (parent != null) {
                baseLocation = parent.getBaseLocation();
            }
            String xmlUrl = XmlTree.expandRelativeUrl(this.href, baseLocation);
            return xmlUrl;
        }

        public String getHref() {
            return this.getXlinkHref();
        }
    }

    public static class XmlTreeNode
    extends DefaultMutableTreeNode {
        Element xmlNode;
        String baseLocation;

        public XmlTreeNode(Element node, String name) {
            this(node, name, null);
        }

        public XmlTreeNode(Element node, String name, String baseLocation) {
            super(name);
            this.xmlNode = node;
            this.baseLocation = baseLocation;
        }

        public Element getXmlNode() {
            return this.xmlNode;
        }

        public String getBaseLocation() {
            String parentBaseLocation = null;
            XmlTreeNode parent = (XmlTreeNode)this.getParent();
            if (parent != null) {
                parentBaseLocation = parent.getBaseLocation();
            }
            return XmlTree.expandRelativeUrl(this.baseLocation, parentBaseLocation);
        }
    }

    public class MyRenderer
    extends DefaultTreeCellRenderer {
        XmlTree xmlTree;

        public MyRenderer(XmlTree xmlTree) {
            this.xmlTree = xmlTree;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            XmlTreeNode treeNode;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.setIcon(null);
            if (value instanceof XmlTreeNode && (treeNode = (XmlTreeNode)value).getXmlNode() != null) {
                ImageIcon icon = XmlTree.this.getIconForNode(treeNode.getXmlNode());
                if (icon == null) {
                    icon = this.xmlTree.getIcon(treeNode.getXmlNode(), leaf);
                }
                if (icon != null) {
                    this.setIcon(icon);
                }
            }
            return this;
        }
    }
}

