/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Msg;

public abstract class WindowHolder
implements ActionListener {
    protected JComponent contents;
    protected JDialog dialog;
    protected JFrame frame;
    protected Window window;
    private JMenuBar menuBar;

    public void setMenuBar(JMenuBar menuBar) {
        this.menuBar = menuBar;
        if (this.frame != null) {
            GuiUtils.decorateFrame(this.frame, menuBar);
        }
    }

    public Window getWindow() {
        if (this.windowOk()) {
            return null;
        }
        return this.window;
    }

    protected boolean shouldMakeDialog() {
        return false;
    }

    public void toFront() {
        if (!this.windowOk()) {
            return;
        }
        this.window.toFront();
    }

    protected void windowIsClosing() {
    }

    private boolean windowOk() {
        this.getContents();
        if (this.contents == null) {
            return false;
        }
        if (this.shouldMakeDialog()) {
            if (this.dialog == null) {
                this.dialog = new JDialog((Frame)null, this.getWindowTitle(), false);
                LogUtil.registerWindow(this.dialog);
                GuiUtils.packDialog(this.dialog, this.contents);
                this.dialog.setLocation(100, 100);
                this.window = this.dialog;
            }
        } else if (this.frame == null) {
            this.frame = new JFrame(this.getWindowTitle());
            if (this.menuBar != null) {
                GuiUtils.decorateFrame(this.frame, this.menuBar);
            }
            LogUtil.registerWindow(this.frame);
            this.frame.getContentPane().add(this.contents);
            this.frame.pack();
            Msg.translateTree(this.frame);
            this.frame.setLocation(100, 100);
            this.window = this.frame;
        }
        if (this.window != null) {
            this.window.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    WindowHolder.this.windowIsClosing();
                }
            });
        }
        return this.window != null;
    }

    public JDialog getDialog() {
        this.windowOk();
        return this.dialog;
    }

    public JFrame getFrame() {
        this.windowOk();
        return this.frame;
    }

    public boolean isShowing() {
        if (!this.windowOk()) {
            return false;
        }
        return this.getWindow().isShowing();
    }

    public void removeAll() {
        if (this.dialog != null) {
            this.dialog.getContentPane().removeAll();
        }
        if (this.frame != null) {
            this.frame.getContentPane().removeAll();
        }
    }

    public void show() {
        this.show(false);
    }

    public void showModal() {
        this.show(true);
    }

    public void setWindowTitle(String title) {
        if (!this.windowOk()) {
            return;
        }
        if (this.dialog != null) {
            this.dialog.setTitle(title);
        }
        if (this.frame != null) {
            this.frame.setTitle(title);
        }
    }

    public void show(boolean modal) {
        if (!this.windowOk()) {
            return;
        }
        if (this.dialog != null) {
            this.dialog.setModal(modal);
            this.dialog.setVisible(true);
        }
        if (this.frame != null) {
            this.frame.setVisible(true);
        }
        if (this.window != null) {
            GuiUtils.showWidget(this.window);
        }
    }

    public void close() {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            if (this.dialog.isModal()) {
                this.dialog.setModal(false);
            }
        }
        if (this.frame != null) {
            this.frame.setVisible(false);
        }
    }

    protected String getWindowTitle() {
        return "";
    }

    protected JComponent doMakeContents() {
        return null;
    }

    protected JComponent getContents() {
        if (this.contents == null) {
            this.contents = this.doMakeContents();
        }
        return this.contents;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals(GuiUtils.CMD_CLOSE)) {
            this.close();
        }
    }
}

