/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Msg;
import ucar.unidata.util.TwoFacedObject;

public class TwoListPanel
extends JPanel
implements ActionListener {
    private static final String CMD_UP = "Up";
    private static final String CMD_DOWN = "Down";
    private static final String CMD_INSERT = "Insert";
    private static final String CMD_REMOVE = "Remove";
    private static final String CMD_RELOAD = "Reload Original";
    boolean changed = false;
    Hashtable seenEntries = new Hashtable();
    private JList toList = new JList();
    private Vector toEntries;
    private JList fromList = new JList();
    private Vector fromEntries = new Vector();
    private List originalFromEntries;
    private List originalToEntries;
    private boolean showUpDownButtons = true;

    public TwoListPanel(List fromEntries, String fromLabel, List toEntries, String toLabel, JComponent extraButtons) {
        this(fromEntries, fromLabel, toEntries, toLabel, extraButtons, true);
    }

    public TwoListPanel(List fromEntries, String fromLabel, List toEntries, String toLabel, JComponent extraButtons, boolean showUpDownButtons) {
        this.fromEntries = new Vector(fromEntries);
        this.toEntries = new Vector(toEntries);
        this.originalFromEntries = new ArrayList(fromEntries);
        this.originalToEntries = new ArrayList(toEntries);
        this.showUpDownButtons = showUpDownButtons;
        this.init(fromLabel, toLabel, extraButtons);
    }

    public boolean showDialog(String title, String windowLabel, List labels, List ids, Hashtable current) {
        JComponent contents = this.getContents(windowLabel, labels, ids, current);
        return GuiUtils.showOkCancelDialog(null, title, contents, null);
    }

    public JComponent getContents(String windowLabel, List labels, List ids, Hashtable current) {
        JPanel contents = GuiUtils.topCenter(new JLabel(windowLabel), this);
        ArrayList<TwoFacedObject> currentTfo = new ArrayList<TwoFacedObject>();
        ArrayList<TwoFacedObject> allTfo = new ArrayList<TwoFacedObject>();
        for (int i = 0; i < labels.size(); ++i) {
            String label = (String)labels.get(i);
            Object id = ids.get(i);
            allTfo.add(new TwoFacedObject((Object)label, id));
            if (current.get(id) == null) continue;
            currentTfo.add(new TwoFacedObject((Object)label, id));
        }
        if (currentTfo.size() == 0) {
            currentTfo = new ArrayList(allTfo);
        }
        this.reinitialize(allTfo, currentTfo);
        return contents;
    }

    public void reinitialize(List fromEntries, List toEntries) {
        this.fromEntries = new Vector(fromEntries);
        this.toEntries = new Vector(toEntries);
        this.originalFromEntries = new ArrayList(fromEntries);
        this.originalToEntries = new ArrayList(toEntries);
        this.reload();
    }

    public List getCurrentEntries() {
        return this.toEntries;
    }

    private void setList(JList jlist, Vector entries) {
        int toIdx = jlist.getSelectedIndex();
        jlist.setListData(entries);
        if (toIdx < 0) {
            if (jlist == this.fromList) {
                jlist.setSelectedIndex(0);
            } else {
                jlist.setSelectedIndex(entries.size() - 1);
            }
        } else if (toIdx < entries.size()) {
            jlist.setSelectedIndex(toIdx);
        } else {
            jlist.setSelectedIndex(entries.size() - 1);
        }
    }

    public void insertEntry(Object tfo) {
        this.changed = true;
        int toIdx = this.toList.getSelectedIndex();
        if (toIdx < 0) {
            this.toEntries.add(tfo);
        } else {
            this.toEntries.add(toIdx + 1, tfo);
        }
        this.setList(this.toList, this.toEntries);
        this.toList.setSelectedValue(tfo, true);
    }

    private void insertEntry() {
        Object[] objects = this.fromList.getSelectedValues();
        if (objects == null || objects.length == 0) {
            return;
        }
        for (int i = objects.length - 1; i >= 0; --i) {
            Object object = objects[i];
            this.seenEntries.put(object, object);
            this.insertEntry(object);
        }
        this.updateFromList();
    }

    private int getLastIndex(JList l) {
        int[] indices = l.getSelectedIndices();
        int idx = -1;
        for (int i = 0; i < indices.length; ++i) {
            if (i != 0 && indices[i] <= idx) continue;
            idx = indices[i];
        }
        return idx;
    }

    public JList getFromList() {
        return this.fromList;
    }

    public JList getToList() {
        return this.toList;
    }

    private int getFirstIndex(JList l) {
        int[] indices = l.getSelectedIndices();
        int idx = -1;
        for (int i = 0; i < indices.length; ++i) {
            if (i != 0 && indices[i] >= idx) continue;
            idx = indices[i];
        }
        return idx;
    }

    private void moveUp(boolean resetSelected) {
        this.changed = true;
        int toIdx = this.getFirstIndex(this.toList);
        if (toIdx <= 0) {
            return;
        }
        Object tmp = this.toEntries.remove(toIdx);
        this.toEntries.add(toIdx - 1, tmp);
        this.setList(this.toList, this.toEntries);
        if (resetSelected) {
            this.toList.setSelectedValue(this.toEntries.get(toIdx - 1), true);
        }
    }

    private void moveDown(boolean resetSelected) {
        this.changed = true;
        int toIdx = this.getLastIndex(this.toList);
        if (toIdx < 0) {
            return;
        }
        if (toIdx >= this.toEntries.size() - 1) {
            return;
        }
        Object tmp = this.toEntries.remove(toIdx);
        this.toEntries.add(toIdx + 1, tmp);
        this.setList(this.toList, this.toEntries);
        if (resetSelected) {
            this.toList.setSelectedValue(this.toEntries.get(toIdx + 1), true);
        }
    }

    private void removeEntry() {
        this.changed = true;
        Object[] objects = this.toList.getSelectedValues();
        if (objects == null || objects.length == 0) {
            return;
        }
        for (int i = 0; i < objects.length; ++i) {
            this.seenEntries.remove(objects[i]);
            this.toEntries.remove(objects[i]);
        }
        this.setList(this.toList, this.toEntries);
        this.updateFromList();
    }

    private void updateFromList() {
        this.fromEntries.clear();
        for (int i = 0; i < this.originalFromEntries.size(); ++i) {
            Object entry = this.originalFromEntries.get(i);
            if (this.seenEntries.get(entry) != null) continue;
            this.fromEntries.add(entry);
        }
        this.setList(this.fromList, this.fromEntries);
    }

    public void reload() {
        this.changed = false;
        this.seenEntries = new Hashtable();
        this.toEntries = new Vector();
        for (int i = 0; i < this.originalToEntries.size(); ++i) {
            Object o = this.originalToEntries.get(i);
            this.seenEntries.put(o, o);
            this.toEntries.add(o);
        }
        this.updateFromList();
        this.setList(this.toList, this.toEntries);
    }

    private void init(String fromLabel, String toLabel, JComponent extra) {
        this.changed = false;
        this.reload();
        this.toList.setToolTipText("<html>Delete/Left arrow to remove <br>Right arrow to add</html>");
        this.fromList.setToolTipText("Right arrow to add");
        this.toList.setSelectionMode(2);
        this.fromList.setSelectionMode(2);
        this.fromList.setVisibleRowCount(15);
        this.toList.setVisibleRowCount(15);
        JButton removeButton = new JButton("<html>&lt;&nbsp;&nbsp;" + Msg.msg(CMD_REMOVE) + "</html>");
        JButton insertButton = new JButton("<html>" + Msg.msg("Add") + "&nbsp;&nbsp;&gt;</html>");
        insertButton.setActionCommand(CMD_INSERT);
        insertButton.addActionListener(this);
        removeButton.setActionCommand(CMD_REMOVE);
        removeButton.addActionListener(this);
        JButton upButton = GuiUtils.getImageButton("/auxdata/ui/icons/Up16.gif", this.getClass());
        upButton.setActionCommand(CMD_UP);
        upButton.addActionListener(this);
        JButton downButton = GuiUtils.getImageButton("/auxdata/ui/icons/Down16.gif", this.getClass());
        downButton.setActionCommand(CMD_DOWN);
        downButton.addActionListener(this);
        this.fromList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 39) {
                    TwoListPanel.this.insertEntry();
                }
            }
        });
        this.toList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (GuiUtils.isDeleteEvent(event) || event.getKeyCode() == 37) {
                    TwoListPanel.this.removeEntry();
                } else if (event.getKeyCode() == 38 && event.isShiftDown() || event.getKeyCode() != 40 || event.isShiftDown()) {
                    // empty if block
                }
            }
        });
        JPanel middlePanel = GuiUtils.inset((Component)GuiUtils.vbox(insertButton, removeButton, extra == null ? new JPanel() : extra), 10);
        int width = 200;
        int height = 400;
        JScrollPane fromSp = GuiUtils.makeScrollPane(this.fromList, width, height);
        fromSp.setPreferredSize(new Dimension(width, height));
        fromSp.setMinimumSize(new Dimension(width, height));
        JScrollPane toSp = GuiUtils.makeScrollPane(this.toList, width, height);
        toSp.setPreferredSize(new Dimension(width, height));
        toSp.setMinimumSize(new Dimension(width, height));
        JPanel mainPanel = GuiUtils.doLayout(new Component[]{GuiUtils.topCenter(GuiUtils.cLabel(fromLabel), fromSp), middlePanel, GuiUtils.topCenter(GuiUtils.cLabel(toLabel), toSp), GuiUtils.top(this.showUpDownButtons ? GuiUtils.vbox(upButton, downButton) : new JPanel())}, 4, GuiUtils.WT_YNYN, GuiUtils.WT_Y);
        mainPanel = GuiUtils.inset((Component)mainPanel, 5);
        this.setLayout(new BorderLayout());
        this.add("Center", mainPanel);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals(CMD_INSERT)) {
            this.insertEntry();
        } else if (cmd.equals(CMD_REMOVE)) {
            this.removeEntry();
        } else if (cmd.equals(CMD_UP)) {
            this.moveUp(true);
        } else if (cmd.equals(CMD_DOWN)) {
            this.moveDown(true);
        }
    }

    public boolean getChanged() {
        return this.changed;
    }
}

