/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;

public class TreePanel
extends JPanel
implements TreeSelectionListener {
    public static final String CATEGORY_DELIMITER = ">";
    private JTree tree;
    private JScrollPane treeView;
    private boolean useSplitPane = true;
    private int treeWidth = -1;
    private DefaultMutableTreeNode root;
    private DefaultTreeModel treeModel;
    private GuiUtils.CardLayoutPanel panel;
    private JPanel emptyPanel;
    private Hashtable<Object, JComponent> catComponents = new Hashtable();
    private Hashtable<Object, List<JComponent>> buttonsForCategory = new Hashtable();
    private Hashtable catToNode = new Hashtable();
    private Hashtable compToNode = new Hashtable();
    private boolean okToUpdateTree = true;

    public TreePanel() {
        this(true, -1);
    }

    public TreePanel(boolean useSplitPane, int treeWidth) {
        JComponent center;
        this.useSplitPane = useSplitPane;
        this.treeWidth = treeWidth;
        this.setLayout(new BorderLayout());
        this.root = new DefaultMutableTreeNode("");
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.treeModel);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        DefaultTreeCellRenderer renderer = this.doMakeTreeCellRenderer();
        renderer.setIcon(null);
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        this.tree.setCellRenderer(renderer);
        this.panel = new GuiUtils.CardLayoutPanel(){

            @Override
            public void show(Component comp) {
                super.show(comp);
                TreePanel.this.showPath(TreePanel.this.panel.getVisibleComponent());
            }
        };
        this.catToNode = new Hashtable();
        this.treeView = new JScrollPane(this.tree);
        if (treeWidth > 0) {
            this.treeView.setPreferredSize(new Dimension(treeWidth, 100));
        }
        if (useSplitPane) {
            double weight = 0.2;
            JSplitPane splitPane = treeWidth > 0 ? GuiUtils.hsplit(this.treeView, this.panel, treeWidth, weight) : GuiUtils.hsplit(this.treeView, this.panel, 150, weight);
            center = splitPane;
            splitPane.setOneTouchExpandable(true);
        } else {
            center = GuiUtils.leftCenter(this.treeView, this.panel);
        }
        this.add("Center", center);
        this.tree.addTreeSelectionListener(this);
    }

    public DefaultTreeCellRenderer doMakeTreeCellRenderer() {
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree theTree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(theTree, value, sel, expanded, leaf, row, hasFocus);
                if (!(value instanceof MyTreeNode)) {
                    return this;
                }
                MyTreeNode node = (MyTreeNode)value;
                if (node.icon != null) {
                    this.setIcon(node.icon);
                } else {
                    this.setIcon(null);
                }
                return this;
            }
        };
        return renderer;
    }

    public Component getVisibleComponent() {
        return this.panel.getVisibleComponent();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (!this.okToUpdateTree) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (node.isLeaf()) {
            TwoFacedObject tfo = (TwoFacedObject)node.getUserObject();
            this.panel.show((Component)tfo.getId());
        } else {
            if (this.emptyPanel == null && this.emptyPanel == null) {
                this.emptyPanel = new JPanel(new BorderLayout());
                this.panel.addCard(this.emptyPanel);
            }
            this.emptyPanel.removeAll();
            if (node.getUserObject() instanceof TwoFacedObject) {
                TwoFacedObject tfo = (TwoFacedObject)node.getUserObject();
                JComponent interior = this.catComponents.get(tfo.getId());
                if (interior != null) {
                    if (!this.panel.contains(interior)) {
                        this.panel.addCard(interior);
                    }
                    this.panel.show(interior);
                    return;
                }
                List<JComponent> buttons = this.buttonsForCategory.get(tfo.getId());
                if (buttons != null) {
                    this.emptyPanel.add(GuiUtils.top(GuiUtils.doLayout(new Component[]{GuiUtils.filler(50, 5), GuiUtils.vbox(buttons), GuiUtils.filler(50, 5)}, 3, GuiUtils.WT_Y, GuiUtils.WT_N)));
                    this.emptyPanel.invalidate();
                    this.emptyPanel.validate();
                    this.emptyPanel.repaint();
                }
            }
            this.panel.show(this.emptyPanel);
        }
    }

    public void setIcon(Component comp, ImageIcon icon) {
        MyTreeNode node = (MyTreeNode)this.compToNode.get(comp);
        if (node != null) {
            node.icon = icon;
            this.tree.repaint();
        }
    }

    public void addComponent(JComponent component, String category, String label, ImageIcon icon) {
        this.addComponent(component, category, label, icon, "");
    }

    public void addComponent(JComponent component, String category, String label, ImageIcon icon, Object object) {
        TwoFacedObject tfo = new TwoFacedObject((Object)label, component);
        MyTreeNode panelNode = new MyTreeNode(tfo, icon, object);
        this.compToNode.put(component, panelNode);
        if (category == null) {
            this.root.add(panelNode);
        } else {
            List<String> toks = StringUtil.split(category, CATEGORY_DELIMITER, true, true);
            String catSoFar = "";
            DefaultMutableTreeNode catNode = this.root;
            for (int i = 0; i < toks.size(); ++i) {
                String cat = toks.get(i);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.catToNode.get(catSoFar = catSoFar + CATEGORY_DELIMITER + cat);
                if (node == null) {
                    TwoFacedObject catTfo = new TwoFacedObject((Object)cat, catSoFar);
                    node = new DefaultMutableTreeNode(catTfo);
                    this.catToNode.put(catSoFar, node);
                    catNode.add(node);
                }
                catNode = node;
            }
            catNode.add(panelNode);
            List<JComponent> comps = this.buttonsForCategory.get(catSoFar);
            if (comps == null) {
                comps = new ArrayList<JComponent>();
                this.buttonsForCategory.put(catSoFar, comps);
            }
            if (toks.size() > 0) {
                comps.add(GuiUtils.makeButton(label, this, "show", component));
            }
        }
        this.panel.addCard(component);
        this.treeChanged();
    }

    private void treeChanged() {
        Hashtable stuff = GuiUtils.initializeExpandedPathsBeforeChange(this.tree, this.root);
        this.treeModel.nodeStructureChanged(this.root);
        GuiUtils.expandPathsAfterChange(this.tree, stuff, this.root);
    }

    public void addCategoryComponent(String cat, JComponent comp) {
        this.catComponents.put(CATEGORY_DELIMITER + cat, comp);
    }

    public void removeComponent(JComponent component) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.compToNode.get(component);
        if (node == null) {
            return;
        }
        this.compToNode.remove(component);
        if (node.getParent() != null) {
            node.removeFromParent();
        }
        this.panel.remove(component);
        this.treeChanged();
    }

    public void show(Component component) {
        this.panel.show(component);
    }

    public void showPath(Component component) {
        DefaultMutableTreeNode node;
        if (component != null && (node = (DefaultMutableTreeNode)this.compToNode.get(component)) != null) {
            TreePath path = new TreePath(this.treeModel.getPathToRoot(node));
            this.okToUpdateTree = false;
            this.tree.setSelectionPath(path);
            this.tree.expandPath(path);
            this.okToUpdateTree = true;
        }
    }

    public void openAll() {
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandPath(this.tree.getPathForRow(i));
        }
        this.showPath(this.panel.getVisibleComponent());
    }

    public void closeAll() {
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.collapsePath(this.tree.getPathForRow(i));
        }
        this.showPath(this.panel.getVisibleComponent());
    }

    public static class MyTreeNode
    extends DefaultMutableTreeNode {
        public ImageIcon icon;
        public Object object;

        public MyTreeNode(Object o, ImageIcon icon, Object object) {
            super(o);
            this.icon = icon;
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }
    }
}

