/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import ucar.unidata.ui.DateSelectionGui;
import ucar.unidata.util.DateSelection;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.DatedObject;
import ucar.unidata.util.DatedThing;
import ucar.unidata.util.LayoutUtil;
import ucar.unidata.util.MenuUtil;
import ucar.unidata.util.StringUtil;

public class Timeline
extends JPanel
implements MouseListener,
MouseMotionListener {
    public static String CMD_APPLY = "Apply";
    public static String CMD_CANCEL = "Cancel";
    public static String CMD_OK = "Ok";
    public static final Cursor CURSOR_NORMAL = Cursor.getPredefinedCursor(0);
    public static final Cursor CURSOR_MOVE = Cursor.getPredefinedCursor(12);
    public static final Cursor CURSOR_LEFT = Cursor.getPredefinedCursor(10);
    public static final Cursor CURSOR_RIGHT = Cursor.getPredefinedCursor(11);
    private static String FONT_FACE = "Monospaced";
    private static final Font FONT_MAIN = new Font(FONT_FACE, 1, 10);
    private static final Font FONT_AXIS_MINOR = new Font(FONT_FACE, 2, 10);
    private static final Font FONT_AXIS_MAJOR = new Font(FONT_FACE, 1, 10);
    private FieldPosition FP = new FieldPosition(0);
    private static final int DIM_SELECTION_BOX = 10;
    private static final int DIM_TIME_WIDTH = 4;
    public static final int DIM_TIME_HEIGHT = 10;
    private static final int DIM_INTERVAL_HEIGHT = 15;
    private static final Stroke STROKE_DASHED_ONEPIXEL = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f, 1.0f}, 0.0f);
    private static final Stroke STROKE_DASHED_TWOPIXEL = new BasicStroke(2.0f, 0, 2, 0.0f, new float[]{1.0f, 1.0f}, 0.0f);
    private static final Stroke STROKE_SOLID_ONEPIXEL = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{Float.MAX_VALUE}, 0.0f);
    private static final Stroke STROKE_SOLID_TWOPIXEL = new BasicStroke(2.0f, 0, 2, 0.0f, new float[]{Float.MAX_VALUE}, 0.0f);
    private static final Color COLOR_BACKGROUND = Color.white;
    private static final Color COLOR_BACKGROUND_DISABLED = new Color(230, 230, 230);
    private static final Color COLOR_LINE = Color.black;
    private static final Color COLOR_RANGE = Color.black;
    private static final Color COLOR_RANGE_DART = Color.gray;
    private static final Color COLOR_HIGHLIGHT_SELECTION = Color.cyan.darker();
    private static final Color COLOR_HIGHLIGHT_DATE = Color.cyan;
    private static final Color COLOR_TIME_SELECTED = Color.red;
    private static final Color COLOR_TIME_UNSELECTED = Color.blue;
    private static final Color COLOR_INTERVAL_FILL = new Color(237, 237, 237);
    private static final Color COLOR_INTERVAL_LINE = COLOR_INTERVAL_FILL.darker();
    private static final Color COLOR_AXIS_MINOR = Color.gray;
    private static final Color COLOR_AXIS_MAJOR = Color.black;
    private static final int PICK_THRESHOLD = 10;
    public static final int DRAGMODE_LEFT = 0;
    public static final int DRAGMODE_RIGHT = 1;
    public static final int DRAGMODE_CENTER = 2;
    private static AxisFormat[] FORMATS = new AxisFormat[]{new AxisFormat(100L, "ss:SS", new AxisFormat(14, 500, "mm:ss:SS")), new AxisFormat(500L, "ss:SS", new AxisFormat(13, 2, "mm:ss:SS")), new AxisFormat(1000L, "ss", new AxisFormat(13, 10, "HH:mm:ss")), new AxisFormat(5000L, "ss", new AxisFormat(13, 30, "HH:mm:ss")), new AxisFormat(15000L, "ss", new AxisFormat(12, 1, "HH:mm:ss")), new AxisFormat(30000L, "ss", new AxisFormat(12, 2, "HH:mm:ss")), new AxisFormat(60000L, "mm", new AxisFormat(12, 5, "dd/HH:mm")), new AxisFormat(300000L, "mm", new AxisFormat(12, 30, "dd/HH:mm")), new AxisFormat(600000L, "m", new AxisFormat(12, 60, "dd/HH:mm")), new AxisFormat(900000L, "mm", new AxisFormat(10, 1, "dd/HH:mm")), new AxisFormat(1800000L, "mm", new AxisFormat(10, 2, "dd/HH")), new AxisFormat(3600000L, "HH:mm", new AxisFormat(10, 3, "dd/HH")), new AxisFormat(0x6DDD00L, "HH:mm", new AxisFormat(10, 6, "dd/HH")), new AxisFormat(10800000L, "HH:mm", new AxisFormat(10, 6, "dd/HH")), new AxisFormat(14400000L, "HH:mm", new AxisFormat(10, 6, "dd/HH")), new AxisFormat(18000000L, "HH:mm", new AxisFormat(10, 12, "dd/HH")), new AxisFormat(21600000L, "HH:mm", new AxisFormat(10, 12, "dd/HH")), new AxisFormat(43200000L, "HH:mm", new AxisFormat(5, 1, "dd/HH")), new AxisFormat(86400000L, "dd", new AxisFormat(5, 1, "dd/HH")), new AxisFormat(172800000L, "dd", new AxisFormat(5, 7, "MM-dd")), new AxisFormat(259200000L, "dd", new AxisFormat(5, 14, "MM-dd")), new AxisFormat(345600000L, "dd", new AxisFormat(5, 14, "MM-dd")), new AxisFormat(432000000L, "dd", new AxisFormat(5, 14, "MM-dd")), new AxisFormat(518400000L, "dd", new AxisFormat(5, 30, "MM-dd")), new AxisFormat(604800000L, "MM-dd", new AxisFormat(5, 30, "MM-dd")), new AxisFormat(2592000000L, "MM-dd", new AxisFormat(2, 4, "yyyy-MM")), new AxisFormat(15552000000L, "MM-dd", new AxisFormat(1, 2, "yyyy")), new AxisFormat(31536000000L, "yyyy-MM"), new AxisFormat(157680000000L, "yyyy"), new AxisFormat(315360000000L, "yyyy"), new AxisFormat(3153600000000L, "yyyy"), new AxisFormat(31536000000000L, "yyyy"), new AxisFormat(315360000000000L, "yyyy"), new AxisFormat(3153600000000000L, "yyyy"), new AxisFormat(31536000000000000L, "yyyy"), new AxisFormat(315360000000000000L, "yyyy"), new AxisFormat(3153600000000000000L, "yyyy")};
    private boolean isCapableOfSelection = true;
    private boolean justShowSelected = false;
    private boolean doingDragSelect = false;
    private Date dragStartDate;
    private Date dragEndDate;
    private MouseEvent dragStartEvent;
    private boolean draggingDateSelection = false;
    private Rectangle selectionBox;
    private int dragMode;
    private long initDragDeltaStart;
    private long initDragDeltaEnd;
    private JCheckBox useDateSelectionCbx;
    private JCheckBox showIntervalsCbx;
    private JCheckBox stickyCbx;
    private DateSelectionGui dateSelectionGui;
    private JDialog propertiesDialog;
    private JDialog dialog;
    private boolean dialogOK = false;
    private DateSelection dateSelection = new DateSelection();
    private boolean useDateSelection = true;
    private DateSelection originalDateSelection;
    private boolean paintIntervals = true;
    private static TimeZone defaultTimeZone;
    private static String defaultFormat;
    private int horizontalPadding = 0;
    private int verticalPadding = 0;
    private Date startDate;
    private Date endDate;
    private Date originalStartDate;
    private Date originalEndDate;
    private List datedThings;
    private DatedThing lastSelectedThing;
    private List selected = new ArrayList();
    private DatedThing mouseHighlighted;
    private JComponent contents;
    private boolean showIntervals = true;
    private boolean sticky = false;
    protected List sunriseDates = new ArrayList();
    private List timelineGroup;
    private boolean shortDisplay = false;
    private Color colorTimeSelected = COLOR_TIME_SELECTED;
    private Color colorTimeUnselected = COLOR_TIME_UNSELECTED;
    private Hashtable selectedMap = new Hashtable();

    public Timeline() {
        this(new Date(System.currentTimeMillis() - 86400000L), new Date(System.currentTimeMillis()));
    }

    public Timeline(List times, int initDimension) {
        this(times, initDimension, 100);
    }

    public Timeline(List times, int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
        this.setDatedThings(times, true);
        this.initGui();
    }

    public Timeline(Date start, Date end) {
        this(start, end, 600);
    }

    public Timeline(Date start, Date end, int initDimension) {
        this.setPreferredSize(new Dimension(initDimension, 100));
        this.init(start, end);
        this.initGui();
    }

    public static TimeZone getTimeZone() {
        if (defaultTimeZone == null) {
            defaultTimeZone = TimeZone.getTimeZone("GMT");
        }
        return defaultTimeZone;
    }

    public static void setDateFormat(String format) {
        defaultFormat = format;
    }

    public static void setTimeZone(TimeZone tz) {
        defaultTimeZone = tz;
    }

    protected void initGui() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                boolean doDateSelection;
                double smallStep = 0.05;
                double bigStep = 0.5;
                boolean bl = doDateSelection = e.isControlDown() && Timeline.this.dateSelectionActive();
                if (e.getKeyCode() == 39) {
                    Timeline.this.shiftByPercent(e.isShiftDown() ? bigStep : smallStep, doDateSelection);
                } else if (e.getKeyCode() == 37) {
                    Timeline.this.shiftByPercent(e.isShiftDown() ? -bigStep : -smallStep, doDateSelection);
                } else if (e.getKeyCode() == 38) {
                    Timeline.this.expandByPercent(e.isShiftDown() ? 0.5 : 0.9, doDateSelection);
                } else if (e.getKeyCode() == 40) {
                    Timeline.this.expandByPercent(e.isShiftDown() ? 1.5 : 1.1, doDateSelection);
                } else if (e.getKeyCode() == 82) {
                    Timeline.this.reset(e.isControlDown());
                } else if (e.getKeyCode() == 80 && e.isControlDown()) {
                    Timeline.this.showProperties();
                } else if (!Timeline.this.dateSelectionActive() && Timeline.this.isCapableOfSelection && e.getKeyCode() == 65 && e.isControlDown()) {
                    Timeline.this.setSelected(new ArrayList(Timeline.this.datedThings));
                    Timeline.this.repaint();
                }
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent event) {
                boolean doDateSelection = event.isControlDown() && Timeline.this.dateSelectionActive();
                int notches = event.getWheelRotation();
                if (notches < 0) {
                    Timeline.this.expandByPercent(event.isShiftDown() ? 0.5 : 0.9, doDateSelection);
                } else {
                    Timeline.this.expandByPercent(event.isShiftDown() ? 1.5 : 1.1, doDateSelection);
                }
            }
        });
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setToolTipText("");
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        if (this.startDate == null || this.endDate == null) {
            return;
        }
        DatedThing closest = this.findClosest(new Point(me.getX(), me.getY()));
        boolean changed = closest != this.mouseHighlighted;
        this.setHighlightedDate(closest);
        this.setCursor(CURSOR_NORMAL);
        if (this.selectionBox != null && this.dateSelectionActive()) {
            Rectangle r = new Rectangle(this.selectionBox);
            r.grow(10, 10);
            if (r.contains(new Point(me.getX(), me.getY()))) {
                double d1 = Math.abs(this.selectionBox.getX() - (double)me.getX());
                double d2 = Math.abs(this.selectionBox.getX() + this.selectionBox.getWidth() - (double)me.getX());
                if (d1 > 10.0 && d2 > 10.0) {
                    this.setCursor(CURSOR_MOVE);
                } else if (d1 < d2) {
                    this.setCursor(CURSOR_LEFT);
                } else {
                    this.setCursor(CURSOR_RIGHT);
                }
            }
        }
        if (changed) {
            this.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.startDate == null || this.endDate == null) {
            return;
        }
        if (SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        if (this.doingDragSelect) {
            if (e.isShiftDown()) {
                this.dragEndDate = this.toDate(e.getX());
                int w = this.getWidth();
                int x = e.getX();
                if (x > w) {
                    this.shiftByPercent(1.2 * (double)(x - w) / (double)w, false);
                } else if (x < 0) {
                    this.shiftByPercent(1.2 * (double)x / (double)w, false);
                }
                this.setSelected(DatedObject.select(this.dragStartDate, this.dragEndDate, this.datedThings));
                this.repaint();
                return;
            }
            this.doingDragSelect = false;
        }
        int mouseLoc = e.getX();
        int left = this.toLocation(this.startDate.getTime());
        int right = this.toLocation(this.endDate.getTime());
        int delta = mouseLoc - this.dragStartEvent.getX();
        double percent = (double)delta / ((double)right - (double)left);
        if (this.draggingDateSelection) {
            Date d = this.toDate(mouseLoc);
            long newTime = d.getTime();
            double d1 = Math.abs(this.selectionBox.getX() - (double)mouseLoc);
            double d2 = Math.abs(this.selectionBox.getX() + this.selectionBox.getWidth() - (double)mouseLoc);
            if (this.dragMode == 2) {
                this.dateSelection.setStartFixedTime(newTime + this.initDragDeltaStart);
                this.dateSelection.setEndFixedTime(newTime + this.initDragDeltaEnd);
            } else {
                if (this.dragMode == 0 && (double)mouseLoc >= this.selectionBox.getX() + this.selectionBox.getWidth()) {
                    this.dragMode = 1;
                } else if (this.dragMode == 1 && (double)mouseLoc <= this.selectionBox.getX()) {
                    this.dragMode = 0;
                }
                if (this.dragMode == 0) {
                    this.dateSelection.setStartFixedTime(newTime);
                } else {
                    this.dateSelection.setEndFixedTime(newTime);
                }
            }
            if (mouseLoc < 0) {
                long diff = this.startDate.getTime() - d.getTime();
                this.startDate = d;
                this.endDate = new Date(this.endDate.getTime() - diff);
                this.timelineChanged();
            } else if (mouseLoc > this.getBounds().width) {
                long diff = d.getTime() - this.endDate.getTime();
                this.endDate = d;
                this.startDate = new Date(this.startDate.getTime() + diff);
                this.timelineChanged();
            }
            this.dateSelectionChanged();
        } else {
            this.shiftByPercent(-percent, false);
        }
        this.dragStartEvent = e;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.mouseHighlighted != null) {
            this.setHighlightedDate(null);
            this.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        DatedThing closest;
        if (this.startDate == null || this.endDate == null) {
            return;
        }
        if (e.getClickCount() > 1) {
            return;
        }
        if (SwingUtilities.isRightMouseButton(e)) {
            this.showPopupMenu(e.getX(), e.getY());
            return;
        }
        if (this.dateSelectionActive()) {
            // empty if block
        }
        if (!this.isCapableOfSelection) {
            return;
        }
        if (!e.isShiftDown() && !e.isControlDown()) {
            this.setSelected(new ArrayList());
        }
        if ((closest = this.findClosest(new Point(e.getX(), e.getY()))) != null) {
            if (e.isShiftDown() && this.lastSelectedThing != null) {
                long t2;
                long t1 = this.lastSelectedThing.getDate().getTime();
                if (t1 > (t2 = closest.getDate().getTime())) {
                    long tmp = t1;
                    t1 = t2;
                    t2 = tmp;
                }
                for (int i = 0; i < this.datedThings.size(); ++i) {
                    DatedThing datedThing = (DatedThing)this.datedThings.get(i);
                    long time = datedThing.getDate().getTime();
                    if (time < t1 || time > t2 || this.selected.contains(datedThing)) continue;
                    this.selected.add(datedThing);
                    this.selectedDatesChanged();
                }
            } else {
                if (this.selected.contains(closest)) {
                    this.selected.remove(closest);
                } else {
                    this.selected.add(closest);
                }
                this.selectedDatesChanged();
            }
        }
        this.lastSelectedThing = closest;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.startDate == null || this.endDate == null) {
            return;
        }
        this.requestFocus();
        if (SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        this.draggingDateSelection = false;
        this.dragStartEvent = e;
        this.doingDragSelect = false;
        if (this.isCapableOfSelection && !this.dateSelectionActive() && e.isShiftDown()) {
            this.doingDragSelect = true;
            this.dragStartDate = this.dragEndDate = this.toDate(e.getX());
            this.setSelected(new ArrayList());
            this.repaint();
            return;
        }
        if (!this.dateSelectionActive()) {
            // empty if block
        }
        if (this.selectionBox == null) {
            return;
        }
        Rectangle r = new Rectangle(this.selectionBox);
        r.grow(10, 10);
        if (r.contains(new Point(e.getX(), e.getY()))) {
            this.draggingDateSelection = true;
            double d1 = Math.abs(this.selectionBox.getX() - (double)e.getX());
            double d2 = Math.abs(this.selectionBox.getX() + this.selectionBox.getWidth() - (double)e.getX());
            this.dragMode = d1 > 10.0 && d2 > 10.0 ? 2 : (d1 < d2 ? 0 : 1);
            long time = this.toDate(e.getX()).getTime();
            this.initDragDeltaStart = this.dateSelection.getStartFixedTime() - time;
            this.initDragDeltaEnd = this.dateSelection.getEndFixedTime() - time;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.setCursor(CURSOR_NORMAL);
        this.dragStartEvent = null;
        this.dragStartDate = null;
        this.dragEndDate = null;
        this.doingDragSelect = false;
        if (this.startDate == null || this.endDate == null) {
            return;
        }
        this.draggingDateSelection = false;
        this.repaint();
    }

    public void setDateSelection(DateSelection dateSelection) {
        this.dateSelection = dateSelection;
        this.originalDateSelection = new DateSelection(dateSelection);
        this.dateSelectionChanged();
    }

    public DateSelection getDateSelection() {
        return this.dateSelection;
    }

    public List getDatedThings() {
        return this.datedThings;
    }

    public void setSelected(List l) {
        this.selected = l == null ? new ArrayList() : new ArrayList(l);
        this.selectedDatesChanged();
        this.repaint();
    }

    public void selectedDatesChanged() {
        this.selectedMap = new Hashtable();
        if (this.datedThings == null || this.selected == null) {
            return;
        }
        for (int i = 0; i < this.selected.size(); ++i) {
            DatedThing datedThing = (DatedThing)this.selected.get(i);
            this.selectedMap.put(datedThing, datedThing);
        }
    }

    public List getSelected() {
        return new ArrayList(this.selected);
    }

    protected void init(Date start, Date end) {
        this.startDate = start;
        this.endDate = end;
        this.originalStartDate = start;
        this.originalEndDate = end;
    }

    protected void showPopupMenu(int x, int y) {
        ArrayList items = new ArrayList();
        this.getMenuItems(items);
        JPopupMenu popup = MenuUtil.makePopupMenu(items);
        popup.show(this, x, y);
    }

    public void resetDateRange() {
        this.reset(false);
    }

    public void resetDateSelection() {
        this.reset(true);
    }

    public void setDateSelection(Date[] r) {
        this.dateSelection.setStartFixedTime(r[0]);
        this.dateSelection.setEndFixedTime(r[1]);
        this.startDate = r[0];
        this.endDate = r[1];
        this.dateSelectionChanged();
        this.expandByPercent(1.1, false);
    }

    public void setVisibleRange(Date[] r) {
        this.startDate = r[0];
        this.endDate = r[1];
        this.expandByPercent(1.1, false);
    }

    protected void getMenuItems(List items) {
        int i;
        JMenuItem mi = MenuUtil.makeMenuItem("Properties", this, "showProperties");
        items.add(mi);
        ArrayList<JMenuItem> subItems = new ArrayList<JMenuItem>();
        long now = System.currentTimeMillis();
        Calendar cal = Calendar.getInstance(Timeline.getTimeZone());
        cal.setTimeInMillis(now);
        cal.clear(14);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(10, 0);
        cal.add(6, 1);
        now = cal.getTimeInMillis();
        subItems.add(MenuUtil.makeMenuItem("Reset", this, "resetDateRange"));
        subItems.add(MenuUtil.makeMenuItem("Today", this, "setVisibleRange", new Date[]{new Date(now - DateUtil.daysToMillis(1.0)), new Date(now)}));
        subItems.add(MenuUtil.makeMenuItem("Past Week", this, "setVisibleRange", new Date[]{new Date(now - DateUtil.daysToMillis(7.0)), new Date(now)}));
        subItems.add(MenuUtil.makeMenuItem("Past Month", this, "setVisibleRange", new Date[]{new Date(now - DateUtil.daysToMillis(30.0)), new Date(now)}));
        subItems.add(MenuUtil.makeMenuItem("Past Year", this, "setVisibleRange", new Date[]{new Date(now - DateUtil.daysToMillis(365.0)), new Date(now)}));
        if (this.dateSelectionActive()) {
            subItems.add(MenuUtil.makeMenuItem("Selection Range", this, "setVisibleRange", new Date[]{this.dateSelection.getStartFixedDate(), this.dateSelection.getEndFixedDate()}));
        }
        items.add(MenuUtil.makeMenu("Set Visible Range", subItems));
        if (this.dateSelectionActive()) {
            subItems = new ArrayList();
            subItems.add(MenuUtil.makeMenuItem("View", this, "setVisibleRange", new Date[]{this.dateSelection.getStartFixedDate(), this.dateSelection.getEndFixedDate()}));
            subItems.add(MenuUtil.makeMenuItem("Reset", this, "resetDateSelection"));
            subItems.add(MenuUtil.makeMenuItem("Today", this, "setDateSelection", new Date[]{new Date(now - DateUtil.daysToMillis(1.0)), new Date(now)}));
            subItems.add(MenuUtil.makeMenuItem("Past Week", this, "setDateSelection", new Date[]{new Date(now - DateUtil.daysToMillis(7.0)), new Date(now)}));
            subItems.add(MenuUtil.makeMenuItem("Past Month", this, "setDateSelection", new Date[]{new Date(now - DateUtil.daysToMillis(30.0)), new Date(now)}));
            items.add(MenuUtil.makeMenu("Set Date Selection", subItems));
        }
        if (this.isCapableOfSelection) {
            items.add(MenuUtil.makeCheckboxMenuItem("Use Date Selection", this, "useDateSelection", null));
        }
        if (!this.dateSelectionActive()) {
            return;
        }
        items.add(MenuUtil.makeCheckboxMenuItem("Use Visible Range", this, "sticky", null));
        mi.setToolTipText("Make the selection range be the visible range");
        double[] intervals = new double[]{Double.NaN, 0.0, DateUtil.minutesToMillis(5.0), DateUtil.minutesToMillis(10.0), DateUtil.minutesToMillis(15.0), DateUtil.minutesToMillis(30.0), DateUtil.hoursToMillis(1.0), DateUtil.hoursToMillis(2.0), DateUtil.hoursToMillis(3.0), DateUtil.hoursToMillis(4.0), DateUtil.hoursToMillis(5.0), DateUtil.hoursToMillis(6.0), DateUtil.hoursToMillis(12.0), DateUtil.daysToMillis(1.0), DateUtil.daysToMillis(2.0), DateUtil.daysToMillis(7.0)};
        String[] intervalNames = new String[]{"Default", "0 minutes", "5 minutes", "10 minutes", "15 minutes", "30 minutes", "1 hour", "2 hours", "3 hours", "4 hours", "5 hours", "6 hours", "12 hours", "1 day", "2 days", "7 days"};
        subItems = new ArrayList();
        double currentInterval = this.dateSelection.getInterval();
        for (int i2 = 0; i2 < intervals.length; ++i2) {
            if (intervals[i2] != intervals[i2]) continue;
            String lbl = intervalNames[i2];
            if (intervals[i2] == 0.0) {
                lbl = "None";
            }
            subItems.add(MenuUtil.makeMenuItem(intervals[i2] == currentInterval ? "-" + lbl + "-" : " " + lbl + " ", this, "setInterval", new Double(intervals[i2])));
        }
        items.add(MenuUtil.makeMenu("Interval", subItems));
        if (this.dateSelection.hasInterval()) {
            String lbl;
            boolean isCurrent;
            subItems = new ArrayList();
            double range = this.dateSelection.getPreRange();
            for (i = 0; i < intervals.length; ++i) {
                boolean bl = isCurrent = intervals[i] == range;
                if (range != range && intervals[i] != intervals[i]) {
                    isCurrent = true;
                }
                lbl = intervalNames[i];
                subItems.add(MenuUtil.makeMenuItem(isCurrent ? "-" + lbl + "-" : " " + lbl + " ", this, "setPreRange", new Double(intervals[i])));
            }
            items.add(MenuUtil.makeMenu("Before Range", subItems));
            subItems = new ArrayList();
            range = this.dateSelection.getPostRange();
            for (i = 0; i < intervals.length; ++i) {
                boolean bl = isCurrent = intervals[i] == range;
                if (range != range && intervals[i] != intervals[i]) {
                    isCurrent = true;
                }
                lbl = intervalNames[i];
                subItems.add(MenuUtil.makeMenuItem(isCurrent ? "-" + lbl + "-" : " " + lbl + " ", this, "setPostRange", new Double(intervals[i])));
            }
            items.add(MenuUtil.makeMenu("After Range", subItems));
        }
        subItems = new ArrayList();
        int currentSkip = this.dateSelection.getSkip();
        int[] skips = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 15, 20, 25, 30, 40, 50, 75, 100};
        for (i = 0; i < skips.length; ++i) {
            subItems.add(MenuUtil.makeMenuItem(skips[i] == currentSkip ? "-" + skips[i] + "-" : " " + skips[i] + " ", this, "setSkipFactor", new Integer(skips[i])));
        }
        items.add(MenuUtil.makeMenu("Skip Factor", subItems));
        subItems = new ArrayList();
        int[] counts = new int[]{Integer.MAX_VALUE, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 15, 20, 25, 30, 40, 50, 75, 100};
        int currentCount = this.dateSelection.getCount();
        for (int i3 = 0; i3 < counts.length; ++i3) {
            int cnt = counts[i3];
            String lbl = cnt == Integer.MAX_VALUE ? "All" : "" + cnt;
            subItems.add(MenuUtil.makeMenuItem(cnt == currentCount ? "-" + lbl + "-" : " " + lbl + " ", this, "setCount", new Integer(cnt)));
        }
        items.add(MenuUtil.makeMenu("Count", subItems));
    }

    public void removeIntervals() {
        this.dateSelection.setInterval(0.0);
        this.dateSelectionChanged();
    }

    public void setSkipFactor(Integer i) {
        this.dateSelection.setSkip(i);
        this.dateSelectionChanged();
    }

    public void setInterval(Double i) {
        this.dateSelection.setInterval(i);
        this.dateSelectionChanged();
    }

    public void setPreRange(Double i) {
        this.dateSelection.setPreRange(i);
        this.dateSelectionChanged();
    }

    public void setPostRange(Double i) {
        this.dateSelection.setPostRange(i);
        this.dateSelectionChanged();
    }

    public void setCount(Integer i) {
        this.dateSelection.setCount(i);
        this.dateSelectionChanged();
    }

    public void showProperties() {
        if (this.propertiesDialog == null) {
            this.useDateSelectionCbx = new JCheckBox("Use Date Selection:", this.useDateSelection);
            this.showIntervalsCbx = new JCheckBox("Show Intervals", this.showIntervals);
            this.stickyCbx = new JCheckBox("Use Visible Range", this.sticky);
            this.dateSelectionGui = new DateSelectionGui(this.dateSelection);
            JPanel timeRangePanel = new JPanel();
            JPanel flagsPanel = LayoutUtil.hbox(this.stickyCbx, this.showIntervalsCbx);
            JPanel contents = this.isCapableOfSelection ? LayoutUtil.vbox(timeRangePanel, LayoutUtil.filler(10, 10), this.useDateSelectionCbx, LayoutUtil.inset((Component)this.dateSelectionGui, new Insets(0, 20, 0, 0))) : timeRangePanel;
            contents = LayoutUtil.inset((Component)contents, 5);
            this.propertiesDialog = new JDialog((Frame)null, "Date Selection", true);
            this.propertiesDialog.setLocation(new Point(200, 200));
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    String cmd = ae.getActionCommand();
                    if ((cmd.equals(CMD_APPLY) || cmd.equals(CMD_OK)) && !Timeline.this.applyProperties()) {
                        return;
                    }
                    if (cmd.equals(CMD_CANCEL) || cmd.equals(CMD_OK)) {
                        Timeline.this.propertiesDialog.setVisible(false);
                    }
                }
            };
            JPanel buttons = Timeline.makeButtons(listener, new String[]{CMD_APPLY, CMD_OK, CMD_CANCEL});
            this.propertiesDialog.getContentPane().add(LayoutUtil.inset((Component)LayoutUtil.centerBottom(contents, buttons), 5));
            this.propertiesDialog.pack();
        }
        this.dateSelectionGui.setDateSelection(this.dateSelection);
        this.propertiesDialog.setVisible(true);
    }

    public static JPanel makeButtons(ActionListener l, String[] labels) {
        return Timeline.makeButtons(l, labels, labels);
    }

    public static JPanel makeButtons(ActionListener listener, String[] labels, String[] cmds) {
        JPanel p = new JPanel();
        ArrayList<JButton> buttons = new ArrayList<JButton>();
        p.setLayout(new BoxLayout(p, 0));
        for (int i = 0; i < cmds.length; ++i) {
            String label;
            String cmd = cmds[i] != null ? cmds[i] : (labels != null ? labels[i] : "");
            String string = label = labels != null ? labels[i] : cmd;
            if (label == null) {
                label = cmd;
            }
            JButton button = new JButton(label);
            button.addActionListener(listener);
            button.setActionCommand(cmd);
            if (cmd.equals(CMD_OK)) {
                button.setDefaultCapable(true);
            }
            buttons.add(button);
        }
        return LayoutUtil.doLayout(p, LayoutUtil.getComponentArray(buttons), buttons.size(), LayoutUtil.WT_N, LayoutUtil.WT_N, null, null, new Insets(5, 5, 5, 5));
    }

    private boolean applyProperties() {
        if (this.isCapableOfSelection) {
            if (!this.dateSelectionGui.applyProperties()) {
                return false;
            }
            this.useDateSelection = this.useDateSelectionCbx.isSelected();
            this.showIntervals = this.showIntervalsCbx.isSelected();
            this.sticky = this.stickyCbx.isSelected();
        }
        this.timelineChanged();
        this.dateSelectionChanged();
        return true;
    }

    public void setSticky(boolean sticky) {
        this.sticky = sticky;
        this.timelineChanged();
    }

    public boolean getSticky() {
        return this.sticky;
    }

    protected boolean dateSelectionActive() {
        return this.isCapableOfSelection && this.dateSelection != null && this.useDateSelection;
    }

    public void setUseDateSelection(boolean value) {
        this.useDateSelection = value;
        if (this.useDateSelection) {
            this.dateSelectionChanged();
        }
        this.repaint();
    }

    public boolean getUseDateSelection() {
        return this.useDateSelection;
    }

    public void setShowIntervals(boolean value) {
        this.showIntervals = value;
        this.repaint();
    }

    public boolean getShowIntervals() {
        return this.showIntervals;
    }

    protected void dateSelectionChanged() {
        if (this.dateSelectionActive() && this.datedThings != null) {
            this.setSelected(this.dateSelection.apply(this.datedThings));
        }
        this.repaint();
    }

    private void rangeChanged(Timeline timeline) {
        this.startDate = timeline.startDate;
        this.endDate = timeline.endDate;
        this.setHighlightedDate(this.mouseHighlighted);
        this.repaint();
    }

    public void timelineChanged() {
        if (this.dateSelectionActive() && this.getSticky()) {
            this.dateSelection.setStartFixedTime(this.startDate);
            this.dateSelection.setEndFixedTime(this.endDate);
            this.dateSelectionChanged();
        }
        if (this.timelineGroup != null) {
            for (int i = 0; i < this.timelineGroup.size(); ++i) {
                Timeline timeline = (Timeline)this.timelineGroup.get(i);
                if (timeline == this) continue;
                timeline.rangeChanged(this);
            }
        }
        this.makeSunriseDates();
        this.setHighlightedDate(null);
        this.repaint();
    }

    public void makeSunriseDates() {
    }

    public void selectDaytime() {
        long time;
        Date date;
        DatedThing datedThing;
        if (this.datedThings == null) {
            return;
        }
        ArrayList<DatedThing> selected = new ArrayList<DatedThing>();
        ArrayList<DatedThing> visibleDates = new ArrayList<DatedThing>();
        long start = this.startDate.getTime();
        long end = this.endDate.getTime();
        for (int i = 0; i < this.datedThings.size(); ++i) {
            datedThing = (DatedThing)this.datedThings.get(i);
            date = datedThing.getDate();
            time = date.getTime();
            if (time < start || time > end) continue;
            visibleDates.add(datedThing);
        }
        block1: for (int datedThingIdx = 0; datedThingIdx < visibleDates.size(); ++datedThingIdx) {
            datedThing = (DatedThing)visibleDates.get(datedThingIdx);
            date = datedThing.getDate();
            time = date.getTime();
            for (int i = 0; i < this.sunriseDates.size(); i += 2) {
                Date d1 = (Date)this.sunriseDates.get(i);
                Date d2 = (Date)this.sunriseDates.get(i + 1);
                if (time < d1.getTime() || time > d2.getTime()) continue;
                selected.add(datedThing);
                continue block1;
            }
        }
        this.setSelected(selected);
    }

    protected DatedThing findClosest(Point p) {
        return this.findClosest(p, 10);
    }

    protected DatedThing findClosest(Point p, int minimumDistance) {
        if (p == null) {
            return null;
        }
        Dimension dim = this.getSize();
        int middle = this.getBaseLine();
        if (p.y > middle + 10) {
            return null;
        }
        if (p.y < middle - 10) {
            return null;
        }
        if (this.datedThings == null) {
            return null;
        }
        DatedThing closest = null;
        double minDistance = minimumDistance;
        for (int i = 0; i < this.datedThings.size(); ++i) {
            DatedThing datedThing = (DatedThing)this.datedThings.get(i);
            int location = this.toLocation(datedThing.getDate());
            double distance = Math.abs(p.getX() - (double)location);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            closest = datedThing;
        }
        return closest;
    }

    @Override
    public Point getToolTipLocation(MouseEvent e) {
        int height = this.getBounds().height;
        return new Point(e.getX(), height);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        String tmp;
        if (this.startDate == null || this.endDate == null) {
            return null;
        }
        Date dttm = this.mouseHighlighted != null ? this.mouseHighlighted.getDate() : this.toDate(event.getX());
        SimpleDateFormat sdf = new SimpleDateFormat(defaultFormat);
        sdf.setTimeZone(Timeline.getTimeZone());
        String tt = sdf.format(dttm.getTime(), new StringBuffer(), this.FP).toString() + "<br>";
        if (this.mouseHighlighted != null && (tmp = this.mouseHighlighted.toString()) != null && tmp.length() > 0) {
            tt = tt + tmp + "<br>";
        }
        tt = tt + "Control-P to show properties;<br>Arrow keys to shift/zoom;<br>";
        if (this.dateSelectionActive()) {
            tt = tt + "Use Control-Arrow to change selection;";
        } else if (this.isCapableOfSelection) {
            tt = tt + "Click to select; Control or Shift Click to select multiples; Shift-drag to select;";
        }
        return "<html>" + tt + "</html>";
    }

    public JComponent getContents(boolean withButtons) {
        return this.getContents(withButtons, true);
    }

    public JComponent getContents(boolean withButtons, boolean withBorder) {
        if (this.contents == null) {
            this.doMakeContents(withButtons, withBorder);
        }
        return this.contents;
    }

    protected void doMakeContents(boolean withButtons) {
        this.doMakeContents(withButtons, true);
    }

    protected void doMakeContents(boolean withButtons, boolean withBorder) {
        JPanel thisContainer = LayoutUtil.inset((Component)this, 0);
        if (withBorder) {
            thisContainer.setBorder(BorderFactory.createBevelBorder(1));
        }
        if (!withButtons) {
            this.contents = thisContainer;
            return;
        }
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String cmd = ae.getActionCommand();
                Timeline.this.dialogOK = cmd.equals(CMD_OK);
                if (Timeline.this.dialog != null) {
                    Timeline.this.dialog.setVisible(false);
                }
            }
        };
        JPanel bottom = Timeline.makeButtons(listener, new String[]{CMD_OK, CMD_CANCEL});
        this.contents = LayoutUtil.centerBottom(thisContainer, bottom);
    }

    protected void paintDateSelection(Graphics2D g, DateSelection dateSelection) {
        Dimension dim = this.getSize();
        int width = (int)dim.getWidth();
        int height = (int)dim.getHeight();
        int top = 0 + this.verticalPadding;
        int bottom = height - this.verticalPadding * 2;
        int middle = top + (bottom - top) / 2;
        Date[] range = dateSelection.getRange();
        int left = this.toLocation(range[0]);
        int right = this.toLocation(range[1]);
        if (dateSelection.hasInterval() && Math.abs(right - left) > 5) {
            this.paintIntervals(g);
        }
        this.selectionBox = new Rectangle(left, middle - 10, right - left, 20);
        g.setStroke(STROKE_SOLID_TWOPIXEL);
        if (this.draggingDateSelection) {
            g.setColor(COLOR_HIGHLIGHT_SELECTION);
        } else {
            g.setColor(COLOR_LINE);
        }
        g.drawPolyline(new int[]{this.selectionBox.x, this.selectionBox.x, this.selectionBox.x + this.selectionBox.width, this.selectionBox.x + this.selectionBox.width, this.selectionBox.x}, new int[]{this.selectionBox.y + this.selectionBox.height, this.selectionBox.y, this.selectionBox.y, this.selectionBox.y + this.selectionBox.height, this.selectionBox.y + this.selectionBox.height}, 5);
        FontMetrics fm = g.getFontMetrics();
        String s1 = this.format(range[0]);
        String s2 = this.format(range[1]);
        int w1 = fm.stringWidth(s1);
        int w2 = fm.stringWidth(s2);
        int x1 = this.selectionBox.x;
        int x2 = this.selectionBox.x + this.selectionBox.width - w2;
        int y1 = this.selectionBox.y - 2;
        int y2 = this.selectionBox.y - 2;
        if (this.draggingDateSelection) {
            if (x1 + w1 >= x2) {
                g.drawLine(this.selectionBox.x + this.selectionBox.width, y1 + 2, this.selectionBox.x + this.selectionBox.width, y2 -= fm.getHeight());
            }
            g.setStroke(STROKE_SOLID_ONEPIXEL);
            g.drawString(s1, x1, y1);
            g.drawString(s2, x2, y2);
        }
    }

    protected void paintIntervals(Graphics2D g) {
        if (!this.paintIntervals || !this.showIntervals) {
            return;
        }
        double[] ticks = this.dateSelection.getIntervalTicks();
        if (ticks == null) {
            return;
        }
        long start = this.startDate.getTime();
        long end = this.endDate.getTime();
        Date[] range = this.dateSelection.getRange();
        long intervalStart = range[0].getTime();
        long intervalEnd = range[1].getTime();
        Dimension dim = this.getSize();
        int width = (int)dim.getWidth();
        int height = (int)dim.getHeight();
        int top = 0 + this.verticalPadding;
        int bottom = height - this.verticalPadding * 2;
        int middle = top + (bottom - top) / 2;
        int left = 0 + this.horizontalPadding;
        int right = width - this.horizontalPadding;
        int[] xs = new int[5];
        int[] ys = new int[5];
        for (int i = 0; i < ticks.length; ++i) {
            int y;
            g.setStroke(STROKE_SOLID_ONEPIXEL);
            long time = (long)ticks[i];
            int location = this.toLocation(time);
            int leftRange = this.toLocation((long)((double)time - this.dateSelection.getPreRangeToUse()));
            int rightRange = this.toLocation((long)((double)time + this.dateSelection.getPostRangeToUse()));
            if ((double)time + this.dateSelection.getPostRangeToUse() < (double)intervalStart || (double)time - this.dateSelection.getPreRangeToUse() > (double)intervalEnd) continue;
            xs[0] = leftRange;
            xs[1] = leftRange;
            xs[2] = location;
            xs[3] = rightRange;
            xs[4] = rightRange;
            ys[0] = y = middle - 10;
            ys[1] = y + (middle - y) / 2;
            ys[2] = middle;
            ys[3] = y + (middle - y) / 2;
            ys[4] = y;
            g.setColor(COLOR_INTERVAL_FILL);
            g.fillPolygon(xs, ys, 5);
            g.setColor(COLOR_INTERVAL_LINE);
            g.drawLine(leftRange, y, leftRange, y + (middle - y) / 2);
            g.drawLine(rightRange, y, rightRange, y + (middle - y) / 2);
            g.drawLine(location, y, location, middle);
        }
        g.setStroke(STROKE_SOLID_ONEPIXEL);
    }

    protected int getBaseLine() {
        if (this.shortDisplay) {
            return 10;
        }
        int height = (int)this.getSize().getHeight();
        int top = this.verticalPadding;
        int bottom = height - this.verticalPadding;
        return height / 2;
    }

    protected int getBottom() {
        int height = (int)this.getSize().getHeight();
        return height - this.verticalPadding;
    }

    protected int getLeft() {
        return this.horizontalPadding;
    }

    protected int getRight() {
        return (int)(this.getSize().getWidth() - (double)this.horizontalPadding);
    }

    protected void paintAxis(Graphics2D g) {
        int cnt;
        g.setFont(FONT_AXIS_MINOR);
        FontMetrics fm = g.getFontMetrics();
        long start = this.startDate.getTime();
        long leftTime = this.startDate.getTime();
        long end = this.endDate.getTime();
        int baseLine = this.getBaseLine();
        int minorY = baseLine + 10 + fm.getHeight();
        int left = this.getLeft();
        int right = this.getRight();
        int bottom = this.getBottom();
        Calendar cal = Calendar.getInstance(Timeline.getTimeZone());
        cal.setTimeInMillis(start);
        cal.clear(14);
        long range = end - start;
        int field2 = 2;
        int width = (int)this.getSize().getWidth();
        AxisFormat format = null;
        int maxTicks = width / 40;
        for (int i = 0; i < FORMATS.length; ++i) {
            format = FORMATS[i];
            if (format.step > 1000L) {
                cal.set(13, 0);
            }
            if (format.step > 60000L) {
                cal.set(12, 0);
            }
            if (format.step > 3600000L) {
                cal.set(10, 0);
            }
            if (format.step > 604800000L) {
                cal.set(5, 0);
            }
            if (format.step > 2592000000L) {
                cal.set(2, 0);
            }
            if (range / format.step <= (long)maxTicks) break;
        }
        SimpleDateFormat sdf = format.getSDF(Timeline.getTimeZone());
        g.setStroke(STROKE_DASHED_ONEPIXEL);
        g.setColor(COLOR_AXIS_MINOR);
        int majorValue = -1;
        start = cal.getTimeInMillis();
        int x = 0;
        int limit = 100;
        for (cnt = 0; x <= width && cnt < limit; ++cnt) {
            x = this.toLocation(start);
            if (x < 0) {
                start += format.step;
                continue;
            }
            String s = sdf.format(start, new StringBuffer(), this.FP).toString();
            g.drawLine(x, minorY, x, baseLine);
            int sw = fm.stringWidth(s);
            g.drawString(s, x + 2, minorY);
            start += format.step;
        }
        if (cnt >= limit) {
            return;
        }
        g.setFont(FONT_AXIS_MAJOR);
        fm = g.getFontMetrics();
        g.setColor(COLOR_AXIS_MAJOR);
        g.setStroke(STROKE_SOLID_ONEPIXEL);
        if (format.subFormat != null) {
            cal.set(14, 0);
            if (format.subFormat.field != 14) {
                cal.set(13, 0);
                if (format.subFormat.field != 13) {
                    cal.set(12, 0);
                    if (format.subFormat.field != 12) {
                        cal.set(10, 0);
                        cal.set(11, 0);
                        cal.set(5, 0);
                    }
                }
            }
            start = cal.getTimeInMillis();
            int y = baseLine + 10 + fm.getHeight() * 2;
            sdf = format.subFormat.getSDF(Timeline.getTimeZone());
            x = 0;
            while ((start = cal.getTimeInMillis()) < leftTime) {
                cal.add(format.subFormat.field, format.subFormat.offset);
            }
            while (x <= width) {
                x = this.toLocation(start);
                if (x < 0) {
                    cal.add(format.subFormat.field, format.subFormat.offset);
                    start = cal.getTimeInMillis();
                    continue;
                }
                String s = sdf.format(start, new StringBuffer(), this.FP).toString();
                if (s.startsWith("0")) {
                    s = " " + s.substring(1);
                }
                g.drawLine(x, minorY + 4, x, baseLine);
                int sw = fm.stringWidth(s);
                g.drawString(s, x - sw / 2, y);
                cal.add(format.subFormat.field, format.subFormat.offset);
                start = cal.getTimeInMillis();
            }
        }
        g.setStroke(STROKE_SOLID_ONEPIXEL);
    }

    public void paintBackgroundDecoration(Graphics2D g) {
        if (this.sunriseDates.size() > 0) {
            g.setColor(Color.yellow);
            int height = (int)this.getSize().getHeight();
            for (int i = 0; i < this.sunriseDates.size(); i += 2) {
                Date d1 = (Date)this.sunriseDates.get(i);
                Date d2 = (Date)this.sunriseDates.get(i + 1);
                int x1 = this.toLocation(d1);
                int x2 = this.toLocation(d2);
                g.fillRect(x1, 0, x2 - x1, height);
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g.setFont(FONT_MAIN);
        int width = (int)this.getSize().getWidth();
        int height = (int)this.getSize().getHeight();
        int baseLine = this.getBaseLine();
        int left = this.getLeft();
        int right = this.getRight();
        if (this.isEnabled()) {
            g.setColor(COLOR_BACKGROUND);
        } else {
            g.setColor(COLOR_BACKGROUND_DISABLED);
        }
        g.fillRect(0, 0, width, height);
        this.paintBackgroundDecoration(g2);
        if (this.doingDragSelect && this.dragStartDate != null && this.dragEndDate != null) {
            int dx1 = this.toLocation(this.dragStartDate);
            int dx2 = this.toLocation(this.dragEndDate);
            int x = Math.min(dx1, dx2);
            int h = 40;
            int y = baseLine - h / 2;
            int w = Math.abs(dx1 - dx2);
            g2.setStroke(STROKE_DASHED_ONEPIXEL);
            g2.setColor(Color.lightGray);
            g2.fillRect(x, y, w, h);
            g2.setColor(Color.black);
            g2.drawRect(x, y, w, h);
        }
        g.setColor(COLOR_LINE);
        g.drawLine(left, baseLine, right, baseLine);
        if (this.startDate == null || this.endDate == null) {
            return;
        }
        long start = this.startDate.getTime();
        long end = this.endDate.getTime();
        if (!this.shortDisplay) {
            this.paintAxis(g2);
        }
        if (this.dateSelectionActive()) {
            this.paintDateSelection((Graphics2D)g, this.dateSelection);
        }
        g2.setStroke(STROKE_SOLID_ONEPIXEL);
        g2.setColor(COLOR_LINE);
        FontMetrics fm = g.getFontMetrics();
        String s1 = this.format(this.startDate);
        String s2 = this.format(this.endDate);
        int w1 = fm.stringWidth(s1);
        int w2 = fm.stringWidth(s2);
        int s2x = right - w2 - 2;
        if (!this.shortDisplay) {
            int dart = 6;
            s2x -= dart;
            int bottomy = this.verticalPadding + fm.getHeight();
            g.setColor(COLOR_RANGE_DART);
            g.fillPolygon(new int[]{0, dart, dart, 0}, new int[]{1, 1, dart + 1, 1}, 4);
            g2.setColor(COLOR_RANGE);
            g.drawString(s1, left + dart + 2, bottomy);
            g.setColor(COLOR_RANGE_DART);
            if (s2x <= left + 2 + w1) {
                bottomy = this.getBottom();
                g.fillPolygon(new int[]{right - dart, right, right - dart, right - dart}, new int[]{bottomy - 1, bottomy - 1, bottomy - dart - 1, bottomy - 1}, 4);
            } else {
                g.fillPolygon(new int[]{right - dart, right, right - dart, right - dart}, new int[]{1, 1, dart + 1, 1}, 4);
            }
            g2.setColor(COLOR_RANGE);
            g.drawString(s2, s2x, bottomy);
        }
        Hashtable seenLocations = new Hashtable();
        if (this.datedThings != null) {
            for (int selectIdx = 0; selectIdx < 2; ++selectIdx) {
                for (int i = 0; i < this.datedThings.size(); ++i) {
                    boolean isSelected;
                    DatedThing datedThing = (DatedThing)this.datedThings.get(i);
                    Date date = datedThing.getDate();
                    long time = date.getTime();
                    if (time < start || time > end) continue;
                    int location = this.toLocation(date);
                    boolean bl = isSelected = this.selectedMap.get(datedThing) != null;
                    if (isSelected && selectIdx == 0 || !isSelected && selectIdx == 1 || this.justShowSelected && !isSelected) continue;
                    if (datedThing == this.mouseHighlighted) {
                        if (isSelected) {
                            g.setColor(this.getColorTimeSelected());
                            g.fillRect(location - 2 - 1, baseLine - 5 - 1, 6, 12);
                        }
                        g.setColor(COLOR_HIGHLIGHT_DATE);
                    } else if (isSelected) {
                        g.setColor(this.getColorTimeSelected());
                    } else {
                        g.setColor(this.getColorTimeUnselected());
                    }
                    g.fillRect(location - 2, baseLine - 5, 4, 10);
                }
            }
        }
    }

    public void setHighlightedDate(DatedThing d) {
        this.mouseHighlighted = d;
    }

    public DatedThing getHighlightedDate() {
        return this.mouseHighlighted;
    }

    public void setDatedThings(List l) {
        this.setDatedThings(l, false);
    }

    public void setGroup(List group) {
        this.timelineGroup = group;
    }

    public void setDatedThings(List l, boolean andSetRange) {
        this.datedThings = DatedObject.sort(l, true);
        if (andSetRange) {
            if (this.datedThings.size() >= 2) {
                Date d1 = ((DatedThing)this.datedThings.get(0)).getDate();
                Date d2 = ((DatedThing)this.datedThings.get(this.datedThings.size() - 1)).getDate();
                long middle = d1.getTime() + (d2.getTime() - d1.getTime()) / 2L;
                long timeDelta = (long)((double)(d2.getTime() - d1.getTime()) * 1.1);
                this.init(new Date(middle - timeDelta / 2L), new Date(middle + timeDelta / 2L));
            } else {
                this.startDate = new Date(System.currentTimeMillis() - 86400000L);
                this.startDate = new Date(System.currentTimeMillis());
            }
        }
        this.repaint();
    }

    public String format(Date date) {
        return this.format(date.getTime());
    }

    public String getFormat() {
        long start = this.startDate.getTime();
        long end = this.endDate.getTime();
        long diff = end - start;
        if (diff < 20000L) {
            return "yyyy-MM-dd HH:mm:ss:SS z";
        }
        if (diff < 300000L) {
            return "yyyy-MM-dd HH:mm:ss z";
        }
        if (diff < 3600000L) {
            return "yyyy-MM-dd HH:mm z";
        }
        if (diff < 86400000L) {
            return "yyyy-MM-dd HH:mm z";
        }
        if (diff < 259200000L) {
            return "yyyy-MM-dd HH:00 z";
        }
        if (diff < 604800000L) {
            return "yyyy-MM-dd";
        }
        if (diff < 2592000000L) {
            return "yyyy-MM-dd";
        }
        if (diff < 31536000000L) {
            return "yyyy-MM-dd";
        }
        if (diff < 315360000000L) {
            return "yyyy-MM";
        }
        if (diff > 31536000000000L) {
            return "yyyy G";
        }
        return "yyyy";
    }

    public String format(long time) {
        return this.format(time, this.getFormat());
    }

    public String format(long time, String pattern) {
        long now = System.currentTimeMillis();
        double diff = now - time;
        if (diff > 3.1536E16) {
            diff /= 3.1536E16;
            diff *= 100.0;
            diff = (int)diff;
            return (diff /= 100.0) + " mya";
        }
        if ((diff = Math.abs(diff)) > 3.1536E16) {
            diff /= 3.1536E16;
            diff *= 100.0;
            diff = (int)diff;
            return (diff /= 100.0) + " my";
        }
        StringBuffer buf = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.setTimeZone(Timeline.getTimeZone());
        if (pattern != null && sdf instanceof SimpleDateFormat) {
            sdf.applyPattern(pattern);
        }
        return sdf.format(time, buf, new FieldPosition(0)).toString();
    }

    protected void reset(boolean doDateSelection) {
        if (doDateSelection) {
            this.dateSelection = this.originalDateSelection != null ? new DateSelection(this.originalDateSelection) : new DateSelection();
            this.dateSelectionChanged();
        } else {
            this.startDate = this.originalStartDate;
            this.endDate = this.originalEndDate;
            this.timelineChanged();
        }
    }

    protected void shiftByPercent(double percent, boolean doDateSelection) {
        long start = doDateSelection ? this.dateSelection.getStartFixedTime() : this.startDate.getTime();
        long end = doDateSelection ? this.dateSelection.getEndFixedTime() : this.endDate.getTime();
        long timeDelta = (long)((double)(end - start) * percent);
        if (doDateSelection) {
            this.dateSelection.setStartFixedTime(start + timeDelta);
            this.dateSelection.setEndFixedTime(end + timeDelta);
            this.dateSelectionChanged();
        } else {
            this.startDate = new Date(start + timeDelta);
            this.endDate = new Date(end + timeDelta);
            this.timelineChanged();
        }
    }

    public void expandByPercent(double percent, boolean doDateSelection) {
        long half;
        long start = doDateSelection ? this.dateSelection.getStartFixedTime() : this.startDate.getTime();
        long end = doDateSelection ? this.dateSelection.getEndFixedTime() : this.endDate.getTime();
        long middle = start + (end - start) / 2L;
        long timeDelta = (long)((double)(end - start) * percent);
        if (timeDelta <= 1L) {
            timeDelta = 2L;
        }
        for (half = timeDelta / 2L; half <= 2L; ++half) {
        }
        long t2 = middle + half;
        long t1 = middle - half;
        if (t2 <= t1) {
            t1 -= t1 - t2 + 1L;
            ++t2;
        }
        if (doDateSelection) {
            this.dateSelection.setStartFixedTime(t1);
            this.dateSelection.setEndFixedTime(t2);
            this.dateSelectionChanged();
        } else {
            this.startDate = new Date(t1);
            this.endDate = new Date(t2);
            this.timelineChanged();
        }
    }

    public Date toDate(int location) {
        Dimension dim = this.getSize();
        long start = this.startDate.getTime();
        long end = this.endDate.getTime();
        int width = (int)dim.getWidth();
        int left = this.horizontalPadding;
        int right = width - this.horizontalPadding;
        double percent = (double)location / (double)(right - left);
        return new Date(start + (long)(percent * (double)(end - start)));
    }

    public int toLocation(Date date) {
        return this.toLocation(date.getTime());
    }

    public int toLocation(long date) {
        long end;
        if (this.startDate == null) {
            return 0;
        }
        Dimension dim = this.getSize();
        long start = this.startDate.getTime();
        if (start == (end = this.endDate.getTime())) {
            return -1;
        }
        double percent = (double)(date - start) / (double)(end - start);
        int width = (int)dim.getWidth();
        int innerWidth = width - this.horizontalPadding * 2;
        return this.horizontalPadding + (int)(percent * (double)innerWidth);
    }

    public void setRange(Date start, Date end) {
        this.setRange(start, end, false);
    }

    public void makeCurrentRangeOriginal() {
        this.originalStartDate = this.startDate;
        this.originalEndDate = this.endDate;
    }

    public void setRange(Date start, Date end, boolean makeTheseTheOriginal) {
        this.startDate = start;
        this.endDate = end;
        if (makeTheseTheOriginal) {
            this.originalStartDate = this.startDate;
            this.originalEndDate = this.endDate;
        }
        this.timelineChanged();
    }

    public void setStartDate(Date value) {
        this.startDate = value;
        this.timelineChanged();
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setEndDate(Date value) {
        this.endDate = value;
        this.timelineChanged();
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public boolean popup() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)null, "Date Selection", true);
            this.dialog.getContentPane().add(this.getContents(true));
            this.dialog.pack();
            this.dialog.setLocation(new Point(200, 200));
        }
        this.dialogOK = false;
        this.dialog.setVisible(true);
        return this.dialogOK;
    }

    public static void main(String[] args) throws Exception {
        boolean useDateSelection = true;
        try {
            final ArrayList<DatedObject> dates = new ArrayList<DatedObject>();
            if (args.length == 0) {
                long now = System.currentTimeMillis();
                for (int i = 0; i < 30; ++i) {
                    DatedObject datedObject = new DatedObject(new Date((long)((double)(now + DateUtil.minutesToMillis(20.0)) - (double)i * Math.random() * 60.0 * 60.0 * 1000.0)));
                    dates.add(datedObject);
                }
            } else {
                String line;
                String file;
                useDateSelection = false;
                String fmt = "EEE MMM dd hh:mm:ss yyyy";
                if (args.length > 1) {
                    fmt = args[0];
                    file = args[1];
                } else {
                    file = args[0];
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                SimpleDateFormat dateFormat = new SimpleDateFormat(fmt);
                ParsePosition pp = new ParsePosition(0);
                while ((line = reader.readLine()) != null) {
                    int idx1 = line.indexOf("[");
                    int idx2 = line.indexOf("]", idx1);
                    if (idx1 < 0 || idx2 <= idx1) continue;
                    String dateString = line.substring(idx1 + 1, idx2);
                    pp.setIndex(0);
                    Date date = dateFormat.parse(dateString, pp);
                    if (date != null) {
                        dates.add(new DatedObject(date, line));
                        continue;
                    }
                    System.err.println("failed to  parse:" + dateString);
                    System.err.println("fmt:" + fmt);
                    return;
                }
            }
            if (dates.size() == 0) {
                System.err.println("no dates");
                return;
            }
            final Timeline timeline = new Timeline(dates, 400);
            timeline.setUseDateSelection(useDateSelection);
            DateSelection dateSelection = new DateSelection(timeline.getStartDate(), timeline.getEndDate());
            dateSelection.setRoundTo(DateUtil.minutesToMillis(15.0));
            dateSelection.setInterval(DateUtil.minutesToMillis(120.0));
            timeline.setDateSelection(dateSelection);
            final JCheckBox justShowSelectedCbx = new JCheckBox("Just show selected", false);
            justShowSelectedCbx.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    timeline.justShowSelected = justShowSelectedCbx.isSelected();
                    timeline.repaint();
                }
            });
            JButton useSelectedBtn = new JButton("Use selected");
            useSelectedBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    timeline.setDatedThings(timeline.getSelected());
                }
            });
            JButton resetBtn = new JButton("Reset");
            resetBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    timeline.setDatedThings(dates);
                }
            });
            final JTextField searchFld = new JTextField();
            searchFld.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    List<String> toks = StringUtil.split(searchFld.getText().trim(), ",", true, true);
                    ArrayList<DatedObject> selected = new ArrayList<DatedObject>();
                    for (int i = 0; i < dates.size(); ++i) {
                        DatedObject datedObject = (DatedObject)dates.get(i);
                        boolean ok = true;
                        for (int tokIdx = 0; tokIdx < toks.size(); ++tokIdx) {
                            boolean contains;
                            String s = toks.get(tokIdx);
                            boolean not = s.startsWith("!");
                            if (not) {
                                s = s.substring(0);
                            }
                            boolean bl = contains = datedObject.getObject().toString().indexOf(s) >= 0;
                            if (not) {
                                boolean bl2 = contains = !contains;
                            }
                            if (contains) continue;
                            ok = false;
                            break;
                        }
                        if (!ok) continue;
                        selected.add(datedObject);
                    }
                    timeline.setSelected(selected);
                }
            });
            JPanel bottom = LayoutUtil.centerRight(searchFld, LayoutUtil.hbox(useSelectedBtn, resetBtn));
            JDialog dialog = new JDialog((Frame)null, "Date Selection", true);
            dialog.getContentPane().add(LayoutUtil.centerBottom(timeline.getContents(true), bottom));
            dialog.pack();
            dialog.setLocation(new Point(200, 200));
            dialog.setVisible(true);
        }
        catch (Throwable thr) {
            thr.printStackTrace();
            return;
        }
    }

    public void setIsCapableOfSelection(boolean value) {
        this.isCapableOfSelection = value;
    }

    public boolean getIsCapableOfSelection() {
        return this.isCapableOfSelection;
    }

    public void setShortDisplay(boolean value) {
        this.shortDisplay = value;
        Dimension dim = this.getPreferredSize();
        if (this.shortDisplay) {
            this.setPreferredSize(new Dimension((int)dim.getWidth(), 20));
        } else {
            this.setPreferredSize(new Dimension((int)dim.getWidth(), 100));
        }
    }

    public boolean getShortDisplay() {
        return this.shortDisplay;
    }

    public void setColorTimeSelected(Color value) {
        this.colorTimeSelected = value;
    }

    public Color getColorTimeSelected() {
        return this.colorTimeSelected;
    }

    public void setColorTimeUnselected(Color value) {
        this.colorTimeUnselected = value;
    }

    public Color getColorTimeUnselected() {
        return this.colorTimeUnselected;
    }

    static {
        defaultFormat = "yyyy-MM-dd HH:mm:ss";
    }

    private static class AxisFormat {
        int field;
        int offset;
        long step;
        String format;
        AxisFormat subFormat;

        public AxisFormat(int field, int offset, String fmt) {
            this.field = field;
            this.offset = offset;
            this.format = fmt;
        }

        public AxisFormat(long step, String fmt) {
            this(step, fmt, null);
        }

        public AxisFormat(long step, String fmt, AxisFormat subFormat) {
            this.step = step;
            this.format = fmt;
            this.subFormat = subFormat;
        }

        SimpleDateFormat getSDF(TimeZone tz) {
            SimpleDateFormat sdf = new SimpleDateFormat(this.format);
            if (tz != null) {
                sdf.setTimeZone(tz);
            }
            return sdf;
        }
    }
}

