/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;

public class TimeLengthField {
    private PropertyChangeSupport changeListeners = new PropertyChangeSupport(this);
    boolean isPositiveOnly = false;
    double time = 0.0;
    JTextField yearsFld;
    JTextField daysFld;
    JTextField hoursFld;
    JTextField minutesFld;
    JLabel label;
    JComboBox signCbx;
    ImageIcon editIcon = null;
    JButton editButton;
    String name = "Interval";
    private String intervalText;

    public TimeLengthField(String name) {
        this(name, false);
    }

    public TimeLengthField(String name, boolean isPositiveOnly) {
        this(name, isPositiveOnly, true);
    }

    public TimeLengthField(String name, double minutes) {
        this(name, minutes, false, true);
    }

    public TimeLengthField(String name, boolean isPositiveOnly, boolean showYearsFld) {
        this(name, 0.0, isPositiveOnly, showYearsFld);
    }

    public TimeLengthField(String name, double minutes, boolean isPositiveOnly, boolean showYearsFld) {
        this.isPositiveOnly = isPositiveOnly;
        this.name = name;
        this.signCbx = new JComboBox();
        GuiUtils.setListData(this.signCbx, Misc.newList("+", "-"));
        if (showYearsFld) {
            this.yearsFld = new JTextField("", 4);
            this.yearsFld.setHorizontalAlignment(4);
        }
        this.daysFld = new JTextField("", 3);
        this.daysFld.setHorizontalAlignment(4);
        this.hoursFld = new JTextField("", 3);
        this.hoursFld.setHorizontalAlignment(4);
        this.minutesFld = new JTextField("", 3);
        this.minutesFld.setHorizontalAlignment(4);
        Font monoFont = Font.decode("monospaced");
        this.label = new JLabel(" ");
        this.label.setFont(monoFont);
        this.setTime(minutes);
    }

    private double getNum(String t) {
        this.intervalText = t;
        if (t.length() == 0) {
            return 0.0;
        }
        return new Double(t);
    }

    public boolean showDialog() {
        return this.showDialog(null);
    }

    public JComponent getFieldsComponent(boolean allFields) {
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        if (!this.isPositiveOnly) {
            comps.add(this.signCbx);
            comps.add(new JLabel("  "));
        }
        if (this.yearsFld != null) {
            comps.add(this.yearsFld);
            comps.add(new JLabel(" Years   "));
        }
        comps.add(this.daysFld);
        comps.add(new JLabel(" Days   "));
        comps.add(this.hoursFld);
        comps.add(new JLabel(" Hours   "));
        comps.add(this.minutesFld);
        comps.add(new JLabel(" Minutes   "));
        return GuiUtils.left(GuiUtils.hbox(comps));
    }

    public boolean showDialog(String topMsg) {
        double oldTime = this.time;
        this.setTime(this.time);
        JComponent contents = this.getFieldsComponent(true);
        if (topMsg != null) {
            contents = GuiUtils.topCenter(GuiUtils.inset((Component)new JLabel(topMsg), 5), contents);
        }
        do {
            if (GuiUtils.showOkCancelDialog(null, "Set " + this.name, GuiUtils.inset((Component)contents, 5), this.editButton)) continue;
            return false;
        } while (!this.applyFields(true));
        this.changeListeners.firePropertyChange("time", new Double(oldTime), new Double(this.time));
        return true;
    }

    public boolean applyFields(boolean allFields) {
        try {
            String minutesText = this.minutesFld.getText().trim();
            String hoursText = this.hoursFld.getText().trim();
            String daysText = this.daysFld.getText().trim();
            String yearsText = "";
            if (this.yearsFld != null) {
                yearsText = this.yearsFld.getText().trim();
            }
            if (minutesText.length() == 0 && hoursText.length() == 0 && daysText.length() == 0 && yearsText.length() == 0) {
                this.setTime(Double.NaN);
                return true;
            }
            double newTime = this.getNum(minutesText);
            newTime += this.getNum(hoursText) * 60.0;
            newTime += this.getNum(daysText) * 60.0 * 24.0;
            if (this.yearsFld != null) {
                newTime += this.getNum(yearsText) * 365.0 * 60.0 * 24.0;
            }
            if (this.isPositiveOnly) {
                newTime = Math.abs(newTime);
            } else if (this.signCbx.getSelectedIndex() == 1) {
                newTime = -newTime;
            }
            this.time = newTime;
            this.setTime(this.time);
        }
        catch (NumberFormatException nfe) {
            LogUtil.userErrorMessage("Bad value:" + this.intervalText);
            return false;
        }
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeListeners.addPropertyChangeListener(listener);
    }

    public JComponent getContents() {
        if (this.editIcon == null) {
            this.editIcon = GuiUtils.getImageIcon("/auxdata/ui/icons/calendar_edit.png", this.getClass());
        }
        this.editButton = GuiUtils.getImageButton(this.editIcon);
        this.editButton.setToolTipText("Edit " + this.name);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TimeLengthField.this.showDialog(null);
            }
        });
        return GuiUtils.wrap(GuiUtils.hbox(this.label, this.editButton));
    }

    public double getTime() {
        return this.isPositiveOnly ? Math.abs(this.time) : this.time;
    }

    public void setTime(double minutes) {
        if (minutes != minutes) {
            this.time = minutes;
            this.label.setText(StringUtil.padLeft("Undefined", 12));
            if (this.yearsFld != null) {
                this.yearsFld.setText("");
            }
            this.daysFld.setText("");
            this.hoursFld.setText("");
            this.minutesFld.setText("");
            return;
        }
        if (this.isPositiveOnly) {
            minutes = Math.abs(minutes);
        }
        boolean negative = minutes < 0.0;
        this.time = minutes;
        minutes = Math.abs(minutes);
        if (this.signCbx == null) {
            return;
        }
        if (negative) {
            this.signCbx.setSelectedIndex(1);
        } else {
            this.signCbx.setSelectedIndex(0);
        }
        double years = minutes / 525600.0;
        int intYears = (int)years;
        minutes = years > 1000.0 ? (minutes -= years * 365.0 * 60.0 * 24.0) : (minutes -= (double)(intYears * 365 * 60 * 24));
        int days = (int)(minutes / 1440.0);
        if (this.yearsFld != null) {
            this.yearsFld.setText("" + intYears);
        } else {
            days += 365 * intYears;
        }
        this.daysFld.setText("" + days);
        int hours = (int)((minutes -= (double)(days * 60 * 24)) / 60.0);
        this.hoursFld.setText("" + hours);
        double tmp = minutes -= (double)(hours * 60);
        String text = "";
        text = minutes == 0.0 ? "0" : (minutes == (double)((int)minutes) ? text + (int)minutes : text + minutes);
        this.minutesFld.setText(text);
        String string = text = negative ? "- " : "";
        if (intYears != 0) {
            text = text + intYears + "y ";
        }
        if (days != 0) {
            text = text + days + "d ";
        }
        if (hours != 0) {
            text = text + hours + "h ";
        }
        if (minutes != 0.0) {
            text = minutes == (double)((int)minutes) ? text + (int)minutes + "m" : text + minutes + "m";
        } else if (text.length() == 0) {
            text = text + "0" + "m";
        }
        this.label.setText(StringUtil.padLeft(text, 12));
        this.timeChanged();
    }

    public void timeChanged() {
    }

    public String toString() {
        return this.label.getText();
    }
}

