/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;

public class TextSearcher
extends JPanel {
    private JTextField findFld;
    private JCheckBox caseCbx;
    JToggleButton highlightAllBtn;
    private TextWrapper textWrapper;
    public static final Color COLOR_BADSEARCH = new Color(255, 102, 102);

    public TextSearcher(JTextComponent comp) {
        this.textWrapper = new TextWrapper(comp);
        this.init();
    }

    public TextSearcher() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.highlightAllBtn = GuiUtils.getToggleImageButton("/ucar/unidata/ui/images/SearchHighlightOff16.gif", "/ucar/unidata/ui/images/SearchHighlightOn16.gif", 0, 0, true);
        this.highlightAllBtn.addActionListener(GuiUtils.makeActionListener(this, "searchFor", null));
        this.highlightAllBtn.setToolTipText("Highlight All");
        this.caseCbx = new JCheckBox("Match case", false);
        this.caseCbx.addActionListener(GuiUtils.makeActionListener(this, "searchFor", null));
        this.findFld = new JTextField("", 20);
        JButton nextBtn = GuiUtils.makeImageButton("/ucar/unidata/ui/images/SearchNext16.gif", this, "doSearch", null, true);
        JButton prevBtn = GuiUtils.makeImageButton("/ucar/unidata/ui/images/SearchPrev16.gif", this, "doSearchPrevious", null, true);
        nextBtn.setToolTipText("Find Next");
        prevBtn.setToolTipText("Find Previous");
        this.findFld.addActionListener(GuiUtils.makeActionListener(this, "doSearch", null));
        this.findFld.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.isControlDown()) {
                    return;
                }
                if (e.getKeyCode() != 10) {
                    TextSearcher.this.searchFor(TextSearcher.this.findFld.getText(), true);
                }
            }
        });
        JPanel buttons = GuiUtils.hbox(Misc.newList(nextBtn, prevBtn, this.highlightAllBtn, this.caseCbx), 2);
        JPanel bottomPanel = GuiUtils.left(GuiUtils.hbox((Component)new JLabel(" Find: "), (Component)GuiUtils.hfill(this.findFld), buttons));
        this.add("Center", bottomPanel);
    }

    private void searchFor(String text, boolean next) {
        TextWrapper holder = this.getTextWrapper();
        if (holder == null) {
            return;
        }
        if (!holder.find(text, this.highlightAllBtn.isSelected(), this.caseCbx.isSelected(), next)) {
            this.findFld.setBackground(COLOR_BADSEARCH);
        } else {
            this.findFld.setBackground(Color.white);
        }
    }

    public void searchFor() {
        this.searchFor(this.findFld.getText(), true);
    }

    public void doSearch() {
        TextWrapper holder = this.getTextWrapper();
        holder.resetToCurrentSearchIndex();
        this.searchFor(this.findFld.getText(), true);
    }

    public void doSearchPrevious() {
        TextWrapper holder = this.getTextWrapper();
        holder.resetToCurrentSearchIndex();
        this.searchFor(this.findFld.getText(), false);
    }

    public TextWrapper getTextWrapper() {
        return this.textWrapper;
    }

    public static class TextWrapper {
        JTextComponent textComp;
        String lastSearch;
        int lastIndex = -1;
        int currentIndex = -1;
        List highlights = new ArrayList();
        static DefaultHighlighter.DefaultHighlightPainter allPainter;
        static DefaultHighlighter.DefaultHighlightPainter onePainter;

        public TextWrapper() {
            if (allPainter == null) {
                allPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.yellow);
                onePainter = new DefaultHighlighter.DefaultHighlightPainter(Color.green);
            }
        }

        public TextWrapper(JTextComponent comp) {
            this();
            this.textComp = comp;
        }

        public JTextComponent getTextComponent() {
            return this.textComp;
        }

        protected void setTextComponent(JTextComponent comp) {
            this.textComp = comp;
        }

        public void setSearchIndex(Point pt) {
            Highlighter highlighter = this.textComp.getHighlighter();
            this.removeHighlights();
            this.lastIndex = this.textComp.viewToModel(pt);
            this.lastSearch = null;
        }

        public void removeHighlights() {
            Highlighter highlighter = this.textComp.getHighlighter();
            for (int i = 0; i < this.highlights.size(); ++i) {
                highlighter.removeHighlight(this.highlights.get(i));
            }
        }

        public void resetToCurrentSearchIndex() {
            this.lastIndex = this.currentIndex;
        }

        private void highlightAll(String what, String t) {
            if (what.length() == 0) {
                return;
            }
            Highlighter highlighter = this.textComp.getHighlighter();
            int baseIndex = 0;
            int lastIndex = -1;
            try {
                int index;
                while ((index = t.indexOf(what, baseIndex)) >= 0 && index != lastIndex) {
                    lastIndex = index;
                    this.highlights.add(highlighter.addHighlight(index, index + what.length(), allPainter));
                    baseIndex = index + 1;
                }
            }
            catch (Exception exc) {
                LogUtil.logException("Bad highlight area", exc);
            }
        }

        public boolean find(String what, boolean highlightAll, boolean doCase, boolean next) {
            String t = this.textComp.getText();
            if (!doCase) {
                t = t.toLowerCase();
                what = what.toLowerCase();
            }
            int start = 0;
            start = this.lastIndex + 1;
            Highlighter highlighter = this.textComp.getHighlighter();
            this.removeHighlights();
            if (!next) {
                String prevText = t;
                if (this.currentIndex >= 0) {
                    prevText = prevText.substring(0, this.currentIndex);
                }
                this.currentIndex = prevText.lastIndexOf(what, start);
            } else {
                this.currentIndex = t.indexOf(what, start);
            }
            if (this.currentIndex >= 0) {
                try {
                    this.highlights.add(highlighter.addHighlight(this.currentIndex, this.currentIndex + what.length(), onePainter));
                    this.textComp.setCaretPosition(this.currentIndex);
                }
                catch (Exception exc) {
                    LogUtil.logException("Bad highlight area", exc);
                }
            }
            if (highlightAll) {
                this.highlightAll(what, t);
            }
            return this.currentIndex >= 0;
        }
    }
}

