/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import ucar.unidata.sql.SqlUtil;
import ucar.unidata.ui.InteractiveShell;
import ucar.unidata.util.LogUtil;
import ucar.unidata.xml.XmlUtil;

public class SqlShell
extends InteractiveShell {
    private Connection connection;

    public SqlShell(String title, Connection connection) {
        super(title);
        this.connection = connection;
        this.init();
        this.commandFld.setToolTipText("Enter '?' to list tables; '?tablename' to list columns of table;");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eval(String sql) {
        super.eval(sql);
        this.showWaitCursor();
        try {
            ResultSet results;
            StringBuffer sb = new StringBuffer("");
            if (sql.trim().startsWith("?")) {
                String tablePattern = sql.substring(1).trim();
                if (tablePattern.length() == 0) {
                    tablePattern = null;
                }
                if (tablePattern == null) {
                    sb.append("Tables:<br>");
                }
                DatabaseMetaData dbmd = this.connection.getMetaData();
                ResultSet catalogs = dbmd.getCatalogs();
                while (catalogs.next()) {
                    String catalog = catalogs.getString(1);
                    sb.append("<h3>" + catalog + "</h3>");
                    ResultSet tables = dbmd.getTables(catalog, null, tablePattern, null);
                    while (tables.next()) {
                        String tableName = tables.getString("TABLE_NAME");
                        ResultSet columns = dbmd.getColumns(catalog, null, tableName, null);
                        String encoded = new String(XmlUtil.encodeBase64(("text:?" + tableName).getBytes()));
                        if (tablePattern != null) {
                            sb.append("Table:" + tableName + " " + this.getHref("select * from " + tableName + ";", "(select *)") + "<ul>");
                        } else {
                            sb.append("<a href=\"" + encoded + "\">" + tableName + "</a>");
                        }
                        if (tablePattern != null) {
                            while (columns.next()) {
                                String colName = columns.getString("COLUMN_NAME");
                                sb.append("<li>");
                                sb.append(this.getHref("select " + colName + " from " + tableName + ";", colName));
                                sb.append(" (" + columns.getString("TYPE_NAME") + ")");
                            }
                            sb.append("</ul>");
                            continue;
                        }
                        sb.append("<br>");
                    }
                }
                this.output(sb.toString());
                return;
            }
            if (!sql.endsWith(";")) {
                sql = sql + ";";
            }
            Statement stmt = this.connection.createStatement();
            stmt.execute(sql);
            int cnt = 0;
            SqlUtil.Iterator iter = SqlUtil.getIterator(stmt);
            ResultSetMetaData rsmd = null;
            while ((results = iter.getNext()) != null) {
                if (rsmd == null) {
                    rsmd = results.getMetaData();
                }
                int colcnt = 0;
                while (colcnt < rsmd.getColumnCount()) {
                    String s = results.getString(++colcnt);
                    if (colcnt > 1) {
                        sb.append(", ");
                    }
                    sb.append(s);
                }
                sb.append("<br>");
                if (++cnt <= 100) continue;
                sb.append("...");
                break;
            }
            if (cnt == 0) {
                sb.append("No data retreived<br>");
            }
            this.output(sb.toString());
        }
        catch (Exception exc) {
            LogUtil.logException("Error evaluating sql:" + sql, exc);
        }
        finally {
            this.showNormalCursor();
        }
    }
}

