/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public abstract class Rubberband {
    protected Point anchorPt = new Point(0, 0);
    protected Point stretchedPt = new Point(0, 0);
    protected Point lastPt = new Point(0, 0);
    protected Point endPt = new Point(0, 0);
    private Component component;
    private boolean firstStretch = true;
    private boolean active = false;

    public abstract void drawLast(Graphics var1);

    public abstract void drawNext(Graphics var1);

    public Rubberband() {
    }

    public Rubberband(Component c) {
        this.setComponent(c);
    }

    public void setActive(boolean b) {
        this.active = b;
    }

    public void setComponent(Component c) {
        this.component = c;
        this.component.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent event) {
                if (Rubberband.this.isActive()) {
                    Rubberband.this.stretch(event.getPoint());
                }
            }
        });
    }

    public boolean isActive() {
        return this.active;
    }

    public Point getAnchor() {
        return this.anchorPt;
    }

    public Point getStretched() {
        return this.stretchedPt;
    }

    public Point getLast() {
        return this.lastPt;
    }

    public Point getEnd() {
        return this.endPt;
    }

    public void anchor(Point p) {
        this.firstStretch = true;
        this.anchorPt.x = p.x;
        this.anchorPt.y = p.y;
        this.stretchedPt.x = this.lastPt.x = this.anchorPt.x;
        this.stretchedPt.y = this.lastPt.y = this.anchorPt.y;
    }

    public void stretch(Point p) {
        this.lastPt.x = this.stretchedPt.x;
        this.lastPt.y = this.stretchedPt.y;
        this.stretchedPt.x = p.x;
        this.stretchedPt.y = p.y;
        Graphics g = this.component.getGraphics();
        if (g != null) {
            try {
                g.setXORMode(this.component.getBackground());
                if (this.firstStretch) {
                    this.firstStretch = false;
                } else {
                    this.drawLast(g);
                }
                this.drawNext(g);
            }
            finally {
                g.dispose();
            }
        }
    }

    public void end(Point p) {
        this.lastPt.x = this.endPt.x = p.x;
        this.lastPt.y = this.endPt.y = p.y;
        Graphics g = this.component.getGraphics();
        if (g != null) {
            try {
                g.setXORMode(this.component.getBackground());
                this.drawLast(g);
            }
            finally {
                g.dispose();
            }
        }
    }

    public Rectangle getBounds() {
        return new Rectangle(this.stretchedPt.x < this.anchorPt.x ? this.stretchedPt.x : this.anchorPt.x, this.stretchedPt.y < this.anchorPt.y ? this.stretchedPt.y : this.anchorPt.y, Math.abs(this.stretchedPt.x - this.anchorPt.x), Math.abs(this.stretchedPt.y - this.anchorPt.y));
    }

    public Rectangle lastBounds() {
        return new Rectangle(this.lastPt.x < this.anchorPt.x ? this.lastPt.x : this.anchorPt.x, this.lastPt.y < this.anchorPt.y ? this.lastPt.y : this.anchorPt.y, Math.abs(this.lastPt.x - this.anchorPt.x), Math.abs(this.lastPt.y - this.anchorPt.y));
    }
}

