/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.Border;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Removable;

public class RovingProgress
extends JPanel
implements Removable {
    public static final Insets DEFAULT_INSETS = new Insets(0, 0, 0, 0);
    public static final Color DEFAULT_COLOR = new Color(156, 153, 205);
    private Runnable currentRunnable;
    private int barWidth = 20;
    private double percent = 0.0;
    private boolean running = false;
    private double delta = 0.05;
    private long sleepTime = 100L;
    private Color color = null;
    private String label;
    private BufferedImage bufferedImage;
    private Dimension imageSize;
    private boolean showClock = false;
    private boolean clockRunning = false;
    private static final Font clockFont = new Font("Dialog", 1, 11);
    private static SimpleDateFormat clockFormat = new SimpleDateFormat("HH:mm:ss z");

    public RovingProgress(boolean showClock) {
        this(null, null);
        this.showClock = showClock;
        if (showClock) {
            this.startClock();
        }
    }

    private void startClock() {
        if (this.clockRunning) {
            return;
        }
        Misc.run(new Runnable(){

            @Override
            public void run() {
                RovingProgress.this.startClockInner();
            }
        });
    }

    private void startClockInner() {
        while (this.showClock) {
            this.repaint();
            Misc.sleep(1000L);
        }
        this.clockRunning = false;
    }

    public void setShowClock(boolean showClock) {
        this.showClock = showClock;
        if (showClock) {
            this.startClock();
        }
    }

    public RovingProgress() {
        this(null, null);
    }

    public RovingProgress(String label) {
        this(null, label);
    }

    public RovingProgress(Color c) {
        this(c, null);
    }

    public RovingProgress(Color c, String label) {
        this.label = label;
        this.color = c == null ? DEFAULT_COLOR : c;
    }

    public synchronized void stop() {
        this.currentRunnable = null;
        this.running = false;
        this.repaint();
    }

    @Override
    public void doRemove() {
        this.currentRunnable = null;
        this.running = false;
        this.showClock = false;
        GuiUtils.empty(this, true);
    }

    public synchronized void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.currentRunnable = new Runnable(){

            @Override
            public void run() {
                while (RovingProgress.this.running) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(RovingProgress.this.sleepTime);
                        if (RovingProgress.this.currentRunnable != this) {
                            return;
                        }
                        RovingProgress.this.tick();
                    }
                    catch (Exception exc) {
                        System.err.println(exc);
                    }
                }
            }
        };
        Thread thread = new Thread(this.currentRunnable);
        thread.start();
    }

    public void reset() {
        this.percent = 0.0;
        this.repaint(1L);
    }

    private void tick() {
        this.percent += this.delta;
        if (this.percent > 1.0) {
            if (this.drawFilledSquare()) {
                this.delta = -this.delta;
            } else {
                this.percent = 0.0;
            }
        } else if (this.percent < 0.0) {
            this.delta = -this.delta;
        }
        this.repaint(1L);
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public final void paint(Graphics g) {
        Dimension dim = this.getSize();
        if (!Misc.equals(dim, this.imageSize)) {
            this.imageSize = dim;
            this.bufferedImage = (BufferedImage)this.createImage(dim.width, dim.height);
        }
        Graphics2D bg = this.bufferedImage.createGraphics();
        super.paint(bg);
        this.paintInner(bg);
        g.drawImage(this.bufferedImage, 0, 0, null);
    }

    public void paintInner(Graphics g) {
        Rectangle b = this.getBounds();
        Color bg = this.getBackground();
        if (bg == null) {
            bg = Color.gray;
        }
        g.setColor(this.getBackground());
        g.fillRect(2, 2, b.width - 4, b.height - 4);
        if (!this.isRunning()) {
            if (this.showClock) {
                g.setFont(clockFont);
                g.setColor(Color.BLACK);
                Date d = new Date();
                clockFormat.setTimeZone(GuiUtils.getTimeZone());
                g.drawString(clockFormat.format(d), 3, b.height - 5);
            }
            return;
        }
        int w = b.width;
        g.setColor(this.color);
        Insets insets = DEFAULT_INSETS;
        Border border = this.getBorder();
        if (border != null) {
            insets = border.getBorderInsets(this);
        }
        if (this.drawFilledSquare()) {
            int x = (int)(this.percent * (double)(b.width - this.barWidth));
            if (x + this.barWidth > b.width) {
                x -= x + this.barWidth - b.width;
            }
            g.fillRect(x, insets.top, this.barWidth, b.height - (insets.top + insets.bottom));
        } else {
            int x = (int)(this.percent * (double)b.width);
            for (int myX = 0; myX < x; myX += 3) {
                g.fillRect(myX, insets.top, 1, b.height - (insets.top + insets.bottom));
            }
        }
        this.paintLabel(g, b);
    }

    public boolean drawFilledSquare() {
        return true;
    }

    public void paintLabel(Graphics g, Rectangle bounds) {
        if (this.label != null) {
            g.setColor(Color.gray);
            g.drawString(this.label, 5, bounds.height - 4);
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        RovingProgress mm = new RovingProgress(Color.blue);
        f.getContentPane().add(mm);
        f.pack();
        f.setVisible(true);
        mm.start();
    }
}

