/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.visad.Util;
import visad.Real;

public class PropertyFilter {
    public static final String NULL_NAME = "--";
    public static final int OP_GREATERTHAN = 0;
    public static final int OP_LESSTHAN = 1;
    public static final int OP_EQUALS = 2;
    public static final int OP_NOTEQUALS = 3;
    public static final int OP_STREQUALS = 4;
    public static final int OP_STRNOTEQUALS = 5;
    public static final int OP_STRCONTAINS = 6;
    public static final int OP_STRNOTCONTAINS = 7;
    public static final int OP_STRMATCH = 8;
    public static final int OP_STRNOTMATCH = 9;
    public static final int OP_STRCONTAINS_NOCASE = 10;
    public static final int OP_STRNOTCONTAINS_NOCASE = 11;
    public static final int OP_STRCONTAINEDIN = 12;
    public static final int OP_STRCONTAINEDIN_NOCASE = 13;
    public static final int[] OPERATORS = new int[]{0, 1, 2, 3, 4, 5, 6, 10, 7, 11, 8, 9, 12, 13};
    public static final String[] OP_LABELS = new String[]{">", "<", "=", "!=", "String equals", "String not equals", "Contains string", "Contains string (no case)", "Not contains", "Not contains (no case)", "String matches", "Not string matches", "Is contained in", "Is contained in (no case)"};
    private String name;
    private int operator;
    private String value;

    public PropertyFilter(String name, String operator, String value) {
        this(name, PropertyFilter.getOperator(operator), value);
    }

    public PropertyFilter(String name, int operator, String value) {
        this.name = name;
        this.operator = operator;
        this.value = value;
    }

    public PropertyFilter() {
    }

    public boolean ok(Object inValue) {
        return this.ok(inValue, this.value);
    }

    public boolean isNumericOperator() {
        return this.operator == 0 || this.operator == 1 || this.operator == 2 || this.operator == 3;
    }

    public boolean ok(Object inValue, Object myValue) {
        if (this.name.length() == 0) {
            return true;
        }
        if (this.operator == 4) {
            return myValue.toString().equals(inValue.toString());
        }
        if (this.operator == 5) {
            return !myValue.toString().equals(inValue.toString());
        }
        if (this.operator == 6) {
            return inValue.toString().trim().indexOf(myValue.toString()) >= 0;
        }
        if (this.operator == 10) {
            return inValue.toString().toLowerCase().trim().indexOf(myValue.toString().toLowerCase()) >= 0;
        }
        if (this.operator == 7) {
            return inValue.toString().indexOf(myValue.toString()) < 0;
        }
        if (this.operator == 11) {
            return inValue.toString().toLowerCase().indexOf(myValue.toString().toLowerCase()) < 0;
        }
        if (this.operator == 8) {
            return StringUtil.stringMatch(inValue.toString().trim(), myValue.toString());
        }
        if (this.operator == 9) {
            return !StringUtil.stringMatch(inValue.toString().trim(), myValue.toString());
        }
        if (this.operator == 12) {
            return myValue.toString().indexOf(inValue.toString().trim()) >= 0;
        }
        if (this.operator == 13) {
            return myValue.toString().toLowerCase().indexOf(inValue.toString().toLowerCase().trim()) >= 0;
        }
        try {
            Real myReal = myValue instanceof Real ? (Real)myValue : Util.toReal(myValue.toString());
            Real inReal = inValue instanceof Real ? (Real)inValue : Util.toReal(inValue.toString());
            if (this.operator == 0) {
                return inReal.__gt__(myReal) == 1;
            }
            if (this.operator == 1) {
                return inReal.__lt__(myReal) == 1;
            }
            if (this.operator == 2) {
                return inReal.__eq__(myReal) == 1;
            }
            if (this.operator == 3) {
                return inReal.__ne__(myReal) == 1;
            }
        }
        catch (Exception exc) {
            System.err.println("Exception: " + exc);
        }
        return false;
    }

    public static int getOperator(String opLabel) {
        for (int i = 0; i < OPERATORS.length; ++i) {
            if (!opLabel.equals(OP_LABELS[i])) continue;
            return OPERATORS[i];
        }
        return OPERATORS[0];
    }

    public String getOperatorLabel() {
        for (int i = 0; i < OPERATORS.length; ++i) {
            if (this.operator != OPERATORS[i]) continue;
            return OP_LABELS[i];
        }
        return OP_LABELS[0];
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getName() {
        return this.name;
    }

    public void setOperator(String value) {
        this.operator = PropertyFilter.getOperator(value);
    }

    public void setOperator(int value) {
        this.operator = value;
    }

    public int getOperator() {
        return this.operator;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setIsNot(boolean v) {
    }

    public static class FilterGui {
        private List filterNameFields = new ArrayList();
        private List filterValues = new ArrayList();
        private List filterOps = new ArrayList();
        protected boolean matchAll;
        protected boolean enabled;
        private ActionListener listener;
        JPanel contents;

        public FilterGui(List filters, List filterNames, boolean enabled, boolean matchAll) {
            this(filters, filterNames, enabled, matchAll, null);
        }

        public FilterGui(List filters, List filterNames, boolean enabled, boolean matchAll, ActionListener listener) {
            this.listener = listener;
            this.enabled = enabled;
            this.matchAll = matchAll;
            this.makeGui(filters, filterNames);
        }

        private void makeGui(List filters, List filterNames) {
            int cnt;
            if (filterNames == null) {
                filterNames = new ArrayList<String>();
            }
            ArrayList<JComponent> filterComps = new ArrayList<JComponent>();
            filterComps.add(new JLabel("Property"));
            filterComps.add(new JLabel(""));
            filterComps.add(new JLabel("Value"));
            PropertyFilter defaultFilter = new PropertyFilter(PropertyFilter.NULL_NAME, 0, "");
            filterNames = new ArrayList(filterNames);
            if (!filterNames.contains(PropertyFilter.NULL_NAME)) {
                filterNames.add(0, PropertyFilter.NULL_NAME);
            }
            if ((cnt = filters.size() + 1) < 5) {
                cnt = 5;
            }
            for (int i = 0; i < cnt; ++i) {
                PropertyFilter filter = i < filters.size() ? (PropertyFilter)filters.get(i) : defaultFilter;
                JComboBox nameFld = new JComboBox();
                if (!filterNames.contains(filter.getName())) {
                    List tmp = Misc.newList(filter.getName());
                    tmp.addAll(filterNames);
                    GuiUtils.setListData(nameFld, tmp);
                } else {
                    GuiUtils.setListData(nameFld, filterNames);
                }
                if (filterNames.get(0) instanceof TwoFacedObject) {
                    nameFld.setSelectedItem(new TwoFacedObject((Object)filter.getName(), filter.getName()));
                } else {
                    nameFld.setSelectedItem(filter.getName());
                }
                JComboBox<String> opFld = new JComboBox<String>(OP_LABELS);
                opFld.setSelectedItem(filter.getOperatorLabel());
                JTextField valueFld = new JTextField(filter.getValue(), 20);
                valueFld.setToolTipText("<html>Enter a value to compare.<br>Use <i>value[unit]</i> to specify a unit.</html>");
                if (this.listener != null) {
                    valueFld.addActionListener(this.listener);
                }
                this.filterNameFields.add(nameFld);
                this.filterOps.add(opFld);
                this.filterValues.add(valueFld);
                filterComps.add(nameFld);
                filterComps.add(opFld);
                filterComps.add(valueFld);
            }
            final JCheckBox enabledCbx = new JCheckBox("Filters Enabled", this.enabled);
            enabledCbx.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    enabled = enabledCbx.isSelected();
                    if (listener != null) {
                        listener.actionPerformed(ae);
                    }
                }
            });
            final JRadioButton allRB = new JRadioButton("Match all of the filters", this.matchAll);
            final JRadioButton anyRB = new JRadioButton("Match any of the filters", !this.matchAll);
            allRB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    matchAll = allRB.isSelected();
                    if (listener != null) {
                        listener.actionPerformed(ae);
                    }
                }
            });
            anyRB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    boolean bl = matchAll = !anyRB.isSelected();
                    if (listener != null) {
                        listener.actionPerformed(ae);
                    }
                }
            });
            GuiUtils.buttonGroup(allRB, anyRB);
            JPanel allPanel = GuiUtils.inset((Component)GuiUtils.hbox(Misc.newList(enabledCbx, new JLabel("      "), allRB, anyRB), 2), new Insets(0, 10, 0, 10));
            GuiUtils.tmpInsets = new Insets(2, 2, 2, 2);
            JPanel lines = GuiUtils.doLayout(filterComps, 3, GuiUtils.WT_Y, GuiUtils.WT_N);
            this.contents = GuiUtils.topCenter(allPanel, GuiUtils.top(lines));
        }

        public boolean getMatchAll() {
            return this.matchAll;
        }

        public boolean getEnabled() {
            return this.enabled;
        }

        public JComponent getContents() {
            return this.contents;
        }

        public List getFilters() {
            ArrayList<PropertyFilter> filters = new ArrayList<PropertyFilter>();
            for (int i = 0; i < this.filterNameFields.size(); ++i) {
                JComboBox nameFld = (JComboBox)this.filterNameFields.get(i);
                JTextField valueFld = (JTextField)this.filterValues.get(i);
                JComboBox opFld = (JComboBox)this.filterOps.get(i);
                String name = TwoFacedObject.getIdString(nameFld.getSelectedItem());
                if (name.equals(PropertyFilter.NULL_NAME) || name.length() == 0) continue;
                filters.add(new PropertyFilter(name, opFld.getSelectedItem().toString(), valueFld.getText().trim()));
            }
            return filters;
        }
    }
}

