/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.RootPaneContainer;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import ucar.unidata.ui.Help;
import ucar.unidata.ui.IndependentDialog;
import ucar.unidata.ui.PersistentDataManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;

public class PersistentDataDialog
implements ActionListener {
    private JDialog dialog;
    private Component contents;
    private PersistentDataManager manage;
    private String objectName;
    private String helpId;
    private TitledBorder viewBorder;
    private boolean debug = false;

    public PersistentDataDialog(String name, JComponent view, JComponent list, PersistentDataManager manager) {
        this.init(name, view, list, manager, false);
    }

    public PersistentDataDialog(RootPaneContainer parent, boolean modal, String name, JComponent view, JComponent list, PersistentDataManager manager) {
        this(parent, modal, name, view, list, manager, name);
    }

    public PersistentDataDialog(RootPaneContainer parent, boolean modal, String name, JComponent view, JComponent list, PersistentDataManager manager, String helpId) {
        this.init(name, view, list, manager, true, helpId);
        if (parent == null && modal) {
            parent = (RootPaneContainer)((Object)LogUtil.getCurrentWindow());
        }
        if (parent != null) {
            if (parent instanceof JFrame) {
                this.dialog = new IndependentDialog((JFrame)parent, modal, name + " Manager");
            } else if (parent instanceof JDialog) {
                this.dialog = new IndependentDialog((JDialog)parent, modal, name + " Manager");
            }
        }
        if (this.dialog == null) {
            this.dialog = new IndependentDialog(parent, modal, name + " Manager");
        }
        this.dialog.setLocation(100, 100);
        GuiUtils.packDialog(this.dialog, this.contents);
        this.dialog.pack();
    }

    public Component getContents() {
        return this.contents;
    }

    protected void init(String name, JComponent view, JComponent list, PersistentDataManager manager, boolean doWindow) {
        this.init(name, view, list, manager, doWindow, name);
    }

    protected void init(String name, JComponent view, JComponent list, PersistentDataManager manager, boolean doWindow, String helpId) {
        this.manage = manager;
        this.objectName = name;
        this.helpId = helpId;
        JPanel mainPanel = new JPanel(new BorderLayout());
        EtchedBorder standardBorder = new EtchedBorder();
        JPanel viewSide = new JPanel();
        viewSide.setLayout(new BorderLayout());
        this.viewBorder = new TitledBorder(standardBorder, "Current " + name, 1, 2);
        viewSide.setBorder(this.viewBorder);
        viewSide.add((Component)view, "Center");
        mainPanel.add((Component)viewSide, "West");
        JToolBar listTools = new JToolBar();
        listTools.setFloatable(false);
        JButton editButton = new JButton("Edit");
        editButton.setToolTipText("edit selected " + name);
        JButton newButton = new JButton("New");
        newButton.setToolTipText("define new " + name);
        JButton deleteButton = new JButton("Delete");
        deleteButton.setToolTipText("delete selected " + name);
        listTools.add(editButton);
        listTools.add(newButton);
        listTools.add(deleteButton);
        JPanel listPanel = new JPanel(new BorderLayout());
        listPanel.setBorder(new TitledBorder(standardBorder, "Saved " + name + "s", 1, 2));
        listPanel.add((Component)listTools, "North");
        listPanel.add((Component)list, "Center");
        mainPanel.add((Component)listPanel, "Center");
        if (doWindow) {
            JPanel buttPanel = GuiUtils.makeApplyOkHelpCancelButtons(this);
            this.contents = GuiUtils.centerBottom(mainPanel, buttPanel);
        } else {
            this.contents = mainPanel;
        }
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersistentDataDialog.this.manage.edit(false);
            }
        });
        newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersistentDataDialog.this.manage.edit(true);
            }
        });
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersistentDataDialog.this.manage.deleteSelected();
            }
        });
    }

    public void destroy() {
        if (this.dialog != null) {
            this.dialog.dispose();
        }
        this.dialog = null;
    }

    public void show() {
        if (this.dialog != null) {
            this.dialog.setVisible(true);
        }
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public void close() {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals(GuiUtils.CMD_OK) || cmd.equals(GuiUtils.CMD_APPLY)) {
            this.manage.accept();
        }
        if (cmd.equals(GuiUtils.CMD_OK) || cmd.equals(GuiUtils.CMD_CANCEL)) {
            this.close();
        }
        if (cmd.equals(GuiUtils.CMD_HELP)) {
            Help.getDefaultHelp().gotoTarget(this.helpId);
        }
    }

    public void setHelpId(String newId) {
        this.helpId = newId;
    }

    public void setEnabled(boolean enabled) {
    }

    public void setCurrent(String name) {
        this.viewBorder.setTitle(name);
        this.contents.invalidate();
        this.contents.repaint();
    }

    public boolean checkSaveOK(String startingId, String id) {
        if ((id = id.trim()).length() == 0) {
            JOptionPane.showMessageDialog(null, "You must enter a name for this " + this.objectName);
            return false;
        }
        if (!this.manage.contains(id)) {
            return true;
        }
        if (startingId.equals(id)) {
            return true;
        }
        return 0 == JOptionPane.showConfirmDialog(null, "You are about to replace an existing " + this.objectName + " named '" + id + "'", "Confirm " + this.objectName + " Replacement", 2);
    }
}

